/*
 * Decompiled with CFR 0.152.
 */
package org.merlin.beans.numberfield;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.merlin.beans.arrow.ArrowBean;

public class NumberFieldBean
extends Container
implements ActionListener {
    protected ArrowBean up;
    protected ArrowBean down;
    protected TextField field;
    protected int minimum = Integer.MIN_VALUE;
    protected int maximum = Integer.MAX_VALUE;
    protected int step = 1;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    Integer oValue = new Integer(0);
    static /* synthetic */ Class class$java$awt$Component;

    public NumberFieldBean() {
        this.setLayout(new BorderLayout());
        try {
            this.down = (ArrowBean)Beans.instantiate(this.getClass().getClassLoader(), "org.merlin.beans.arrow.ArrowBean");
            this.up = (ArrowBean)Beans.instantiate(this.getClass().getClassLoader(), "org.merlin.beans.arrow.ArrowBean");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.add("West", (Component)Beans.getInstanceOf(this.down, class$java$awt$Component == null ? (class$java$awt$Component = NumberFieldBean.class$("java.awt.Component")) : class$java$awt$Component));
        this.down.setDirection("left");
        this.down.addActionListener(this);
        this.field = new TextField(4);
        this.add("Center", this.field);
        this.field.addActionListener(this);
        this.add("East", (Component)Beans.getInstanceOf(this.up, class$java$awt$Component == null ? (class$java$awt$Component = NumberFieldBean.class$("java.awt.Component")) : class$java$awt$Component));
        this.up.setDirection("right");
        this.up.addActionListener(this);
    }

    public void requestFocus() {
        this.field.requestFocus();
    }

    public void setColumns(int c) {
        this.field.setColumns(c);
    }

    public int getColumns() {
        return this.field.getColumns();
    }

    public synchronized void setValue(int v) {
        this.field.setText(String.valueOf(v));
        this.fireValueChange(this.getValue());
    }

    public int getValue() {
        try {
            return this.clamp(Integer.parseInt(this.field.getText()));
        }
        catch (NumberFormatException ex) {
            return this.clamp(0);
        }
    }

    public synchronized void setMinimum(int m) {
        this.minimum = m;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public synchronized void setMaximum(int m) {
        this.maximum = m;
    }

    public int getMaximum() {
        return this.maximum;
    }

    protected int clamp(int v) {
        return Math.max(this.minimum, Math.min(this.maximum, v));
    }

    public synchronized void setStep(int s) {
        if (s <= 0) {
            throw new IllegalArgumentException("Step too small (" + s + ").");
        }
        this.step = s;
    }

    public int getStep() {
        return this.step;
    }

    public synchronized void actionPerformed(ActionEvent e) {
        block3: {
            block5: {
                int value;
                block4: {
                    value = this.getValue();
                    if (e.getSource() != this.down) break block4;
                    if (value <= this.minimum) break block3;
                    value = value - this.step > value ? this.minimum : this.clamp(value - this.step);
                    this.setValue(value);
                    this.fireValueChange(value);
                    break block3;
                }
                if (e.getSource() != this.up) break block5;
                if (value >= this.maximum) break block3;
                value = value + this.step < value ? this.maximum : this.clamp(value + this.step);
                this.setValue(value);
                this.fireValueChange(value);
                break block3;
            }
            if (e.getSource() != this.field) break block3;
            try {
                int v = Integer.parseInt(e.getActionCommand());
                if (v < this.minimum || v > this.maximum) {
                    this.getToolkit().beep();
                    break block3;
                }
                this.fireValueChange(v);
            }
            catch (NumberFormatException ex) {
                this.getToolkit().beep();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected void fireValueChange(int v) {
        this.oValue = new Integer(v);
        this.listeners.firePropertyChange("value", this.oValue, this.oValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

