/*
 * Decompiled with CFR 0.152.
 */
package org.merlin.beans.arrow;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import org.merlin.beans.arrow.ArrowRoller;

public class ArrowBean
extends Component {
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    protected String direction;
    protected String od;
    protected static ArrowRoller roller;
    protected boolean down;
    protected boolean in;
    protected ActionListener listeners;

    public ArrowBean() {
        this.od = this.direction = LEFT;
        this.enableEvents(16L);
    }

    public void setDirection(String d) {
        this.direction = LEFT.equals(d) ? LEFT : RIGHT;
        this.repaint();
    }

    public String getDirection() {
        return this.direction;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void update(Graphics g) {
        if (this.od == this.direction) {
            this.paint(g);
        } else {
            super.update(g);
            this.od = this.direction;
        }
    }

    public void paint(Graphics g) {
        int x = this.getSize().width;
        int y = this.getSize().height;
        if (this.direction == LEFT) {
            g.setColor(this.in && this.down ? this.getBackground().brighter() : this.getBackground().darker());
            g.drawLine(x - 2, 2, x - 2, y - 2);
            g.drawLine(x - 2, y - 2, 2, (y - 2) / 2);
            g.setColor(this.in && this.down ? this.getBackground().darker() : this.getBackground().brighter());
            g.drawLine(2, (y - 2) / 2, x - 2, 2);
        } else {
            g.setColor(this.in && this.down ? this.getBackground().brighter() : this.getBackground().darker());
            g.drawLine(2, 2, x - 2, (y - 2) / 2);
            g.drawLine(2, y - 2, x - 2, (y - 2) / 2);
            g.setColor(this.in && this.down ? this.getBackground().darker() : this.getBackground().brighter());
            g.drawLine(2, 2, 2, y - 2);
        }
    }

    protected static synchronized ArrowRoller createRoller() {
        if (roller == null) {
            roller = new ArrowRoller();
        }
        return roller;
    }

    public static synchronized void destroyRoller() {
        roller.abort();
        roller = null;
    }

    protected void processMouseEvent(MouseEvent e) {
        ArrowRoller roller = ArrowBean.roller;
        if (roller == null) {
            roller = ArrowBean.createRoller();
        }
        switch (e.getID()) {
            case 501: {
                this.fireActionEvent();
                roller.addTarget(this);
                this.in = true;
                this.down = true;
                this.repaint();
                break;
            }
            case 502: {
                roller.removeTarget(this);
                this.in = false;
                this.down = false;
                this.repaint();
                break;
            }
            case 504: {
                this.in = true;
                if (!this.down) break;
                roller.addTarget(this);
                this.repaint();
                break;
            }
            case 505: {
                this.in = false;
                if (!this.down) break;
                roller.removeTarget(this);
                this.repaint();
            }
        }
        super.processMouseEvent(e);
    }

    public void addActionListener(ActionListener l) {
        this.listeners = AWTEventMulticaster.add(l, this.listeners);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners = AWTEventMulticaster.remove(l, this.listeners);
    }

    protected void fireActionEvent() {
        if (this.listeners != null) {
            this.listeners.actionPerformed(new ActionEvent(this, 1001, this.direction));
        }
    }
}

