/*
 * Decompiled with CFR 0.152.
 */
package net.janino.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.janino.util.TunnelException;
import net.janino.util.resource.PathResourceFinder;
import net.janino.util.resource.ResourceFinder;

public class PathClassLoader
extends ClassLoader {
    private final ResourceFinder resourceFinder;

    public PathClassLoader(ResourceFinder resourceFinder, ClassLoader classLoader) {
        super(classLoader);
        this.resourceFinder = resourceFinder;
    }

    public PathClassLoader(File[] fileArray, ClassLoader classLoader) {
        super(classLoader);
        this.resourceFinder = new PathResourceFinder(fileArray);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        InputStream inputStream = this.resourceFinder.findResourceAsStream(String.valueOf(string.replace('.', '/')) + ".class");
        if (inputStream == null) {
            throw new ClassNotFoundException(string);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new TunnelException(iOException);
            }
            clazz = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        byte[] byArray = byteArrayOutputStream.toByteArray();
        clazz = super.defineClass(null, byArray, 0, byArray.length);
        if (!clazz.getName().equals(string)) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    public URL findResource(String string) {
        return this.resourceFinder.findResource(string);
    }

    public ResourceFinder getResourceFinder() {
        return this.resourceFinder;
    }
}

