/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.util.math;

import ch.abacus.lib.util.math.LinearCongruence;

public class AdditiveCongruence {
    private int[] field;
    private int pos = 0;
    private int m;
    private static final int MULT_HELP = 10000;
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTES_PER_INT = 4;

    public AdditiveCongruence(int[] initField, int m) {
        if (initField == null) {
            throw new NullPointerException();
        }
        this.field = initField;
        this.m = m;
    }

    public static final AdditiveCongruence createNew() {
        int[] field = new int[55];
        for (int i = 0; i < field.length; ++i) {
            field[i] = LinearCongruence.random();
        }
        return new AdditiveCongruence(field, 100000000);
    }

    public static final AdditiveCongruence createNew(int seed) {
        LinearCongruence lc = new LinearCongruence(seed);
        int[] field = new int[55];
        for (int i = 0; i < field.length; ++i) {
            field[i] = lc.next();
        }
        return new AdditiveCongruence(field, 100000000);
    }

    public int random(int r) {
        this.pos = (this.pos + 1) % this.field.length;
        this.field[this.pos] = (this.field[(this.pos + 23) % this.field.length] + this.field[(this.pos + 54) % this.field.length]) % this.m;
        return this.field[this.pos] / 10000 * r / 10000;
    }

    public void nextBytes(byte[] bytes) {
        int numRequested = bytes.length;
        int numGot = 0;
        int rnd = 0;
        block0: while (true) {
            int i = 0;
            while (true) {
                if (i >= 4) continue block0;
                if (numGot == numRequested) {
                    return;
                }
                rnd = i == 0 ? this.random(32) : rnd >> 8;
                bytes[numGot++] = (byte)rnd;
                ++i;
            }
            break;
        }
    }
}

