/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common.jdbc;

import com.sun.rowset.JdbcRowSetImpl;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class JSSUpdatableRowSet
extends JdbcRowSetImpl {
    boolean forceNonUpdatableMode = false;
    private String updatableTableName;
    private String uniqueColumnName;
    private HashMap rowChanges = new HashMap();

    public void updateNull(String s) throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            this.rowChanges.put(s, null);
        } else {
            super.updateNull(s);
        }
    }

    public void updateInt(String s, int i) throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            this.rowChanges.put(s, i);
        } else {
            super.updateInt(s, i);
        }
    }

    public void updateLong(String s, long l) throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            this.rowChanges.put(s, l);
        } else {
            super.updateLong(s, l);
        }
    }

    public void updateFloat(String s, float v) throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            this.rowChanges.put(s, Float.valueOf(v));
        } else {
            super.updateFloat(s, v);
        }
    }

    public void updateDouble(String s, double v) throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            this.rowChanges.put(s, v);
        } else {
            super.updateDouble(s, v);
        }
    }

    public void updateDate(String s, Date date) throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            this.rowChanges.put(s, date);
        } else {
            super.updateDate(s, date);
        }
    }

    public void updateBoolean(String s, boolean b) throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            this.rowChanges.put(s, b);
        } else {
            super.updateBoolean(s, b);
        }
    }

    public void updateString(String s, String s1) throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            System.err.println("rowChanges.put(" + s + ", " + s1 + ")");
            this.rowChanges.put(s, s1);
        } else {
            super.updateString(s, s1);
        }
    }

    public JSSUpdatableRowSet(Connection conn, String param_updatableTableName, String param_uniqueColumnName) throws SQLException {
        super(conn);
        this.setUpdatableTableName(param_updatableTableName);
        this.setUniqueColumnName(param_uniqueColumnName);
    }

    public String getUpdatableTableName() throws SQLException {
        if (this.updatableTableName == null) {
            this.updatableTableName = this.getMetaData().getTableName(1);
        }
        return this.updatableTableName;
    }

    public void setUpdatableTableName(String tableName) {
        this.updatableTableName = tableName;
    }

    public String getUniqueColumnName() {
        try {
            if (this.uniqueColumnName == null) {
                this.uniqueColumnName = JSSUpdatableRowSet.getPrimaryKey(this.getConnection(), this.updatableTableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.uniqueColumnName;
    }

    public void setUniqueColumnName(String uniqueColumnName) {
        this.uniqueColumnName = uniqueColumnName;
    }

    public void insertRow() throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            int n = this.execSQLInsert(this.getUpdatableTableName(), this.getUniqueColumnName(), this.getConnection(), this, this.rowChanges);
            if (n > 0) {
                this.refreshRow();
                this.notifyRowChanged();
            }
        } else {
            super.insertRow();
        }
    }

    public void updateRow() throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            System.err.println("execSQLUpdate(): " + this.rowChanges);
            int n = this.execSQLUpdate(this.getUpdatableTableName(), this.getUniqueColumnName(), this.getConnection(), this, this.rowChanges);
            if (n > 0) {
                this.notifyRowChanged();
            }
        } else {
            super.updateRow();
        }
    }

    public void deleteRow() throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            int n = this.execSQLDelete(this.getUpdatableTableName(), this.getUniqueColumnName(), this.getConnection(), this);
            if (n > 0) {
                this.refreshRow();
                this.notifyRowChanged();
            }
        } else {
            super.deleteRow();
        }
    }

    public static String getFieldQuote(ResultSetMetaData rsmd, String fieldName) {
        int i = -1;
        String fieldQuote = "";
        int fieldType = 0;
        try {
            int numcols = rsmd.getColumnCount();
            for (int i1 = 1; i1 <= numcols; ++i1) {
                if (!rsmd.getColumnLabel(i1).equalsIgnoreCase(fieldName)) continue;
                i = i1;
                break;
            }
            if (i == -1) {
                return null;
            }
            fieldType = rsmd.getColumnType(i);
            fieldQuote = "";
            if (fieldType == 12 || fieldType == 1 || fieldType == -1 || fieldType == 92 || fieldType == 93 || fieldType == 91) {
                fieldQuote = "'";
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return fieldQuote;
    }

    public int execSQLUpdate(String paramTable, String uniqueFieldName, Connection dbconn, ResultSet rs, Map paramFields) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        PreparedStatement updateST = null;
        String qrystr = "";
        String valstr = "";
        String fieldQuote = "";
        ArrayList<String> validFields = new ArrayList<String>();
        boolean bFirstColumn = true;
        for (Object o : paramFields.keySet()) {
            String aname = String.valueOf(o);
            if (!this.isField(paramTable, aname, dbconn) || aname.equalsIgnoreCase(uniqueFieldName)) continue;
            if (bFirstColumn) {
                valstr = aname + "=?";
                bFirstColumn = false;
            } else {
                valstr = valstr + "," + aname + "=?";
            }
            validFields.add(aname);
        }
        qrystr = "UPDATE " + paramTable + " SET " + valstr;
        String uniqueFieldValue = rs.getString(uniqueFieldName);
        fieldQuote = JSSUpdatableRowSet.getFieldQuote(rsmd, uniqueFieldName);
        qrystr = qrystr + " WHERE " + uniqueFieldName + "=" + fieldQuote + uniqueFieldValue + fieldQuote;
        System.err.println("execSQLUpdate(): " + qrystr);
        updateST = dbconn.prepareStatement(qrystr);
        for (int fld = 0; fld < validFields.size(); ++fld) {
            String aname = (String)validFields.get(fld);
            String avalue = (String)paramFields.get(aname);
            System.err.println("execSQLUpdate(): " + aname + "=" + avalue);
            updateST.setString(fld + 1, avalue);
        }
        int numUpdates = updateST.executeUpdate();
        updateST.close();
        return numUpdates;
    }

    public int execSQLInsert(String paramTable, String uniqueFieldName, Connection dbconn, ResultSet rs, Map paramFields) throws SQLException {
        String aname;
        ResultSetMetaData rsmd = rs.getMetaData();
        PreparedStatement updateST = null;
        String qrystr = "";
        String valstr = "";
        ArrayList<String> validFields = new ArrayList<String>();
        qrystr = "INSERT INTO " + paramTable + " (";
        boolean bFirstColumn = true;
        for (Object o : paramFields.keySet()) {
            aname = String.valueOf(o);
            if (!this.isField(paramTable, aname, dbconn) || ("," + qrystr + ",").toLowerCase().indexOf(("," + aname + ",").toLowerCase()) > 0) continue;
            if (bFirstColumn) {
                qrystr = qrystr + aname;
                valstr = "?";
                bFirstColumn = false;
            } else {
                qrystr = qrystr + "," + aname;
                valstr = valstr + ",?";
            }
            validFields.add(aname);
        }
        qrystr = qrystr + ") VALUES (" + valstr + ") ";
        updateST = dbconn.prepareStatement(qrystr);
        for (int fld = 0; fld < validFields.size(); ++fld) {
            aname = (String)validFields.get(fld);
            String avalue = (String)paramFields.get(aname);
            updateST.setString(fld + 1, avalue);
        }
        int numUpdates = updateST.executeUpdate();
        updateST.close();
        return numUpdates;
    }

    public static String getPrimaryKey(Connection con, String tableName) {
        String[] key = new String[]{"TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        DatabaseMetaData dbMeta = null;
        try {
            dbMeta = con.getMetaData();
        }
        catch (SQLException e) {
            return null;
        }
        ResultSet rsKey = null;
        try {
            rsKey = dbMeta.getPrimaryKeys(null, null, tableName.toUpperCase());
        }
        catch (Exception e) {
            try {
                rsKey = dbMeta.getPrimaryKeys(null, null, tableName);
            }
            catch (Exception e1) {
                return null;
            }
        }
        String scolname = null;
        try {
            if (rsKey.next()) {
                scolname = rsKey.getString(key[1]);
            }
            rsKey.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return scolname;
    }

    public int execSQLDelete(String paramTable, String uniqueFieldName, Connection dbconn, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        Statement updateST = null;
        updateST = dbconn.createStatement();
        String qrystr = "";
        String fieldQuote = "";
        qrystr = "DELETE FROM " + paramTable;
        String uniqueFieldValue = rs.getString(uniqueFieldName);
        fieldQuote = JSSUpdatableRowSet.getFieldQuote(rsmd, uniqueFieldName);
        qrystr = qrystr + " WHERE " + uniqueFieldName + "=" + fieldQuote + uniqueFieldValue + fieldQuote;
        int numUpdates = updateST.executeUpdate(qrystr);
        updateST.close();
        return numUpdates;
    }

    public boolean isField(String tableName, String fieldName, Connection dbconn) {
        boolean foundField = false;
        try {
            DatabaseMetaData dbmd = dbconn.getMetaData();
            ResultSet columnRS = dbmd.getColumns(null, null, tableName, "%");
            if (!(columnRS.next() || (columnRS = dbmd.getColumns(null, null, tableName.toLowerCase(), "%")).next() || (columnRS = dbmd.getColumns(null, null, tableName.toUpperCase(), "%")).next())) {
                columnRS.close();
                return false;
            }
            if (columnRS == null) {
                return false;
            }
            do {
                String dbColumnName;
                if (!fieldName.equalsIgnoreCase(dbColumnName = columnRS.getString(4))) continue;
                foundField = true;
                break;
            } while (columnRS.next());
            columnRS.close();
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return foundField;
    }

    protected void notifyCursorMoved() throws SQLException {
        if (this.getConcurrency() != 1008 || this.forceNonUpdatableMode) {
            this.rowChanges.clear();
        }
        super.notifyCursorMoved();
    }

    protected void notifyRowChanged() throws SQLException {
        super.notifyRowChanged();
    }

    protected void notifyRowSetChanged() throws SQLException {
        super.notifyRowSetChanged();
    }

    public boolean getBoolean(String s) throws SQLException {
        if ((this.getConcurrency() != 1008 || this.forceNonUpdatableMode) && this.rowChanges.containsKey(s)) {
            return (Boolean)this.rowChanges.get(s);
        }
        return super.getBoolean(s);
    }

    public Date getDate(String s) throws SQLException {
        if ((this.getConcurrency() != 1008 || this.forceNonUpdatableMode) && this.rowChanges.containsKey(s)) {
            return (Date)this.rowChanges.get(s);
        }
        return super.getDate(s);
    }

    public double getDouble(String s) throws SQLException {
        if ((this.getConcurrency() != 1008 || this.forceNonUpdatableMode) && this.rowChanges.containsKey(s)) {
            return (Double)this.rowChanges.get(s);
        }
        return super.getDouble(s);
    }

    public float getFloat(String s) throws SQLException {
        if ((this.getConcurrency() != 1008 || this.forceNonUpdatableMode) && this.rowChanges.containsKey(s)) {
            return ((Float)this.rowChanges.get(s)).floatValue();
        }
        return super.getFloat(s);
    }

    public int getInt(String s) throws SQLException {
        if ((this.getConcurrency() != 1008 || this.forceNonUpdatableMode) && this.rowChanges.containsKey(s)) {
            return (Integer)this.rowChanges.get(s);
        }
        return super.getInt(s);
    }

    public long getLong(String s) throws SQLException {
        if ((this.getConcurrency() != 1008 || this.forceNonUpdatableMode) && this.rowChanges.containsKey(s)) {
            return (Long)this.rowChanges.get(s);
        }
        return super.getLong(s);
    }

    public String getString(String s) throws SQLException {
        if ((this.getConcurrency() != 1008 || this.forceNonUpdatableMode) && this.rowChanges.containsKey(s)) {
            return (String)this.rowChanges.get(s);
        }
        return super.getString(s);
    }
}

