/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common.generator;

import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.HammerNLSAccess;
import ch.abacus.lib.ui.renderer.common.ListenerCollection;
import ch.abacus.lib.ui.renderer.common.ListenerDiscriminator;
import ch.abacus.lib.ui.renderer.common.ListenerEntry;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaMethod;
import ch.abacus.lib.ui.renderer.common.MetaMethodLinkage;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaParameter;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import ch.abacus.lib.ui.renderer.common.ProjectDocument;
import ch.abacus.lib.ui.renderer.common.generator.BufferCollection;
import ch.abacus.lib.ui.renderer.common.generator.ProjectCodeGenerator;
import com.ibm.cf.CodeFormatter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JViewport;

public class AbacusCodeGenerator
implements ProjectCodeGenerator {
    ProjectDocument theDocument;
    public Vector vectorConstants = new Vector(0);
    private Vector vRequiredImports;
    private boolean bNLSTranslation = true;
    private boolean bgenerateAccessor = true;
    HashMap Variables = new HashMap();
    HashMap VariableClasses = new HashMap();
    BufferCollection theBufferCollection = new BufferCollection();
    HashMap theLookupTable = new HashMap();
    ListenerCollection theListenerCollection = new ListenerCollection();

    public AbacusCodeGenerator(ProjectDocument theDocument) {
        this.theDocument = theDocument;
        this.vRequiredImports = new Vector();
    }

    public ProjectDocument getProjectDocument() {
        return this.theDocument;
    }

    public void setProjectDocument(ProjectDocument theDocument) {
        this.theDocument = theDocument;
    }

    private String getValue(MetaObject theObject, String sKey) {
        sKey = theObject.getName() + "|" + sKey;
        return (String)this.theLookupTable.get(sKey);
    }

    private void setValue(MetaObject theObject, String sKey, String sValue) {
        sKey = theObject.getName() + "|" + sKey;
        this.theLookupTable.put(sKey, sValue);
    }

    private String getIdentifier(MetaObject theObject) {
        return this.getValue(theObject, "Identifier");
    }

    private void setIdentifier(MetaObject theObject, String value) {
        this.setValue(theObject, "Identifier", value);
    }

    private String getContainerName(MetaObject theObject) {
        return this.getValue(theObject, "ContainerName");
    }

    private void setContainerName(MetaObject theObject, String value) {
        this.setValue(theObject, "ContainerName", value);
    }

    private String getLayoutName(MetaObject theObject) {
        return this.getValue(theObject, "LayoutName");
    }

    private void setLayoutName(MetaObject theObject, String value) {
        this.setValue(theObject, "LayoutName", value);
    }

    private String getGroupName(MetaObject theObject) {
        return this.getValue(theObject, "GroupName");
    }

    private void setGroupName(MetaObject theObject, String value) {
        this.setValue(theObject, "GroupName", value);
    }

    public void generateObjectCode(MetaObject theObject) throws HammerException {
        String sProjectName = theObject.theDesignProject.getName();
        int iIndex = sProjectName.indexOf(".");
        sProjectName = sProjectName.substring(0, iIndex);
        if (this.getProjectDocument().isOpenSource() && theObject.getObjectCode() != null) {
            this.generateObjecClass(theObject);
        }
        this.setIdentifier(theObject, theObject.getName());
        this.generateMember(theObject);
        this.bgenerateAccessor = theObject.theDesignProject.isGenerateAccessor();
        this.generateAccessor(theObject);
        this.generateBuilder(theObject);
        this.generatePropertySettings(theObject);
        this.generateAttachmentCode(theObject);
        MetaObject objTest = theObject.theFirstChild;
        while (objTest != null) {
            this.generateObjectCode(objTest);
            objTest = objTest.theNextObject;
        }
    }

    public void generateMember(MetaObject theObject) {
        String sClassName = theObject.theClass.theMetadata.sFullClassName;
        if (theObject.isPatched() && this.getProjectDocument().isOpenSource()) {
            sClassName = theObject.getPatchedClassName();
        } else {
            int iLastDot = sClassName.lastIndexOf(".");
            sClassName = sClassName.substring(iLastDot + 1);
        }
        String sDeclaration = "    private " + sClassName + " " + this.getIdentifier(theObject) + ";";
        this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + sDeclaration;
        this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "\r\n";
        int iContainerType = theObject.getContainerType();
        if (iContainerType == 3 || iContainerType == 5) {
            this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "Container contentPane;\r\n";
        }
    }

    public void generateObjecClass(MetaObject theObject) {
        String sObjectName = theObject.getName();
        String sObjectBasedClassName = "$$$" + sObjectName + "$$$";
        String sSuperClassName = theObject.theClass.theMetadata.sFullClassName;
        int iLastDot = sSuperClassName.lastIndexOf(".");
        sSuperClassName = sSuperClassName.substring(iLastDot + 1);
        String sObjectBasedClass = "class " + sObjectBasedClassName + " extends " + sSuperClassName + "{" + "\r\n";
        sObjectBasedClass = sObjectBasedClass + theObject.getObjectCode() + "\r\n" + "}" + "\r\n";
        theObject.setPatchedClassName(sObjectBasedClassName);
        theObject.setPatchedStatus(true);
        this.theBufferCollection.sAccessorBuffer = this.theBufferCollection.sAccessorBuffer + sObjectBasedClass;
    }

    public void generateAccessor(MetaObject theObject) {
        String sAccessorCode;
        String sClassName = theObject.theClass.theMetadata.sFullClassName;
        int iLastDot = sClassName.lastIndexOf(".");
        sClassName = sClassName.substring(iLastDot + 1);
        if (theObject.equals(theObject.theDesignProject.getFirstObject())) {
            sAccessorCode = "public Object getRenderingDestination() {\r\n";
            sAccessorCode = sAccessorCode + "return " + this.getIdentifier(theObject) + ";\r\n}\r\n\r\n";
            this.theBufferCollection.sAccessorBuffer = this.theBufferCollection.sAccessorBuffer + sAccessorCode;
        }
        sAccessorCode = new String();
        if (this.bgenerateAccessor) {
            if (theObject.isPatched() && this.getProjectDocument().isOpenSource()) {
                sAccessorCode = "public " + theObject.getPatchedClassName() + " get" + theObject.getName() + "() {\r\n";
                sAccessorCode = sAccessorCode + "return " + this.getIdentifier(theObject) + ";\r\n}\r\n\r\n";
            } else {
                sAccessorCode = "public " + sClassName + " get" + theObject.getName() + "() {\r\n";
                sAccessorCode = sAccessorCode + "return " + this.getIdentifier(theObject) + ";\r\n}\r\n\r\n";
            }
        }
        this.theBufferCollection.sAccessorBuffer = this.theBufferCollection.sAccessorBuffer + sAccessorCode;
    }

    public void generateBuilder(MetaObject theObject) {
        String sfullClassName = theObject.theClass.theMetadata.sFullClassName;
        String sClassName = theObject.theClass.theMetadata.sClassName;
        String sBuildCode = null;
        if (theObject.isPatched() && this.getProjectDocument().isOpenSource()) {
            sfullClassName = theObject.getPatchedClassName();
            sClassName = theObject.getPatchedClassName();
            sBuildCode = this.getIdentifier(theObject) + " = new " + sfullClassName + "();" + "\n\r";
            sBuildCode = sBuildCode + "theRenderer.createInterfaceObjectEx(\"" + theObject.getName() + "\"" + "," + theObject.getName() + ");";
        } else {
            int iLastDot = sfullClassName.lastIndexOf(".");
            sfullClassName = sfullClassName.substring(iLastDot + 1);
            sBuildCode = this.getIdentifier(theObject) + " = (" + sfullClassName + ") theRenderer.createInterfaceObject(\"" + theObject.getName() + "\", \"" + sClassName + "\");";
        }
        if (theObject.isFrame() || theObject.isAbalet()) {
            this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "if (bMakeFrame) {\r\n";
        }
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + sBuildCode;
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "\r\n";
    }

    public void generatePropertySettings(MetaObject theObject) throws HammerException {
        String sSetCode = "";
        MetaProperty theProperty = theObject.theFirstProperty;
        String metaClassName = theProperty.theObject.theType.theName;
        this.bNLSTranslation = theObject.theDesignProject.isNLSCodeTranslation();
        while (theProperty != null) {
            String sPropertySet = this.generatePropertyCode(theProperty);
            if (theProperty.thePropertyInfo != null) {
                String sSetMethod = theProperty.thePropertyInfo.getSetMethod();
                boolean bIsObjReference = theProperty.thePropertyInfo.bObjectReference;
                if (sSetMethod != null && sSetMethod.length() > 0 && !bIsObjReference) {
                    sSetCode = sSetCode + this.getIdentifier(theObject) + "." + theProperty.thePropertyInfo.getSetMethod() + "(" + sPropertySet + ")";
                    sSetCode = sSetCode + ";\r\n";
                } else if (sSetMethod != null && sSetMethod.length() > 0 && bIsObjReference) {
                    String sProjectName = theObject.theDesignProject.getName();
                    int iIndex = sProjectName.indexOf(".");
                    sProjectName = sProjectName.substring(0, iIndex);
                    sSetCode = sSetCode + this.getIdentifier(theObject) + "." + theProperty.thePropertyInfo.getSetMethod() + "(" + sPropertySet + ")";
                    sSetCode = sSetCode + ";\r\n";
                }
                if (theObject.bAutoEmbed) {
                    if (sSetMethod.equals("setSize")) {
                        sSetCode = sSetCode + "scr_" + this.getIdentifier(theObject) + "." + theProperty.thePropertyInfo.getSetMethod() + "(" + sPropertySet + ")";
                        sSetCode = sSetCode + ";\r\n";
                    }
                    if (sSetMethod.equals("setLocation")) {
                        sSetCode = sSetCode + "scr_" + this.getIdentifier(theObject) + "." + theProperty.thePropertyInfo.getSetMethod() + "(" + sPropertySet + ")";
                        sSetCode = sSetCode + ";\r\n";
                    }
                }
            }
            theProperty = theProperty.theNextProperty;
        }
        sSetCode = this.generateObjectEventClasses(sSetCode, theObject);
        this.theBufferCollection.sPropertyMethodBuffer = this.theBufferCollection.sPropertyMethodBuffer + "\r\nvoid set_" + this.getIdentifier(theObject) + "_properties(AbaRendererInterface theRenderer) {\r\n" + sSetCode + "\r\n}\r\n";
        if (theObject.isFrame() || theObject.isAbalet()) {
            this.theBufferCollection.sPropertyBuffer = this.theBufferCollection.sPropertyBuffer + "if (bMakeFrame)\r\n";
        }
        this.theBufferCollection.sPropertyBuffer = metaClassName.equalsIgnoreCase("JSSDataSource") ? "set_" + this.getIdentifier(theObject) + "_properties(theRenderer);\r\n" + this.theBufferCollection.sPropertyBuffer : this.theBufferCollection.sPropertyBuffer + "set_" + this.getIdentifier(theObject) + "_properties(theRenderer);\r\n";
    }

    public void generateAttachmentCode(MetaObject theObject) {
        int iContainerType = theObject.getContainerType();
        String sLayoutConstruction = "";
        switch (iContainerType) {
            case 4: {
                this.setContainerName(theObject, this.getIdentifier(theObject));
                break;
            }
            case 6: {
                this.setGroupName(theObject, "grp_" + this.getIdentifier(theObject));
                this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "ButtonGroup " + this.getGroupName(theObject) + " = new ButtonGroup();";
                this.setContainerName(theObject, this.getIdentifier(theObject));
                this.setLayoutName(theObject, "lm_" + this.getIdentifier(theObject));
                this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "AnchoringLayoutManager " + this.getLayoutName(theObject) + " = new AnchoringLayoutManager();" + "\r\n";
                sLayoutConstruction = sLayoutConstruction + this.getContainerName(theObject) + ".setLayout(" + this.getLayoutName(theObject) + ");\r\n";
                break;
            }
            case 2: 
            case 7: {
                this.setLayoutName(theObject, "lm_" + this.getIdentifier(theObject));
                this.setContainerName(theObject, this.getIdentifier(theObject));
                this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "AnchoringLayoutManager " + this.getLayoutName(theObject) + " = new AnchoringLayoutManager();" + "\r\n";
                sLayoutConstruction = sLayoutConstruction + this.getContainerName(theObject) + ".setLayout(" + this.getLayoutName(theObject) + ");\r\n";
                break;
            }
            case 3: 
            case 5: {
                this.setLayoutName(theObject, "lmRenderingObject");
                this.setContainerName(theObject, "contentPane");
                this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "AnchoringLayoutManager " + this.getLayoutName(theObject) + " = new AnchoringLayoutManager();" + "\r\n";
                sLayoutConstruction = sLayoutConstruction + this.getContainerName(theObject) + "= " + this.getIdentifier(theObject) + ".getContentPane();" + "\r\n";
                sLayoutConstruction = sLayoutConstruction + "theRenderer.addFocus(null," + this.getIdentifier(theObject) + ");\r\n";
                sLayoutConstruction = sLayoutConstruction + "}\r\n" + this.getContainerName(theObject) + ".setLayout(" + this.getLayoutName(theObject) + ");\r\n";
                break;
            }
            case 0: 
            case 1: {
                break;
            }
            case 8: 
            case 9: {
                this.setContainerName(theObject, this.getIdentifier(theObject));
                break;
            }
            case 10: {
                this.setContainerName(theObject, this.getIdentifier(theObject));
                sLayoutConstruction = sLayoutConstruction + this.getContainerName(theObject) + ".setLayout(null);\r\n";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.setContainerName(theObject, this.getIdentifier(theObject));
            }
        }
        String sVariableToAttach = this.getIdentifier(theObject);
        if (theObject.bAutoEmbed) {
            this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "JAScrollPane scr_" + this.getIdentifier(theObject) + ";\r\n";
            sVariableToAttach = "scr_" + this.getIdentifier(theObject);
            this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "scr_" + this.getIdentifier(theObject) + " = new JAScrollPane(" + this.getIdentifier(theObject) + ");\r\n";
            if (iContainerType == 10) {
                this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + this.getIdentifier(theObject) + ".setScrollPane(scr_" + this.getIdentifier(theObject) + ");\r\n";
            }
        }
        String sAttachmentCode = "";
        MetaObject theParentContainer = theObject.getVisualContainerObject(true);
        if (theParentContainer != null) {
            int iParentContainerType = theParentContainer.getContainerType();
            switch (iParentContainerType) {
                case 0: {
                    break;
                }
                case 1: {
                    JAScrollPane thePane = new JAScrollPane();
                    JViewport theViewport = new JViewport();
                    theViewport.setView(theObject.theVisualObject);
                    thePane.setViewport(theViewport);
                    sAttachmentCode = "JViewport vp_" + this.getIdentifier(theParentContainer) + "= new JViewport();\r\n";
                    sAttachmentCode = sAttachmentCode + "vp_" + this.getIdentifier(theParentContainer) + ".setView(" + this.getIdentifier(theObject) + ");\r\n";
                    sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".setViewport(vp_" + this.getIdentifier(theParentContainer) + ");\r\n";
                    theParentContainer = theParentContainer.getVisualContainerObject(true);
                    sAttachmentCode = sAttachmentCode + "theRenderer.addFocus(" + this.getIdentifier(theParentContainer) + "," + this.getIdentifier(theObject) + ");\r\n";
                    break;
                }
                case 10: {
                    sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".add(" + sVariableToAttach + ");\r\n";
                    sAttachmentCode = sAttachmentCode + "theRenderer.addFocus(" + this.getIdentifier(theParentContainer) + "," + sVariableToAttach + ");\r\n";
                    break;
                }
                case 6: {
                    sAttachmentCode = "if (" + this.getIdentifier(theObject) + " instanceof JRadioButton)\r\n";
                    sAttachmentCode = this.getGroupName(theParentContainer) + ".add(" + this.getIdentifier(theObject) + ");\r\n";
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".add(\"" + sVariableToAttach + "\"," + sVariableToAttach + ");\r\n";
                    sAttachmentCode = sAttachmentCode + this.getLayoutName(theParentContainer) + ".setAnchoring(" + sVariableToAttach + "," + (theObject.bLeftAnchoring ? "true" : "false") + "," + (theObject.bRightAnchoring ? "true" : "false") + "," + (theObject.bTopAnchoring ? "true" : "false") + "," + (theObject.bBottomAnchoring ? "true" : "false") + ");\r\n";
                    sAttachmentCode = sAttachmentCode + "theRenderer.addFocus(" + this.getIdentifier(theParentContainer) + "," + sVariableToAttach + ");\r\n";
                    if (!(theObject.getSwingObject() instanceof JMenuBar)) break;
                    sAttachmentCode = sAttachmentCode + theObject.theParentObject.getName() + ".setJMenuBar(" + sVariableToAttach + ");\r\n";
                    break;
                }
                case 4: {
                    int iIndex = theParentContainer.getChildIndex(theObject);
                    MetaPropertyValueEx theTabTitle = theParentContainer.getPropertyValue("TabTitle", iIndex);
                    String sTabTitle = "Tab " + iIndex;
                    if (theTabTitle != null) {
                        sTabTitle = theTabTitle.getStringValue();
                        if (this.isNLSTranslationRequired(theTabTitle, sTabTitle)) {
                            sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".addTab(theRenderer.doNLSTranslation(\"" + sTabTitle + "\"), " + this.getIdentifier(theObject) + ");\r\n";
                        } else if (this.isLocalLanguageRequired(theTabTitle)) {
                            String sTestValue = "theRenderer.getCurrentLanguageValue(" + this.getLanguageValuesString(theTabTitle) + ")";
                            sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".addTab(" + sTestValue + ", " + this.getIdentifier(theObject) + ");\r\n";
                        } else {
                            sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".addTab(\"" + sTabTitle + "\", " + this.getIdentifier(theObject) + ");\r\n";
                        }
                    }
                    sAttachmentCode = sAttachmentCode + "theRenderer.addFocus(" + this.getIdentifier(theParentContainer) + "," + this.getIdentifier(theObject) + ");\r\n";
                    break;
                }
                case 8: {
                    if (theObject.equals(theParentContainer.theFirstChild)) {
                        sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".setLeftComponent(" + sVariableToAttach + ");\r\n";
                        break;
                    }
                    sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".setRightComponent(" + sVariableToAttach + ");\r\n";
                    String sDividerLocation = theParentContainer.getPropertyValue("DividerLocation", 0).getLocalString();
                    sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".resetToPreferredSizes();\r\n";
                    sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".setDividerLocation(" + sDividerLocation + ");\r\n";
                    break;
                }
                case 9: {
                    if (theObject.equals(theParentContainer.theFirstChild)) {
                        sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".setTopComponent(" + sVariableToAttach + ");\r\n";
                        break;
                    }
                    sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".setBottomComponent(" + sVariableToAttach + ");\r\n";
                    String sDividerLocation = theParentContainer.getPropertyValue("DividerLocation", 0).getLocalString();
                    sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".resetToPreferredSizes();\r\n";
                    sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".setDividerLocation(" + sDividerLocation + ");\r\n";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".add(" + sVariableToAttach + ");\r\n";
                }
            }
        }
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + sLayoutConstruction;
        this.theBufferCollection.sAttachmentBuffer = this.theBufferCollection.sAttachmentBuffer + sAttachmentCode;
    }

    public void generateProjectCode(String sClassName, MetaProject theProject) throws HammerException {
        this.Variables = new HashMap(0);
        this.VariableClasses = new HashMap(0);
        this.vectorConstants = new Vector(0);
        this.generatePrologCode(theProject, sClassName);
        MetaObject objTest = theProject.getFirstObject();
        while (objTest != null) {
            this.generateObjectCode(objTest);
            objTest = objTest.theNextObject;
        }
        this.generateEpilogCode(theProject);
    }

    public Vector doImports(MetaProject theProject, MetaClass theClass, Vector vImports) {
        String sSuperClass = theClass.theMetadata.sFullClassName;
        if (theClass.theFirstObject != null && sSuperClass != null && sSuperClass.length() > 0) {
            try {
                theProject.getMetaDataUser().getClassLoader().getLoader().loadClass(sSuperClass);
                if (!vImports.contains(sSuperClass)) {
                    vImports.add(sSuperClass);
                }
            }
            catch (ClassNotFoundException e) {
                String sClassDefinition = "class " + sSuperClass.substring(sSuperClass.lastIndexOf(".") + 1);
                String sConstructor = "";
                if (theClass.theMetadata.getSuperClassName() != null && theClass.theMetadata.getSuperClassName().length() > 0) {
                    sClassDefinition = sClassDefinition + " extends " + theClass.theMetadata.getSuperClassName();
                } else {
                    sConstructor = "public " + sSuperClass.substring(sSuperClass.lastIndexOf(".") + 1) + "() {};\r\n";
                }
                sClassDefinition = sClassDefinition + " {\r\n" + sConstructor + "}\r\n\r\n";
                this.theBufferCollection.sAppendedClassBuffer = this.theBufferCollection.sAppendedClassBuffer + sClassDefinition;
            }
        }
        for (theClass = theClass.getFirstClass(); theClass != null; theClass = theClass.getNextSibling()) {
            vImports = this.doImports(theProject, theClass, vImports);
        }
        return vImports;
    }

    public String doImports(MetaProject theProject) {
        String sImports = "";
        Vector vImports = new Vector();
        vImports.add("java.lang.Object");
        for (MetaClass theClass = theProject.getFirstClass(); theClass != null; theClass = theClass.getNextSibling()) {
            vImports = this.doImports(theProject, theClass, vImports);
        }
        String externalImports = this.generateExternalImports(theProject);
        sImports = sImports + "import java.awt.*;\r\n";
        sImports = sImports + "import java.util.*;\r\n";
        sImports = sImports + "import javax.swing.*;\r\n";
        sImports = sImports + "import javax.swing.event.*;\r\n";
        sImports = sImports + "import java.awt.event.*;\r\n";
        sImports = sImports + "import ch.abacus.lib.ui.renderer.abaRenderer.AbaRendererInterface;\r\n";
        sImports = sImports + "import ch.abacus.lib.ui.renderer.common.RenderingProjectInterface;\r\n";
        sImports = sImports + "import ch.abacus.lib.ui.layout.AnchoringLayoutManager;\r\n";
        if (this.getProjectDocument().isOpenSource()) {
            sImports = sImports + "import ch.abacus.lib.ui.renderer.common.jdbc.*;\r\n";
        }
        sImports = sImports + externalImports;
        sImports = sImports + "import ch.abacus.lib.ui.JAScrollPane;\r\n";
        for (int i = 0; i < vImports.size(); ++i) {
            String sImport = (String)vImports.get(i);
            sImports = sImports + "import " + sImport + ";\r\n";
        }
        return sImports;
    }

    public String doImportsObjectBased(MetaProject theProject) {
        String sImports = "";
        String externalImports = this.generateExternalImports(theProject);
        String additionalImports = "";
        externalImports = this.generateExternalImports(theProject);
        if (this.getProjectDocument().isOpenSource()) {
            additionalImports = this.generateAdditionalImports(theProject);
        }
        sImports = sImports + "import java.awt.*;\r\n";
        sImports = sImports + "import java.util.*;\r\n";
        sImports = sImports + "import javax.swing.*;\r\n";
        sImports = sImports + "import javax.swing.event.*;\r\n";
        sImports = sImports + "import java.awt.event.*;\r\n";
        sImports = sImports + "import ch.abacus.lib.ui.renderer.abaRenderer.AbaRendererInterface;\r\n";
        sImports = sImports + "import ch.abacus.lib.ui.renderer.common.RenderingProjectInterface;\r\n";
        sImports = sImports + "import ch.abacus.lib.ui.layout.AnchoringLayoutManager;\r\n";
        if (this.getProjectDocument().isOpenSource()) {
            sImports = sImports + "import ch.abacus.lib.ui.renderer.common.jdbc.*;\r\n";
        }
        sImports = sImports + externalImports;
        sImports = sImports + additionalImports;
        sImports = sImports + "import ch.abacus.lib.ui.JAScrollPane;\r\n";
        for (int i = 0; i < this.vRequiredImports.size(); ++i) {
            String sImport = (String)this.vRequiredImports.get(i);
            sImports = sImports + "import " + sImport + ";\r\n";
        }
        return sImports;
    }

    public void addLocalNLSDocuments(MetaProject theProject) {
        int iDocCount = theProject.theLocalNLSDocuments.size();
        for (int i = 0; i < iDocCount; ++i) {
            HammerNLSAccess theNLSDoc = (HammerNLSAccess)theProject.theLocalNLSDocuments.get(i);
            this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "theRenderer.addNLSDocument(\"" + MetaConstantGroup.preserveEscapeSequences(theNLSDoc.sDocument) + "\",\"" + theNLSDoc.sKey + "\");\r\n";
        }
    }

    public void generateRequiredImports(MetaObject topObject) {
        if (topObject != null) {
            String importClass = topObject.theType.theFullName;
            if (!this.vRequiredImports.contains(importClass)) {
                this.vRequiredImports.add(importClass);
            }
            MetaObject objTest = topObject.theFirstChild;
            while (objTest != null) {
                this.generateRequiredImports(objTest);
                objTest = objTest.theNextObject;
            }
        }
    }

    public void generatePrologCode(MetaProject theProject, String sClassName) {
        this.generateRequiredImports(theProject.getFirstObject());
        String sImports = this.doImportsObjectBased(theProject);
        int iMatch = sClassName.indexOf(46);
        if (iMatch != -1) {
            sClassName = sClassName.substring(0, iMatch);
        }
        String sExtInits = this.generateExternalInit(theProject);
        this.theBufferCollection.sImportBuffer = sImports + "\r\n";
        this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "\r\npublic class " + sClassName + " implements RenderingProjectInterface {\r\n";
        this.theBufferCollection.sAssignmentBuffer1 = "public " + sClassName + "(AbaRendererInterface theRenderer, JFrame theFrame) {\r\n";
        this.theBufferCollection.sAssignmentBuffer1 = this.theBufferCollection.sAssignmentBuffer1 + "contentPane = theFrame.getContentPane();\r\n";
        this.theBufferCollection.sAssignmentBuffer1 = this.theBufferCollection.sAssignmentBuffer1 + "init(theRenderer, false); \r\n}\r\n";
        this.theBufferCollection.sAssignmentBuffer2 = "public " + sClassName + "(AbaRendererInterface theRenderer, JComponent theComponent) {\r\n";
        this.theBufferCollection.sAssignmentBuffer2 = this.theBufferCollection.sAssignmentBuffer2 + "contentPane = (Container)theComponent;\r\n";
        this.theBufferCollection.sAssignmentBuffer2 = this.theBufferCollection.sAssignmentBuffer2 + "init(theRenderer, false); \r\n}\r\n";
        this.theBufferCollection.sAssignmentBuffer3 = "public " + sClassName + "(AbaRendererInterface theRenderer) {\r\n";
        this.theBufferCollection.sAssignmentBuffer3 = this.theBufferCollection.sAssignmentBuffer3 + "init(theRenderer, true);\r\n";
        String sMainObjectIdentifier = theProject.getFirstObject().getName();
        this.theBufferCollection.sAssignmentBuffer3 = this.theBufferCollection.sAssignmentBuffer3 + "// do frame insets\r\n";
        this.theBufferCollection.sAssignmentBuffer3 = this.theBufferCollection.sAssignmentBuffer3 + "Dimension dimSize = " + sMainObjectIdentifier + ".getSize();\r\n";
        this.theBufferCollection.sAssignmentBuffer3 = this.theBufferCollection.sAssignmentBuffer3 + sMainObjectIdentifier + ".setVisible(false);\r\n";
        this.theBufferCollection.sAssignmentBuffer3 = this.theBufferCollection.sAssignmentBuffer3 + sMainObjectIdentifier + ".show();\r\n";
        this.theBufferCollection.sAssignmentBuffer3 = this.theBufferCollection.sAssignmentBuffer3 + "Insets theInsets = " + sMainObjectIdentifier + ".getInsets();\r\n";
        this.theBufferCollection.sAssignmentBuffer3 = this.theBufferCollection.sAssignmentBuffer3 + sMainObjectIdentifier + ".setSize((int) dimSize.getWidth() + theInsets.left + theInsets.right," + "(int) dimSize.getHeight() + theInsets.top + theInsets.bottom);\r\n" + sMainObjectIdentifier + ".setVisible(true);\r\n" + "}\r\n";
        this.theBufferCollection.sAssignmentBuffer = "void init(AbaRendererInterface theRenderer, boolean bMakeFrame) {\r\n";
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + sExtInits;
        this.addLocalNLSDocuments(theProject);
    }

    ListenerDiscriminator findDiscriminator(ArrayList theDiscriminators, MetaClassDetail theClass) {
        int iDiscriminators = theDiscriminators.size();
        for (int i = 0; i < iDiscriminators; ++i) {
            ListenerDiscriminator theDiscriminator = (ListenerDiscriminator)theDiscriminators.get(i);
            if (!theDiscriminator.theClass.equals(theClass)) continue;
            return theDiscriminator;
        }
        return null;
    }

    public void listenerPrint(String sOutputString) {
        this.theBufferCollection.sEventClassBuffer = this.theBufferCollection.sEventClassBuffer + sOutputString;
    }

    public void listenerPrintln(String sOutputString) {
        sOutputString = sOutputString + "\r\n";
        this.listenerPrint(sOutputString);
    }

    public String generateObjectEventClasses(String sSetCode, MetaObject theObject) {
        int i;
        ListenerDiscriminator theDiscriminator;
        MetaMethodLinkage theMethod = theObject.theFirstMethod;
        ArrayList<MetaClassDetail> theListeners = new ArrayList<MetaClassDetail>(0);
        ArrayList<ListenerDiscriminator> theDiscriminators = new ArrayList<ListenerDiscriminator>(0);
        ArrayList<ListenerDiscriminator> theSpecialDiscriminators = new ArrayList<ListenerDiscriminator>(0);
        while (theMethod != null) {
            MetaClassDetail theClass = theMethod.theListener;
            if (!theListeners.contains(theClass)) {
                theListeners.add(theMethod.theListener);
                theDiscriminator = new ListenerDiscriminator(theClass);
                theDiscriminators.add(theDiscriminator);
                theDiscriminator.addMethod(theMethod);
            } else {
                theDiscriminator = this.findDiscriminator(theDiscriminators, theClass);
                theDiscriminator.addMethod(theMethod);
            }
            theMethod = theMethod.theNextMethod;
        }
        for (i = 0; i < theDiscriminators.size(); ++i) {
            theDiscriminator = (ListenerDiscriminator)theDiscriminators.get(i);
            if (!theDiscriminator.isSpecial()) continue;
            theSpecialDiscriminators.add(theDiscriminator);
        }
        for (i = 0; i < theSpecialDiscriminators.size(); ++i) {
            boolean bIsAdapter;
            theDiscriminator = (ListenerDiscriminator)theSpecialDiscriminators.get(i);
            MetaClassDetail theListener = theDiscriminator.theClass;
            String sListenerName = theListener.sClassName;
            String sOutputIdentifier = this.getIdentifier(theObject);
            int iMatchingListener = this.theListenerCollection.getDefaultListenerClass(sListenerName);
            sSetCode = sSetCode + sOutputIdentifier + ".";
            ListenerEntry theEntry = this.theListenerCollection.objDefaultListeners[iMatchingListener];
            sSetCode = sSetCode + theEntry.getAddListenerMethod() + "(";
            sSetCode = sSetCode + "new " + sOutputIdentifier + "$$$" + sListenerName + "());\r\n";
            this.listenerPrintln("/***__@Listener: [" + sOutputIdentifier + "$$$" + sListenerName + "] ***/");
            this.listenerPrint("class " + sOutputIdentifier + "$$$" + sListenerName);
            boolean bl = bIsAdapter = sListenerName.lastIndexOf("Adapter") != -1;
            if (bIsAdapter) {
                this.listenerPrintln(" extends " + sListenerName + "  {");
            } else {
                this.listenerPrintln(" implements " + sListenerName + "  {");
            }
            for (int j = 0; j < theDiscriminator.theMethods.size(); ++j) {
                MetaMethodLinkage theListenerMethodLink = (MetaMethodLinkage)theDiscriminator.theMethods.get(j);
                MetaMethod theListenerMethod = theListenerMethodLink.theMethod;
                String sCode = theListenerMethod.getCode();
                if (sCode.trim().length() != 0) {
                    this.listenerPrintln("/***__@Method: [" + theListenerMethod.getMethodName() + "] ***/");
                    this.listenerPrintln(sCode);
                    this.listenerPrintln("/***__@@Method: [" + theListenerMethod.getMethodName() + "] ***/");
                }
                theListenerMethod = theListenerMethod.getNextMethod();
            }
            this.listenerPrintln("  }");
            this.listenerPrintln("/***__@@Listener: [" + sListenerName + "] ***/");
        }
        return sSetCode;
    }

    public void generateEpilogCode(MetaProject theProject) {
        String sValue;
        String sClassName;
        String sProjectName = theProject.getName();
        int iIndex = sProjectName.indexOf(".");
        sProjectName = sProjectName.substring(0, iIndex);
        this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "Object oTemp;\r\n";
        for (int i = 0; i < this.vectorConstants.size(); ++i) {
            String sCombinedKey = (String)this.vectorConstants.get(i);
            int iMatch1 = sCombinedKey.indexOf("|?|");
            int iMatch2 = sCombinedKey.indexOf("|?|", iMatch1 + 1);
            sClassName = sCombinedKey.substring(0, iMatch1);
            String sConstantName = sCombinedKey.substring(iMatch1 + 3, iMatch2);
            sValue = sCombinedKey.substring(iMatch2 + 3);
            this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + sClassName + " " + sValue + ";\r\n";
            if (sClassName.equals("int")) {
                this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "oTemp = theRenderer.createConstantObject(\"" + sValue + "\",\"" + sConstantName + "\");\r\n";
                this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "if (oTemp instanceof String)\r\n";
                this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "oTemp = new Integer((String)oTemp);\r\n";
                this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + sValue + " = ((Integer)oTemp).intValue();\r\n";
                continue;
            }
            this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + sValue + " = (" + sClassName + ") theRenderer.createConstantObject(\"" + sValue + "\",\"" + sConstantName + "\");\r\n";
        }
        Object[] identifiers = this.Variables.keySet().toArray();
        for (int i = 0; i < identifiers.length; ++i) {
            String sKey = (String)identifiers[i];
            int iMatch = sKey.indexOf("|*|");
            sClassName = sKey.substring(0, iMatch);
            String identifier = sKey.substring(iMatch + 3);
            sValue = (String)this.Variables.get(sKey);
            this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + sClassName + " " + identifier + ";";
            this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + identifier + " = (" + sClassName + ") theRenderer.resolveConstantValue(\"" + sValue + "\");\r\n";
        }
        this.theBufferCollection.sAccessorBuffer = this.theBufferCollection.sAccessorBuffer + "\r\n" + this.theBufferCollection.sPropertyMethodBuffer;
    }

    public String generatePropertyCode(MetaProperty theProperty) throws HammerException {
        String sReturnValue = "";
        int iSize = theProperty.theIndexedValue.size();
        for (int i = 0; i < iSize; ++i) {
            if (sReturnValue.length() > 0) {
                sReturnValue = sReturnValue + ",";
            }
            MetaParameter theParameter = (MetaParameter)theProperty.theIndexedValue.get(i);
            sReturnValue = sReturnValue + this.generateParameterCode(theParameter, theProperty.thePropertyInfo);
        }
        return sReturnValue;
    }

    public String generateParameterCode(MetaParameter theParameter, MetaPropertyDescriptor thePropDesc) throws HammerException {
        boolean bIsString;
        String sTestValue = theParameter.getLiteralValue();
        if (thePropDesc == null) {
            return "";
        }
        String theSimpleType = theParameter.theSimpleType;
        boolean bl = bIsString = theSimpleType != null && (theSimpleType.equalsIgnoreCase("java.lang.String") || theSimpleType.equalsIgnoreCase("String"));
        if (bIsString) {
            sTestValue = sTestValue.indexOf(92) != -1 ? MetaConstantGroup.preserveEscapeSequences("\"" + sTestValue + "\"") : (sTestValue.indexOf(34) != -1 ? "\"" + MetaConstantGroup.protectQuotes(sTestValue) + "\"" : (this.isNLSTranslationRequired(theParameter.theValue, sTestValue) ? "theRenderer.doNLSTranslation(\"" + sTestValue + "\")" : (this.isLocalLanguageRequired(theParameter.theValue) ? "theRenderer.getCurrentLanguageValue(" + this.getLanguageValuesString(theParameter.theValue) + ")" : "\"" + sTestValue + "\"")));
        } else if (theParameter.getMnemonic() & !this.theDocument.isOpenSource() && thePropDesc.getName() != null && thePropDesc.getName().equalsIgnoreCase("mnemonic")) {
            sTestValue = "theRenderer.doNLSMnemonicTranslation(\"" + sTestValue + "\")";
        }
        return this.doCodeGenerationForConstants(theParameter, theParameter.theDesignProject, sTestValue, thePropDesc);
    }

    private boolean isNLSTranslationRequired(MetaPropertyValueEx theValue, String sTestValue) {
        if (!this.bNLSTranslation) {
            return false;
        }
        return sTestValue.startsWith("@AbaNLS.");
    }

    private boolean isLocalLanguageRequired(MetaPropertyValueEx theValue) {
        if (!this.bNLSTranslation && this.theDocument.isOpenSource()) {
            return false;
        }
        if (!theValue.isMultipleLanguages()) {
            return false;
        }
        String[] values = this.getLanguageValues(theValue);
        for (int iLanguage = 0; iLanguage < values.length - 1; ++iLanguage) {
            String s1 = values[iLanguage];
            String s2 = values[iLanguage + 1];
            if (s1 != null && s1.equals(s2)) continue;
            return true;
        }
        return false;
    }

    private String[] getLanguageValues(MetaPropertyValueEx theValue) {
        int iNumLanguages = 4;
        String[] values = new String[iNumLanguages];
        for (int iLanguage = 0; iLanguage < iNumLanguages; ++iLanguage) {
            values[iLanguage] = theValue.getLanguageDependentValue(iLanguage);
        }
        return values;
    }

    private String getLanguageValuesString(MetaPropertyValueEx theValue) {
        String[] values = this.getLanguageValues(theValue);
        String s = "";
        for (int iValue = 0; iValue < values.length; ++iValue) {
            if (iValue > 0) {
                s = s + ", ";
            }
            s = s + "\"" + values[iValue] + "\"";
        }
        return "new String[] {" + s + "}";
    }

    public String doCodeGenerationForConstants(MetaParameter theParameter, MetaProject theProject, String sTestValue, MetaPropertyDescriptor thePropDesc) throws HammerException {
        String sMatch = null;
        if (thePropDesc != null && thePropDesc.getIncludeTypeConstants() != null) {
            MetaConstantGroup theConstantTable = theProject.findConstantGroup(thePropDesc.getIncludeTypeConstants());
            if (theConstantTable != null) {
                sMatch = theConstantTable.getKey(sTestValue);
            } else {
                MetaConstantGroupCollection theConstantTableCollection = theProject.findConstantGroupCollection(thePropDesc.getIncludeTypeConstants());
                if (theConstantTableCollection != null) {
                    sMatch = theConstantTableCollection.getKey(sTestValue);
                }
            }
            if (sMatch != null) {
                String sCombinedKey = thePropDesc.getClassName() + "|?|" + thePropDesc.getIncludeTypeConstants() + "|?|" + sMatch;
                if (!this.isConstantMatch(sMatch)) {
                    this.vectorConstants.add(sCombinedKey);
                }
                sTestValue = sMatch;
            } else {
                Object theThing = MetaConstantGroup.resolve(sTestValue, theParameter.theDesignProject.getMetadataDispenser(), theParameter.theDesignProject.getMetaDataUser().getClassLoader().getLoader());
                String sClass = thePropDesc.getClassName();
                if (!sClass.equals("String") && !(theThing instanceof String)) {
                    sMatch = this.lookupIdentifier(thePropDesc.getClassName(), sTestValue);
                    if (sMatch == null) {
                        sMatch = this.makeIdentifier(thePropDesc.getClassName(), sTestValue);
                    }
                    sTestValue = sMatch;
                }
            }
        } else {
            String sClassName = thePropDesc.getClassName();
            if (!sClassName.endsWith("String") && sTestValue.indexOf("construct") != -1) {
                sMatch = this.lookupIdentifier(thePropDesc.getClassName(), sTestValue);
                if (sMatch == null) {
                    sMatch = this.makeIdentifier(thePropDesc.getClassName(), sTestValue);
                }
                sTestValue = sMatch;
            }
        }
        return sTestValue;
    }

    private boolean isConstantMatch(String sMatch) {
        sMatch = "|" + sMatch;
        for (int i = 0; i < this.vectorConstants.size(); ++i) {
            String sElement = (String)this.vectorConstants.get(i);
            if (!sElement.endsWith(sMatch)) continue;
            return true;
        }
        return false;
    }

    public String getDeclarationBuffer() {
        return this.theBufferCollection.sDeclBuffer;
    }

    public String getAssignmentBuffer() {
        return this.theBufferCollection.sAssignmentBuffer;
    }

    public BufferCollection getBufferCollection() {
        return this.theBufferCollection;
    }

    public void setAssignmentBuffer(String sAssignmentBuffer) {
        this.theBufferCollection.sAssignmentBuffer = sAssignmentBuffer;
    }

    public void setDeclarationBuffer(String sDeclarationBuffer) {
        this.theBufferCollection.sDeclBuffer = sDeclarationBuffer;
    }

    public String lookupIdentifier(String className, String sTestValue) {
        return (String)this.Variables.get(className + "|*|" + sTestValue);
    }

    public String makeIdentifier(String className, String sTestValue) {
        Integer classVariableCount = (Integer)this.VariableClasses.get(className);
        int iClassVarCount = 0;
        if (classVariableCount != null) {
            try {
                iClassVarCount = classVariableCount + 1;
            }
            catch (NumberFormatException e1) {
                // empty catch block
            }
        }
        String sIdentifier = className;
        int iDotPos = sIdentifier.lastIndexOf(".");
        sIdentifier = className.substring(iDotPos + 1) + "_" + iClassVarCount;
        this.Variables.put(className + "|*|" + sIdentifier, sTestValue);
        this.VariableClasses.put(className, new Integer(iClassVarCount));
        return sIdentifier;
    }

    public ListenerCollection getListenerCollection() {
        return this.theListenerCollection;
    }

    public void setListenerCollection(ListenerCollection theListenerCollection) {
        this.theListenerCollection = theListenerCollection;
    }

    public String getFormattedSource() {
        String sSourceCode = this.theBufferCollection.sImportBuffer + "\r\n" + this.theBufferCollection.sDeclBuffer + "\r\n" + this.theBufferCollection.sAccessorBuffer + "\r\n" + this.theBufferCollection.sAssignmentBuffer1 + "\r\n" + "\r\n" + this.theBufferCollection.sAssignmentBuffer2 + "\r\n" + "\r\n" + this.theBufferCollection.sAssignmentBuffer3 + "\r\n" + this.theBufferCollection.sEventClassBuffer + "\r\n" + this.theBufferCollection.sAssignmentBuffer + "\r\n" + this.theBufferCollection.sPropertyBuffer + "\r\n" + this.theBufferCollection.sAttachmentBuffer + "\r\n" + "}\r\n}\r\n";
        CodeFormatter theFormatter = new CodeFormatter();
        StringReader theReader = new StringReader(sSourceCode);
        StringWriter theWriter = new StringWriter(sSourceCode.length());
        theFormatter.formatCode((Reader)theReader, (Writer)theWriter);
        return theWriter.getBuffer().toString();
    }

    private String generateExternalImports(MetaProject theProject) {
        String retVal = "\n";
        if (this.getProjectDocument().isOpenSource()) {
            int extImportCode = 0;
            String externLAF = theProject.getGenCodeLAF();
            extImportCode = theProject.getGenCodeLookFeel(externLAF);
            if (extImportCode == 1) {
                retVal = "import com.jgoodies.plaf.plastic.PlasticXPLookAndFeel;\r\n";
            } else if (extImportCode == 2) {
                retVal = "import com.jgoodies.plaf.plastic.Plastic3DLookAndFeel;\r\n";
            } else if (extImportCode == 3) {
                retVal = "import com.jgoodies.plaf.plastic.PlasticLookAndFeel;\r\n";
            }
        }
        return retVal;
    }

    private String generateExternalInit(MetaProject theProject) {
        String retVal = "\n";
        if (this.getProjectDocument().isOpenSource()) {
            int extImportCode = 0;
            String externLAF = theProject.getGenCodeLAF();
            extImportCode = theProject.getGenCodeLookFeel(externLAF);
            if (extImportCode == 1) {
                retVal = "try {UIManager.setLookAndFeel(new PlasticXPLookAndFeel());}catch (Exception e) {} \n\r";
            } else if (extImportCode == 2) {
                retVal = "try {UIManager.setLookAndFeel(new Plastic3DLookAndFeel());}catch (Exception e) {} \n\r";
            } else if (extImportCode == 3) {
                retVal = "try {UIManager.setLookAndFeel(new PlasticLookAndFeel());}catch (Exception e) {} \n\r";
            }
        }
        return retVal;
    }

    private String generateAdditionalImports(MetaProject theProject) {
        String retVal = "\n";
        retVal = theProject.getAdditionalImports() + "\n";
        return retVal;
    }

    public void reset() {
        this.theBufferCollection = new BufferCollection();
    }
}

