/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.ListenerDiscriminator;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaDataMember;
import ch.abacus.lib.ui.renderer.common.MetaImport;
import ch.abacus.lib.ui.renderer.common.MetaMethod;
import ch.abacus.lib.ui.renderer.common.MetaMethodLinkage;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetadataProvider;
import ch.abacus.lib.ui.renderer.common.UIFactoryBlueprint;
import ch.abacus.lib.ui.renderer.common.UIFactoryException;
import ch.abacus.lib.ui.renderer.common.UIFactoryHighLevelCodeGenerator;
import ch.abacus.lib.ui.renderer.common.UIFactoryLowLevelCodeGenerator;
import com.ibm.cf.CodeFormatter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class UIFactoryCodeGenerator
implements UIFactoryLowLevelCodeGenerator,
UIFactoryHighLevelCodeGenerator {
    MetaProject theProject;
    protected MetadataProvider metadataProvider;
    protected String sSource = "";
    protected String sBegSource = "";
    protected String sBeg2Source = "";
    protected String sEndSource = "";
    protected String sMemberDeclSource = "";
    protected String sDeclSource = "";
    protected String sListenerSource = "";
    protected boolean bAbalet = false;
    protected boolean bGeneratedTabbedPaneListener = false;
    protected String sMainObject = null;
    private String sMainClass;

    public UIFactoryCodeGenerator(MetadataProvider theMetadataProvider, MetaProject theProject, MetaObject theMainObject) throws FileNotFoundException, IOException {
        this.metadataProvider = theMetadataProvider;
        this.theProject = theProject;
        this.sMainObject = theMainObject.getName();
        this.sMainClass = new String(theProject.theProgramData.sProjectName.trim());
        int iKillSpaces = this.sMainClass.indexOf(" ");
        while (iKillSpaces != -1) {
            String sLeftSide = this.sMainClass.substring(0, iKillSpaces);
            String sRightSide = this.sMainClass.substring(iKillSpaces + 1);
            this.sMainClass = sLeftSide + "_" + sRightSide;
            iKillSpaces = this.sMainClass.indexOf(" ");
        }
    }

    public String getSource() {
        return this.sBegSource + this.sMemberDeclSource + this.sBeg2Source + this.sDeclSource + this.sSource + this.sListenerSource + this.sEndSource;
    }

    public String getFormattedSource(int iMaxLineLength, int iIndentation, String sDelims, String sStickyDelims) {
        String sSourceCode = this.sBegSource + this.sMemberDeclSource + this.sBeg2Source + this.sDeclSource + this.sSource + this.sListenerSource + this.sEndSource;
        CodeFormatter theFormatter = new CodeFormatter();
        StringReader theReader = new StringReader(sSourceCode);
        StringWriter theWriter = new StringWriter(sSourceCode.length());
        theFormatter.setDelimiters(sDelims);
        theFormatter.setStickyDelimiters(sStickyDelims);
        theFormatter.setIndentationStep(iIndentation);
        theFormatter.setMaxLineLength(iMaxLineLength);
        theFormatter.formatCode((Reader)theReader, (Writer)theWriter);
        return theWriter.getBuffer().toString();
    }

    public String getFormattedSource() {
        String sSourceCode = this.sBegSource + this.sMemberDeclSource + this.sBeg2Source + this.sDeclSource + this.sSource + this.sListenerSource + this.sEndSource;
        CodeFormatter theFormatter = new CodeFormatter();
        StringReader theReader = new StringReader(sSourceCode);
        StringWriter theWriter = new StringWriter(sSourceCode.length());
        theFormatter.formatCode((Reader)theReader, (Writer)theWriter);
        return theWriter.getBuffer().toString();
    }

    public void generateBasicContainerInitialization(String sFrameIdentifier, String sLayoutType) throws UIFactoryException {
        this.println("//  Get the content pane of the frame.");
        this.println("JPanel contentPane" + sFrameIdentifier + " = (JPanel) " + sFrameIdentifier + ".getContentPane();");
        this.println("// Set the layout.");
        this.println("AnchoringLayoutManager layoutManager" + sFrameIdentifier + " = new AnchoringLayoutManager();");
        this.println("contentPane" + sFrameIdentifier + ".setLayout(layoutManager" + sFrameIdentifier + ");");
    }

    public void generateBasicPanelInitialization(String sPanelIdentifier, String sLayoutType) throws UIFactoryException {
        this.println("AnchoringLayoutManager layoutManager" + sPanelIdentifier + " = new AnchoringLayoutManager();");
        this.println(sPanelIdentifier + ".setLayout(layoutManager" + sPanelIdentifier + ");");
    }

    public void generateBasicGroupInitialization(String sGroupIdentifier, String sLayoutType) throws UIFactoryException {
    }

    public void generateAbaletLinkage() {
        this.bAbalet = true;
    }

    public void generateBasicControlToContentPaneAttachment(String sControlIdentifier, String sContentPaneName, String sContainerName, boolean bAnchorLeft, boolean bAnchorRight, boolean bAnchorTop, boolean bAnchorBottom) {
        this.println("//  Add the control " + sControlIdentifier + " to the content pane.");
        if (!sContentPaneName.equals("")) {
            this.print(sContentPaneName + ".");
        }
        this.println("add(" + sControlIdentifier + ", \"" + sControlIdentifier + "\");");
        this.println("layoutManager" + sContainerName + ".setAnchoring(" + sControlIdentifier + ", " + (bAnchorLeft ? "true, " : "false, ") + (bAnchorRight ? "true, " : "false, ") + (bAnchorTop ? "true, " : "false, ") + (bAnchorBottom ? "true);" : "false);"));
    }

    public void generateBasicControlToTabbedPaneAttachment(String sControlIdentifier, String sContentPaneName, String sCaption) {
        this.println("//  Add the control " + sControlIdentifier + " to the Tabbed pane.");
        if (!sContentPaneName.equals("")) {
            this.print(sContentPaneName + ".");
        }
        this.println("addTab(\"" + sCaption + "\", " + sControlIdentifier + ");");
    }

    public void generateBasicControlToGroupAttachment(String sControlIdentifier, String sContentPaneName) {
        this.println("//  Add the control " + sControlIdentifier + " to the Group.");
        if (!sContentPaneName.equals("")) {
            this.print(sContentPaneName + ".");
        }
        this.println("add(" + sControlIdentifier + ");");
    }

    public void generateBasicControlToMenuAttachment(String sControlIdentifier, String sContentPaneName) {
        this.println("//  Add menu item" + sControlIdentifier + " to Menu.");
        if (!sContentPaneName.equals("")) {
            this.print(sContentPaneName + ".");
        }
        this.println("add(" + sControlIdentifier + ", \"" + sControlIdentifier + "\");");
    }

    public void generateBasicControlToScrollPaneAttachment(String sControlIdentifier, String sContentPaneName) {
        this.println("//  Add the control " + sControlIdentifier + " to the content pane.");
        if (!sContentPaneName.equals("")) {
            this.print(sContentPaneName + ".");
        }
        this.println("setViewportView(" + sControlIdentifier + ");");
    }

    public void generateBasicTabbedPaneInitialization(String sIdentifier) throws UIFactoryException {
        this.println(sIdentifier + ".addChangeListener(new DefaultUIFactoryTabbedPaneListener());");
    }

    public void generateTabbedPaneListener() {
        if (this.bGeneratedTabbedPaneListener) {
            return;
        }
        this.bGeneratedTabbedPaneListener = true;
        this.endPrintln("class DefaultUIFactoryTabbedPaneListener implements ChangeListener {");
        this.endPrintln("int selectedIndex = -1; // -1 = nothing has ever been selected.");
        this.endPrintln("JTabbedPane tp;         // current pane.");
        this.endPrintln("public void stateChanged(ChangeEvent evt) {");
        this.endPrintln("tp = (JTabbedPane) evt.getSource();");
        this.endPrintln("if ((selectedIndex == -1) || (selectedIndex != tp.getSelectedIndex())) {");
        this.endPrintln("tp.setEnabledAt(tp.getSelectedIndex(), false);");
        this.endPrintln("if (selectedIndex != -1)");
        this.endPrintln("tp.setEnabledAt(selectedIndex, true);");
        this.endPrintln("}");
        this.endPrintln("selectedIndex = tp.getSelectedIndex();");
        this.endPrintln("}");
        this.endPrintln("}");
    }

    public void generateBasicControlToPanelAttachment(String sControlIdentifier, String sPanelName, boolean bAnchorLeft, boolean bAnchorRight, boolean bAnchorTop, boolean bAnchorBottom) {
        this.println("//  Add the control " + sControlIdentifier + " to the panel " + sPanelName + ".");
        this.println(sPanelName + ".add(" + sControlIdentifier + ", \"" + sControlIdentifier + "\");");
    }

    public void print(String s) {
        this.sSource = this.sSource + s;
    }

    public void declPrint(String s) {
        this.sDeclSource = this.sDeclSource + s;
    }

    public void begPrint(String s) {
        this.sBegSource = this.sBegSource + s;
    }

    public void begPrintln(String s) {
        this.sBegSource = this.sBegSource + s + '\n';
    }

    public void beg2Print(String s) {
        this.sBeg2Source = this.sBeg2Source + s;
    }

    public void beg2Println(String s) {
        this.sBeg2Source = this.sBeg2Source + s + '\n';
    }

    public void memberDeclPrint(String s) {
        this.sMemberDeclSource = this.sMemberDeclSource + s;
    }

    public void memberDeclPrintln(String s) {
        this.sMemberDeclSource = this.sMemberDeclSource + s + '\n';
    }

    public void listenerPrint(String s) {
        this.sListenerSource = this.sListenerSource + s;
    }

    public void listenerPrintln(String s) {
        this.sListenerSource = this.sListenerSource + s + '\n';
    }

    public void println(String s) {
        this.sSource = this.sSource + s + '\n';
    }

    public void endPrintln(String s) {
        this.sEndSource = this.sEndSource + s + '\n';
    }

    public void endPrint(String s) {
        this.sEndSource = this.sEndSource + s;
    }

    public void declPrintln(String s) {
        this.sDeclSource = this.sDeclSource + s + '\n';
    }

    public void generateDeclaration(Object theObject, String sObjectIdentifier, String sPreCode, boolean bMember) throws UIFactoryException {
        UIFactoryBlueprint obj = (UIFactoryBlueprint)theObject;
        String sFullClassName = obj.getClassName();
        String sClassName = sFullClassName.substring(sFullClassName.lastIndexOf(46) + 1);
        if (bMember) {
            this.memberDeclPrint(sPreCode);
        } else {
            this.declPrint(sPreCode);
        }
        try {
            String sConstructorParameterList = obj.theObject.getConstructorParameters();
            if (sConstructorParameterList == null) {
                sConstructorParameterList = "";
            }
            if (bMember) {
                this.memberDeclPrint("protected " + sClassName + " " + sObjectIdentifier + " = new " + sClassName);
            } else {
                this.declPrint(sClassName + " " + sObjectIdentifier + " = new " + sClassName);
            }
            if (bMember) {
                this.memberDeclPrintln("(" + sConstructorParameterList + ");");
            } else {
                this.declPrintln("(" + sConstructorParameterList + ");");
            }
        }
        catch (Exception e) {
            throw new UIFactoryException("Error in declaration of " + sObjectIdentifier + " during code generation.");
        }
    }

    public void generateAdditionalCustomCode(String sCustomCode) {
        this.println(sCustomCode);
    }

    public void generatePreamble(String sPackageName, String sClassName) throws UIFactoryException {
        this.begPrintln("// PREAMBLE CODE");
        this.begPrintln("package " + sClassName + ";");
        this.begPrintln("");
        MetaImport theImport = this.theProject.theProgramData.theFirstImport;
        if (theImport != null) {
            this.begPrintln("// These are the import packages.");
        }
        while (theImport != null) {
            String sImportName = theImport.sImportName;
            this.begPrintln("import " + sImportName + ";");
            theImport = theImport.theNextImport;
        }
        this.begPrintln("");
    }

    public String getCustomCodeGenerator(String sClassName) {
        MetaClass theMetaClass = this.theProject.findClass(sClassName);
        if (theMetaClass != null && theMetaClass.theMetadata.sCustomCodeGenerationMethod != null) {
            return theMetaClass.theMetadata.sCustomCodeGenerationMethod.trim();
        }
        return "";
    }

    ListenerDiscriminator findDiscriminator(ArrayList theDiscriminators, MetaClassDetail theClass) {
        int iDiscriminators = theDiscriminators.size();
        for (int i = 0; i < iDiscriminators; ++i) {
            ListenerDiscriminator theDiscriminator = (ListenerDiscriminator)theDiscriminators.get(i);
            if (!theDiscriminator.theClass.equals(theClass)) continue;
            return theDiscriminator;
        }
        return null;
    }

    public void generateListenerClasses(String sOutputIdentifier, UIFactoryBlueprint theObject) {
        int i;
        ListenerDiscriminator theDiscriminator;
        MetaObject theDesignObject = theObject.theObject;
        MetaMethodLinkage theMethod = theDesignObject.theFirstMethod;
        ArrayList<MetaClassDetail> theListeners = new ArrayList<MetaClassDetail>(0);
        ArrayList<ListenerDiscriminator> theDiscriminators = new ArrayList<ListenerDiscriminator>(0);
        while (theMethod != null) {
            MetaClassDetail theClass = theMethod.theListener;
            if (!theListeners.contains(theClass)) {
                theListeners.add(theMethod.theListener);
                theDiscriminator = new ListenerDiscriminator(theClass);
                theDiscriminators.add(theDiscriminator);
                theDiscriminator.addMethod(theMethod);
            } else {
                theDiscriminator = this.findDiscriminator(theDiscriminators, theClass);
                theDiscriminator.addMethod(theMethod);
            }
            theMethod = theMethod.theNextMethod;
        }
        for (i = 0; i < theDiscriminators.size(); ++i) {
            theDiscriminator = (ListenerDiscriminator)theDiscriminators.get(i);
            if (theDiscriminator.isSpecial()) continue;
            theDiscriminators.remove(theDiscriminator);
        }
        for (i = 0; i < theDiscriminators.size(); ++i) {
            boolean bIsAdapter;
            theDiscriminator = (ListenerDiscriminator)theDiscriminators.get(i);
            MetaClassDetail theListener = theDiscriminator.theClass;
            String sListenerName = theListener.sClassName;
            this.listenerPrintln("/***__@Listener: [" + sOutputIdentifier + "$$$" + sListenerName + "] ***/");
            this.listenerPrint("class " + sOutputIdentifier + "$$$" + sListenerName);
            boolean bl = bIsAdapter = sListenerName.lastIndexOf("Adapter") != -1;
            if (bIsAdapter) {
                this.listenerPrintln(" extends " + sListenerName + "  {");
            } else {
                this.listenerPrintln(" implements " + sListenerName + "  {");
            }
            for (MetaMethod theListenerMethod = theListener.theFirstMethod; theListenerMethod != null; theListenerMethod = theListenerMethod.getNextMethod()) {
                String sCode = theListenerMethod.getCode();
                if (sCode.trim().length() == 0) continue;
                this.listenerPrintln("/***__@Method: [" + theListenerMethod.sMethodName + "] ***/");
                this.listenerPrintln(sCode);
                this.listenerPrintln("/***__@@Method: [" + theListenerMethod.sMethodName + "] ***/");
            }
            this.listenerPrintln("  }");
            this.listenerPrintln("/***__@@Listener: [" + sListenerName + "] ***/");
        }
        theObject.theDiscriminators = theDiscriminators;
    }

    public void generateMainClass(String sClassName) {
        this.begPrintln("/***__@Class: [" + sClassName + "] ***/");
        this.begPrintln("public class " + sClassName);
        this.begPrintln("{");
        if (this.sMainObject != null) {
            this.begPrintln("public " + sClassName + " theProjectWrapper = this;");
        }
        if (!this.bAbalet) {
            this.beg2Println("public " + sClassName + " () {");
        } else {
            this.beg2Println("Object theServerLink;");
            this.beg2Println("boolean bIsShutdown = false");
            this.beg2Println("public " + sClassName + " (Object theServerLink) {");
            this.beg2Println("bIsShutdown = false;");
            this.beg2Println("this.theServerLink = theServerLink;");
            this.beg2Println("registerWithServer();");
        }
        this.beg2Println("try {");
        this.beg2Println("initializeInterface();");
        this.beg2Println("} catch (Exception e) {");
        this.beg2Println("e.printStackTrace();");
        this.beg2Println("}");
        this.beg2Println("}");
        this.beg2Println("");
        this.beg2Println("public void initializeInterface() {");
    }

    public void generateClasses() throws UIFactoryException {
        MetaClass theClass = this.theProject.theFirstClass;
        boolean bSpecializedClassesExist = false;
        this.generateMainClass(this.sMainClass);
        while (theClass != null) {
            String sClassName = theClass.theMetadata.sClassName;
            if (theClass.theFirstObject != null) {
                String sFullSuperClassName = null;
                String sSuperClass = null;
                int iMethods = theClass.theMetadata.iNumberOfMethods;
                int iMemberData = theClass.theMetadata.iNumberOfDataElements;
                if (iMethods != 0 || iMemberData != 0) {
                    if (!bSpecializedClassesExist) {
                        this.endPrintln("// Declare specialized classes.");
                        bSpecializedClassesExist = true;
                    }
                    Class<?> clsSuper = null;
                    if (sFullSuperClassName != null) {
                        String sInstantiableClass = sFullSuperClassName;
                        while (clsSuper == null && sInstantiableClass != null) {
                            try {
                                clsSuper = Class.forName(sInstantiableClass);
                            }
                            catch (ClassNotFoundException e) {
                                int iLastIndex = sInstantiableClass.lastIndexOf(".") + 1;
                                String sTestClass = sInstantiableClass.substring(iLastIndex);
                                MetaClass theTestClass = this.theProject.findClass(sTestClass);
                                sInstantiableClass = null;
                                if (theTestClass == null) continue;
                                sSuperClass = theTestClass.theMetadata.sClassName;
                                if (sSuperClass != null) {
                                    sInstantiableClass = sSuperClass;
                                }
                                sFullSuperClassName = sSuperClass;
                            }
                        }
                        this.endPrintln("/***__@Class: [" + sClassName + "] ***/");
                        this.endPrintln("class " + sClassName + " extends " + sFullSuperClassName);
                        this.endPrintln("{");
                        MetaDataMember theMemberData = theClass.theMetadata.theFirstData;
                        while (theMemberData != null) {
                            String s = "/**\n  *\n  *  ";
                            s = theMemberData.getDoc() != null ? s + theMemberData.getDataName() + " - " + theMemberData.getDoc() : s + theMemberData.getDataName() + " - Needs documentation";
                            s = s + "\n";
                            s = s + "*\n";
                            s = s + "*/\n\n";
                            s = s + "protected " + theMemberData.getTypeName() + "    " + theMemberData.getDataName();
                            if (theMemberData.getValue() != null) {
                                s = s + " = " + theMemberData.getValue();
                            }
                            s = s + ";\n\n";
                            this.endPrintln("/***__@Member Data: [" + theMemberData.getDataName() + "] ***/");
                            this.endPrintln(s);
                            this.endPrintln("/***__@@Member Data: [" + theMemberData.getDataName() + "] ***/");
                        }
                        if (clsSuper != null) {
                            Constructor<?>[] theConstructors = clsSuper.getConstructors();
                            int iConstructorCount = theConstructors.length;
                            int iConstructor = 0;
                            for (iConstructor = 0; iConstructor < iConstructorCount; ++iConstructor) {
                                String sConstructorMethod = "  public " + sClassName + "(";
                                String sConstructorDoc = "  /**\n";
                                sConstructorDoc = sConstructorDoc + "    *  Constructor for class " + sClassName + " derived from constructor of " + sFullSuperClassName + "\n";
                                Constructor<?> constructorTest = theConstructors[iConstructor];
                                Class<?>[] classesConstructorParam = constructorTest.getParameterTypes();
                                String sSuperParamList = " ";
                                for (int j = 0; j < classesConstructorParam.length; ++j) {
                                    Class<?> clsParam = classesConstructorParam[j];
                                    String sLongParamClassName = clsParam.getName();
                                    StringBuffer sShortParamClassName = new StringBuffer(sLongParamClassName.substring(sLongParamClassName.lastIndexOf(46) + 1));
                                    int iNameLength = sShortParamClassName.length();
                                    if (sLongParamClassName.endsWith(";")) {
                                        sShortParamClassName.setLength(iNameLength - 1);
                                        sShortParamClassName = sShortParamClassName.append("[]");
                                    }
                                    sConstructorMethod = sConstructorMethod + sShortParamClassName + " param" + j;
                                    sSuperParamList = sSuperParamList + "param" + j;
                                    if (j == classesConstructorParam.length - 1) continue;
                                    sSuperParamList = sSuperParamList + ", ";
                                    sConstructorMethod = sConstructorMethod + ", ";
                                }
                                sConstructorMethod = sConstructorMethod + " ) {\n";
                                sConstructorMethod = sConstructorMethod + "    super(" + sSuperParamList + " );\n";
                                sConstructorMethod = sConstructorMethod + "  }\n";
                                this.endPrintln(sConstructorDoc + "    */\n\n" + sConstructorMethod + "\n");
                            }
                        }
                        MetaMethod theMethod = theClass.theMetadata.theFirstMethod;
                        while (theMethod != null) {
                            this.endPrintln("/***__@Method: [" + theMethod.getMethodName() + "] ***/");
                            if (theMethod.getDoc() != null) {
                                String s = theMethod.getDoc();
                                this.endPrintln(s);
                            }
                            if (theMethod.getCode() != null) {
                                String s = theMethod.getCode();
                                this.endPrintln(s);
                            }
                            this.endPrintln("/***__@@Method: [" + theMethod.getMethodName() + "] ***/");
                        }
                        this.endPrintln("}");
                        this.endPrintln("/***__@@Class: [" + sClassName + "] ***/");
                        this.endPrintln("");
                    }
                }
            }
            theClass = theClass.theNextSibling;
        }
    }

    public void generateAbalet() {
        this.println("private Object theServerLink;");
        this.println("private String theTitle;");
        this.println("private boolean bIsShutdown;");
        this.println("HashMap theParameters = null;");
        this.println("public HashMap getAbaletParameters() {");
        this.println("HashMap objRetVal = null;");
        this.println("Class cls = theServerLink.getClass();  // actually an applet link");
        this.println("Class clsParams[] = new Class[1];");
        this.println("try {");
        this.println("clsParams[0] = Class.forName(\"java.lang.Object\");");
        this.println("Method m = cls.getMethod(\"getParameters\", clsParams);");
        this.println("objRetVal = (HashMap)m.invoke(theServerLink, null);");
        this.println("}");
        this.println("catch (java.lang.NoSuchMethodException e1) {");
        this.println("return null;");
        this.println("}");
        this.println("catch (java.lang.reflect.InvocationTargetException e2) {");
        this.println("return null;");
        this.println("}");
        this.println("catch (java.lang.IllegalAccessException e3) {");
        this.println("return null;");
        this.println("}");
        this.println("catch (java.lang.ClassNotFoundException e4) {");
        this.println("return null;");
        this.println("}");
        this.println("return objRetVal;");
        this.println("}");
        this.println("public String getParameterValueByName(String sName) {");
        this.println("Class cls = theServerLink.getClass();  // actually an applet link");
        this.println("Class clsParams[] = new Class[1];");
        this.println("String sRetVal = null;");
        this.println("try {");
        this.println("clsParams[0] = Class.forName(\"java.lang.String\");");
        this.println("Method m = cls.getMethod(\"getParameterValueByName\", clsParams);");
        this.println("Object objParams[] = new Object[1];");
        this.println("objParams[0] = sName;");
        this.println("sRetVal = (String)m.invoke(theServerLink, objParams);");
        this.println("}");
        this.println("catch (java.lang.NoSuchMethodException e1) {");
        this.println("return null;");
        this.println("}");
        this.println("catch (java.lang.reflect.InvocationTargetException e2) {");
        this.println("return null;");
        this.println("}");
        this.println("catch (java.lang.IllegalAccessException e3) {");
        this.println("return null;");
        this.println("}");
        this.println("catch (java.lang.ClassNotFoundException e4) {");
        this.println("return null;");
        this.println("}");
        this.println("return sRetVal;");
        this.println("}");
        this.println("public Boolean canShutdown() {");
        this.println("Object confirmText = \"Do you really want to shut down the application?\";");
        this.println("String confirmTitle = \"Shutdown Confirmation for \"+theTitle;");
        this.println("int optionType = JOptionPane.YES_NO_OPTION;");
        this.println("int messageType = JOptionPane.QUESTION_MESSAGE;");
        this.println("// if selection is 'yes', selected value is 0");
        this.println("// if selection is 'no', selected value is 1");
        this.println("int selectedValue = JOptionPane.showConfirmDialog(this, confirmText, confirmTitle, optionType, messageType);");
        this.println("if (selectedValue==0) {");
        this.println("return new Boolean(true);");
        this.println("}");
        this.println("else return new Boolean(false);");
        this.println("}");
        this.println("public void doShutdown() {");
        this.println("hide();");
        this.println("bIsShutdown = true;");
        this.println("}");
        this.println("public Boolean isShutdown() {");
        this.println("return new Boolean(bIsShutdown);");
        this.println("}");
        this.println("public boolean registerWithServer() {");
        this.println("Class cls = theServerLink.getClass();  // actually an applet link");
        this.println("Class clsParams[] = new Class[1];");
        this.println("try {");
        this.println("clsParams[0] = Class.forName(\"java.lang.Object\");");
        this.println("Method m = cls.getMethod(\"addObject\", clsParams);");
        this.println("Object objParams[] = new Object[1];");
        this.println("objParams[0] = this;");
        this.println("m.invoke(theServerLink, objParams);");
        this.println("}");
        this.println("catch (java.lang.NoSuchMethodException e1) {");
        this.println("return false;");
        this.println("}");
        this.println("catch (java.lang.reflect.InvocationTargetException e2) {");
        this.println("return false;");
        this.println("}");
        this.println("catch (java.lang.IllegalAccessException e3) {");
        this.println("return false;");
        this.println("}");
        this.println("catch (java.lang.ClassNotFoundException e4) {");
        this.println("return false;");
        this.println("}");
        this.println("return true;");
        this.println("}");
        this.println("public boolean unregisterWithServer() {");
        this.println("Class cls = theServerLink.getClass();  // actually an applet link");
        this.println("Class clsParams[] = new Class[1];");
        this.println("try {");
        this.println("clsParams[0] = Class.forName(\"java.lang.Object\");");
        this.println("Method m = cls.getMethod(\"removeObject\", clsParams);");
        this.println("Object objParams[] = new Object[1];");
        this.println("objParams[0] = this;");
        this.println("m.invoke(theServerLink, objParams);");
        this.println("}");
        this.println("catch (java.lang.NoSuchMethodException e1) {");
        this.println("return false;");
        this.println("}");
        this.println("catch (java.lang.reflect.InvocationTargetException e2) {");
        this.println("return false;");
        this.println("}");
        this.println("catch (java.lang.IllegalAccessException e3) {");
        this.println("return false;");
        this.println("}");
        this.println("catch (java.lang.ClassNotFoundException e4) {");
        this.println("return false;");
        this.println("}");
        this.println("return true;");
        this.println("}");
        this.println("public void exitingCode() { ");
        this.println("bIsShutdown = true;");
        this.println("unregisterWithServer();");
        this.println("}");
    }

    public void generateEpilogue(String sFrameObjectName, String sLookAndFeel) throws UIFactoryException {
        this.println("// Show the main window");
        this.println(sFrameObjectName + ".show();");
        this.println("  }  // End of the initializeInterface method. ");
        if (this.bAbalet) {
            this.generateAbalet();
        }
        if (this.bAbalet) {
            this.println("public void jammMain(String[] args, Object objServerLink, Object userObject) {");
            this.println(this.sMainClass + " objMain = new " + this.sMainClass + "(objServerLink);");
            this.println("}");
        } else {
            this.println("public static void main(String[] args) {");
            if (sLookAndFeel != null) {
                this.println("try {");
                this.println("UIManager.setLookAndFeel(\"" + sLookAndFeel + "\");");
                this.println("} catch(Exception evt) {");
                this.println("JOptionPane.showMessageDialog(null, \"Cannot set look and feel to " + sLookAndFeel + "\", \"Swing Error\", JOptionPane.INFORMATION_MESSAGE);");
                this.println("}");
            }
            this.println(this.sMainClass + " objMain = new " + this.sMainClass + "();");
            this.println("}");
        }
        this.endPrintln("}");
        this.endPrintln("/***__@@Class: [" + this.sMainClass + "] ***/");
        this.endPrintln("");
        this.endPrintln("");
        this.generateClasses();
        this.endPrintln("");
    }
}

