/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

public class MetadataChange {
    int iChangeType = 0;
    static final int CLASS_ADDED = 1;
    static final int PROPERTY_ADDED = 2;
    static final int CLASS_REMOVED = 3;
    static final int PROPERTY_REMOVED = 4;
    static final int CLASS_NAME_CHANGED = 5;
    static final int PROPERTY_NAME_CHANGED = 6;
    static final int CLASS_INFORMATION_CHANGED = 7;
    static final int DEFAULT_VALUE_CHANGED = 8;
    static final int CONSTANT_DEFINITION_ADDED = 9;
    static final int CONSTANT_DEFINITION_REMOVED = 10;
    static final int CONSTANT_DEFINITION_CHANGED = 11;
    static final int PROPERTY_TYPE_CHANGED = 12;
    String sOldClassName;
    String sOldPropertyName;
    String sOldTypeName;
    String sOldTypeLongName;
    String sOldFactoryName;
    String sOldConstant;
    String sOldValue;
    String sOldConstantGroup;
    String sOldPropertyType;
    String sNewClassName;
    String sNewPropertyName;
    String sNewTypeName;
    String sNewTypeLongName;
    String sNewFactoryName;
    String sNewConstant;
    String sNewValue;
    String sNewConstantGroup;
    String sNewPropertyType;

    public MetadataChange(int iChangeType) {
        this.iChangeType = iChangeType;
    }

    public static MetadataChange createClassAdditionTrace(String sNewClassName) {
        MetadataChange theMetaDataChange = new MetadataChange(1);
        theMetaDataChange.sNewClassName = sNewClassName;
        return theMetaDataChange;
    }

    public static MetadataChange createPropertyAdditionTrace(String sNewPropertyName) {
        MetadataChange theMetaDataChange = new MetadataChange(2);
        theMetaDataChange.sNewPropertyName = sNewPropertyName;
        return theMetaDataChange;
    }

    public static MetadataChange createClassRemovalTrace(String sOldClassName) {
        MetadataChange theMetaDataChange = new MetadataChange(3);
        theMetaDataChange.sOldClassName = sOldClassName;
        return theMetaDataChange;
    }

    public static MetadataChange createPropertyRemovalTrace(String sOldPropertyName) {
        MetadataChange theMetaDataChange = new MetadataChange(4);
        theMetaDataChange.sOldPropertyName = sOldPropertyName;
        return theMetaDataChange;
    }

    public static MetadataChange createClassNameChangedTrace(String sOldClassName, String sNewClassName) {
        MetadataChange theMetaDataChange = new MetadataChange(5);
        theMetaDataChange.sOldClassName = sOldClassName;
        theMetaDataChange.sNewClassName = sNewClassName;
        return theMetaDataChange;
    }

    public static MetadataChange createPropertyNameChangedTrace(String sClassName, String sPropertyName, String sOldPropertyName) {
        MetadataChange theMetaDataChange = new MetadataChange(6);
        theMetaDataChange.sOldClassName = sClassName;
        theMetaDataChange.sOldPropertyName = sOldPropertyName;
        theMetaDataChange.sNewPropertyName = sPropertyName;
        return theMetaDataChange;
    }

    public static MetadataChange createPropertyTypeChangedTrace(String sOldClassName, String sOldPropertyName, String sOldType, String sNewType) {
        MetadataChange theMetaDataChange = new MetadataChange(8);
        theMetaDataChange.sOldClassName = sOldClassName;
        theMetaDataChange.sOldPropertyName = sOldPropertyName;
        theMetaDataChange.sOldPropertyType = sOldType;
        theMetaDataChange.sNewPropertyType = sNewType;
        return theMetaDataChange;
    }

    public static MetadataChange createClassInformationChangedTrace(String sNewFactoryName, String sNewTypeName, String sNewTypeLongName, String sOldFactoryName, String sOldTypeName, String sOldTypeLongName) {
        MetadataChange theMetaDataChange = new MetadataChange(7);
        theMetaDataChange.sNewFactoryName = sNewFactoryName;
        theMetaDataChange.sNewTypeName = sNewTypeName;
        theMetaDataChange.sNewTypeLongName = sNewTypeLongName;
        theMetaDataChange.sOldFactoryName = sOldFactoryName;
        theMetaDataChange.sOldTypeName = sOldTypeName;
        theMetaDataChange.sOldTypeLongName = sOldTypeLongName;
        return theMetaDataChange;
    }

    public static MetadataChange createDefaultValueChangedTrace(String sOldClassName, String sOldPropertyName, String sOldValue, String sNewValue) {
        MetadataChange theMetaDataChange = new MetadataChange(8);
        theMetaDataChange.sOldClassName = sOldClassName;
        theMetaDataChange.sOldPropertyName = sOldPropertyName;
        theMetaDataChange.sOldValue = sOldValue;
        theMetaDataChange.sNewValue = sNewValue;
        return theMetaDataChange;
    }

    public static MetadataChange createConstantDefinitonAdditionTrace(String sNewConstantGroup, String sNewConstant, String sNewValue) {
        MetadataChange theMetaDataChange = new MetadataChange(9);
        theMetaDataChange.sNewConstantGroup = sNewConstantGroup;
        theMetaDataChange.sNewConstant = sNewConstant;
        theMetaDataChange.sNewValue = sNewValue;
        return theMetaDataChange;
    }

    public static MetadataChange createConstantDefinitonRemovalTrace(String sOldConstantGroup, String sOldConstant, String sOldValue) {
        MetadataChange theMetaDataChange = new MetadataChange(10);
        theMetaDataChange.sOldConstantGroup = sOldConstantGroup;
        theMetaDataChange.sOldConstant = sOldConstant;
        theMetaDataChange.sOldValue = sOldValue;
        return theMetaDataChange;
    }

    public static MetadataChange createConstantDefinitonRemovalTrace(String sOldConstantGroup, String sOldConstant, String sOldValue, String sNewValue) {
        MetadataChange theMetaDataChange = new MetadataChange(11);
        theMetaDataChange.sOldConstantGroup = sOldConstantGroup;
        theMetaDataChange.sOldConstant = sOldConstant;
        theMetaDataChange.sOldValue = sOldValue;
        theMetaDataChange.sNewValue = sNewValue;
        return theMetaDataChange;
    }

    public String getDescription() {
        switch (this.iChangeType) {
            case 1: {
                return "Adding class " + this.sNewClassName;
            }
            case 7: {
                return "Changed class information for " + this.sOldClassName;
            }
            case 5: {
                return "Changed class name from " + this.sOldClassName + " to " + this.sNewClassName;
            }
            case 3: {
                return "Removed class " + this.sOldClassName;
            }
            case 9: {
                return "Added constant definition " + this.sNewConstant + " to " + this.sNewConstantGroup;
            }
            case 11: {
                return "Changed constant definition of " + this.sOldConstant + " of " + this.sOldConstantGroup;
            }
            case 10: {
                return "Removed constant definition of " + this.sOldConstant + " from " + this.sOldConstantGroup;
            }
            case 2: {
                return "Added property " + this.sNewPropertyName + " to " + this.sNewClassName;
            }
            case 6: {
                return "Changed the property name of class " + this.sOldClassName + " from " + this.sOldPropertyName + " to " + this.sNewPropertyName;
            }
            case 4: {
                return "Removed property " + this.sOldPropertyName;
            }
            case 12: {
                return "Changed property type of property " + this.sOldPropertyName + " from " + this.sOldPropertyType + " to " + this.sNewPropertyType;
            }
        }
        return "I don't know what changed!";
    }
}

