/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaParameter;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetaType;
import ch.abacus.lib.ui.renderer.common.MetadataChange;
import ch.abacus.lib.ui.renderer.common.MetadataChanges;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import electric.xml.Element;
import electric.xml.Elements;

public class MetadataAdministrator {
    MetadataAdministrator thePreviousVersioning;
    public int iVersionNumber = 0;
    public int iSubrevisionNumber = 0;
    public int iRevisionNumber = 0;
    public int iBuildNumber = 0;
    MetaProject theDesignProject;
    MetadataChanges theChanges = new MetadataChanges();

    public MetadataAdministrator(MetadataDispenser theMetadataDispenser, Element xmlVersion) {
        Element xmlBuildNumber;
        Element xmlSubrevisionNumber;
        Element xmlRevisionNumber;
        Element xmlVersionNumber = xmlVersion.getElement("VersionNumber");
        if (xmlVersionNumber != null) {
            Integer theVersionNumber = new Integer(xmlVersionNumber.getTextString());
            this.iVersionNumber = theVersionNumber;
        }
        if ((xmlRevisionNumber = xmlVersion.getElement("RevisionNumber")) != null) {
            Integer theRevisionNumber = new Integer(xmlRevisionNumber.getTextString());
            this.iRevisionNumber = theRevisionNumber;
        }
        if ((xmlSubrevisionNumber = xmlVersion.getElement("SubrevisionNumber")) != null) {
            Integer theSubrevisionNumber = new Integer(xmlSubrevisionNumber.getTextString());
            this.iSubrevisionNumber = theSubrevisionNumber;
        }
        if ((xmlBuildNumber = xmlVersion.getElement("BuildNumber")) != null) {
            Integer theBuildNumber = new Integer(xmlBuildNumber.getTextString());
            this.iBuildNumber = theBuildNumber;
        }
    }

    private void load(Element xmlWhatChanged) {
        if (xmlWhatChanged == null) {
            return;
        }
        Elements xmlConstants = xmlWhatChanged.getElements("Constants");
        int iConstantCount = xmlConstants.size();
        for (int i = 0; i < iConstantCount; ++i) {
            Element xmlConstant = xmlConstants.next();
        }
        Elements xmlClasses = xmlWhatChanged.getElements("Classes");
        int iClassCount = xmlClasses.size();
        for (int i = 0; i < iClassCount; ++i) {
            MetadataChange theEvent;
            Element xmlNewName;
            Element xmlOldName;
            Element xmlClass = xmlClasses.next();
            String sClass = xmlClass.getTextString();
            Element xmlCommand = xmlClass.getElement("Command");
            if (xmlCommand != null) {
                String sCommand = xmlCommand.getTextString();
                if (sCommand.equalsIgnoreCase("add")) {
                    MetadataChange theEvent2 = MetadataChange.createClassAdditionTrace(sClass);
                    this.theChanges.addChange(theEvent2);
                } else if (sCommand.equalsIgnoreCase("delete")) {
                    MetadataChange theEvent3 = MetadataChange.createClassRemovalTrace(sClass);
                    this.theChanges.addChange(theEvent3);
                } else if (sCommand.equalsIgnoreCase("data")) {
                    String sNewFactory = null;
                    String sNewType = null;
                    String sNewLongType = null;
                    String sOldFactory = null;
                    String sOldType = null;
                    String sOldLongType = null;
                    Element xmlFactory = xmlClass.getElement("Factory");
                    Element xmlType = xmlClass.getElement("Type");
                    Element xmlLongType = xmlClass.getElement("LongType");
                    if (xmlFactory != null) {
                        xmlOldName = xmlFactory.getElement("OldName");
                        sOldFactory = xmlOldName.getTextString();
                        xmlNewName = xmlFactory.getElement("NewName");
                        sNewFactory = xmlNewName.getTextString();
                    }
                    if (xmlType != null) {
                        xmlOldName = xmlType.getElement("OldName");
                        sOldType = xmlOldName.getTextString();
                        xmlNewName = xmlType.getElement("NewName");
                        sNewType = xmlNewName.getTextString();
                    }
                    if (xmlLongType != null) {
                        xmlOldName = xmlLongType.getElement("OldName");
                        sOldLongType = xmlOldName.getTextString();
                        xmlNewName = xmlLongType.getElement("NewName");
                        sNewLongType = xmlNewName.getTextString();
                    }
                    theEvent = MetadataChange.createClassInformationChangedTrace(sNewFactory, sNewType, sNewLongType, sOldFactory, sOldType, sOldLongType);
                    this.theChanges.addChange(theEvent);
                } else if (sCommand.equalsIgnoreCase("name")) {
                    Element xmlOldName2 = xmlClass.getElement("OldName");
                    String sOldClass = null;
                    if (xmlOldName2 != null) {
                        sOldClass = xmlOldName2.getTextString();
                    }
                    MetadataChange theEvent4 = MetadataChange.createClassNameChangedTrace(sOldClass, sClass);
                    this.theChanges.addChange(theEvent4);
                }
            }
            Elements xmlProperties = xmlClass.getElements("Property");
            int iPropertyCount = xmlProperties.size();
            for (int j = 0; j < iPropertyCount; ++j) {
                MetadataChange theEvent5;
                Element xmlProperty = xmlProperties.next();
                String sProperty = xmlProperty.getTextString();
                Element xmlPropertyCommand = xmlClass.getElement("Command");
                if (xmlPropertyCommand == null) continue;
                String sCommand = xmlPropertyCommand.getTextString();
                if (sCommand.equalsIgnoreCase("add")) {
                    theEvent5 = MetadataChange.createPropertyAdditionTrace(sProperty);
                    this.theChanges.addChange(theEvent5);
                    continue;
                }
                if (sCommand.equalsIgnoreCase("delete")) {
                    theEvent5 = MetadataChange.createPropertyRemovalTrace(sProperty);
                    this.theChanges.addChange(theEvent5);
                    continue;
                }
                if (sCommand.equalsIgnoreCase("type")) {
                    String sNewType = null;
                    String sOldType = null;
                    Element xmlType = xmlClass.getElement("Type");
                    if (xmlType != null) {
                        xmlOldName = xmlType.getElement("OldName");
                        sOldType = xmlOldName.getTextString();
                        xmlNewName = xmlType.getElement("NewName");
                        sNewType = xmlNewName.getTextString();
                    }
                    theEvent = MetadataChange.createPropertyTypeChangedTrace(sClass, sProperty, sOldType, sNewType);
                    this.theChanges.addChange(theEvent);
                    continue;
                }
                if (!sCommand.equalsIgnoreCase("name")) continue;
                Element xmlOldName3 = xmlClass.getElement("OldName");
                String sOldProperty = null;
                if (xmlOldName3 != null) {
                    sOldProperty = xmlOldName3.getTextString();
                }
                MetadataChange theEvent6 = MetadataChange.createPropertyNameChangedTrace(sClass, sProperty, sOldProperty);
                this.theChanges.addChange(theEvent6);
            }
        }
    }

    public static int calculateVersionMagnitude(int version, int revision, int subrevision, int build) {
        return build + 256 * subrevision + 65536 * revision + 0x1000000 * version;
    }

    public int calculateVersionMagnitude() {
        return this.iBuildNumber + 256 * this.iSubrevisionNumber + 65536 * this.iRevisionNumber + 0x1000000 * this.iVersionNumber;
    }

    int getChangeCount() {
        int iChanges = 0;
        if (this.thePreviousVersioning != null && this.thePreviousVersioning.calculateVersionMagnitude() > MetadataAdministrator.calculateVersionMagnitude(this.theDesignProject.iMetadataVersion, this.theDesignProject.iMetadataRevision, this.theDesignProject.iMetadataSubrevision, this.theDesignProject.iMetadataBuild)) {
            iChanges = this.thePreviousVersioning.getChangeCount();
        }
        return iChanges += this.theChanges.getChangeCount();
    }

    String getChangeDescription(int iChange) {
        int iPreviousChanges = 0;
        if (this.thePreviousVersioning != null && this.thePreviousVersioning.calculateVersionMagnitude() > MetadataAdministrator.calculateVersionMagnitude(this.theDesignProject.iMetadataVersion, this.theDesignProject.iMetadataRevision, this.theDesignProject.iMetadataSubrevision, this.theDesignProject.iMetadataBuild)) {
            iPreviousChanges = this.thePreviousVersioning.getChangeCount();
        }
        if (iChange < iPreviousChanges) {
            return this.thePreviousVersioning.getChangeDescription(iChange);
        }
        MetadataChange theChange = this.theChanges.getChange(iChange -= iPreviousChanges);
        if (theChange != null) {
            return theChange.getDescription();
        }
        return null;
    }

    boolean applyChanges() {
        MetaObject theObject = this.theDesignProject.getFirstObject();
        while (theObject != null) {
            this.applyChanges(theObject);
            theObject = theObject.theNextObject;
        }
        return true;
    }

    private boolean applyChanges(MetaObject theObject) {
        boolean bRetVal = true;
        if (this.thePreviousVersioning != null && this.thePreviousVersioning.calculateVersionMagnitude() > MetadataAdministrator.calculateVersionMagnitude(this.theDesignProject.iMetadataVersion, this.theDesignProject.iMetadataRevision, this.theDesignProject.iMetadataSubrevision, this.theDesignProject.iMetadataBuild)) {
            bRetVal = this.thePreviousVersioning.applyChanges();
        }
        int iChangeCount = this.getChangeCount();
        block13: for (int i = 0; i < iChangeCount; ++i) {
            MetadataChange theChange = this.theChanges.getChange(i);
            switch (theChange.iChangeType) {
                case 1: {
                    continue block13;
                }
                case 7: {
                    if (!theObject.theType.theName.equals(theChange.sOldClassName)) continue block13;
                    theObject.theType = new MetaType(theChange.sNewClassName, theChange.sNewTypeLongName, theChange.sNewFactoryName, this.theDesignProject);
                    continue block13;
                }
                case 5: {
                    if (!theObject.theType.theName.equals(theChange.sOldClassName)) continue block13;
                    theObject.theType = new MetaType(theChange.sNewClassName, this.theDesignProject);
                    continue block13;
                }
                case 3: {
                    if (!theObject.theType.theName.equals(theChange.sOldClassName)) continue block13;
                    bRetVal = false;
                    continue block13;
                }
                case 9: {
                    continue block13;
                }
                case 11: {
                    continue block13;
                }
                case 10: {
                    continue block13;
                }
                case 2: {
                    continue block13;
                }
                case 6: {
                    MetaProperty theProperty;
                    if (!theObject.theType.theName.equals(theChange.sOldClassName) || (theProperty = theObject.getPropertyMetadata(theChange.sOldPropertyName)) == null) continue block13;
                    theProperty.theName = theChange.sNewPropertyName;
                    continue block13;
                }
                case 4: {
                    MetaProperty theProperty;
                    if (!theObject.theType.theName.equals(theChange.sOldClassName) || (theProperty = theObject.getPropertyMetadata(theChange.sOldPropertyName)) == null) continue block13;
                    bRetVal = false;
                    continue block13;
                }
                case 12: {
                    MetaProperty theProperty;
                    if (!theObject.theType.theName.equals(theChange.sOldClassName) || (theProperty = theObject.getPropertyMetadata(theChange.sOldPropertyName)) == null) continue block13;
                    ((MetaParameter)theProperty.theIndexedValue.get((int)0)).theSimpleType = theChange.sNewPropertyType;
                    continue block13;
                }
            }
        }
        return bRetVal;
    }
}

