/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.MetaContainerType;
import ch.abacus.lib.ui.renderer.common.MetaDataMember;
import ch.abacus.lib.ui.renderer.common.MetaMethod;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class MetaClassDetail {
    int iVisibility = 0;
    public static final int VISIBILITY_PUBLIC = 1;
    public static final int VISIBILITY_PRIVATE = 2;
    public static final int VISIBILITY_PROTECTED = 3;
    public String sClassName = null;
    public String sFullClassName = null;
    private String DisplayName = null;
    public boolean bUsed = false;
    public boolean bHidden = false;
    public boolean bSkipDecl = false;
    public boolean bDesignBorders = false;
    public boolean bCompositeComponent = false;
    String sSuperClassName = "";
    String sFullPathOfSuperClass = "";
    public boolean bDefaultListeners = true;
    public String sDisplayClass = "";
    public MetaClassDetail theNextClass = null;
    public MetaDataMember theFirstData = null;
    public MetaDataMember theLastData = null;
    public MetaContainerType containerType = new MetaContainerType(0);
    public int iNumberOfMethods = 0;
    public int iNumberOfProperties = 0;
    public int iNumberOfDataElements = 0;
    public MetaMethod theFirstMethod = null;
    public MetaMethod theLastMethod = null;
    public MetaPropertyDescriptor theFirstProperty = null;
    public MetaPropertyDescriptor theLastProperty = null;
    public MetaClassDetail theFirstListener = null;
    public MetaClassDetail theLastListener = null;
    public String sAddListenerMethod = "";
    public String sRemoveListenerMethod = "";
    public String sCustomCodeGenerationMethod = "";
    public String theFactoryName = null;
    public String theDesignEditor = null;
    HashMap defaultPropertyValues = new HashMap(50);
    HashMap defaultTranslatedPropertyValues = new HashMap(50);
    public String sClassComment = null;
    public String sDisplayClassIcon = "";

    public MetaClassDetail() {
    }

    public MetaClassDetail(String sClassName, String sFullClassName) {
        this.sClassName = sClassName;
        this.sFullClassName = sFullClassName;
    }

    public MetaClassDetail(MetaClassDetail objClassMetadata, MetadataDispenser thetheMetadataDispenser) {
        this.iVisibility = objClassMetadata.iVisibility;
        this.sClassName = new String(objClassMetadata.sClassName);
        this.sFullClassName = new String(objClassMetadata.sFullClassName);
        this.setDisplayName(new String(objClassMetadata.getDisplayName()));
        this.sSuperClassName = new String(objClassMetadata.sSuperClassName);
        this.sFullPathOfSuperClass = new String(objClassMetadata.sFullPathOfSuperClass);
        if (objClassMetadata.theFactoryName != null) {
            this.theFactoryName = new String(objClassMetadata.theFactoryName);
        }
        if (objClassMetadata.theDesignEditor != null) {
            this.theDesignEditor = new String(objClassMetadata.theDesignEditor);
        }
        this.sDisplayClass = objClassMetadata.sDisplayClass != null ? new String(objClassMetadata.sDisplayClass) : "";
        this.sCustomCodeGenerationMethod = objClassMetadata.sCustomCodeGenerationMethod;
        this.sRemoveListenerMethod = objClassMetadata.sRemoveListenerMethod;
        this.sAddListenerMethod = objClassMetadata.sAddListenerMethod;
        this.containerType = objClassMetadata.containerType;
        this.bDefaultListeners = objClassMetadata.bDefaultListeners;
        this.bHidden = objClassMetadata.bHidden;
        this.bSkipDecl = objClassMetadata.bSkipDecl;
        this.bDesignBorders = objClassMetadata.bDesignBorders;
        MetaDataMember theDataMetadata = objClassMetadata.theFirstData;
        while (theDataMetadata != null) {
            this.addData(theDataMetadata.sFieldName, theDataMetadata.sTypeName, theDataMetadata.sClassName, theDataMetadata.sValue, theDataMetadata.sDoc);
            theDataMetadata = theDataMetadata.theNextData;
        }
        MetaPropertyDescriptor thePropertyListMetadata = objClassMetadata.theFirstProperty;
        while (thePropertyListMetadata != null) {
            String[] sValueChoices = new String[thePropertyListMetadata.getValueChoiceCount()];
            for (int k = 0; k < thePropertyListMetadata.getValueChoiceCount(); ++k) {
                sValueChoices[k] = thePropertyListMetadata.getValueChoiceAsString(k);
            }
            this.addProperties(thetheMetadataDispenser, thePropertyListMetadata.sName, thePropertyListMetadata.sType, thePropertyListMetadata.sClass, sValueChoices, thePropertyListMetadata.sDoc, thePropertyListMetadata.getDefaultValue(), thePropertyListMetadata.sSetName, thePropertyListMetadata.sGetName, thePropertyListMetadata.theHelperClass, thePropertyListMetadata.getIncludeTypeConstants(), thePropertyListMetadata.getOrder(), thePropertyListMetadata.bVisible, thePropertyListMetadata.bGenerate, thePropertyListMetadata.bAllowMultipleValues, thePropertyListMetadata.bAllowMultipleLanguages, thePropertyListMetadata.isReadOnly());
            thePropertyListMetadata = thePropertyListMetadata.theNextProperty;
        }
        MetaMethod theMethodMetadata = objClassMetadata.theFirstMethod;
        while (theMethodMetadata != null) {
            this.addMethod(theMethodMetadata.sMethodName, theMethodMetadata.sMethodText, theMethodMetadata.sMethodDoc);
            theMethodMetadata = theMethodMetadata.theNextMethod;
        }
    }

    String makeMethodText(Method theMethod, boolean bInherits) {
        int iParam;
        String sText = "public " + theMethod.getReturnType().getName() + " " + theMethod.getName() + "(";
        Class<?>[] theParams = theMethod.getParameterTypes();
        for (iParam = 0; iParam < theParams.length; ++iParam) {
            if (iParam != 0) {
                sText = sText + ", ";
            }
            sText = sText + theParams[iParam].getName() + " p" + iParam;
        }
        sText = sText + ") { \n";
        if (bInherits) {
            sText = sText + "    super." + theMethod.getName() + "(";
            for (iParam = 0; iParam < theParams.length; ++iParam) {
                if (iParam != 0) {
                    sText = sText + ", ";
                }
                sText = sText + "p" + iParam;
            }
            sText = sText + ");";
        }
        sText = sText + "\n}\n";
        return sText;
    }

    public MetaClassDetail(Class cls) {
        this.iVisibility = 1;
        this.sClassName = cls.getName();
        this.sFullClassName = cls.getName();
        this.sSuperClassName = new String(cls.getSuperclass().getName());
        this.sFullPathOfSuperClass = new String(cls.getSuperclass().getName());
        this.sDisplayClass = null;
        this.containerType = new MetaContainerType(0);
        Method[] methods = cls.getDeclaredMethods();
        boolean bInherits = true;
        if (this.sSuperClassName.equals("java.lang.Object")) {
            bInherits = false;
        }
        for (int iMethod = 0; iMethod < methods.length; ++iMethod) {
            this.addMethod(methods[iMethod].getName(), this.makeMethodText(methods[iMethod], bInherits), "");
        }
    }

    public boolean DeleteClass() {
        return true;
    }

    public void setSuperClass(String sSuper, String sFullPath) {
        this.sSuperClassName = sSuper;
        this.sFullPathOfSuperClass = sFullPath;
    }

    public String getFullPathOfSuperClass() {
        return this.sFullPathOfSuperClass;
    }

    public void setFullPathOfSuperClass(String theFullPath) {
        this.sFullPathOfSuperClass = theFullPath;
    }

    public void setDisplayClass(String theDisplayClass) {
        this.sDisplayClass = theDisplayClass;
    }

    public void setDisplayClassIcon(String theClassIcon) {
        this.sDisplayClassIcon = theClassIcon;
    }

    public String getSuperClassName() {
        return this.sSuperClassName;
    }

    public void setSuperClassName(String theName) {
        this.sSuperClassName = theName;
    }

    public void setDesignBorders(boolean bDesignBorders) {
        this.bDesignBorders = bDesignBorders;
    }

    public boolean getDesignBorders() {
        return this.bDesignBorders;
    }

    public void setSkipDecl(boolean bSkipDecl) {
        this.bSkipDecl = bSkipDecl;
    }

    public boolean getSkipDecl() {
        return this.bSkipDecl;
    }

    public int getVisibility() {
        return this.iVisibility;
    }

    public String getDisplayName() {
        String sDesignName = this.DisplayName;
        if (sDesignName == null) {
            sDesignName = this.sClassName;
        }
        return sDesignName;
    }

    public void setDisplayName(String displayName) {
        this.DisplayName = displayName;
    }

    public void addData(String sDataName, String sDataType, String sDataClass, String sDataInitValue, String sDoc) {
        MetaDataMember theData = new MetaDataMember(sDataName, sDataType, sDataClass, sDataInitValue, sDoc);
        if (this.theFirstData == null) {
            this.theFirstData = theData;
        } else {
            this.theLastData.theNextData = theData;
        }
        ++this.iNumberOfDataElements;
        this.theLastData = theData;
    }

    public MetaDataMember getData(String sMemberName) {
        for (MetaDataMember theData = this.theFirstData; theData != null; theData = theData.getNextData()) {
            if (!theData.getDataName().equals(sMemberName)) continue;
            return theData;
        }
        return null;
    }

    public void setData(String sName, String sTypeName, String sClassName, String sDefaultValue, String sDoc) {
        MetaDataMember theData = this.getData(sName);
        if (theData == null) {
            this.addData(sName, sTypeName, sClassName, sDefaultValue, sDoc);
        } else {
            theData.sFieldName = sName;
            theData.sTypeName = sTypeName;
            theData.sClassName = sClassName;
            theData.sValue = sDefaultValue;
            theData.sDoc = sDoc;
        }
    }

    public boolean removeData(String sDataName) {
        MetaDataMember theData = this.theFirstData;
        MetaDataMember theLastProcessed = null;
        while (theData != null) {
            if (theData.sFieldName.equals(sDataName)) {
                if (theLastProcessed == null) {
                    this.theFirstData = theData.theNextData;
                } else {
                    theLastProcessed.theNextData = theData.theNextData;
                }
                if (theData == this.theLastData) {
                    this.theLastData = theLastProcessed;
                    if (theLastProcessed != null) {
                        theLastProcessed.theNextData = null;
                    }
                }
                --this.iNumberOfDataElements;
                return true;
            }
            theLastProcessed = theData;
            theData = theData.theNextData;
        }
        return false;
    }

    public MetaMethod getMethod(String sMethodName) {
        for (MetaMethod theMethod = this.theFirstMethod; theMethod != null; theMethod = theMethod.getNextMethod()) {
            if (!theMethod.getMethodName().equals(sMethodName)) continue;
            return theMethod;
        }
        return null;
    }

    public void setMethod(String sMethodName, String sMethodBody, String sDoc) {
        MetaMethod theMethod = this.getMethod(sMethodName);
        if (theMethod == null) {
            this.addMethod(sMethodName, sMethodBody, sDoc);
        } else {
            theMethod.sMethodDoc = sDoc;
            theMethod.sMethodName = sMethodName;
            theMethod.sMethodText = sMethodBody;
        }
    }

    public void addMethod(String sMethodName, String sMethodBody, String sDoc) {
        MetaMethod theMethod = new MetaMethod(sMethodName, sMethodBody, sDoc);
        if (this.theFirstMethod == null) {
            this.theFirstMethod = theMethod;
        } else {
            this.theLastMethod.theNextMethod = theMethod;
        }
        ++this.iNumberOfMethods;
        this.theLastMethod = theMethod;
    }

    public boolean removeMethod(String sMethodName) {
        MetaMethod theMethod = this.theFirstMethod;
        MetaMethod theLastProcessed = null;
        while (theMethod != null) {
            if (theMethod.sMethodName.equals(sMethodName)) {
                if (theLastProcessed == null) {
                    this.theFirstMethod = theMethod.theNextMethod;
                } else {
                    theLastProcessed.theNextMethod = theMethod.theNextMethod;
                }
                if (theMethod == this.theLastMethod) {
                    this.theLastMethod = theLastProcessed;
                    if (theLastProcessed != null) {
                        theLastProcessed.theNextMethod = null;
                    }
                }
                --this.iNumberOfMethods;
                return true;
            }
            theLastProcessed = theMethod;
            theMethod = theMethod.theNextMethod;
        }
        return false;
    }

    public MetaPropertyDescriptor getProperty(String sPropertyName) {
        for (MetaPropertyDescriptor theProperty = this.theFirstProperty; theProperty != null; theProperty = theProperty.getNextProperty()) {
            String sFront;
            String sNameFromMetadata = theProperty.getName();
            if (sNameFromMetadata.equals(sPropertyName)) {
                return theProperty;
            }
            int iDotPos = sPropertyName.indexOf(".");
            if (iDotPos == -1 || !sNameFromMetadata.equals(sFront = sPropertyName.substring(0, iDotPos))) continue;
            if (theProperty.theFirstSubproperty != null) {
                return theProperty.getProperty(sPropertyName.substring(iDotPos + 1));
            }
            return null;
        }
        return null;
    }

    public void setProperty(MetadataDispenser thetheMetadataDispenser, String sName, String sTypeName, String sClassName, String[] sValueChoices, String sDoc, String sDefaultValue, String sSetMethodName, String sGetMethodName, String sPropertyParser, String sIncludeTypeConstants, int iOrder) {
        MetaPropertyDescriptor theProperty = this.getProperty(sName);
        if (theProperty == null) {
            this.addProperties(thetheMetadataDispenser, sName, sTypeName, sClassName, sValueChoices, sDoc, sDefaultValue, sSetMethodName, sGetMethodName, sPropertyParser, sIncludeTypeConstants, iOrder);
        } else {
            theProperty.sName = sName;
            theProperty.sClass = sClassName;
            theProperty.theValueChoices = new ArrayList(sValueChoices.length);
            for (int i = 0; i < sValueChoices.length; ++i) {
                theProperty.theValueChoices.add(sValueChoices[i]);
            }
            theProperty.sDoc = sDoc;
            theProperty.setDefaultValue(thetheMetadataDispenser, this, sDefaultValue);
            theProperty.sSetName = sSetMethodName;
            theProperty.sGetName = sGetMethodName;
        }
    }

    public void addProperties(MetaPropertyDescriptor theNewProperty) {
        if (this.theFirstProperty == null) {
            this.theFirstProperty = theNewProperty;
        } else {
            this.theLastProperty.theNextProperty = theNewProperty;
        }
        ++this.iNumberOfProperties;
        this.theLastProperty = theNewProperty;
    }

    public void addProperties(MetadataDispenser thetheMetadataDispenser, String sPropertyName, String sType, String sClass, String[] sValueChoices, String sDoc, String sDefaultValue, String sSetMethodName, String sGetMethodName, String sPropertyHelper, String sIncludeTypeConstants, int iOrder) {
        MetaPropertyDescriptor theProperty = new MetaPropertyDescriptor(sPropertyName, sType, sClass, sValueChoices, sDoc, sDefaultValue, sSetMethodName, sGetMethodName, sPropertyHelper, sIncludeTypeConstants, iOrder, thetheMetadataDispenser, this);
        if (this.theFirstProperty == null) {
            this.theFirstProperty = theProperty;
        } else {
            this.theLastProperty.theNextProperty = theProperty;
        }
        ++this.iNumberOfProperties;
        this.theLastProperty = theProperty;
    }

    public void addProperties(MetadataDispenser thetheMetadataDispenser, String sPropertyName, String sType, String sClass, String[] sValueChoices, String sDoc, String sDefaultValue, String sSetMethodName, String sGetMethodName, String sPropertyHelper, String sIncludeTypeConstants, int iOrder, boolean bVisible, boolean bAutoGenerate, boolean bArray, boolean bLanguages, boolean bReadOnly) {
        MetaPropertyDescriptor theProperty = new MetaPropertyDescriptor(sPropertyName, sType, sClass, sValueChoices, sDoc, sDefaultValue, sSetMethodName, sGetMethodName, sPropertyHelper, sIncludeTypeConstants, iOrder, thetheMetadataDispenser, this);
        theProperty.bGenerate = bAutoGenerate;
        theProperty.bVisible = bVisible;
        theProperty.bAllowMultipleValues = bArray;
        theProperty.bAllowMultipleLanguages = bLanguages;
        theProperty.setReadOnly(bReadOnly);
        if (this.theFirstProperty == null) {
            this.theFirstProperty = theProperty;
        } else {
            this.theLastProperty.theNextProperty = theProperty;
        }
        ++this.iNumberOfProperties;
        this.theLastProperty = theProperty;
    }

    public boolean removeProperty(String sPropertyName) {
        MetaPropertyDescriptor theProperty = this.theFirstProperty;
        MetaPropertyDescriptor theLastProcessed = null;
        while (theProperty != null) {
            if (theProperty.sName.equals(sPropertyName)) {
                if (theLastProcessed == null) {
                    this.theFirstProperty = theProperty.theNextProperty;
                } else {
                    theLastProcessed.theNextProperty = theProperty.theNextProperty;
                }
                if (theProperty == this.theLastProperty) {
                    this.theLastProperty = theLastProcessed;
                    if (theLastProcessed.theNextProperty != null) {
                        theLastProcessed.theNextProperty = null;
                    }
                }
                --this.iNumberOfProperties;
                return true;
            }
            theLastProcessed = theProperty;
            theProperty = theProperty.theNextProperty;
        }
        return false;
    }

    public MetaClassDetail getListener(String sListenerName) {
        MetaClassDetail theListener = this.theFirstListener;
        while (theListener != null) {
            if (theListener.sClassName.equals(sListenerName)) {
                return theListener;
            }
            theListener = theListener.theNextClass;
        }
        return null;
    }

    public void addDefaultListeners(MetadataDispenser theProject) {
        if (theProject.getMetadataUser().getMode() == 1) {
            int iDefaultListeners = theProject.getDefaultListenerCount();
            for (int iListener = 0; iListener < iDefaultListeners; ++iListener) {
                MetaClassDetail theListener = theProject.getNewDefaultListener(iListener);
                if (this.theFirstListener == null) {
                    this.theFirstListener = theListener;
                } else {
                    this.theLastListener.theNextClass = theListener;
                }
                this.theLastListener = theListener;
            }
        }
    }

    public void addListener(String sListenerName, MetadataDispenser theProject) {
        if (theProject.getMetadataUser().getMode() == 1) {
            MetaClassDetail theListener = theProject.getNewListener(sListenerName);
            if (this.theFirstListener == null) {
                this.theFirstListener = theListener;
            } else {
                this.theLastListener.theNextClass = theListener;
            }
            this.theLastListener = theListener;
        }
    }

    public boolean removeListener(String sListenerName) {
        MetaClassDetail theListener = this.theFirstListener;
        MetaClassDetail theLastProcessed = null;
        while (theListener != null) {
            if (theListener.sClassName.equals(sListenerName)) {
                if (theLastProcessed == null) {
                    this.theFirstListener = theListener.theNextClass;
                } else {
                    theLastProcessed.theNextClass = theListener.theNextClass;
                }
                if (theListener == this.theLastListener) {
                    this.theLastListener = theLastProcessed;
                    if (theLastProcessed != null) {
                        theLastProcessed.theNextClass = null;
                    }
                }
                return true;
            }
            theLastProcessed = theListener;
            theListener = theListener.theNextClass;
        }
        return false;
    }

    public void setPropertyDefaultValue(String sName, String sDefaultValue, String sTranslatedDefaultValue) {
        this.defaultPropertyValues.put(sName, sDefaultValue);
        this.defaultTranslatedPropertyValues.put(sName, sTranslatedDefaultValue);
    }

    public String getPropertyDefaultValue(String sName) {
        return (String)this.defaultPropertyValues.get(sName);
    }

    public String getPropertyTranslatedDefaultValue(String sName) {
        return (String)this.defaultTranslatedPropertyValues.get(sName);
    }
}

