/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JATextArea;
import ch.abacus.lib.ui.renderer.common.HammerEditorPopupMenu;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class HammerSourceTextArea
extends JATextArea
implements UndoableEditListener {
    Hashtable actions;
    JAScrollPane thePane = null;
    public HammerEditorPopupMenu thePopupMenu = null;
    public static final int UNDO_LIMIT = 1500;
    private UndoManager m_undoManager;

    public HammerSourceTextArea() {
        this.createActionTable();
        this.getDocument().addUndoableEditListener(this);
        this.createUndoMananger();
    }

    public HammerSourceTextArea(int iRows, int iCols) {
        super(iRows, iCols);
        this.createActionTable();
        this.getDocument().addUndoableEditListener(this);
        this.createUndoMananger();
    }

    private void createActionTable() {
        this.actions = new Hashtable();
        Action[] actionsArray = this.getActions();
        for (int i = 0; i < actionsArray.length; ++i) {
            Action a = actionsArray[i];
            String theName = (String)a.getValue("Name");
            this.actions.put(theName, a);
        }
    }

    public Action getActionByName(String name) {
        return (Action)this.actions.get(name);
    }

    public void setPane(JAScrollPane objPane) {
        this.thePane = objPane;
    }

    public void fixupSize() {
        FontMetrics theFontMetrics;
        int iRows = this.getRows();
        int iColumns = this.getColumns();
        Font theFont = this.getFont();
        if (theFont != null && (theFontMetrics = this.getFontMetrics(theFont)) != null) {
            int iXSize = iColumns * theFontMetrics.stringWidth("m    WXZ") / 8;
            int iYSize = iRows * theFontMetrics.getHeight();
            this.thePane.setPreferredSize(new Dimension(iXSize, iYSize));
        }
    }

    private void createUndoMananger() {
        this.m_undoManager = new UndoManager();
        this.m_undoManager.setLimit(1500);
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.m_undoManager.addEdit(e.getEdit());
    }

    public boolean undo() {
        try {
            this.m_undoManager.undo();
        }
        catch (CannotUndoException cue) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        return true;
    }

    public boolean redo() {
        try {
            this.m_undoManager.redo();
        }
        catch (CannotRedoException cue) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        return true;
    }
}

