/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.HammerClassDescriptor;
import ch.abacus.lib.ui.renderer.common.HammerInputStream;
import ch.abacus.lib.ui.renderer.common.HammerJarAccess;
import ch.abacus.lib.ui.renderer.common.HammerJarFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class HammerClassByteFileLoader {
    private ArrayList classPathArrayList;
    private ArrayList shortClassPathArrayList;
    private ArrayList customMetadataFiles;
    AbaMetaDataUser theUser;
    private HashMap properties;

    public HammerClassByteFileLoader(ArrayList classPathArrayList, ArrayList shortClassPathArrayList, HashMap properties, AbaMetaDataUser theUser) {
        this.classPathArrayList = classPathArrayList;
        this.shortClassPathArrayList = shortClassPathArrayList;
        this.properties = properties;
        this.theUser = theUser;
    }

    public byte[] getClassBytes(String name) {
        Object classBytes;
        ArrayList theClassBytes = this.getClassesNotInJars(name, true, false);
        if (theClassBytes != null && (classBytes = theClassBytes.get(0)) instanceof byte[]) {
            return (byte[])classBytes;
        }
        ArrayList theJarAccessArray = this.getJarAccess(name, true, false);
        if (theJarAccessArray != null && theJarAccessArray.size() > 0) {
            HammerJarAccess theJarAccess = (HammerJarAccess)theJarAccessArray.get(0);
            byte[] classBytes2 = this.readClassFile(theJarAccess);
            return classBytes2;
        }
        return null;
    }

    public byte[] readClassFile(HammerJarAccess theJarAccess) {
        JarFile jarf = theJarAccess.theJarFile;
        JarEntry entry = theJarAccess.theJarEntry;
        try {
            int bytesread;
            InputStream is = jarf.getInputStream(entry);
            int fileLength = (int)entry.getSize();
            byte[] classBytes = new byte[fileLength];
            for (int totalbytes = 0; totalbytes != fileLength; totalbytes += bytesread) {
                int iBytesToRead = 512;
                if (fileLength - totalbytes < 512) {
                    iBytesToRead = fileLength - totalbytes;
                }
                bytesread = is.read(classBytes, totalbytes, iBytesToRead);
            }
            is.close();
            return classBytes;
        }
        catch (IOException e2) {
            return null;
        }
    }

    public String findJarFileWithResource(String name) {
        ArrayList theJarAccessArray = this.getJarAccess(name, false, false);
        if (theJarAccessArray != null && theJarAccessArray.size() > 0) {
            HammerJarAccess theJarAccess = (HammerJarAccess)theJarAccessArray.get(0);
            return theJarAccess.theJarFile.getName();
        }
        return null;
    }

    public ArrayList getJarAccess(String fullClassName, boolean bAddCompiledSuffix, boolean bMultiple) {
        int iLastDot;
        ArrayList<Object> retVal = new ArrayList<Object>(0);
        if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
            this.theUser.getLogFile().doClassLoaderLogEntry("GetJarAccess:", "Searching for " + fullClassName);
        }
        String packageSeparator = (String)this.properties.get("packageSeparator");
        String compiledSuffix = (String)this.properties.get("compiledSuffix");
        String fileSeparator = (String)this.properties.get("fileSeparator");
        String jarClassName = "";
        String theSuffix = "";
        if (!bAddCompiledSuffix && packageSeparator.equals(".") && (iLastDot = fullClassName.lastIndexOf(packageSeparator)) != -1) {
            String left = fullClassName.substring(0, iLastDot);
            theSuffix = fullClassName.substring(iLastDot);
            fullClassName = left;
        }
        StringTokenizer st1 = new StringTokenizer(fullClassName, packageSeparator);
        String s1 = new String();
        try {
            s1 = st1.nextToken();
        }
        catch (NoSuchElementException e) {
            return null;
        }
        while (st1.hasMoreTokens()) {
            jarClassName = jarClassName + s1 + "/";
            s1 = st1.nextToken();
        }
        jarClassName = jarClassName + s1;
        jarClassName = bAddCompiledSuffix ? jarClassName + compiledSuffix : jarClassName + theSuffix;
        for (int iListEntry = 0; iListEntry < this.shortClassPathArrayList.size(); ++iListEntry) {
            HammerJarFilter theJarFilter;
            String[] files;
            String sClassPathEntry = (String)this.shortClassPathArrayList.get(iListEntry);
            if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
                this.theUser.getLogFile().doClassLoaderLogEntry("GetJarAccess:", "Searching for " + fullClassName + " using " + sClassPathEntry);
            }
            if (sClassPathEntry.endsWith(".jar")) {
                Object theAccess;
                if (bMultiple) {
                    theAccess = this.getMatchingJarAccess(sClassPathEntry, jarClassName);
                    if (theAccess == null) continue;
                    for (int iAccess = 0; iAccess < ((ArrayList)theAccess).size(); ++iAccess) {
                        retVal.add(((ArrayList)theAccess).get(iAccess));
                    }
                    continue;
                }
                theAccess = this.getJarAccessByName(sClassPathEntry, jarClassName);
                if (theAccess == null) continue;
                retVal.add(theAccess);
                if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
                    this.theUser.getLogFile().doClassLoaderLogEntry("GetJarAccess:", "Found " + jarClassName + " using " + sClassPathEntry);
                }
                return retVal;
            }
            File theDirectoryOrJar = new File(sClassPathEntry);
            if (!theDirectoryOrJar.isDirectory() || (files = theDirectoryOrJar.list(theJarFilter = new HammerJarFilter())) == null) continue;
            for (int iFile = 0; iFile < files.length; ++iFile) {
                Object theAccess;
                String sJarName = sClassPathEntry + fileSeparator + files[iFile];
                if (bMultiple) {
                    theAccess = this.getMatchingJarAccess(sJarName, jarClassName);
                    if (theAccess == null) continue;
                    for (int iAccess = 0; iAccess < ((ArrayList)theAccess).size(); ++iAccess) {
                        retVal.add(((ArrayList)theAccess).get(iAccess));
                    }
                    continue;
                }
                theAccess = this.getJarAccessByName(sJarName, jarClassName);
                if (theAccess == null) continue;
                retVal.add(theAccess);
                if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
                    this.theUser.getLogFile().doClassLoaderLogEntry("GetJarAccess:", "Found " + jarClassName + " using " + sClassPathEntry);
                }
                return retVal;
            }
        }
        if (retVal.size() > 0) {
            if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
                this.theUser.getLogFile().doClassLoaderLogEntry("GetJarAccess:", "Found " + fullClassName);
            }
            return retVal;
        }
        return null;
    }

    private String getConvertedSearchString(String fullClassName, boolean bAddCompiledSuffix) {
        int iLastDot;
        String packageSeparator = (String)this.properties.get("packageSeparator");
        String fileSeparator = (String)this.properties.get("fileSeparator");
        String ClassFileName = "";
        String theSuffix = "";
        if (!bAddCompiledSuffix && packageSeparator.equals(".") && (iLastDot = fullClassName.lastIndexOf(packageSeparator)) != -1) {
            String left = fullClassName.substring(0, iLastDot);
            theSuffix = fullClassName.substring(iLastDot);
            fullClassName = left;
        }
        StringTokenizer st1 = new StringTokenizer(fullClassName, packageSeparator);
        String s1 = st1.nextToken();
        while (st1.hasMoreTokens()) {
            ClassFileName = ClassFileName + s1 + fileSeparator;
            s1 = st1.nextToken();
        }
        ClassFileName = ClassFileName + s1;
        ClassFileName = bAddCompiledSuffix ? ClassFileName + ".class" : ClassFileName + theSuffix;
        return ClassFileName;
    }

    private String getConvertedJarSearchString(String fullClassName, boolean bAddCompiledSuffix) {
        int iLastDot;
        String packageSeparator = (String)this.properties.get("packageSeparator");
        String fileSeparator = (String)this.properties.get("fileSeparator");
        String ClassFileName = "";
        String theSuffix = "";
        if (!bAddCompiledSuffix && packageSeparator.equals(".") && (iLastDot = fullClassName.lastIndexOf(packageSeparator)) != -1) {
            String left = fullClassName.substring(0, iLastDot);
            theSuffix = fullClassName.substring(iLastDot);
            fullClassName = left;
        }
        StringTokenizer st1 = new StringTokenizer(fullClassName, packageSeparator);
        String s1 = st1.nextToken();
        while (st1.hasMoreTokens()) {
            ClassFileName = ClassFileName + s1 + "/";
            s1 = st1.nextToken();
        }
        ClassFileName = ClassFileName + s1;
        ClassFileName = bAddCompiledSuffix ? ClassFileName + ".class" : ClassFileName + theSuffix;
        return ClassFileName;
    }

    public ArrayList getClassesNotInJars(String fullClassName, boolean bAddCompiledSuffix, boolean bMultiple) {
        ArrayList retVal = new ArrayList(0);
        HashMap discrim = new HashMap(311);
        String fileSeparator = (String)this.properties.get("fileSeparator");
        String ClassFileName = this.getConvertedSearchString(fullClassName, bAddCompiledSuffix);
        if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
            this.theUser.getLogFile().doClassLoaderLogEntry("GetClassesNotInJars:", "Searching for " + ClassFileName);
        }
        for (int iClassPathEntry = 0; iClassPathEntry < this.shortClassPathArrayList.size(); ++iClassPathEntry) {
            String sClassPathEntry = (String)this.shortClassPathArrayList.get(iClassPathEntry);
            if (sClassPathEntry.endsWith(".jar")) continue;
            if (!bMultiple) {
                File theClassFile = new File(sClassPathEntry + fileSeparator + ClassFileName);
                if (theClassFile == null) continue;
                byte[] classBytes = this.getClassBytesFromClassFile(theClassFile);
                retVal.add(classBytes);
                if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
                    this.theUser.getLogFile().doClassLoaderLogEntry("GetClassesNotInJars:", "Found " + sClassPathEntry + fileSeparator + ClassFileName);
                }
                return retVal;
            }
            File theDirectoryOrJar = new File(sClassPathEntry + fileSeparator + ClassFileName);
            if (!theDirectoryOrJar.isDirectory()) continue;
            retVal = this.exploreDirectoryForClasses(retVal, theDirectoryOrJar, discrim);
        }
        if (retVal.size() > 1) {
            if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
                this.theUser.getLogFile().doClassLoaderLogEntry("GetClassesNotInJars:", "Found " + ClassFileName);
            }
            return retVal;
        }
        return null;
    }

    ArrayList exploreDirectoryForClasses(ArrayList retVal, File thisDirectoryNode, HashMap discrim) {
        String fileSeparator = (String)this.properties.get("fileSeparator");
        String[] files = thisDirectoryNode.list();
        if (files != null) {
            for (int iFile = 0; iFile < files.length; ++iFile) {
                String sFileName = thisDirectoryNode.getAbsolutePath() + fileSeparator + files[iFile];
                if (discrim.get(sFileName) != null) continue;
                File theDirectoryOrFile = new File(sFileName);
                if (theDirectoryOrFile != null) {
                    if (theDirectoryOrFile.isDirectory()) {
                        retVal = this.exploreDirectoryForClasses(retVal, theDirectoryOrFile, discrim);
                    } else if (sFileName.toLowerCase().endsWith(".class")) {
                        byte[] classBytes = this.getClassBytesFromClassFile(theDirectoryOrFile);
                        HammerClassDescriptor theEntry = new HammerClassDescriptor(classBytes, sFileName);
                        retVal.add(theEntry);
                        if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
                            this.theUser.getLogFile().doClassLoaderLogEntry("ExploreDirectoryForClasses:", "Found " + sFileName);
                        }
                    }
                }
                discrim.put(sFileName, new Boolean(true));
            }
        }
        return retVal;
    }

    byte[] getClassBytesFromClassFile(File theClassFile) {
        try {
            int bytesread;
            FileInputStream is = new FileInputStream(theClassFile);
            int fileLength = (int)theClassFile.length();
            byte[] classBytes = new byte[fileLength];
            for (int totalbytes = 0; totalbytes != fileLength; totalbytes += bytesread) {
                int iBytesToRead = 512;
                if (fileLength - totalbytes < 512) {
                    iBytesToRead = fileLength - totalbytes;
                }
                bytesread = is.read(classBytes, totalbytes, iBytesToRead);
            }
            is.close();
            return classBytes;
        }
        catch (IOException e1) {
            return null;
        }
    }

    private HammerJarAccess getJarAccessByName(String sJarName, String sKeyName) {
        if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
            this.theUser.getLogFile().doClassLoaderLogEntry("Invoking GetJarAccessByName:", "Jar Name: " + sJarName + " Key Name: " + sKeyName);
        }
        try {
            JarFile jarf = new JarFile(sJarName);
            JarEntry entry = jarf.getJarEntry(sKeyName);
            if (entry != null) {
                return new HammerJarAccess(jarf, entry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private ArrayList getMatchingJarAccess(String sJarName, String sKeyName) {
        ArrayList<HammerJarAccess> theMatches = new ArrayList<HammerJarAccess>(0);
        try {
            JarFile jarf = new JarFile(sJarName);
            Enumeration<JarEntry> allentries = jarf.entries();
            while (allentries.hasMoreElements()) {
                JarEntry entry = allentries.nextElement();
                String sTestName = entry.getName();
                if (!sTestName.startsWith(sKeyName) || sTestName.endsWith("/")) continue;
                theMatches.add(new HammerJarAccess(jarf, entry));
            }
            return theMatches;
        }
        catch (IOException e1) {
            return null;
        }
    }

    public ArrayList getClassesFromPath(String sSearchPath) {
        ArrayList<HammerClassDescriptor> theClassBytes = this.getClassesNotInJars(sSearchPath, false, true);
        ArrayList theJarAccessArray = this.getJarAccess(sSearchPath, false, true);
        if (theClassBytes == null) {
            if (theJarAccessArray == null) {
                return null;
            }
            theClassBytes = new ArrayList<HammerClassDescriptor>(0);
        }
        if (theJarAccessArray != null) {
            for (int i = 0; i < theJarAccessArray.size(); ++i) {
                HammerJarAccess theJarAccess = (HammerJarAccess)theJarAccessArray.get(i);
                if (theJarAccess == null) continue;
                byte[] classBytes = this.readClassFile(theJarAccess);
                HammerClassDescriptor theEntry = new HammerClassDescriptor(classBytes, theJarAccess.theJarEntry.getName());
                theClassBytes.add(theEntry);
            }
        }
        return theClassBytes;
    }

    public ArrayList getFilesInPath(String sPath) {
        if (this.customMetadataFiles != null) {
            return this.customMetadataFiles;
        }
        Object theRetVal = null;
        String fileSeparator = (String)this.properties.get("fileSeparator");
        this.customMetadataFiles = new ArrayList();
        for (int iClassPathEntry = 0; iClassPathEntry < this.classPathArrayList.size(); ++iClassPathEntry) {
            String sClassPathEntry = (String)this.classPathArrayList.get(iClassPathEntry);
            File isDir = new File(sClassPathEntry);
            try {
                if (isDir.isDirectory() || !sClassPathEntry.endsWith("AbacusCustom.jar")) continue;
                try {
                    ZipFile zf = new ZipFile(sClassPathEntry);
                    Enumeration<? extends ZipEntry> e = zf.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry ze = e.nextElement();
                        String fullPath = ze.toString();
                        boolean begins = fullPath.startsWith(sPath);
                        boolean ends = fullPath.endsWith(".xml");
                        if (!begins || !ends) continue;
                        this.customMetadataFiles.add(fullPath);
                    }
                    zf.close();
                }
                catch (Exception eJar) {
                    System.out.println("Warning: " + sClassPathEntry + " in classpath not found.");
                }
                continue;
            }
            catch (Exception e) {
                System.out.println(sClassPathEntry);
                e.printStackTrace();
            }
        }
        return this.customMetadataFiles;
    }

    public HammerInputStream getFileInPathAsStream(String sFileName, boolean bDevFlag) {
        if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
            this.theUser.getLogFile().doClassLoaderLogEntry("FindFileInPath:", "Searching for " + sFileName);
        }
        File theRetVal = null;
        String ClassFileName = this.getConvertedSearchString(sFileName, false);
        String JarClassFileName = this.getConvertedJarSearchString(sFileName, false);
        String fileSeparator = (String)this.properties.get("fileSeparator");
        for (int iClassPathEntry = 0; iClassPathEntry < this.classPathArrayList.size(); ++iClassPathEntry) {
            int iLastDot;
            String sClassPathEntry = (String)this.classPathArrayList.get(iClassPathEntry);
            if (!sClassPathEntry.toLowerCase().endsWith("jar")) {
                HammerJarFilter theJarFilter;
                String[] files;
                if (!sClassPathEntry.endsWith(fileSeparator)) {
                    sClassPathEntry = sClassPathEntry + fileSeparator;
                }
                if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
                    this.theUser.getLogFile().doClassLoaderLogEntry("FindFileInPath:", "Searching in " + sClassPathEntry);
                }
                if ((theRetVal = new File(sClassPathEntry + ClassFileName)).exists()) {
                    if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
                        this.theUser.getLogFile().doClassLoaderLogEntry("FindFileInPath:", "Found " + sFileName + " in " + sClassPathEntry);
                    }
                    try {
                        FileInputStream in = new FileInputStream(theRetVal);
                        String sCanonicalPath = sClassPathEntry + ClassFileName;
                        try {
                            sCanonicalPath = theRetVal.getCanonicalPath();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                        return new HammerInputStream(sClassPathEntry, sCanonicalPath, in);
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
                File theDirectoryOrJar = new File(sClassPathEntry);
                if (!theDirectoryOrJar.isDirectory() || (files = theDirectoryOrJar.list(theJarFilter = new HammerJarFilter())) == null) continue;
                for (int iFile = 0; iFile < files.length; ++iFile) {
                    String sJarName = sClassPathEntry + fileSeparator + files[iFile];
                    HammerJarAccess theAccess = this.getJarAccessByName(sJarName, JarClassFileName);
                    if (theAccess == null) continue;
                    if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
                        this.theUser.getLogFile().doClassLoaderLogEntry("GetJarAccess:", "Found " + ClassFileName + " using " + sClassPathEntry);
                    }
                    JarFile jarf = theAccess.theJarFile;
                    JarEntry entry = theAccess.theJarEntry;
                    try {
                        return new HammerInputStream(sClassPathEntry, sJarName, JarClassFileName, jarf.getInputStream(entry));
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                continue;
            }
            if (!bDevFlag || !sClassPathEntry.toLowerCase().endsWith("jar")) continue;
            String packageSeparator = (String)this.properties.get("packageSeparator");
            String compiledSuffix = (String)this.properties.get("compiledSuffix");
            String sTmpFileName = "";
            String jarClassName = "";
            String theSuffix = "";
            if (packageSeparator.equals(".") && (iLastDot = sFileName.lastIndexOf(packageSeparator)) != -1) {
                String left = sFileName.substring(0, iLastDot);
                theSuffix = sFileName.substring(iLastDot);
                sTmpFileName = left;
            }
            StringTokenizer st1 = new StringTokenizer(sTmpFileName, packageSeparator);
            String s1 = st1.nextToken();
            while (st1.hasMoreTokens()) {
                jarClassName = jarClassName + s1 + "/";
                s1 = st1.nextToken();
            }
            jarClassName = jarClassName + s1;
            HammerJarAccess theAccess = this.getJarAccessByName(sClassPathEntry, jarClassName = jarClassName + theSuffix);
            if (theAccess == null) continue;
            JarFile jarf = theAccess.theJarFile;
            JarEntry entry = theAccess.theJarEntry;
            if (this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
                this.theUser.getLogFile().doClassLoaderLogEntry("GetJarAccess:", "Found " + sClassPathEntry + " using " + sClassPathEntry);
            }
            try {
                return new HammerInputStream(sClassPathEntry, sClassPathEntry, JarClassFileName, jarf.getInputStream(entry));
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public void setPaths(ArrayList vClassPath, ArrayList vShortPath) {
        this.classPathArrayList = vClassPath;
        this.shortClassPathArrayList = vShortPath;
    }
}

