/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.CheckTreeCellRenderer;
import ch.abacus.lib.ui.renderer.common.SwingEventMulticaster;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

public class CheckTreeCellEditor
extends CheckTreeCellRenderer
implements TreeCellEditor,
ActionListener {
    protected CellEditorListener list;

    public CheckTreeCellEditor(JTree tree) {
        this(tree, new DefaultTreeCellRenderer());
    }

    public CheckTreeCellEditor(JTree tree, TreeCellRenderer renderer) {
        super(tree, renderer);
        if (this.check != null) {
            this.check.addActionListener(this);
        }
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        return this.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
    }

    public boolean stopCellEditing() {
        return true;
    }

    public Object getCellEditorValue() {
        if (this.node != null && this.check != null) {
            this.node.setSelected(this.check.isSelected());
        }
        return this.node;
    }

    public boolean isCellEditable(EventObject event) {
        return true;
    }

    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.list = SwingEventMulticaster.add(this.list, listener);
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.list = SwingEventMulticaster.remove(this.list, listener);
    }

    protected void fireEditingStopped() {
        if (this.list != null) {
            this.list.editingStopped(new ChangeEvent(this));
        }
    }

    protected void fireEditingCanceled() {
        if (this.list != null) {
            this.list.editingCanceled(new ChangeEvent(this));
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.fireEditingStopped();
    }
}

