/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.AbaNLSDocument;
import ch.abacus.lib.ui.renderer.common.HammerConfigurationManager;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.HammerInputStream;
import ch.abacus.lib.ui.renderer.common.HammerLanguagePresentation;
import ch.abacus.lib.ui.renderer.common.HammerNLSAccess;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import electric.xml.Attribute;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.IXPath;
import electric.xml.ParseException;
import electric.xml.XPath;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import org.w3c.dom.Node;

public class AbaNLS {
    AbaNLSDocument firstDocument;
    AbaNLSDocument lastDocument;
    int theDocumentCount = 0;
    MetaProject theProject;

    public AbaNLS(MetaProject theProject) {
        this.theProject = theProject;
    }

    public void clear() {
        AbaNLSDocument document = this.firstDocument;
        while (document != null) {
            document = document.nextDocument;
            if (document == null) continue;
            document.prevDocument = null;
        }
        this.firstDocument = null;
        this.lastDocument = null;
        this.theDocumentCount = 0;
    }

    public boolean addDocument(String sDocumentName, String sDocumentKey) {
        block13: {
            if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS AddDocument:  Will try to add Key = " + sDocumentKey + ", Name: " + sDocumentName, "");
            }
            try {
                BufferedInputStream inputStream;
                HammerInputStream hfin = this.theProject.getMetaDataUser().getFileManager().getInputStream(sDocumentName);
                if (hfin == null) {
                    hfin = this.theProject.getMetaDataUser().getFileManager().getInputStream(this.theProject.getMetaDataUser().getSystemConfigurationPathName() + sDocumentName);
                }
                if (hfin == null) {
                    return false;
                }
                InputStream fin = hfin.theStream;
                if (fin == null) {
                    return false;
                }
                if (sDocumentName.endsWith("nlz")) {
                    GZIPInputStream fzip = new GZIPInputStream(fin);
                    inputStream = new BufferedInputStream(fzip);
                } else {
                    inputStream = new BufferedInputStream(fin);
                }
                Document xmlDocument = new Document((InputStream)inputStream);
                Element xmlRoot = xmlDocument.getRoot();
                if (xmlRoot != null) {
                    AbaNLSDocument theNewDocument = new AbaNLSDocument(sDocumentName, sDocumentKey, xmlDocument, xmlRoot, new Boolean(false));
                    this.addNLSDocument(theNewDocument);
                    ++this.theDocumentCount;
                    return true;
                }
            }
            catch (ParseException e1) {
                if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                    this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS AddDocument:  Key = " + sDocumentKey + ", Name: " + sDocumentName, " Failed to load. Parse Error.");
                }
            }
            catch (FileNotFoundException e2) {
                if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                    this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS AddDocument:  Key = " + sDocumentKey + ", Name: " + sDocumentName, " Failed to load. Document not found.");
                }
            }
            catch (IOException e3) {
                if (this.theProject.getMetaDataUser().getLogFile() == null || !this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) break block13;
                this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS AddDocument:  Key = " + sDocumentKey + ", Name: " + sDocumentName, " Failed to load. IO Error.");
            }
        }
        return false;
    }

    public void addNLSDocument(AbaNLSDocument theNewDocument) {
        if (this.firstDocument == null) {
            this.firstDocument = theNewDocument;
            this.lastDocument = theNewDocument;
        } else {
            AbaNLSDocument doc = this.firstDocument;
            AbaNLSDocument prevDoc = null;
            AbaNLSDocument nextDoc = null;
            while (doc != null) {
                int iCompare = doc.theDocumentKey.compareTo(theNewDocument.theDocumentKey);
                if (iCompare >= 0) {
                    nextDoc = doc;
                    break;
                }
                prevDoc = doc;
                doc = doc.nextDocument;
            }
            if (nextDoc != null) {
                nextDoc.prevDocument = theNewDocument;
                theNewDocument.nextDocument = nextDoc;
            } else {
                this.lastDocument.nextDocument = theNewDocument;
                this.lastDocument = theNewDocument;
            }
            if (prevDoc != null) {
                theNewDocument.prevDocument = prevDoc;
                prevDoc.nextDocument = theNewDocument;
            } else {
                this.firstDocument.prevDocument = theNewDocument;
                this.firstDocument = theNewDocument;
            }
        }
    }

    public void removeNLSDocument(AbaNLSDocument theDocument) {
        if (this.firstDocument.equals(theDocument)) {
            this.firstDocument = theDocument.nextDocument;
        } else if (theDocument.nextDocument != null) {
            theDocument.nextDocument.prevDocument = theDocument.prevDocument;
        }
        if (this.lastDocument.equals(theDocument)) {
            this.lastDocument = theDocument.prevDocument;
        } else if (theDocument.prevDocument != null) {
            theDocument.prevDocument.nextDocument = theDocument.nextDocument;
        }
    }

    public AbaNLSDocument findNLSDocumentByKey(String sDocumentKey) {
        AbaNLSDocument doc = this.firstDocument;
        while (doc != null) {
            if (doc.theDocumentKey.equals(sDocumentKey)) {
                return doc;
            }
            doc = doc.nextDocument;
        }
        return null;
    }

    public AbaNLSDocument findNLSDocumentByName(String sDocumentName) {
        AbaNLSDocument doc = this.firstDocument;
        while (doc != null) {
            if (doc.theDocumentName.equals(sDocumentName)) {
                return doc;
            }
            doc = doc.nextDocument;
        }
        return null;
    }

    public AbaNLSDocument getNLSDocumentByIndex(int i) {
        int iDocument = 0;
        AbaNLSDocument doc = this.firstDocument;
        while (doc != null) {
            if (iDocument++ == i) {
                return doc;
            }
            doc = doc.nextDocument;
        }
        return null;
    }

    public Document getAbaNLSDocument(int i) {
        return this.getNLSDocumentByIndex(i).getDocument();
    }

    public Element getAbaNLSDocumentRootElement(int i) {
        return this.getNLSDocumentByIndex(i).getRootElement();
    }

    public int getAbaNLSDocumentByKey(String sKey) {
        if (sKey == null) {
            return -1;
        }
        AbaNLSDocument doc = this.firstDocument;
        int i = 0;
        while (doc != null) {
            if (doc.theDocumentKey.equals(sKey)) {
                return i;
            }
            ++i;
            doc = doc.nextDocument;
        }
        return -1;
    }

    public int getAbaNLSDocumentByName(String sName) {
        if (sName == null) {
            return -1;
        }
        AbaNLSDocument doc = this.firstDocument;
        int i = 0;
        while (doc != null) {
            if (doc.theDocumentName.equals(sName)) {
                return i;
            }
            ++i;
            doc = doc.nextDocument;
        }
        return -1;
    }

    public Element getValueElement(int iDocument, String sValueKey) {
        Element xmlRootElement = this.getAbaNLSDocumentRootElement(iDocument);
        if (xmlRootElement != null) {
            String sSearchString = "TEXT[@key=\"" + sValueKey + "\"]";
            XPath thePath = new XPath(sSearchString);
            Element theElement = xmlRootElement.getElement((IXPath)thePath);
            return theElement;
        }
        return null;
    }

    public String getAbaNLSValue(String sDocumentKey, String sValueKey, boolean bMnemonic) {
        int iDocument;
        if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
            this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getAbaNLSValue - Document key: " + sDocumentKey + ", Value key:" + sValueKey, " Mnemonic: " + bMnemonic);
        }
        if ((iDocument = this.getAbaNLSDocumentByKey(sDocumentKey)) > -1) {
            if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getAbaNLSValue - Document found ", "");
            }
            Element theMatchingElement = this.getValueElement(iDocument, sValueKey);
            if (bMnemonic) {
                String sMnemonic = theMatchingElement.getAttribute("mnemonic");
                if (sMnemonic == null) {
                    sMnemonic = new String("\u0000");
                } else if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                    this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getAbaNLSValue, Mnemonic found ", sMnemonic);
                }
                return sMnemonic;
            }
            if (theMatchingElement != null) {
                String sRetVal = theMatchingElement.getTextString();
                if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                    this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getAbaNLSValue, Value found ", sRetVal);
                }
                return sRetVal;
            }
        }
        return null;
    }

    public Element getRootElement(String sDocumentKey) {
        int iDocument = this.getAbaNLSDocumentByKey(sDocumentKey);
        if (iDocument > -1) {
            return this.getAbaNLSDocumentRootElement(iDocument);
        }
        return null;
    }

    public Element getAbaNLSElement(String sDocumentKey, String sValueKey) {
        int iDocument = this.getAbaNLSDocumentByKey(sDocumentKey);
        if (iDocument > -1) {
            return this.getValueElement(iDocument, sValueKey);
        }
        return null;
    }

    public boolean addAbaNLSValue(String sDocumentKey, String sKeyName, String sKeyValue) {
        Attribute theAttribute;
        Element theRootElement;
        Element theNewElement = new Element("TEXT");
        if (theNewElement != null && (theRootElement = this.getRootElement(sDocumentKey)) != null && (theAttribute = new Attribute("key", sKeyValue)) != null) {
            theNewElement = theNewElement.setAttribute(theAttribute);
            theRootElement.addElement(theNewElement);
            theNewElement.setText(sKeyValue);
            return true;
        }
        return false;
    }

    public boolean changeAbaNLSValue(String sDocumentKey, String sValueKey, String sValue) {
        AbaNLSDocument theDocument = this.findNLSDocumentByKey(sDocumentKey);
        Element theElement = this.getAbaNLSElement(sDocumentKey, sValueKey);
        if (theElement != null) {
            theDocument.setChangeFlag(Boolean.TRUE);
            theElement.setText(sValue);
            return true;
        }
        return false;
    }

    public boolean changeAbaNLSMnemonic(String sDocumentKey, String sValueKey, String sMnemonicValue) {
        AbaNLSDocument theDocument = this.findNLSDocumentByKey(sDocumentKey);
        Element theElement = this.getAbaNLSElement(sDocumentKey, sValueKey);
        if (theElement != null) {
            theDocument.setChangeFlag(Boolean.TRUE);
            theElement.setAttribute("mnemonic", sMnemonicValue);
            return true;
        }
        return false;
    }

    public boolean removeAbaNLSValue(String sDocumentKey, String sValueKey) {
        Element theRootElement;
        Element theElement = this.getAbaNLSElement(sDocumentKey, sValueKey);
        if (theElement != null && (theRootElement = this.getRootElement(sDocumentKey)) != null) {
            theRootElement.removeChild((Node)theElement);
            return true;
        }
        return false;
    }

    public boolean writeNlsDocument(int iDocument) {
        AbaNLSDocument theNLSDocument = this.getNLSDocumentByIndex(iDocument);
        try {
            File fileOutput = new File(theNLSDocument.getDocumentName());
            if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS writeNLSDocument:  Will try to write = " + theNLSDocument.getDocumentName(), "");
            }
            PrintWriter pwOutput = new PrintWriter(new FileWriter(fileOutput));
            Document theDocument = theNLSDocument.getDocument();
            theDocument.write((Writer)pwOutput);
            pwOutput.close();
            if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS writeNLSDocument:  " + theNLSDocument.getDocumentName() + " successfully written", "");
            }
        }
        catch (IOException e) {
            if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS writeNLSDocument:  " + theNLSDocument.getDocumentName() + " Failure", "");
            }
            return false;
        }
        return true;
    }

    public boolean writeAllChangedNlsDocuments() {
        boolean bRetVal = true;
        for (int i = 0; i < this.theDocumentCount; ++i) {
            boolean bTestWrite;
            AbaNLSDocument theDocument = this.getNLSDocumentByIndex(i);
            Boolean bTestValue = theDocument.getChangeFlag();
            if (!bTestValue.booleanValue() || (bTestWrite = this.writeNlsDocument(i))) continue;
            bRetVal = false;
        }
        return bRetVal;
    }

    public String getTranslatedValue(String sKey, int iLanguagePresentation, boolean bMnemonic) {
        if (sKey.startsWith("@AbaNLS")) {
            if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  " + sKey + ". Language is " + HammerLanguagePresentation.getLanguageName(iLanguagePresentation), "");
            }
            int iFirstDot = sKey.indexOf(".");
            int iLastDot = sKey.lastIndexOf(".");
            if (iFirstDot == -1 || iFirstDot == iLastDot) {
                return sKey;
            }
            String sDocumentKey = sKey.substring(iFirstDot + 1, iLastDot);
            String sSearchKey = sKey.substring(iLastDot + 1);
            String sDefaultDocumentKey = sDocumentKey + "_DE";
            switch (iLanguagePresentation) {
                case 0: {
                    sDocumentKey = sDocumentKey + "_DE";
                    break;
                }
                case 1: {
                    sDocumentKey = sDocumentKey + "_FR";
                    break;
                }
                case 2: {
                    sDocumentKey = sDocumentKey + "_IT";
                    break;
                }
                case 3: {
                    sDocumentKey = sDocumentKey + "_EN";
                    break;
                }
                default: {
                    sDocumentKey = sDocumentKey + "_DE";
                }
            }
            if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  Searching for document with key: " + sDocumentKey, "");
                this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  Searching for value with key: " + sSearchKey, "");
            }
            if ((sKey = this.getAbaNLSValue(sDocumentKey, sSearchKey, bMnemonic)) == null && iLanguagePresentation != 0) {
                if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                    this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  Didn't find match.  Trying deutsch: " + sDefaultDocumentKey, "");
                    this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  Didn't find match.  Trying deutsch: " + sSearchKey, "");
                }
                sKey = this.getAbaNLSValue(sDefaultDocumentKey, sSearchKey, bMnemonic);
            }
            if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
                this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  Return value: " + sKey, "");
            }
        }
        return sKey;
    }

    public int getDocumentCount() {
        return this.theDocumentCount;
    }

    public void Load() {
        int i;
        this.clear();
        if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
            this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS Load was invoked!", "");
        }
        HammerConfigurationManager theConfigManager = this.theProject.getMetaDataUser().getConfigurationManager();
        int iDocCount = theConfigManager.getNLSDocCount();
        for (i = 0; i < iDocCount; ++i) {
            String sKey = theConfigManager.getNLSDocKey(i);
            String sDoc = theConfigManager.getNLSDocName(i);
            if (this.findNLSDocumentByName(sKey) != null) continue;
            this.addDocument(sDoc, sKey);
        }
        if (this.theProject.theLocalNLSDocuments != null) {
            iDocCount = this.theProject.theLocalNLSDocuments.size();
            for (i = 0; i < iDocCount; ++i) {
                HammerNLSAccess theAccess = (HammerNLSAccess)this.theProject.theLocalNLSDocuments.get(i);
                String sKey = theAccess.sKey;
                String sDoc = theAccess.sDocument;
                if (this.findNLSDocumentByName(sKey) != null) continue;
                this.addDocument(sDoc, sKey);
            }
        }
        if (this.theProject.getMetaDataUser().getLogFile() != null && this.theProject.getMetaDataUser().getLogFile().isNLSLogging()) {
            this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS Load - after loading there are " + this.getDocumentCount() + "NLS Docs", "");
            for (i = 0; i < this.getDocumentCount(); ++i) {
                AbaNLSDocument theNLSDocument = this.getNLSDocumentByIndex(i);
                this.theProject.getMetaDataUser().getLogFile().doLogEntry("NLS Load - Document: " + i, theNLSDocument.getDocumentName());
            }
        }
    }

    public void Load(MetaProject theTemplateProject) throws HammerException {
        int i;
        this.clear();
        HammerConfigurationManager theConfigManager = theTemplateProject.getMetaDataUser().getConfigurationManager();
        int iDocCount = theConfigManager.getNLSDocCount();
        for (i = 0; i < iDocCount; ++i) {
            String sKey = theConfigManager.getNLSDocKey(i);
            String sDoc = theConfigManager.getNLSDocName(i);
            if (this.findNLSDocumentByName(sKey) == null && this.addDocument(sDoc, sKey)) continue;
        }
        if (theTemplateProject.theLocalNLSDocuments != null) {
            iDocCount = theTemplateProject.theLocalNLSDocuments.size();
            for (i = 0; i < iDocCount; ++i) {
                HammerNLSAccess theAccess = (HammerNLSAccess)theTemplateProject.theLocalNLSDocuments.get(i);
                String sKey = theAccess.sKey;
                String sDoc = theAccess.sDocument;
                if (this.findNLSDocumentByName(sKey) == null && this.addDocument(sDoc, sKey)) continue;
            }
        }
    }
}

