/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.abaRenderer;

import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JATextField;
import ch.abacus.lib.ui.renderer.abaRenderer.AbaRenderer;
import ch.abacus.lib.ui.renderer.abaRenderer.DefaultPathAbaRenderer;
import ch.abacus.lib.ui.renderer.abaRenderer.RendererFocusTraversalPolicy;
import ch.abacus.lib.ui.renderer.common.HammerException;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

public class TestRenderer
extends JAFrame {
    JATextField prozField = new JATextField();
    JAButton goButton = new JAButton("Go");

    public TestRenderer() {
        this.addWindowListener(new MainWindowListener());
        this.setSize(100, 100);
        this.setSize(100, 100);
        this.setLocation(100, 100);
        this.setTitle("Renderer Launcher");
        Container theContainer = this.getContentPane();
        theContainer.setLayout(new GridLayout(2, 1));
        theContainer.add(this.prozField);
        theContainer.add(this.goButton);
        this.goButton.addActionListener(new GoButtonListener());
        this.show();
    }

    public void render(String sDocumentName) throws HammerException {
        DefaultPathAbaRenderer theRenderer;
        boolean bTest;
        File docFile;
        if (sDocumentName.endsWith(".jar") && !sDocumentName.startsWith("http:") && (docFile = new File(sDocumentName)).exists()) {
            sDocumentName = docFile.getAbsolutePath();
        }
        if (bTest = (theRenderer = new DefaultPathAbaRenderer(sDocumentName, true, null)).load()) {
            JAFrame theFrame = new JAFrame();
            theFrame.setTitle("Test Rendering of " + sDocumentName);
            theFrame.setLocation(100, 100);
            theFrame.setSize(500, 400);
            JAPanel thePanel = new JAPanel();
            thePanel.setLocation(0, 0);
            thePanel.setSize(500, 400);
            theFrame.getContentPane().add(thePanel);
            theFrame.show();
            theRenderer.renderInterface(thePanel);
            theFrame.setVisible(false);
            theFrame.setVisible(true);
            theFrame.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
            theRenderer.setFocus();
            theFrame.addWindowListener(new ChildWindowListener(theFrame, theRenderer));
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window newFocus = focusManager.getFocusedWindow();
            System.out.println("New focus is: " + newFocus.getName());
        }
    }

    public static void main(String[] args) {
        new TestRenderer();
    }

    class ChildWindowListener
    extends WindowAdapter {
        private JAFrame theFrame;
        private AbaRenderer theRenderer;

        ChildWindowListener(JAFrame theFrame, AbaRenderer theRenderer) {
            this.theFrame = theFrame;
            this.theRenderer = theRenderer;
        }

        public void windowClosing(WindowEvent evt) {
            System.out.println("Window is closed.  Getting back resources.");
            this.theRenderer.close();
            super.windowClosing(evt);
            this.theRenderer = null;
            this.theFrame = null;
            System.gc();
        }
    }

    class MainWindowListener
    extends WindowAdapter {
        MainWindowListener() {
        }
    }

    class GoButtonListener
    implements ActionListener {
        GoButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TestRenderer.this.render(TestRenderer.this.prozField.getText());
            }
            catch (HammerException e1) {
                e1.printStackTrace();
            }
        }
    }
}

