/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.images.ImageLoader;
import ch.abacus.lib.ui.propertyinspector.core.Group;
import ch.abacus.lib.ui.propertyinspector.display.DisplayGroup;
import ch.abacus.lib.ui.propertyinspector.display.DisplayProperty;
import ch.abacus.lib.ui.propertyinspector.display.PropertyModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class PropertyBorder
implements Border {
    private int level = 0;
    private int toggle = 0;
    private PropertyModel model;
    private Color background = UIManager.getColor("Panel.background");
    private Icon collapsedIcon = ImageLoader.getImageIcon("lnf/tree_collapsed.png");
    private Icon expandedIcon = ImageLoader.getImageIcon("lnf/tree_expanded.png");

    public PropertyBorder(PropertyModel model) {
        this.model = model;
    }

    public void init(DisplayProperty property) {
        this.toggle = 0;
        if (this.model.isGrouped()) {
            this.calculateLevel(property.getProperty().getGroup());
        } else {
            this.level = 0;
        }
    }

    public void init(DisplayGroup group) {
        this.toggle = group.getGroup() == null || group.getGroup().isFolded() ? 2 : 1;
        if (this.model.isGrouped()) {
            this.calculateLevel(group.getGroup());
        } else {
            this.level = 0;
        }
    }

    private void calculateLevel(Group group) {
        this.level = 0;
        while (group != null) {
            ++this.level;
            group = group.getParent();
        }
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(1, this.level * this.expandedIcon.getIconWidth() + 6, 1, 1);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.background);
        g.fillRect(x, y, x + this.level * this.expandedIcon.getIconWidth() + 4, y + height);
        switch (this.toggle) {
            case 1: {
                this.expandedIcon.paintIcon(c, g, x + 2 + (this.level - 1) * this.expandedIcon.getIconHeight(), y + (height - this.expandedIcon.getIconHeight()) / 2);
                break;
            }
            case 2: {
                this.collapsedIcon.paintIcon(c, g, x + 2 + (this.level - 1) * this.expandedIcon.getIconHeight(), y + (height - this.collapsedIcon.getIconHeight()) / 2);
            }
        }
        g.setColor(oldColor);
    }
}

