/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.propertyinspector.display.editor;

import ch.abacus.lib.images.ImageLoader;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.layout.JABox;
import ch.abacus.lib.ui.propertyinspector.display.DisplayProperty;
import ch.abacus.lib.ui.propertyinspector.display.PropertyEditorEvent;
import ch.abacus.lib.ui.propertyinspector.display.PropertyRunner;
import ch.abacus.lib.ui.propertyinspector.display.PropertyValueEditorInterface;
import ch.abacus.lib.ui.propertyinspector.display.editor.ButtonMouseAdapter;
import ch.abacus.lib.ui.propertyinspector.display.editor.EditorDelegate;
import ch.abacus.lib.ui.report.preview.PreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;

public class BaseEditor
extends AbstractCellEditor
implements PropertyValueEditorInterface {
    private JComponent editorComponent;
    private JTable table;
    private JAButton editorButton = new JAButton("..");
    private JAButton btnUp = new JAButton();
    private JAButton btnDown = new JAButton();
    protected EditorDelegate delegate;
    private PreviewPanel panel = new PreviewPanel();
    private DisplayProperty property;
    private boolean hasUpDown;
    private PreviewPanel editorButtonWrapper;
    private PreviewPanel spinButtonWrapper;
    private PropertyRunner propertyRunner = new PropertyRunner(){

        public void execute(Object value) {
            BaseEditor.this.delegate.setValue(value);
            BaseEditor.this.stopCellEditing();
        }
    };
    private ActionListener upDownActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == BaseEditor.this.btnUp) {
                BaseEditor.this.spinUp();
            } else if (e.getSource() == BaseEditor.this.btnDown) {
                BaseEditor.this.spinDown();
            }
        }
    };
    private ActionListener buttonEditorActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Object value = BaseEditor.this.property.getValues().isSame() ? BaseEditor.this.property.getValues().get(0) : null;
            BaseEditor.this.property.getProperty().getPropertyEditor().edit(new PropertyEditorEvent(BaseEditor.this, BaseEditor.this.property, value, BaseEditor.this.propertyRunner));
        }
    };
    private ButtonMouseAdapter upDownMouseAdapter = new ButtonMouseAdapter(this.upDownActionListener);

    public BaseEditor() {
    }

    public boolean isModified() {
        return this.delegate.isModified();
    }

    public void modify() {
        this.delegate.modify();
    }

    public void setValueEditorReadOnly(boolean value) {
        this.editorComponent.setEnabled(!value);
    }

    public BaseEditor(final JTextField textField) {
        this.delegate = new EditorDelegate(this){

            public void setValue(Object value) {
                textField.setText(value != null ? value.toString() : "");
            }

            public void selectAll() {
                textField.selectAll();
            }

            public void selectNone() {
                textField.select(0, 0);
            }

            public Object getValue() {
                return textField.getText();
            }
        };
        this.initialize(textField);
        textField.addActionListener(this.delegate);
    }

    public BaseEditor(final JCheckBox checkBox) {
        this.delegate = new EditorDelegate(this){

            public void setValue(Object value) {
                if (value == null) {
                    value = Boolean.FALSE;
                }
                checkBox.setSelected((Boolean)value);
            }

            public Object getValue() {
                return checkBox.isSelected();
            }
        };
        this.initialize(checkBox);
        checkBox.addActionListener(this.delegate);
    }

    public BaseEditor(final JComboBox comboBox) {
        comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.delegate = new EditorDelegate(this){

            public void setValue(Object value) {
                comboBox.setSelectedIndex((Integer)value);
            }

            public Object getValue() {
                return comboBox.getSelectedIndex();
            }

            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }

            public boolean stopCellEditing() {
                if (comboBox.isEditable()) {
                    comboBox.actionPerformed(new ActionEvent(BaseEditor.this, 0, ""));
                }
                return super.stopCellEditing();
            }
        };
        this.initialize(comboBox);
        comboBox.addActionListener(this.delegate);
    }

    public void fireEditingStopped() {
        super.fireEditingStopped();
    }

    public void fireEditingCanceled() {
        super.fireEditingCanceled();
    }

    protected JAButton getEditorButton() {
        return this.editorButton;
    }

    private PreviewPanel getWrapperPanel(JComponent component) {
        PreviewPanel p = new PreviewPanel();
        p.setLayout(new BorderLayout());
        p.add(JABox.createHorizontalStrut(1), "West");
        p.add((Component)component, "Center");
        return p;
    }

    public void initialized() {
    }

    protected void initialize(JComponent editor) {
        this.panel.setLayout(new BorderLayout(0, 0));
        this.editorComponent = editor;
        this.panel.add((Component)this.editorComponent, "Center");
        this.editorButtonWrapper = this.getWrapperPanel(this.editorButton);
        PreviewPanel p = new PreviewPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.btnUp, "North");
        p.add(JABox.createVerticalStrut(1), "Center");
        p.add((Component)this.btnDown, "South");
        this.btnUp.setIcon(ImageLoader.getImageIcon("spin_up.gif"));
        this.btnDown.setIcon(ImageLoader.getImageIcon("spin_down.gif"));
        this.btnUp.setPreferredSize(new Dimension(16, 7));
        this.btnDown.setPreferredSize(new Dimension(16, 7));
        this.spinButtonWrapper = this.getWrapperPanel(p);
        p = new PreviewPanel();
        p.setLayout(new FlowLayout(4, 0, 0));
        p.add(this.spinButtonWrapper);
        p.add(this.editorButtonWrapper);
        this.panel.add((Component)p, "East");
        this.editorButton.addActionListener(this.buttonEditorActionListener);
        this.editorButton.setPreferredSize(new Dimension(16, 15));
        this.editorComponent.addKeyListener(this.delegate);
        this.editorComponent.addFocusListener(this.delegate);
        this.btnUp.addActionListener(this.upDownActionListener);
        this.btnUp.addMouseListener(this.upDownMouseAdapter);
        this.btnDown.addActionListener(this.upDownActionListener);
        this.btnDown.addMouseListener(this.upDownMouseAdapter);
    }

    public boolean isHasUpDown() {
        return this.hasUpDown;
    }

    public void setHasUpDown(boolean hasUpDown) {
        this.hasUpDown = hasUpDown;
    }

    public Object getCellEditorValue() {
        return this.delegate.getValue();
    }

    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return this.delegate.shouldSelectCell(anEvent);
    }

    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    protected void spinUp() {
    }

    protected void spinDown() {
    }

    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.property = (DisplayProperty)value;
        this.editorButtonWrapper.setVisible(this.property.getProperty().getPropertyEditor() != null && this.property.getProperty().getPropertyEditor().isVisible(this.property.getProperty()));
        this.spinButtonWrapper.setVisible(this.hasUpDown);
        if (this.property.getValues().isSame()) {
            this.delegate.setValue(this.property.getValues().get(0));
        } else {
            this.delegate.setValue(null);
        }
        this.delegate.clearModified();
        return this.panel;
    }
}

