/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.propertyinspector.display;

import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.ui.propertyinspector.display.HeaderlessColumnResizer;
import ch.abacus.lib.ui.propertyinspector.display.PropertyEditorRegistry;
import ch.abacus.lib.ui.propertyinspector.display.PropertyModel;
import ch.abacus.lib.ui.propertyinspector.display.PropertyRendererRegistry;
import ch.abacus.lib.ui.propertyinspector.display.PropertyTable;
import ch.abacus.lib.ui.propertyinspector.display.PropertyValueEditorInterface;
import ch.abacus.lib.util.GlobalInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyInspector
extends JAPanel {
    private PropertyTable table = new PropertyTable();
    private PropertyModel model;
    private GlobalInterface globalInterface;
    private HashMap<String, String> languageStrings = new HashMap();
    private PropertyEditorRegistry editorRegistry = new PropertyEditorRegistry();
    private PropertyRendererRegistry rendererRegistry = new PropertyRendererRegistry();

    public PropertyInspector(GlobalInterface globalInterface) {
        this.init(globalInterface, true);
    }

    public PropertyInspector(GlobalInterface globalInterface, boolean useInternalScrollPane) {
        this.init(globalInterface, useInternalScrollPane);
    }

    private void init(GlobalInterface globalInterface, boolean useInternalScrollPane) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.globalInterface = globalInterface;
        this.model = new PropertyModel(this, this.table);
        this.table.setModel(this.model);
        Dimension nullSize = new Dimension(0, 0);
        this.table.getTableHeader().setPreferredSize(nullSize);
        this.table.getTableHeader().setMinimumSize(nullSize);
        this.table.getTableHeader().setMaximumSize(nullSize);
        this.table.getTableHeader().setVisible(false);
        this.table.setSelectionMode(0);
        this.table.setGridColor(UIManager.getColor("Panel.background"));
        new HeaderlessColumnResizer(this.table);
        this.model.initialize();
        this.setLayout(new BorderLayout(0, 0));
        if (useInternalScrollPane) {
            JAScrollPane scrollPane = new JAScrollPane(this.table);
            this.add((Component)scrollPane, "Center");
        } else {
            this.add((Component)this.table, "Center");
        }
    }

    public GlobalInterface getGlobalInterface() {
        return this.globalInterface;
    }

    public void initialize() {
        Iterator iterator = this.editorRegistry.iterator();
        while (iterator.hasNext()) {
            ((PropertyValueEditorInterface)iterator.next()).initialized();
        }
    }

    public HashMap<String, String> getLanguageStrings() {
        return this.languageStrings;
    }

    public PropertyEditorRegistry getEditorRegistry() {
        return this.editorRegistry;
    }

    public PropertyRendererRegistry getRendererRegistry() {
        return this.rendererRegistry;
    }

    public PropertyModel getModel() {
        return this.model;
    }

    public JATable getTable() {
        return this.table;
    }

    public void endEditing() {
        this.table.endEditing();
    }

    public void beginEditing() {
        this.model.editCurrentRow();
    }

    public void beginUpdate() {
        this.model.beginUpdate();
    }

    public void endUpdate() {
        this.model.endUpdate();
    }

    public void changeSelection() {
        this.model.changeSelection();
    }

    public void addSelection(Object object) {
        this.model.addSelection(object);
    }

    public void editCurrentRow() {
        this.model.editCurrentRow();
    }

    public boolean isEditing() {
        return this.table.isEditing();
    }
}

