/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.plaf.generic;

import ch.abacus.lib.ui.plaf.generic.GenericBorders;
import ch.abacus.lib.ui.plaf.generic.GenericTheme;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import sun.awt.AppContext;

public class GenericLookAndFeel
extends BasicLookAndFeel {
    public static final Font DEFAULT_FONT = new Font("Tahoma", 0, 11);
    public static final Font TITLE_FONT_14 = new Font("dialog", 1, 14);
    public static final Font TITLE_FONT_12 = new Font("dialog", 1, 12);
    private static boolean mIsInstalled = false;
    private static GenericTheme currentTheme;
    private static AppContext cachedAppContext;

    public GenericLookAndFeel() {
        if (!mIsInstalled) {
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("GenericLookAndFeel", this.getClass().getName()));
            mIsInstalled = true;
        }
        UIManager.getDefaults().put("Button.font", DEFAULT_FONT);
        UIManager.getDefaults().put("CheckBox.font", DEFAULT_FONT);
        UIManager.getDefaults().put("CheckBoxMenuItem.acceleratorFont", DEFAULT_FONT);
        UIManager.getDefaults().put("CheckBoxMenuItem.font", DEFAULT_FONT);
        UIManager.getDefaults().put("ComboBox.font", DEFAULT_FONT);
        UIManager.getDefaults().put("Label.font", DEFAULT_FONT);
        UIManager.getDefaults().put("Menu.acceleratorFont", DEFAULT_FONT);
        UIManager.getDefaults().put("Menu.font", DEFAULT_FONT);
        UIManager.getDefaults().put("MenuBar.font", DEFAULT_FONT);
        UIManager.getDefaults().put("MenuItem.acceleratorFont", DEFAULT_FONT);
        UIManager.getDefaults().put("MenuItem.font", DEFAULT_FONT);
        UIManager.getDefaults().put("PasswordField.font", DEFAULT_FONT);
        UIManager.getDefaults().put("ProgressBar.font", DEFAULT_FONT);
        UIManager.getDefaults().put("RadioButton.font", DEFAULT_FONT);
        UIManager.getDefaults().put("RadioButtonMenuItem.acceleratorFont", DEFAULT_FONT);
        UIManager.getDefaults().put("RadioButtonMenuItem.font", DEFAULT_FONT);
        UIManager.getDefaults().put("TabbedPane.font", DEFAULT_FONT);
        UIManager.getDefaults().put("Table.font", DEFAULT_FONT);
        UIManager.getDefaults().put("TableHeader.font", DEFAULT_FONT);
        UIManager.getDefaults().put("TextField.font", DEFAULT_FONT);
        UIManager.getDefaults().put("TextArea.font", DEFAULT_FONT);
        UIManager.getDefaults().put("TitledBorder.font", DEFAULT_FONT);
        UIManager.getDefaults().put("ToggleButton.font", DEFAULT_FONT);
        UIManager.getDefaults().put("ToolBar.font", DEFAULT_FONT);
        UIManager.getDefaults().put("ToolTip.font", DEFAULT_FONT);
        UIManager.getDefaults().put("Tree.font", DEFAULT_FONT);
        UIManager.getDefaults().put("FormattedTextField.font", DEFAULT_FONT);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        String abacusPackageName = "ch.abacus.lib.ui.plaf.generic.";
        String abacusBorderFactoryClass = "ch.abacus.lib.ui.plaf.generic.GenericBorders";
        UIDefaults.ProxyLazyValue textFieldBorder = new UIDefaults.ProxyLazyValue(abacusBorderFactoryClass, "getTextFieldBorder");
        UIDefaults.ProxyLazyValue lineBorder = new UIDefaults.ProxyLazyValue(abacusBorderFactoryClass, "getLineBorder");
        Border emptyBorder1111 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        UIDefaults.ProxyLazyValue buttonBorder = new UIDefaults.ProxyLazyValue(abacusBorderFactoryClass, "getButtonBorder");
        UIDefaults.ProxyLazyValue progressBarBorder = new UIDefaults.ProxyLazyValue(abacusBorderFactoryClass, "getProgressBarBorder");
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        Object[] defaults = new Object[]{"TextField.border", textFieldBorder, "PasswordField.border", textFieldBorder, "TextArea.border", textFieldBorder, "TextArea.focusInputMap", multilineInputMap, "TextPane.focusInputMap", multilineInputMap, "EditorPane.focusInputMap", multilineInputMap, "Panel.border", emptyBorder1111, "TextPane.border", emptyBorder1111, "TitledBorder.border", BorderFactory.createLineBorder(GenericLookAndFeel.getDarkGray(), 1), "TextField.focusInputMap", fieldInputMap, "PasswordField.focusInputMap", fieldInputMap, "FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "FormattedTextField.border", textFieldBorder, "CheckBox.icon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getCheckBoxIcon"), "RadioButton.disabledText", GenericLookAndFeel.getInactiveCaption(), "RadioButton.icon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getRadioButtonIcon"), "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "ComboBox.border", lineBorder, "ComboBox.buttonShadow", GenericLookAndFeel.getSilver(), "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "ENTER", "enterPressed", "F4", "togglePopup"}), "Label.disabledForeground", GenericLookAndFeel.getInactiveCaption(), "ScrollPane.border", lineBorder, "EditorPane.border", emptyBorder1111, "TextPane.border", textFieldBorder, "ScrollPane.viewportBorder", emptyBorder1111, "ScrollBar.border", emptyBorder1111, "SplitPane.border", emptyBorder1111, "SplitPaneDivider.border", BorderFactory.createEmptyBorder(), "SplitPane.dividerSize", new Integer(3), "SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"}), "RootPane.frameBorder", emptyBorder1111, "RootPane.plainDialogBorder", emptyBorder1111, "RootPane.informationDialogBorder", emptyBorder1111, "RootPane.errorDialogBorder", emptyBorder1111, "RootPane.colorChooserDialogBorder", emptyBorder1111, "RootPane.fileChooserDialogBorder", emptyBorder1111, "RootPane.questionDialogBorder", emptyBorder1111, "RootPane.warningDialogBorder", emptyBorder1111, "InternalFrame.border", emptyBorder1111, "TableHeader.cellBorder", GenericBorders.getTableHeaderBorder(), "Table.gridColor", new ColorUIResource(13947080), "Table.scrollPaneBorder", lineBorder, "Table.focusCellHighlightBorder", BorderFactory.createLineBorder(GenericLookAndFeel.getSelectBorderColor(), 1), "List.font", DEFAULT_FONT, "List.border", BorderFactory.createEmptyBorder(), "List.scrollPaneBorder", emptyBorder1111, "List.focusCellHighlightBorder", BorderFactory.createLineBorder(GenericLookAndFeel.getSelectBorderColor(), 1), "ToolBar.border", emptyBorder1111, "ToolBar.background", GenericLookAndFeel.getToolBarBGColor(), "MenuBar.border", emptyBorder1111, "Menu.border", lineBorder, "MenuItem.border", lineBorder, "PopupMenu.border", lineBorder, "Menu.foreground", GenericLookAndFeel.getBlack(), "Menu.disabledForeground", GenericLookAndFeel.getDisabledColor(), "Menu.acceleratorForeground", GenericLookAndFeel.getBlack(), "Menu.acceleratorSelectionForeground", GenericLookAndFeel.getBlack(), "MenuItem.foreground", GenericLookAndFeel.getBlack(), "MenuItem.background", GenericLookAndFeel.getFillHovered(), "MenuItem.disabledForeground", GenericLookAndFeel.getDisabledColor(), "MenuItem.acceleratorForeground", GenericLookAndFeel.getBlack(), "MenuItem.acceleratorSelectionForeground", GenericLookAndFeel.getBlack(), "RadioButtonMenuItem.background", GenericLookAndFeel.getFillHovered(), "RadioButtonMenuItem.checkIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getRadioButtonIcon"), "CheckBoxMenuItem.background", GenericLookAndFeel.getFillHovered(), "CheckBoxMenuItem.checkIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getCheckBoxIcon"), "FileView.directoryIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFolderIcon"), "FileView.fileIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeLeafIcon"), "FileView.computerIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeComputerIcon"), "FileView.hardDriveIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeHardDriveIcon"), "FileView.floppyDriveIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFloppyDriveIcon"), "FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI", "FileChooser.detailsViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserDetailViewIcon"), "FileChooser.homeFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserHomeFolderIcon"), "FileChooser.listViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserListViewIcon"), "FileChooser.newFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserNewFolderIcon"), "FileChooser.upFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserUpFolderIcon"), "OptionPane.errorIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getErrorIcon"), "OptionPane.informationIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getInformIcon"), "OptionPane.warningIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getWarningIcon"), "OptionPane.questionIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getQuestionIcon"), "ProgressBar.border", progressBarBorder, "Entry.font", DEFAULT_FONT, "Entry.background", table.get("control"), "Entry.foreground", table.get("control"), "Entry.border", emptyBorder1111, "Entry.arrowButtonSize", new Dimension(16, 11), "Entry.dateButtonSize", new Dimension(14, 19), "Entry.promptButtonSize", new Dimension(16, 19), "Entry.entryHeight", new Integer(19), "Tree.openIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFolderIcon"), "Tree.closedIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getTreeFolderIconClosed"), "Tree.leafIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeLeafIcon"), "Tree.expandedIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getTreeExpandedIcon"), "Tree.collapsedIcon", new UIDefaults.ProxyLazyValue(abacusPackageName + "GenericIconFactory", "getTreeCollapsedIcon"), "Tree.editorBorder", emptyBorder1111, "Tree.background", GenericLookAndFeel.getWhite(), "Tree.textBackground", GenericLookAndFeel.getWhite(), "TabbedPane.border", emptyBorder1111, "TabbedPane.highlight", GenericLookAndFeel.getSilver(), "PanelExtenderPanel.background", GenericLookAndFeel.getColGroupFill(), "PanelExtenderPanel.border", BorderFactory.createLineBorder(GenericLookAndFeel.getColGroupBorder())};
        table.putDefaults(defaults);
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String abacusPackageName = "ch.abacus.lib.ui.plaf.generic.";
        String basicPackageName = "javax.swing.plaf.basic.";
        Object[] uiDefaults = new Object[]{"CheckBoxUI", abacusPackageName + "GenericCheckBoxUI", "ToggleButtonUI", abacusPackageName + "GenericToggleButtonUI", "ButtonUI", abacusPackageName + "GenericButtonUI", "ToolBarUI", abacusPackageName + "GenericToolBarUI"};
        table.putDefaults(uiDefaults);
        ClassLoader cl = this.getClass().getClassLoader();
        table.put("ClassLoader", cl);
    }

    public String getID() {
        return "GenericLookAndFeel";
    }

    public String getName() {
        return "GenericLookAndFeel";
    }

    public String getDescription() {
        return "GenericLookAndFeel Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        Object[] systemColors = new Object[]{"control", GenericLookAndFeel.getColor(), "menu", GenericLookAndFeel.getColor(), "text", GenericLookAndFeel.getColor()};
        for (int i = 0; i < systemColors.length; i += 2) {
            table.put(systemColors[i], systemColors[i + 1]);
        }
    }

    public static void setCurrentTheme(GenericTheme theme) {
        if (theme == null) {
            throw new NullPointerException("Can't have null theme");
        }
        currentTheme = theme;
        cachedAppContext = AppContext.getAppContext();
        cachedAppContext.put("currentAbacusGenericTheme", theme);
    }

    public static GenericTheme getCurrentTheme() {
        if (currentTheme == null) {
            currentTheme = new GenericTheme();
        }
        return currentTheme;
    }

    public static ColorUIResource getAqua() {
        return GenericLookAndFeel.getCurrentTheme().getAqua();
    }

    public static ColorUIResource getBlack() {
        return GenericLookAndFeel.getCurrentTheme().getBlack();
    }

    public static ColorUIResource getBlue() {
        return GenericLookAndFeel.getCurrentTheme().getBlue();
    }

    public static ColorUIResource getBtnFace() {
        return GenericLookAndFeel.getCurrentTheme().getBtnFace();
    }

    public static ColorUIResource getBtnShadow() {
        return GenericLookAndFeel.getCurrentTheme().getBtnShadow();
    }

    public static ColorUIResource getColGroupBorder() {
        return GenericLookAndFeel.getCurrentTheme().getColGroupBorder();
    }

    public static ColorUIResource getColGroupBorderFooter() {
        return GenericLookAndFeel.getCurrentTheme().getColGroupBorderFooter();
    }

    public static ColorUIResource getColGroupFill() {
        return GenericLookAndFeel.getCurrentTheme().getColGroupFill();
    }

    public static ColorUIResource getColGroupFillFooter() {
        return GenericLookAndFeel.getCurrentTheme().getColGroupFillFooter();
    }

    public static ColorUIResource getColGroupFont() {
        return GenericLookAndFeel.getCurrentTheme().getColGroupFont();
    }

    public static ColorUIResource getColGroupFontFooter() {
        return GenericLookAndFeel.getCurrentTheme().getColGroupFontFooter();
    }

    public static boolean isColorsInitialized() {
        return GenericLookAndFeel.getCurrentTheme().isColorsInitialized();
    }

    public static ColorUIResource getDarkGray() {
        return GenericLookAndFeel.getCurrentTheme().getDarkGray();
    }

    public static ColorUIResource getFuchsia() {
        return GenericLookAndFeel.getCurrentTheme().getFuchsia();
    }

    public static ColorUIResource getGray() {
        return GenericLookAndFeel.getCurrentTheme().getGray();
    }

    public static ColorUIResource getGreen() {
        return GenericLookAndFeel.getCurrentTheme().getGreen();
    }

    public static ColorUIResource getHighLight() {
        return GenericLookAndFeel.getCurrentTheme().getHighLight();
    }

    public static ColorUIResource getInactiveCaption() {
        return GenericLookAndFeel.getCurrentTheme().getInactiveCaption();
    }

    public static ColorUIResource getLightGray() {
        return GenericLookAndFeel.getCurrentTheme().getLightGray();
    }

    public static ColorUIResource getLime() {
        return GenericLookAndFeel.getCurrentTheme().getLime();
    }

    public static ColorUIResource getMaroon() {
        return GenericLookAndFeel.getCurrentTheme().getMaroon();
    }

    public static ColorUIResource getMenuText() {
        return GenericLookAndFeel.getCurrentTheme().getMenuText();
    }

    public static ColorUIResource getNavy() {
        return GenericLookAndFeel.getCurrentTheme().getNavy();
    }

    public static ColorUIResource getOlive() {
        return GenericLookAndFeel.getCurrentTheme().getOlive();
    }

    public static ColorUIResource getPurple() {
        return GenericLookAndFeel.getCurrentTheme().getPurple();
    }

    public static ColorUIResource getRed() {
        return GenericLookAndFeel.getCurrentTheme().getRed();
    }

    public static ColorUIResource getSilver() {
        return GenericLookAndFeel.getCurrentTheme().getSilver();
    }

    public static ColorUIResource getTeal() {
        return GenericLookAndFeel.getCurrentTheme().getTeal();
    }

    public static ColorUIResource getWhite() {
        return GenericLookAndFeel.getCurrentTheme().getWhite();
    }

    public static ColorUIResource getArrowDisabled() {
        return GenericLookAndFeel.getCurrentTheme().getArrowDisabled();
    }

    public static ColorUIResource getArrowDown() {
        return GenericLookAndFeel.getCurrentTheme().getArrowDown();
    }

    public static ColorUIResource getArrowNormal() {
        return GenericLookAndFeel.getCurrentTheme().getArrowNormal();
    }

    public static ColorUIResource getBaseSelectColor() {
        return GenericLookAndFeel.getCurrentTheme().getBaseSelectColor();
    }

    public static ColorUIResource getBorderFocused() {
        return GenericLookAndFeel.getCurrentTheme().getBorderFocused();
    }

    public static ColorUIResource getBorderHovered() {
        return GenericLookAndFeel.getCurrentTheme().getBorderHovered();
    }

    public static ColorUIResource getBorderNormal() {
        return GenericLookAndFeel.getCurrentTheme().getBorderNormal();
    }

    public static ColorUIResource getButtonUpLeftCorner() {
        return GenericLookAndFeel.getCurrentTheme().getButtonUpLeftCorner();
    }

    public static ColorUIResource getCheckedAreaColor() {
        return GenericLookAndFeel.getCurrentTheme().getCheckedAreaColor();
    }

    public static ColorUIResource getCheckedAreaSelectColor() {
        return GenericLookAndFeel.getCurrentTheme().getCheckedAreaSelectColor();
    }

    public static ColorUIResource getCheckedColor() {
        return GenericLookAndFeel.getCurrentTheme().getCheckedColor();
    }

    public static ColorUIResource getColor() {
        return GenericLookAndFeel.getCurrentTheme().getColor();
    }

    public static ColorUIResource getDisabledColor() {
        return GenericLookAndFeel.getCurrentTheme().getDisabledColor();
    }

    public static ColorUIResource getFillDown() {
        return GenericLookAndFeel.getCurrentTheme().getFillDown();
    }

    public static ColorUIResource getFillFocused() {
        return GenericLookAndFeel.getCurrentTheme().getFillFocused();
    }

    public static ColorUIResource getFillHovered() {
        return GenericLookAndFeel.getCurrentTheme().getFillHovered();
    }

    public static ColorUIResource getFillNormal() {
        return GenericLookAndFeel.getCurrentTheme().getFillNormal();
    }

    public static ColorUIResource getIconBackColor() {
        return GenericLookAndFeel.getCurrentTheme().getIconBackColor();
    }

    public static ColorUIResource getMenuBarColor() {
        return GenericLookAndFeel.getCurrentTheme().getMenuBarColor();
    }

    public static ColorUIResource getMenuBorderColor() {
        return GenericLookAndFeel.getCurrentTheme().getMenuBorderColor();
    }

    public static ColorUIResource getMenuShadowColor() {
        return GenericLookAndFeel.getCurrentTheme().getMenuShadowColor();
    }

    public static ColorUIResource getSelectBorderColor() {
        return GenericLookAndFeel.getCurrentTheme().getSelectBorderColor();
    }

    public static ColorUIResource getSelectColor() {
        return GenericLookAndFeel.getCurrentTheme().getSelectColor();
    }

    public static ColorUIResource getSelectFontColor() {
        return GenericLookAndFeel.getCurrentTheme().getSelectFontColor();
    }

    public static ColorUIResource getSeparatorColor() {
        return GenericLookAndFeel.getCurrentTheme().getSeparatorColor();
    }

    public static ColorUIResource getToolButtonBGColor() {
        return GenericLookAndFeel.getCurrentTheme().getToolButtonBGColor();
    }

    public static ColorUIResource getToolBarBGColor() {
        return GenericLookAndFeel.getCurrentTheme().getToolBarBGColor();
    }

    public static ColorUIResource getCatalogBGColor() {
        return GenericLookAndFeel.getCurrentTheme().getCatalogBGColor();
    }

    public static ColorUIResource getYellow() {
        return GenericLookAndFeel.getCurrentTheme().getYellow();
    }

    public static ColorUIResource getSelectedNonFocus() {
        return GenericLookAndFeel.getSilver();
    }

    public static ColorUIResource getWindow() {
        GenericLookAndFeel.getCurrentTheme();
        return GenericTheme.window;
    }

    public static ColorUIResource getWindowText() {
        GenericLookAndFeel.getCurrentTheme();
        return GenericTheme.windowText;
    }
}

