/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.plaf.generic;

import ch.abacus.lib.ui.JAComboBox;
import ch.abacus.lib.ui.plaf.generic.GenericLookAndFeel;
import ch.abacus.lib.ui.plaf.generic.GenericUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;

public class GenericBorders {
    private static Border mTextFieldBorder;
    private static Border mHoveredTextFieldBorder;
    private static Border mLineBorder;
    private static Border mHoveredLineBorder;
    private static Border mComboBoxBorder;
    private static Border mButtonBorder;
    private static Border mHoveredButtonBorder;
    private static ButtonBorder mHoverAbacusButtonBorder;
    private static Border mTableHeaderBorder;

    public static Border getTextFieldBorder() {
        if (mTextFieldBorder == null) {
            mTextFieldBorder = new TextFieldBorder(GenericLookAndFeel.getBorderNormal(), 1);
        }
        return mTextFieldBorder;
    }

    public static Border getHoveredTextFieldBorder() {
        if (mHoveredTextFieldBorder == null) {
            mHoveredTextFieldBorder = new TextFieldBorder(GenericLookAndFeel.getSelectBorderColor(), 1);
        }
        return mHoveredTextFieldBorder;
    }

    public static Border getLineBorder() {
        if (mLineBorder == null) {
            mLineBorder = new BorderUIResource.LineBorderUIResource(GenericLookAndFeel.getBorderNormal(), 1);
        }
        return mLineBorder;
    }

    public static Border getHoveredLineBorder() {
        if (mHoveredLineBorder == null) {
            mHoveredLineBorder = new BorderUIResource.LineBorderUIResource(GenericLookAndFeel.getSelectBorderColor(), 1);
        }
        return mHoveredLineBorder;
    }

    public static Border getComboBoxBorder() {
        if (mComboBoxBorder == null) {
            mComboBoxBorder = new BorderUIResource.LineBorderUIResource(GenericLookAndFeel.getBorderNormal(), 2);
        }
        return mComboBoxBorder;
    }

    public static Border getProgressBarBorder() {
        CompoundBorder progressBarBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(GenericLookAndFeel.getBorderNormal(), 1), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        return progressBarBorder;
    }

    public static Border getTableHeaderBorder() {
        if (mTableHeaderBorder == null) {
            mTableHeaderBorder = new EmptyBorder(0, 2, 0, 0){

                public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                    g.setClip((int)g.getClipBounds().getX(), (int)g.getClipBounds().getY(), (int)g.getClipBounds().getWidth(), (int)g.getClipBounds().getHeight() + 1);
                    g.setColor(GenericLookAndFeel.getWhite());
                    g.drawLine(x, y, x + w - 1, y);
                    g.drawLine(x, y + h - 1, x, y + 1);
                    g.setColor(GenericLookAndFeel.getDarkGray());
                    g.drawLine(x + 1, y + h, x + w - 1, y + h);
                    g.drawLine(x + w - 1, y + h, x + w - 1, y + 1);
                }

                public Insets getBorderInsets(Component c) {
                    return new Insets(1, 1, 1, 1);
                }
            };
        }
        return mTableHeaderBorder;
    }

    public static Border getButtonBorder() {
        if (mButtonBorder == null) {
            mButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(false), new BasicBorders.MarginBorder());
        }
        return mButtonBorder;
    }

    public static Border getHoveredButtonBorder(AbstractButton oldButton) {
        if (mHoveredButtonBorder == null) {
            mHoverAbacusButtonBorder = new ButtonBorder(true);
            mHoveredButtonBorder = new BorderUIResource.CompoundBorderUIResource(mHoverAbacusButtonBorder, new MarginBorder());
        }
        mHoverAbacusButtonBorder.setBorderInsets(oldButton.getInsets());
        return mHoveredButtonBorder;
    }

    public static class TextFieldBorder
    extends LineBorder {
        private static final Insets mInsets = new Insets(1, 3, 1, 2);

        public TextFieldBorder(Color color) {
            super(color);
        }

        public TextFieldBorder(Color color, int thickness) {
            super(color, thickness);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            super.paintBorder(c, g, x, y, width, height);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            if (c instanceof JAComboBox) {
                return super.getBorderInsets(c, insets);
            }
            return super.getBorderInsets(c, mInsets);
        }

        public Insets getBorderInsets(Component c) {
            if (c instanceof JAComboBox) {
                return super.getBorderInsets(c);
            }
            return mInsets;
        }
    }

    public static class MarginBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            return insets;
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected Insets borderInsets = new Insets(3, 3, 3, 3);
        protected boolean mIsHovered;

        public ButtonBorder(boolean hovered) {
            this.mIsHovered = hovered;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    GenericUtils.drawPressedBorder(g, x, y, w, h, this.mIsHovered);
                } else if (button instanceof JButton && ((JButton)button).isDefaultButton()) {
                    if (button.hasFocus()) {
                        // empty if block
                    }
                    GenericUtils.drawDefaultButtonBorder(g, x, y, w, h, false, this.mIsHovered);
                } else {
                    if (button.hasFocus()) {
                        // empty if block
                    }
                    GenericUtils.drawButtonBorder(g, x, y, w, h, false, this.mIsHovered);
                }
            } else {
                GenericUtils.drawDisabledBorder(g, x, y, w - 1, h - 1);
            }
        }

        public void setBorderInsets(Insets insets) {
            this.borderInsets = insets;
        }

        public Insets getBorderInsets(Component c) {
            return this.borderInsets;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            return this.borderInsets;
        }
    }
}

