/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.layout;

import ch.abacus.lib.util.math.IntMath;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class VerticalFlowLayout2
implements LayoutManager2,
Serializable {
    private HAlignment mHAlignment;
    private VAlignment mVAlignment;
    private int mFillComponent = -1;
    private int mHgap;
    private int mVgap;
    private boolean mHfill;
    private boolean mVfill;

    public VerticalFlowLayout2() {
        this(HAlignment.Left, VAlignment.Top, 0, 0, true, false);
    }

    public VerticalFlowLayout2(boolean hfill, boolean vfill) {
        this(HAlignment.Left, VAlignment.Top, 0, 0, hfill, vfill);
    }

    public VerticalFlowLayout2(HAlignment hAlign, VAlignment vAlign) {
        this(hAlign, vAlign, 0, 0, true, false);
    }

    public VerticalFlowLayout2(HAlignment hAlign, VAlignment vAlign, int hgap, int vgap, boolean hfill, boolean vfill) {
        this.mHAlignment = hAlign;
        this.mVAlignment = vAlign;
        this.setHgap(hgap);
        this.setVgap(vgap);
        this.mHfill = hfill;
        this.mVfill = vfill;
    }

    public int getFillComponent() {
        return this.mFillComponent;
    }

    public void setFillComponent(int fillComponent) {
        this.mFillComponent = fillComponent;
    }

    public int getHgap() {
        return this.mHgap;
    }

    public void setHgap(int hgap) {
        if (hgap < 0) {
            throw new IllegalArgumentException("hgap must be positive");
        }
        this.mHgap = hgap;
    }

    public int getVgap() {
        return this.mVgap;
    }

    public void setVgap(int vgap) {
        if (vgap < 0) {
            throw new IllegalArgumentException("vgap must be positive");
        }
        this.mVgap = vgap;
    }

    public boolean isHfill() {
        return this.mHfill;
    }

    public void setHfill(boolean hfill) {
        this.mHfill = hfill;
    }

    public boolean isVfill() {
        return this.mVfill;
    }

    public void setVfill(boolean vfill) {
        this.mVfill = vfill;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension maximumLayoutSize(Container target) {
        if (this.mHfill && this.mVfill) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int height = this.mVfill ? Integer.MAX_VALUE : 0;
            int width = this.mHfill ? Integer.MAX_VALUE : 0;
            for (int i = 0; i < target.getComponentCount(); ++i) {
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getMaximumSize();
                height = IntMath.add(height, d.height, this.mVgap);
                if (width >= d.width) continue;
                width = d.width;
            }
            height = IntMath.add(height, insets.top, insets.bottom, this.mVgap);
            width = IntMath.add(width, insets.left, insets.right, 2 * this.mHgap);
            return new Dimension(width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int fillComp = -1;
            int fillHeight = target.getHeight() - insets.top - insets.bottom - this.mVgap;
            int width = target.getWidth() - insets.left - insets.right - 2 * this.mHgap;
            for (int i = 0; i < target.getComponentCount(); ++i) {
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                if (i == this.mFillComponent || i == target.getComponentCount() - 1 && fillComp == -1 && this.mVfill) {
                    fillComp = i;
                    fillHeight -= this.mVgap;
                    continue;
                }
                fillHeight -= d.height + this.mVgap;
            }
            if (fillComp == -1 && this.mVfill) {
                fillComp = target.getComponentCount();
            }
            int top = insets.top + this.mVgap;
            int left = insets.left + this.mHgap;
            if (!this.mVfill) {
                switch (this.mVAlignment) {
                    case Middle: {
                        top = insets.top + this.mVgap + fillHeight / 2;
                        break;
                    }
                    case Bottom: {
                        top = insets.top + this.mVgap + fillHeight;
                    }
                }
            }
            for (int i = 0; i < target.getComponentCount(); ++i) {
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                int h = i == fillComp ? fillHeight : d.height;
                int w = this.mHfill ? width : d.width;
                int l = left;
                if (!this.mHfill) {
                    switch (this.mHAlignment) {
                        case Center: {
                            l = left + (width - d.width) / 2;
                            break;
                        }
                        case Right: {
                            l = left + width - d.width;
                        }
                    }
                }
                c.setBounds(l, top, w, h);
                top += h;
                top += this.mVgap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int height = 0;
            int width = 0;
            for (int i = 0; i < target.getComponentCount(); ++i) {
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getMinimumSize();
                height = IntMath.add(height, d.height, this.mVgap);
                if (width >= d.width) continue;
                width = d.width;
            }
            height = IntMath.add(height, insets.top, insets.bottom, this.mVgap);
            int n = (width = IntMath.add(width, insets.left, insets.right, 2 * this.mHgap)) < 0 ? 0 : width;
            return new Dimension(n, height < 0 ? 0 : height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int height = 0;
            int width = 0;
            for (int i = 0; i < target.getComponentCount(); ++i) {
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                height = IntMath.add(height, d.height, this.mVgap);
                if (width >= d.width) continue;
                width = d.width;
            }
            height = IntMath.add(height, insets.top, insets.bottom, this.mVgap);
            int n = (width = IntMath.add(width, insets.left, insets.right, 2 * this.mHgap)) < 0 ? 0 : width;
            return new Dimension(n, height < 0 ? 0 : height);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VAlignment {
        Top,
        Middle,
        Bottom;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HAlignment {
        Left,
        Center,
        Right;

    }
}

