/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui;

import ch.abacus.lib.ui.BorderFactory;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.util.math.IntMath;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.SystemColor;

public class JAGradientPanel
extends JAPanel {
    public static final Color DEFAULT_START_COLOR = new Color(254, 254, 254);
    private Color startColor = null;
    private Color endColor = null;
    private int colorCount = 100;
    private boolean topLine = false;

    public JAGradientPanel(LayoutManager layout) {
        super(layout);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public int getColorCount() {
        return this.colorCount;
    }

    public void setColorCount(int count) {
        if (count > 0) {
            this.colorCount = count;
        }
    }

    public void setStartColor(Color color) {
        this.startColor = color;
    }

    public void setEndColor(Color color) {
        this.endColor = color;
    }

    public Color getStartColor() {
        if (this.startColor == null) {
            return DEFAULT_START_COLOR;
        }
        return this.startColor;
    }

    public Color getEndColor() {
        if (this.endColor == null) {
            return this.getBackground();
        }
        return this.endColor;
    }

    public boolean getTopLineEnabled() {
        return this.topLine;
    }

    public void setTopLineEnabled(boolean _Enabled) {
        this.topLine = _Enabled;
    }

    public void paint(Graphics gx) {
        Color ec = this.getEndColor();
        Color sc = this.getStartColor();
        int dr = ec.getRed() - sc.getRed();
        int dg = ec.getGreen() - sc.getGreen();
        int db = ec.getBlue() - sc.getBlue();
        int height = this.getHeight();
        int width = this.getWidth() / this.colorCount;
        int left = 0;
        gx.setColor(sc);
        if (this.colorCount == 1) {
            gx.fillRect(0, 0, this.getWidth(), height);
            return;
        }
        gx.fillRect(left, 0, width, height);
        left += width;
        for (int i = 1; i < this.colorCount; ++i) {
            int r = sc.getRed() + IntMath.mulDiv(i, dr, this.colorCount - 1);
            int g = sc.getGreen() + IntMath.mulDiv(i, dg, this.colorCount - 1);
            int b = sc.getBlue() + IntMath.mulDiv(i, db, this.colorCount - 1);
            gx.setColor(new Color(r, g, b));
            if (i < this.colorCount - 1) {
                gx.fillRect(left, 0, width, height);
            } else {
                gx.fillRect(left, 0, this.getWidth() - left, height);
            }
            left += width;
        }
        if (this.topLine) {
            gx.setColor(SystemColor.controlShadow);
            gx.drawLine(0, 0, this.getWidth(), 0);
        }
        this.paintChildren(gx);
    }
}

