/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.JLinkButton;
import com.l2fprod.common.swing.JTaskPaneGroup;
import com.l2fprod.common.swing.icons.EmptyIcon;
import com.l2fprod.common.swing.plaf.TaskPaneGroupUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicTaskPaneGroupUI
extends TaskPaneGroupUI {
    private static FocusListener focusListener = new RepaintOnFocus();
    protected JTaskPaneGroup group;
    protected boolean mouseOver;
    protected MouseInputListener mouseListener;
    protected boolean animationRunning = false;
    protected float animationStage = 0.0f;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTaskPaneGroupUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.group = (JTaskPaneGroup)c;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        this.group.setOpaque(true);
        this.group.setBorder(this.createPaneBorder());
        ((JComponent)this.group.getContentPane()).setBorder(this.createContentPaneBorder());
        LookAndFeel.installColorsAndFont(this.group, "TaskPaneGroup.background", "TaskPaneGroup.foreground", "TaskPaneGroup.font");
        LookAndFeel.installColorsAndFont((JComponent)this.group.getContentPane(), "TaskPaneGroup.background", "TaskPaneGroup.foreground", "TaskPaneGroup.font");
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseInputListener();
        this.group.addMouseMotionListener(this.mouseListener);
        this.group.addMouseListener(this.mouseListener);
        this.group.addFocusListener(focusListener);
    }

    protected void installKeyboardActions() {
        ActionMap map;
        InputMap inputMap = (InputMap)UIManager.get("TaskPaneGroup.focusInputMap");
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.group, 0, inputMap);
        }
        if ((map = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.group, map);
        }
    }

    ActionMap getActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("toggleExpanded", new ToggleExpandedAction());
        return map;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        super.uninstallUI(c);
    }

    protected void uninstallListeners() {
        this.group.removeMouseListener(this.mouseListener);
        this.group.removeMouseMotionListener(this.mouseListener);
        this.group.removeFocusListener(focusListener);
    }

    protected MouseInputListener createMouseInputListener() {
        return new ToggleListener();
    }

    protected boolean isInBorder(MouseEvent event) {
        return event.getY() < this.getTitleHeight();
    }

    protected int getTitleHeight() {
        return 25;
    }

    protected Border createPaneBorder() {
        return new PaneBorder();
    }

    protected Border createContentPaneBorder() {
        Color borderColor = UIManager.getColor("TaskPaneGroup.borderColor");
        return new CompoundBorder(new ContentPaneBorder(borderColor), BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public Component createAction(Action action) {
        JLinkButton button = new JLinkButton(action);
        button.setOpaque(false);
        button.setBorder(null);
        button.setBorderPainted(false);
        button.setFocusPainted(true);
        button.setForeground(UIManager.getColor("TaskPaneGroup.titleForeground"));
        return button;
    }

    protected void ensureVisible() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BasicTaskPaneGroupUI.this.group.scrollRectToVisible(new Rectangle(BasicTaskPaneGroupUI.this.group.getWidth(), BasicTaskPaneGroupUI.this.group.getHeight()));
            }
        });
    }

    protected static int getTitleHeight(Component c) {
        return ((BasicTaskPaneGroupUI)((JTaskPaneGroup)c).getUI()).getTitleHeight();
    }

    protected static class PaneBorder
    implements Border {
        protected Color borderColor = UIManager.getColor("TaskPaneGroup.borderColor");
        protected Color titleForeground = UIManager.getColor("TaskPaneGroup.titleForeground");
        protected Color specialTitleBackground = UIManager.getColor("TaskPaneGroup.specialTitleBackground");
        protected Color specialTitleForeground = UIManager.getColor("TaskPaneGroup.specialTitleForeground");
        protected Color titleBackgroundGradientStart = UIManager.getColor("TaskPaneGroup.titleBackgroundGradientStart");
        protected Color titleBackgroundGradientEnd = UIManager.getColor("TaskPaneGroup.titleBackgroundGradientEnd");
        protected Color titleOver = UIManager.getColor("TaskPaneGroup.titleOver");
        protected Color specialTitleOver;

        public PaneBorder() {
            if (this.titleOver == null) {
                this.titleOver = this.specialTitleBackground.brighter();
            }
            this.specialTitleOver = UIManager.getColor("TaskPaneGroup.specialTitleOver");
            if (this.specialTitleOver == null) {
                this.specialTitleOver = this.specialTitleBackground.brighter();
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(BasicTaskPaneGroupUI.getTitleHeight(c), 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        protected void paintTitleBackground(JTaskPaneGroup group, Graphics g) {
            if (group.isSpecial()) {
                g.setColor(this.specialTitleBackground);
            } else {
                g.setColor(this.titleBackgroundGradientStart);
            }
            g.fillRect(0, 0, group.getWidth(), BasicTaskPaneGroupUI.getTitleHeight(group) - 1);
        }

        protected void paintTitle(JTaskPaneGroup group, Graphics g, Color textColor, int x, int y, int width, int height) {
            JLabel label = new JLabel();
            label.setOpaque(false);
            label.setForeground(textColor);
            label.setFont(g.getFont());
            label.setIconTextGap(8);
            label.setText(group.getText());
            label.setIcon(group.getIcon() == null ? new EmptyIcon() : group.getIcon());
            g.translate(x, y);
            label.setBounds(0, 0, width, height);
            label.paint(g);
            g.translate(-x, -y);
        }

        protected void paintExpandedControls(JTaskPaneGroup group, Graphics g) {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JTaskPaneGroup group = (JTaskPaneGroup)c;
            this.paintTitleBackground(group, g);
            this.paintExpandedControls(group, g);
            Color paintColor = group.isSpecial() ? this.specialTitleForeground : this.titleForeground;
            if (group.hasFocus()) {
                g.setColor(paintColor);
                BasicGraphicsUtils.drawDashedRect(g, 3, 3, width - 6, BasicTaskPaneGroupUI.getTitleHeight(c) - 6);
            }
            this.paintTitle(group, g, paintColor, 3, 0, c.getWidth() - BasicTaskPaneGroupUI.getTitleHeight(c) - 3, BasicTaskPaneGroupUI.getTitleHeight(c));
        }
    }

    protected static class ContentPaneBorder
    implements Border {
        Color color;

        public ContentPaneBorder(Color color) {
            this.color = color;
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.color);
            g.drawLine(x, y, x, y + height - 1);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        }
    }

    protected static class ChevronIcon
    implements Icon {
        boolean up = true;

        public ChevronIcon(boolean up) {
            this.up = up;
        }

        public int getIconHeight() {
            return 3;
        }

        public int getIconWidth() {
            return 6;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.up) {
                g.drawLine(x + 3, y, x, y + 3);
                g.drawLine(x + 3, y, x + 6, y + 3);
            } else {
                g.drawLine(x, y, x + 3, y + 3);
                g.drawLine(x + 3, y + 3, x + 6, y);
            }
        }
    }

    class ToggleExpandedAction
    extends AbstractAction {
        public ToggleExpandedAction() {
            super("toggleExpanded");
        }

        public void actionPerformed(ActionEvent e) {
            BasicTaskPaneGroupUI.this.group.setExpanded(!BasicTaskPaneGroupUI.this.group.isExpanded());
        }

        public boolean isEnabled() {
            return BasicTaskPaneGroupUI.this.group.isVisible();
        }
    }

    class ToggleListener
    extends MouseInputAdapter {
        ToggleListener() {
        }

        public void mouseEntered(MouseEvent e) {
            if (BasicTaskPaneGroupUI.this.isInBorder(e)) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                BasicTaskPaneGroupUI.this.mouseOver = false;
                BasicTaskPaneGroupUI.this.group.repaint();
            }
        }

        public void mouseExited(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
            BasicTaskPaneGroupUI.this.mouseOver = false;
            BasicTaskPaneGroupUI.this.group.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            if (BasicTaskPaneGroupUI.this.isInBorder(e)) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                BasicTaskPaneGroupUI.this.mouseOver = true;
                BasicTaskPaneGroupUI.this.group.repaint();
            } else {
                e.getComponent().setCursor(Cursor.getDefaultCursor());
                BasicTaskPaneGroupUI.this.mouseOver = false;
                BasicTaskPaneGroupUI.this.group.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (BasicTaskPaneGroupUI.this.isInBorder(e)) {
                BasicTaskPaneGroupUI.this.group.setExpanded(!BasicTaskPaneGroupUI.this.group.isExpanded());
            }
        }
    }

    static class RepaintOnFocus
    implements FocusListener {
        RepaintOnFocus() {
        }

        public void focusGained(FocusEvent e) {
            e.getComponent().repaint();
        }

        public void focusLost(FocusEvent e) {
            e.getComponent().repaint();
        }
    }
}

