/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.ManageCollectionGroupsDialog;
import ch.abacus.designcockpit.metadataEditor.ManageConstantCollectionsDialog;
import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JAList;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JASplitPane;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MetadataEditorPageConstantCollections
extends JAPanel {
    final MetadataEditor editor;
    JAList lstCollections = new JAList();
    JAList lstGroups = new JAList();
    ListSelectionListener selectionListener = new SelectionListener();
    ArrayList collections = new ArrayList();
    JAButton btnModifyCollections = new JAButton("Modify Collections");
    String[] groups = null;

    public MetadataEditorPageConstantCollections(MetadataEditor editor) {
        this.editor = editor;
        this.initDisplay();
        this.populateDisplay();
    }

    public void populateDisplay() {
        this.collections.clear();
        MetaConstantGroupCollection collection = this.editor.theMetadataDispenser.getFirstMetaConstantGroupCollection();
        while (collection != null) {
            this.collections.add(collection.sClassName);
            collection = collection.theNextSibling;
        }
        this.lstCollections.setListData(this.collections.toArray());
        if (this.collections.size() != 0) {
            this.lstCollections.setSelectedIndex(0);
        }
    }

    void initDisplay() {
        this.setLayout(new BorderLayout());
        JAPanel pnlCollections = new JAPanel((LayoutManager)new BorderLayout());
        JAPanel pnlGroupsInCollection = new JAPanel((LayoutManager)new BorderLayout());
        pnlCollections.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        pnlGroupsInCollection.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JASplitPane splitPane = new JASplitPane(1, (Component)pnlCollections, (Component)pnlGroupsInCollection);
        splitPane.setDividerLocation(200);
        Dimension minimumSize = new Dimension(100, 50);
        pnlCollections.setMinimumSize(minimumSize);
        pnlGroupsInCollection.setMinimumSize(minimumSize);
        JALabel lblCollections = new JALabel("Collections");
        pnlCollections.add((Component)lblCollections, (Object)"North");
        pnlCollections.add((Component)new JScrollPane((Component)this.lstCollections), (Object)"Center");
        JAPanel pnlModifyCollections = new JAPanel((LayoutManager)new FlowLayout(0, 0, 5));
        pnlModifyCollections.add((Component)this.btnModifyCollections);
        pnlCollections.add((Component)pnlModifyCollections, (Object)"South");
        JALabel lblGroups = new JALabel("Groups in Collection");
        pnlGroupsInCollection.add((Component)lblGroups, (Object)"North");
        pnlGroupsInCollection.add((Component)new JAScrollPane((Component)this.lstGroups), (Object)"Center");
        JAButton btnModifyConstants = new JAButton("Modify Groups");
        JAPanel pnlModifyConstants = new JAPanel((LayoutManager)new FlowLayout(0, 0, 5));
        pnlModifyConstants.add((Component)btnModifyConstants);
        pnlGroupsInCollection.add((Component)pnlModifyConstants, (Object)"South");
        this.add((Component)splitPane);
        this.lstCollections.addListSelectionListener(this.selectionListener);
        this.btnModifyCollections.addActionListener((ActionListener)new ModifyCollectionsAction(this));
        btnModifyConstants.addActionListener((ActionListener)new ModifyGroupsInCollectionAction(this));
    }

    void showGroupsOfTheCollection(String sCollection) {
        MetaConstantGroupCollection collection = this.editor.theMetadataDispenser.findConstantGroupCollection(sCollection);
        if (collection != null) {
            this.groups = new String[collection.getGroupCount()];
            for (int i = 0; i < collection.getGroupCount(); ++i) {
                this.groups[i] = collection.getGroup((int)i).sClassName;
            }
            this.lstGroups.setListData((Object[])this.groups);
        } else {
            this.lstGroups.setListData((Object[])new String[0]);
        }
    }

    class ModifyGroupsInCollectionAction
    implements ActionListener {
        private MetadataEditorPageConstantCollections page;

        public ModifyGroupsInCollectionAction(MetadataEditorPageConstantCollections page) {
            this.page = page;
        }

        public void actionPerformed(ActionEvent e) {
            MetaConstantGroupCollection collection = this.page.editor.theMetadataDispenser.findConstantGroupCollection((String)this.page.lstCollections.getSelectedValue());
            ManageCollectionGroupsDialog dialog = new ManageCollectionGroupsDialog(this.page, collection, "Manage Groups in Collection", "Select Groups");
            dialog.show();
            MetadataEditorPageConstantCollections.this.populateDisplay();
        }
    }

    class ModifyCollectionsAction
    implements ActionListener {
        private final MetadataEditorPageConstantCollections pageCollections;

        public ModifyCollectionsAction(MetadataEditorPageConstantCollections pageCollections) {
            this.pageCollections = pageCollections;
        }

        public void actionPerformed(ActionEvent e) {
            ManageConstantCollectionsDialog dialog = new ManageConstantCollectionsDialog(this.pageCollections, "Manage Constant-Group Collections", "Collections");
            dialog.show();
            MetadataEditorPageConstantCollections.this.populateDisplay();
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            MetadataEditorPageConstantCollections.this.showGroupsOfTheCollection((String)MetadataEditorPageConstantCollections.this.lstCollections.getSelectedValue());
        }
    }
}

