/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.ManageClassDialog;
import ch.abacus.designcockpit.metadataEditor.ManageClassPropertyDialog;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JASplitPane;
import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.ui.JATree;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ClassPropertiesPage
extends JAPanel {
    private JAPanel pnlProperties;
    private JAPanel pnlPropertiesButtons;
    private JAPanel pnlPropertyAttributes;
    private PropertiesTree treProperties;
    private PropertyAttributesTable tblPropertyAttributes;
    private JAPanel pnlEditButton;
    private final ManageClassDialog theDialog;
    private final MetaClassDetail theMetadata;

    public ClassPropertiesPage(ManageClassDialog dialog, MetaClassDetail metadata) {
        super((LayoutManager)new BorderLayout());
        this.theDialog = dialog;
        this.theMetadata = metadata;
        this.createInterface();
        this.populateInterface();
    }

    private void createInterface() {
        this.treProperties = new PropertiesTree(this.theMetadata);
        this.pnlProperties = new JAPanel((LayoutManager)new BorderLayout());
        this.pnlProperties.add((Component)new JAScrollPane((Component)((Object)this.treProperties)), (Object)"Center");
        this.pnlPropertiesButtons = new JAPanel((LayoutManager)new FlowLayout(0));
        this.pnlEditButton = new JAPanel((LayoutManager)new FlowLayout(0));
        JAButton btnAdd = new JAButton("Add");
        JAButton btnDelete = new JAButton("Delete");
        btnAdd.addActionListener((ActionListener)new AddPropertyAction(this.treProperties));
        btnDelete.addActionListener((ActionListener)new DeletePropertyAction(this.treProperties));
        JAButton btnEdit = new JAButton("Edit");
        btnEdit.addActionListener((ActionListener)new EditPropertyAction(this.treProperties));
        this.pnlPropertiesButtons.add((Component)btnAdd);
        this.pnlPropertiesButtons.add((Component)btnDelete);
        this.pnlProperties.add((Component)this.pnlPropertiesButtons, (Object)"South");
        this.pnlPropertyAttributes = new JAPanel((LayoutManager)new BorderLayout());
        this.tblPropertyAttributes = new PropertyAttributesTable();
        this.pnlPropertyAttributes.add((Component)new JAScrollPane((Component)((Object)this.tblPropertyAttributes)), (Object)"Center");
        this.pnlEditButton.add((Component)btnEdit);
        this.pnlPropertyAttributes.add((Component)this.pnlEditButton, (Object)"South");
        this.add((Component)new JASplitPane(1, (Component)this.pnlProperties, (Component)this.pnlPropertyAttributes));
    }

    private void populateInterface() {
        this.treProperties.populateInterface();
        this.tblPropertyAttributes.populateInterface();
    }

    class PropertyAttributesTable
    extends JATable {
        public PropertyAttributesTable() {
            this.setModel(new MyTableModel());
            this.setRowSelectionAllowed(false);
        }

        void populateInterface() {
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("Name", 0, 0);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("Class", 1, 0);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("Get", 2, 0);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("Set", 3, 0);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("Constant Group", 4, 0);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("Default Value", 5, 0);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("Visible", 6, 0);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("Array", 7, 0);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("Languages", 8, 0);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("Read-Only", 9, 0);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("Helper", 10, 0);
        }

        public void displayPropertyAttributes(MetaPropertyDescriptor property) {
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt(property.getName(), 0, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt(property.getClassName(), 1, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt(property.getGetMethod(), 2, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt(property.getSetMethod(), 3, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt(property.getIncludeTypeConstants(), 4, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt(property.getDefaultValue(), 5, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt(new Boolean(property.bVisible), 6, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt(new Boolean(property.bAllowMultipleValues), 7, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt(new Boolean(property.bAllowMultipleLanguages), 8, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt(new Boolean(property.isReadOnly()), 9, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt(property.getHelperClass(), 10, 1);
        }

        public void displayNoAttributes() {
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("", 0, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("", 1, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("", 2, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("", 3, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("", 4, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("", 5, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("", 6, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("", 7, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("", 8, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("", 9, 1);
            ClassPropertiesPage.this.tblPropertyAttributes.setValueAt("", 10, 1);
        }

        private class MyTableModel
        extends DefaultTableModel {
            private MyTableModel() {
            }

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return 11;
            }

            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return "Attribute Name";
                }
                return "Attribute Value";
            }

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        }
    }

    class PropertiesTree
    extends JATree {
        private final MetaClassDetail theMetadata;

        public PropertiesTree(MetaClassDetail metadata) {
            this.theMetadata = metadata;
            this.addTreeSelectionListener(new PropertySelectionListener());
        }

        void populateInterface() {
            this.setModel(new DefaultTreeModel(new ClassNode("Class Properties")));
            for (MetaPropertyDescriptor property = this.theMetadata.theFirstProperty; property != null; property = property.getNextProperty()) {
                ((ClassNode)this.getModel().getRoot()).addPropertyNode(property);
            }
            this.expandRow(0);
            this.setSelectionRow(0);
        }

        MetaPropertyDescriptor getSelectedProperty() {
            ClassNode node = (ClassNode)ClassPropertiesPage.this.treProperties.getLastSelectedPathComponent();
            if (node.getNodeType() == 1) {
                return node.getMetaProperty();
            }
            return null;
        }

        class PropertySelectionListener
        implements TreeSelectionListener {
            PropertySelectionListener() {
            }

            public void valueChanged(TreeSelectionEvent e) {
                ClassNode node = (ClassNode)e.getPath().getLastPathComponent();
                if (node.nodeType == 0) {
                    ClassPropertiesPage.this.tblPropertyAttributes.displayNoAttributes();
                } else {
                    MetaPropertyDescriptor property = node.getMetaProperty();
                    ClassPropertiesPage.this.tblPropertyAttributes.displayPropertyAttributes(property);
                }
            }
        }

        class ClassNode
        extends DefaultMutableTreeNode {
            static final int TEXT_NODE = 0;
            static final int PROPERTY_NODE = 1;
            private final int nodeType;
            private final MetaPropertyDescriptor metaProperty;

            public ClassNode(MetaPropertyDescriptor metaProperty) {
                super(metaProperty.getName());
                this.metaProperty = metaProperty;
                this.nodeType = 1;
            }

            public ClassNode(String userObject) {
                super(userObject);
                this.nodeType = 0;
                this.metaProperty = null;
            }

            public MetaPropertyDescriptor getMetaProperty() {
                return this.metaProperty;
            }

            public int getNodeType() {
                return this.nodeType;
            }

            void addPropertyNode(MetaPropertyDescriptor property) {
                ClassNode propertyNode = new ClassNode(property);
                for (MetaPropertyDescriptor subProperty = property.theFirstSubproperty; subProperty != null; subProperty = subProperty.getNextProperty()) {
                    ClassNode subNode = new ClassNode(subProperty);
                    propertyNode.add(subNode);
                }
                this.add(propertyNode);
            }
        }
    }

    class EditPropertyAction
    extends AbstractAction {
        private final PropertiesTree treProperties;

        public EditPropertyAction(PropertiesTree treProperties) {
            this.treProperties = treProperties;
        }

        public void actionPerformed(ActionEvent e) {
            MetaPropertyDescriptor property = this.treProperties.getSelectedProperty();
            if (property == null) {
                JOptionPane.showMessageDialog((Component)((Object)ClassPropertiesPage.this.theDialog), "You must select a property before you can edit it.", "No Property Selected", 0);
                return;
            }
            final ManageClassPropertyDialog dialog = new ManageClassPropertyDialog(ClassPropertiesPage.this.theDialog, this.treProperties.getSelectedProperty());
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.show(new Runnable(){

                public void run() {
                    if (dialog.isDialogModified()) {
                        ClassPropertiesPage.this.populateInterface();
                        ((ClassPropertiesPage)ClassPropertiesPage.this).theDialog.theEditor.setMetadataModified(true);
                    }
                }
            });
        }
    }

    class AddPropertyAction
    extends AbstractAction {
        private final PropertiesTree treProperties;

        public AddPropertyAction(PropertiesTree treProperties) {
            this.treProperties = treProperties;
        }

        public void actionPerformed(ActionEvent e) {
            final MetaPropertyDescriptor parentProperty = this.treProperties.getSelectedProperty();
            final MetaPropertyDescriptor property = new MetaPropertyDescriptor(null, null, null, null, null, null, null, null, null, null, 0, ((ClassPropertiesPage)ClassPropertiesPage.this).theDialog.theEditor.theMetadataDispenser, ClassPropertiesPage.this.theMetadata);
            property.bGenerate = false;
            final ManageClassPropertyDialog dialog = new ManageClassPropertyDialog(ClassPropertiesPage.this.theDialog, property, parentProperty);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.show(new Runnable(){

                public void run() {
                    if (dialog.isDialogModified()) {
                        ((ClassPropertiesPage)ClassPropertiesPage.this).theDialog.theEditor.setMetadataModified(true);
                        if (parentProperty != null) {
                            parentProperty.addSubproperty(property);
                        } else {
                            ClassPropertiesPage.this.theMetadata.addProperties(property);
                        }
                        ClassPropertiesPage.this.populateInterface();
                    }
                }
            });
        }
    }

    class DeletePropertyAction
    extends AbstractAction {
        private final PropertiesTree treProperties;

        public DeletePropertyAction(PropertiesTree treProperties) {
            this.treProperties = treProperties;
        }

        public void actionPerformed(ActionEvent e) {
            MetaPropertyDescriptor property = this.treProperties.getSelectedProperty();
            if (property != null) {
                String sPropertyName = property.getName();
                if (property.theSuperProperty != null) {
                    property.theSuperProperty.removeSubProperty(sPropertyName);
                } else {
                    ClassPropertiesPage.this.theMetadata.removeProperty(sPropertyName);
                }
                ClassPropertiesPage.this.populateInterface();
            }
        }
    }
}

