/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDEProjectTool;
import ch.abacus.lib.ui.renderer.common.HammerNLSAccess;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class ProjectNLSTableModel
extends AbstractTableModel {
    private ArrayList theNLSDocs = new ArrayList(0);
    private ArrayList theNLSKeys = new ArrayList(0);
    private IDEProjectTool theTool;

    public ProjectNLSTableModel(IDEProjectTool theTool) {
        this.theTool = theTool;
    }

    public int getRowCount() {
        if (this.theNLSKeys != null) {
            return this.theNLSKeys.size() + 1;
        }
        return 1;
    }

    public int getColumnCount() {
        return 2;
    }

    public void setValueAt(Object theNewValue, int row, int column) {
        if (column == 0) {
            if (row < this.theNLSKeys.size()) {
                this.theNLSKeys.set(row, theNewValue);
            } else {
                this.theNLSKeys.add(theNewValue);
                this.theNLSDocs.add("");
            }
        } else if (row < this.theNLSDocs.size()) {
            this.theNLSDocs.set(row, theNewValue);
        } else {
            this.theNLSDocs.add(theNewValue);
        }
    }

    public Object getValueAt(int row, int column) {
        if (row < this.theNLSKeys.size()) {
            if (column == 0) {
                return this.theNLSKeys.get(row);
            }
            if (row < this.theNLSDocs.size()) {
                return this.theNLSDocs.get(row);
            }
        }
        return null;
    }

    public Class getColumnClass(int iColumn) {
        return String.class;
    }

    public Class getCellClass(int iRow, int iColumn) {
        return String.class;
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public String getColumnName(int iColumn) {
        if (iColumn == 0) {
            return "Key";
        }
        return "Document Location";
    }

    protected void clear() {
        this.theNLSDocs = new ArrayList(0);
        this.theNLSKeys = new ArrayList(0);
    }

    protected void load() {
        if (this.theTool.theProject.theLocalNLSDocuments != null) {
            this.theNLSDocs = new ArrayList(0);
            this.theNLSKeys = new ArrayList(0);
            int iSize = this.theTool.theProject.theLocalNLSDocuments.size();
            for (int i = 0; i < iSize; ++i) {
                HammerNLSAccess theNLSAccess = (HammerNLSAccess)this.theTool.theProject.theLocalNLSDocuments.get(i);
                this.theNLSDocs.add(theNLSAccess.sDocument);
                this.theNLSKeys.add(theNLSAccess.sKey);
            }
        }
    }

    protected void save() {
        this.theTool.theProject.theLocalNLSDocuments = new ArrayList(0);
        int iSize = this.theNLSKeys.size();
        for (int i = 0; i < iSize; ++i) {
            String sKey = (String)this.theNLSKeys.get(i);
            String sDoc = (String)this.theNLSDocs.get(i);
            if (sKey == null || sDoc == null || sKey.trim().length() <= 0 || sDoc.trim().length() <= 0) continue;
            HammerNLSAccess theNewAccess = new HammerNLSAccess(sKey.trim(), sDoc.trim());
            this.theTool.theProject.theLocalNLSDocuments.add(theNewAccess);
        }
        this.theTool.theProject.getNLS().Load();
    }

    public void deleteSelectedRow(int iRow) {
        if (iRow < this.theNLSKeys.size()) {
            this.theNLSDocs.remove(iRow);
            this.theNLSKeys.remove(iRow);
        }
        this.theTool.theNLSTable.setVisible(false);
        this.theTool.theNLSDeleteRowButton.setVisible(false);
        this.theTool.theNLSTable.setVisible(true);
        this.theTool.theNLSDeleteRowButton.setVisible(true);
    }
}

