/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.MetaCloneMode;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;

public class IDEUndoRedoEvent {
    static final int UNDEFINED = 0;
    static final int CLEAR = 1;
    static final int IMPORT_OBJECT = 2;
    static final int DELETE_OBJECTS = 3;
    static final int CUT = 4;
    static final int PASTE = 5;
    static final int CHANGE_LOCATIONS = 6;
    static final int CHANGE_SIZE = 7;
    static final int CHANGE_PROPERTY = 8;
    static final int CHANGE_ALL_PROPERTY = 9;
    static final int CHANGE_DATA_LINKAGE = 10;
    int event = 0;
    HashMap theValues = new HashMap(0);

    public IDEUndoRedoEvent(int event) {
        this.event = event;
    }

    public static IDEUndoRedoEvent createClearEvent() {
        IDEUndoRedoEvent theEvent = new IDEUndoRedoEvent(1);
        theEvent.theValues = null;
        return theEvent;
    }

    public static IDEUndoRedoEvent createImportObjectEvent(MetaObject theMetaObject, MetaObject theParentObject) {
        IDEUndoRedoEvent theEvent = new IDEUndoRedoEvent(2);
        theEvent.theValues.put("Object", theMetaObject);
        theEvent.theValues.put("Parent", theParentObject);
        return theEvent;
    }

    public static IDEUndoRedoEvent createDeleteObjectsEvent(ArrayList theParentObjects, ArrayList theMetaObjects) {
        IDEUndoRedoEvent theEvent = new IDEUndoRedoEvent(3);
        theEvent.theValues.put("Objects", theMetaObjects);
        theEvent.theValues.put("Parents", theParentObjects);
        return theEvent;
    }

    public static IDEUndoRedoEvent createCutEvent(ArrayList theParentObjects, ArrayList theMetaObjects) {
        IDEUndoRedoEvent theEvent = new IDEUndoRedoEvent(4);
        theEvent.theValues.put("Objects", theMetaObjects);
        theEvent.theValues.put("Parents", theParentObjects);
        return theEvent;
    }

    public static IDEUndoRedoEvent createPasteEvent(MetaObject theTarget, ArrayList theMetaObjects) {
        IDEUndoRedoEvent theEvent = new IDEUndoRedoEvent(5);
        theEvent.theValues.put("Target", theTarget);
        theEvent.theValues.put("Objects", theMetaObjects);
        return theEvent;
    }

    public static IDEUndoRedoEvent createChangeLocationEvent(ArrayList theMetaObjects) {
        IDEUndoRedoEvent theEvent = new IDEUndoRedoEvent(6);
        theEvent.theValues.put("Objects", theMetaObjects);
        ArrayList<Point> theOldLocations = new ArrayList<Point>(0);
        for (int i = 0; i < theMetaObjects.size(); ++i) {
            Point ptOrigin = ((MetaObject)theMetaObjects.get(i)).getLocation();
            theOldLocations.add(ptOrigin);
        }
        theEvent.theValues.put("Locations", theOldLocations);
        return theEvent;
    }

    public static IDEUndoRedoEvent createChangeSizeEvent(MetaObject theMetaObject) {
        IDEUndoRedoEvent theEvent = new IDEUndoRedoEvent(7);
        theEvent.theValues.put("Object", theMetaObject);
        Dimension theSize = theMetaObject.getSize();
        theEvent.theValues.put("Size", theSize);
        return theEvent;
    }

    public static IDEUndoRedoEvent createChangePropertyEvent(MetaObject theMetaObject, String sPropertyName, int iItemIndex, int iOrderIndex) {
        IDEUndoRedoEvent theEvent = new IDEUndoRedoEvent(8);
        theEvent.theValues.put("Object", theMetaObject);
        theEvent.theValues.put("PropertyName", sPropertyName);
        theEvent.theValues.put("PropertyIndex", new Integer(iItemIndex));
        theEvent.theValues.put("OrderIndex", new Integer(iOrderIndex));
        MetaPropertyValueEx pv = theMetaObject.getPropertyValue(sPropertyName, iItemIndex);
        if (pv == null) {
            theMetaObject.setPropertyValue(sPropertyName, iItemIndex, iOrderIndex, (Object)new String(""), true);
            pv = theMetaObject.getPropertyValue(sPropertyName, iItemIndex);
        }
        pv = pv.Clone();
        theEvent.theValues.put("PropertyValue", pv);
        return theEvent;
    }

    public static IDEUndoRedoEvent createChangeAllPropertyEvent(MetaObject theMetaObject, String sPropertyName) {
        IDEUndoRedoEvent theEvent = new IDEUndoRedoEvent(9);
        theEvent.theValues.put("Object", theMetaObject);
        theEvent.theValues.put("PropertyName", sPropertyName);
        MetaProperty prop = theMetaObject.getPropertyMetadata(sPropertyName);
        ArrayList<MetaPropertyValueEx> thePropertyValues = new ArrayList<MetaPropertyValueEx>(0);
        if (prop != null) {
            int iValueCount = prop.getValueCount();
            for (int i = 0; i < iValueCount; ++i) {
                thePropertyValues.add(theMetaObject.getPropertyValue(sPropertyName, i).Clone());
            }
        }
        theEvent.theValues.put("PropertyValues", thePropertyValues);
        return theEvent;
    }

    public static IDEUndoRedoEvent createDataLinkageEvent(MetaObject theMetaObject) {
        IDEUndoRedoEvent theEvent = new IDEUndoRedoEvent(10);
        theEvent.theValues.put("Object", theMetaObject);
        MetaProperty prop = theMetaObject.getPropertyMetadata("FieldNames");
        int iValueCount = prop.getValueCount();
        ArrayList<MetaPropertyValueEx> theFields = new ArrayList<MetaPropertyValueEx>(0);
        for (int i = 0; i < iValueCount; ++i) {
            MetaPropertyValueEx pvTableName = theMetaObject.getPropertyValue("FieldNames", i);
            theFields.add(pvTableName.Clone());
        }
        theEvent.theValues.put("FieldNames", theFields);
        MetaPropertyValueEx pvTableName = theMetaObject.getPropertyValue("TableName", 0);
        theEvent.theValues.put("TableName", pvTableName.Clone());
        return theEvent;
    }

    void undo() {
        switch (this.event) {
            case 1: {
                this.undoClear();
                break;
            }
            case 2: {
                this.undoImportObject();
                break;
            }
            case 3: {
                this.undoDeleteObjects();
                break;
            }
            case 4: {
                this.undoCut();
                break;
            }
            case 5: {
                this.undoPaste();
                break;
            }
            case 6: {
                this.undoChangeLocations();
                break;
            }
            case 7: {
                this.undoChangeSize();
                break;
            }
            case 8: {
                this.undoChangeProperty();
                break;
            }
            case 9: {
                this.undoChangeAllProperty();
                break;
            }
            case 10: {
                this.undoChangeDataLinkage();
            }
        }
    }

    void redo() {
        switch (this.event) {
            case 1: {
                this.redoClear();
                break;
            }
            case 2: {
                this.redoImportObject();
                break;
            }
            case 3: {
                this.redoDeleteObjects();
                break;
            }
            case 4: {
                this.redoCut();
                break;
            }
            case 5: {
                this.redoPaste();
                break;
            }
            case 6: {
                this.redoChangeLocations();
                break;
            }
            case 7: {
                this.redoChangeSize();
                break;
            }
            case 8: {
                this.redoChangeProperty();
                break;
            }
            case 9: {
                this.redoChangeAllProperty();
                break;
            }
            case 10: {
                this.redoChangeDataLinkage();
            }
        }
    }

    private void undoClear() {
    }

    private void redoClear() {
    }

    private void undoImportObject() {
        MetaObject theMetaObject = (MetaObject)this.theValues.get("Object");
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)theMetaObject.theDesignProject.getMetaDataUser();
        theMetaObject.DeleteObject(theMetaObject.theDesignProject, (AbaMetaDataUser)theDesignCockpit);
    }

    private void redoImportObject() {
        MetaObject theMetaObject = (MetaObject)this.theValues.get("Object");
        MetaObject theParentObject = (MetaObject)this.theValues.get("Parent");
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)theMetaObject.theDesignProject.getMetaDataUser();
        theDesignCockpit.PasteObject(theParentObject, theMetaObject, theMetaObject.theDesignProject, false);
    }

    private void undoDeleteObjects() {
        ArrayList theMetaObjects = (ArrayList)this.theValues.get("Objects");
        ArrayList theParentObjects = (ArrayList)this.theValues.get("Parents");
        for (int i = 0; i < theMetaObjects.size(); ++i) {
            MetaObject theMetaObject = (MetaObject)theMetaObjects.get(i);
            MetaObject theParentObject = (MetaObject)theParentObjects.get(i);
            SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)theMetaObject.theDesignProject.getMetaDataUser();
            theDesignCockpit.PasteObject(theParentObject, theMetaObject, theMetaObject.theDesignProject, true);
        }
    }

    private void redoDeleteObjects() {
        ArrayList theMetaObjects = (ArrayList)this.theValues.get("Objects");
        for (int i = 0; i < theMetaObjects.size(); ++i) {
            MetaObject theMetaObject = (MetaObject)theMetaObjects.get(i);
            SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)theMetaObject.theDesignProject.getMetaDataUser();
            theMetaObject.DeleteObject(theMetaObject.theDesignProject, (AbaMetaDataUser)theDesignCockpit);
        }
    }

    private void undoCut() {
        ArrayList theMetaObjects = (ArrayList)this.theValues.get("Objects");
        ArrayList theParentObjects = (ArrayList)this.theValues.get("Parents");
        for (int i = 0; i < theMetaObjects.size(); ++i) {
            MetaObject theMetaObject = (MetaObject)theMetaObjects.get(i);
            MetaObject theParentObject = (MetaObject)theParentObjects.get(i);
            SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)theMetaObject.theDesignProject.getMetaDataUser();
            MetaObject theNewObject = theDesignCockpit.PasteObject(theParentObject, theMetaObject, theMetaObject.theDesignProject, true);
            theMetaObjects.set(i, theNewObject);
        }
    }

    private void redoCut() {
        ArrayList theMetaObjects = (ArrayList)this.theValues.get("Objects");
        for (int i = 0; i < theMetaObjects.size(); ++i) {
            MetaObject theMetaObject = (MetaObject)theMetaObjects.get(i);
            SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)theMetaObject.theDesignProject.getMetaDataUser();
            theMetaObjects.set(i, theMetaObject.Clone(new MetaCloneMode(0), null, true));
            theMetaObject.DeleteObject(theMetaObject.theDesignProject, (AbaMetaDataUser)theDesignCockpit);
        }
    }

    private void undoPaste() {
        ArrayList theMetaObjects = (ArrayList)this.theValues.get("Objects");
        for (int i = 0; i < theMetaObjects.size(); ++i) {
            MetaObject theMetaObject = (MetaObject)theMetaObjects.get(i);
            SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)theMetaObject.theDesignProject.getMetaDataUser();
            theMetaObjects.set(i, theMetaObject.Clone(new MetaCloneMode(0), null, true));
            theMetaObject.DeleteObject(theMetaObject.theDesignProject, (AbaMetaDataUser)theDesignCockpit);
        }
    }

    private void redoPaste() {
        ArrayList theMetaObjects = (ArrayList)this.theValues.get("Objects");
        MetaObject theTarget = (MetaObject)this.theValues.get("Target");
        for (int i = 0; i < theMetaObjects.size(); ++i) {
            MetaObject theMetaObject = (MetaObject)theMetaObjects.get(i);
            SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)theMetaObject.theDesignProject.getMetaDataUser();
            MetaObject theNewObject = theDesignCockpit.PasteObject(theTarget, theMetaObject, theMetaObject.theDesignProject, true);
            theMetaObjects.set(i, theNewObject);
        }
    }

    private void undoChangeLocations() {
        ArrayList theMetaObjects = (ArrayList)this.theValues.get("Objects");
        ArrayList thePoints = (ArrayList)this.theValues.get("Locations");
        ArrayList<Point> theOldPoints = new ArrayList<Point>(0);
        for (int i = 0; i < theMetaObjects.size(); ++i) {
            MetaObject theMetaObject = (MetaObject)theMetaObjects.get(i);
            Point theLocation = (Point)thePoints.get(i);
            Point theOldLocation = theMetaObject.getLocation();
            theOldPoints.add(theOldLocation);
            theMetaObject.setLocation((int)theLocation.getX(), (int)theLocation.getY());
        }
        this.theValues.put("OldLocations", theOldPoints);
    }

    private void redoChangeLocations() {
        ArrayList theMetaObjects = (ArrayList)this.theValues.get("Objects");
        ArrayList thePoints = (ArrayList)this.theValues.get("OldLocations");
        for (int i = 0; i < theMetaObjects.size(); ++i) {
            MetaObject theMetaObject = (MetaObject)theMetaObjects.get(i);
            Point theOldLocation = (Point)thePoints.get(i);
            theMetaObject.setLocation((int)theOldLocation.getX(), (int)theOldLocation.getY());
        }
    }

    private void undoChangeSize() {
        MetaObject theMetaObject = (MetaObject)this.theValues.get("Object");
        Dimension theSize = (Dimension)this.theValues.get("Size");
        Dimension theOldSize = theMetaObject.getSize();
        this.theValues.put("OldSize", theOldSize);
        theMetaObject.setSize((int)theSize.getWidth(), (int)theSize.getHeight());
    }

    private void redoChangeSize() {
        MetaObject theMetaObject = (MetaObject)this.theValues.get("Object");
        Dimension theOldSize = (Dimension)this.theValues.get("OldSize");
        theMetaObject.setSize(theOldSize.width, theOldSize.height);
    }

    private void undoChangeProperty() {
        MetaObject theMetaObject = (MetaObject)this.theValues.get("Object");
        String thePropertyName = (String)this.theValues.get("PropertyName");
        MetaPropertyValueEx thePropertyValue = (MetaPropertyValueEx)this.theValues.get("PropertyValue");
        int iPropertyIndex = (Integer)this.theValues.get("PropertyIndex");
        int iOrderIndex = (Integer)this.theValues.get("OrderIndex");
        MetaPropertyValueEx theOldPropertyValue = theMetaObject.getPropertyValue(thePropertyName, iPropertyIndex).Clone();
        this.theValues.put("OldPropertyValue", theOldPropertyValue);
        theMetaObject.setPropertyValue(thePropertyName, iPropertyIndex, iOrderIndex, thePropertyValue.Clone());
    }

    private void redoChangeProperty() {
        MetaObject theMetaObject = (MetaObject)this.theValues.get("Object");
        String thePropertyName = (String)this.theValues.get("PropertyName");
        MetaPropertyValueEx theOldPropertyValue = (MetaPropertyValueEx)this.theValues.get("OldPropertyValue");
        int iPropertyIndex = (Integer)this.theValues.get("PropertyIndex");
        int iOrderIndex = (Integer)this.theValues.get("OrderIndex");
        theMetaObject.setPropertyValue(thePropertyName, iPropertyIndex, iOrderIndex, theOldPropertyValue.Clone());
    }

    private void undoChangeAllProperty() {
        MetaObject theMetaObject = (MetaObject)this.theValues.get("Object");
        String thePropertyName = (String)this.theValues.get("PropertyName");
        ArrayList propertyValues = (ArrayList)this.theValues.get("PropertyValues");
        ArrayList<MetaPropertyValueEx> oldPropertyValues = new ArrayList<MetaPropertyValueEx>(0);
        int iCount = propertyValues.size();
        for (int i = 0; i < iCount; ++i) {
            MetaPropertyValueEx theOldPropertyValue = theMetaObject.getPropertyValue(thePropertyName, i).Clone();
            oldPropertyValues.add(theOldPropertyValue);
            theMetaObject.setPropertyValue(thePropertyName, i, 0, (MetaPropertyValueEx)propertyValues.get(i));
        }
        this.theValues.put("OldPropertyValues", oldPropertyValues);
    }

    private void redoChangeAllProperty() {
        MetaObject theMetaObject = (MetaObject)this.theValues.get("Object");
        String thePropertyName = (String)this.theValues.get("PropertyName");
        ArrayList propertyValues = (ArrayList)this.theValues.get("OldPropertyValues");
        int iCount = propertyValues.size();
        for (int i = 0; i < iCount; ++i) {
            theMetaObject.setPropertyValue(thePropertyName, i, 0, (MetaPropertyValueEx)propertyValues.get(i));
        }
    }

    private void undoChangeDataLinkage() {
        MetaObject theMetaObject = (MetaObject)this.theValues.get("Object");
        String theTableName = (String)this.theValues.get("TableName");
        ArrayList fieldNames = (ArrayList)this.theValues.get("FieldNames");
        ArrayList<String> oldFieldNames = new ArrayList<String>(0);
        int iCount = fieldNames.size();
        String theOldTableName = theMetaObject.getPropertyValue("TableName", 0).getStringValue();
        for (int i = 0; i < iCount; ++i) {
            String theOldField = theMetaObject.getPropertyValue("FieldNames", i).getStringValue();
            oldFieldNames.add(new String(theOldField));
            theMetaObject.setPropertyValue("FieldNames", i, 0, fieldNames.get(i), false);
        }
        this.theValues.put("OldFieldNames", oldFieldNames);
        this.theValues.put("OldTableName", theOldTableName);
        theMetaObject.setPropertyValue("TableName", 0, 0, (Object)theTableName, false);
    }

    private void redoChangeDataLinkage() {
        MetaObject theMetaObject = (MetaObject)this.theValues.get("Object");
        String theTableName = (String)this.theValues.get("OldTableName");
        ArrayList fieldNames = (ArrayList)this.theValues.get("OldFieldNames");
        int iCount = fieldNames.size();
        for (int i = 0; i < iCount; ++i) {
            theMetaObject.setPropertyValue("FieldNames", i, 0, fieldNames.get(i), false);
        }
        theMetaObject.setPropertyValue("TableName", 0, 0, (Object)theTableName, false);
    }

    public String getDescription() {
        switch (this.event) {
            case 1: {
                return "Clear";
            }
            case 2: {
                return "New Object";
            }
            case 3: {
                return "Delete";
            }
            case 4: {
                return "Cut";
            }
            case 5: {
                return "Paste";
            }
            case 6: {
                return "Drag Object";
            }
            case 7: {
                return "Resize Object";
            }
            case 8: {
                return "Change Property";
            }
            case 9: {
                return "Change Array Based Property";
            }
            case 10: {
                return "Change Data Linkage";
            }
        }
        return null;
    }
}

