/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDEActionManager;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JAComboBox;
import ch.abacus.lib.ui.JAToolBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class IDEToolBar
extends JAToolBar {
    private final SuperDesignCockpit theCockpit;
    private final IDEActionManager theActionManager;
    private JButton newButton;
    private JButton openButton;
    private JButton saveButton;
    private JButton saveWithCompileButton;
    private JButton saveAllButton;
    private JButton cutButton;
    private JButton copyButton;
    private JButton pasteButton;
    private JButton fontButton;
    private JButton fgColorButton;
    private JButton bgColorButton;
    private JButton dbSelectButton;
    private JButton compileButton;
    private JButton runButton;
    private JButton projectEditButton;
    private JButton importerButton;
    private JButton pointModeButton;
    private JAComboBox languageComboBox;

    public IDEToolBar(SuperDesignCockpit theCockpit, IDEActionManager theActionManager) {
        this.theCockpit = theCockpit;
        this.theActionManager = theActionManager;
        this.setFocusable(false);
        this.setRollover(true);
        this.setBorder(null);
        this.setFloatable(false);
        Color colToolbar = UIManager.getColor("ToolBar.background");
        if (colToolbar == null) {
            colToolbar = this.getBackground();
        }
        this.setBackground(colToolbar);
        this.initInterface(colToolbar);
    }

    void initInterface(Color color) {
        if (this.theActionManager.getNewAction() != null) {
            this.newButton = this.add(this.theActionManager.getNewAction());
            this.newButton.setBackground(color);
        }
        if (this.theActionManager.getOpenAction() != null) {
            this.openButton = this.add(this.theActionManager.getOpenAction());
            this.openButton.setBackground(color);
        }
        if (this.theActionManager.getSaveAction() != null) {
            this.saveButton = this.add(this.theActionManager.getSaveAction());
            this.saveButton.setBackground(color);
        }
        if (this.theActionManager.getSaveWithCompileAction() != null) {
            this.saveWithCompileButton = this.add(this.theActionManager.getSaveWithCompileAction());
            this.saveWithCompileButton.setBackground(color);
        }
        if (this.theActionManager.getSaveAllAction() != null) {
            this.saveAllButton = this.add(this.theActionManager.getSaveAllAction());
            this.saveAllButton.setBackground(color);
        }
        this.addSeparator();
        if (this.theActionManager.getCutAction() != null) {
            this.cutButton = this.add(this.theActionManager.getCutAction());
            this.cutButton.setBackground(color);
        }
        if (this.theActionManager.getCopyAction() != null) {
            this.copyButton = this.add(this.theActionManager.getCopyAction());
            this.copyButton.setBackground(color);
        }
        if (this.theActionManager.getPasteAction() != null) {
            this.pasteButton = this.add(this.theActionManager.getPasteAction());
            this.pasteButton.setBackground(color);
        }
        this.addSeparator();
        if (this.theActionManager.getFontChooserAction() != null) {
            this.fontButton = this.add(this.theActionManager.getFontChooserAction());
            this.fontButton.setBackground(color);
        }
        if (this.theActionManager.getForegroundColorChooserAction() != null) {
            this.fgColorButton = this.add(this.theActionManager.getForegroundColorChooserAction());
            this.fgColorButton.setBackground(color);
        }
        if (this.theActionManager.getBackgroundColorChooserAction() != null) {
            this.bgColorButton = this.add(this.theActionManager.getBackgroundColorChooserAction());
            this.bgColorButton.setBackground(color);
        }
        if (this.theActionManager.getDatabaseSelectionAction() != null) {
            this.dbSelectButton = this.add(this.theActionManager.getDatabaseSelectionAction());
            this.dbSelectButton.setBackground(color);
        }
        this.addSeparator();
        if (this.theActionManager.getCompileAction() != null) {
            this.compileButton = this.add(this.theActionManager.getCompileAction());
            this.compileButton.setBackground(color);
        }
        if (this.theActionManager.getRunAction() != null) {
            this.runButton = this.add(this.theActionManager.getRunAction());
            this.runButton.setBackground(color);
        }
        this.addSeparator();
        if (this.theActionManager.getProjectPreferencesAction() != null) {
            this.projectEditButton = this.add(this.theActionManager.getProjectPreferencesAction());
            this.projectEditButton.setBackground(color);
        }
        if (this.theActionManager.getImporterAction() != null) {
            this.importerButton = this.add(this.theActionManager.getImporterAction());
            this.importerButton.setBackground(color);
        }
        if (this.theActionManager.getPointModeAction() != null) {
            this.pointModeButton = this.add(this.theActionManager.getPointModeAction());
            this.pointModeButton.setBackground(color);
        }
        this.addSeparator();
        this.languageComboBox = this.createLanguageComboBox();
        this.add((Component)this.languageComboBox);
    }

    public void addSeparator() {
        if (!(this.getComponentAtIndex(this.getComponentCount() - 1) instanceof JSeparator)) {
            super.addSeparator();
        }
    }

    private JAComboBox createLanguageComboBox() {
        String sGerman = this.theActionManager.getLanguageDeutschAction().getLabel();
        String sFrench = this.theActionManager.getLanguageFrancaisAction().getLabel();
        String sItalian = this.theActionManager.getLanguageItalianAction().getLabel();
        String sEnglish = this.theActionManager.getLanguageEnglishAction().getLabel();
        JAComboBox combo = new JAComboBox(new Object[]{sGerman, sFrench, sItalian, sEnglish});
        combo.setToolTipText(this.theCockpit.theLanguageManager.getMessage("LanguageComboBox.tooltip", "Set Language"));
        combo.setMaximumSize(combo.getPreferredSize());
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int iSelectedItem = IDEToolBar.this.languageComboBox.getSelectedIndex();
                switch (iSelectedItem) {
                    case 0: {
                        ((IDEToolBar)IDEToolBar.this).theCockpit.theActionManager.getLanguageDeutschAction().actionPerformed(new ActionEvent(this, 0, null));
                        break;
                    }
                    case 1: {
                        ((IDEToolBar)IDEToolBar.this).theCockpit.theActionManager.getLanguageFrancaisAction().actionPerformed(new ActionEvent(this, 0, null));
                        break;
                    }
                    case 2: {
                        ((IDEToolBar)IDEToolBar.this).theCockpit.theActionManager.getLanguageItalianAction().actionPerformed(new ActionEvent(this, 0, null));
                        break;
                    }
                    case 3: {
                        ((IDEToolBar)IDEToolBar.this).theCockpit.theActionManager.getLanguageEnglishAction().actionPerformed(new ActionEvent(this, 0, null));
                    }
                }
            }
        });
        return combo;
    }

    void setPointModeButtonEnabledState(boolean bEnabled) {
        this.pointModeButton.setEnabled(bEnabled);
    }

    void setLangauge(int iLanguage) {
        this.languageComboBox.setSelectedIndex(iLanguage);
    }
}

