/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDEMethodListModel;
import ch.abacus.designcockpit.ide.IDEMethodListSelectionListener;
import ch.abacus.designcockpit.ide.IDESourceEditor;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaMethodLinkage;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import javax.swing.JList;

public class IDEMethodList
extends JList {
    IDEMethodListModel theModel = null;
    String sPrevMethodNameSelected = null;
    public IDESourceEditor theSourceEditor = null;
    public SuperDesignCockpit theDesignCockpit = null;
    public MetaObject theLastObjectLoaded = null;

    public IDEMethodList(IDEMethodListModel theListModel, SuperDesignCockpit objDesignCockpit) {
        super(theListModel);
        this.theDesignCockpit = objDesignCockpit;
        this.theModel = theListModel;
        this.setSelectionMode(0);
        this.addListSelectionListener(new IDEMethodListSelectionListener(this));
    }

    public void Load(MetaClass someClass) {
        MetaObject theSelectedObject = this.theDesignCockpit.getDesignProject().getSelectedObject();
        if (this.theSourceEditor.getText().trim().length() != 0) {
            this.save();
        }
        this.theLastObjectLoaded = theSelectedObject;
        this.theModel.Load(theSelectedObject);
        this.setSelectedIndex(0);
        this.showCurrentMethod();
        this.updateUI();
    }

    public void resetContents() {
        this.theModel.theMetaObject = null;
        this.updateUI();
    }

    public void showMethodByName(String sMethodNameSelected) {
        MetaObject theSelectedObject = this.theDesignCockpit.getDesignProject().getSelectedObject();
        if (sMethodNameSelected == null || theSelectedObject == null) {
            return;
        }
        MetaMethodLinkage theMethod = theSelectedObject.theFirstMethod;
        theMethod = theSelectedObject.theFirstMethod;
        while (theMethod != null) {
            if (theMethod.theMethod.getMethodName().equals(sMethodNameSelected)) {
                this.theDesignCockpit.theSourceViewer.showCodeEditor();
                this.theSourceEditor.setCode(theMethod.theMethod.getCode());
                break;
            }
            theMethod = theMethod.theNextMethod;
        }
    }

    public void showCurrentMethod() {
        String sMethodNameSelected = (String)this.getSelectedValue();
        this.showMethodByName(sMethodNameSelected);
    }

    public boolean selectMethod(String sMethodName) {
        int iSelection = this.theModel.getValueIndex(sMethodName);
        if (iSelection != -1) {
            this.setSelectedIndex(iSelection);
            return true;
        }
        return false;
    }

    public void save(String sMethodNameSelected) {
        MetaObject theSelectedObject = this.theLastObjectLoaded;
        if (sMethodNameSelected == null || theSelectedObject == null) {
            return;
        }
        MetaMethodLinkage theMethod = theSelectedObject.theFirstMethod;
        String sOldCode = this.theSourceEditor.getText();
        while (theMethod != null) {
            if (theMethod.theMethod.getMethodName().equals(sMethodNameSelected)) {
                if (this.theLastObjectLoaded == this.theDesignCockpit.getSelectedObject()) break;
                theMethod.theMethod.setCode(sOldCode);
                break;
            }
            theMethod = theMethod.theNextMethod;
        }
        if (theMethod == null && sOldCode != null && !sOldCode.trim().equals("")) {
            theSelectedObject.setMethodCode(this.sPrevMethodNameSelected, sOldCode);
        }
    }

    public void save() {
        String sMethodNameSelected = (String)this.getSelectedValue();
        this.save(sMethodNameSelected);
    }

    public void save(String sMethodNameSelected, String theCode) {
        MetaObject theSelectedObject = this.theLastObjectLoaded;
        if (sMethodNameSelected == null || theSelectedObject == null) {
            return;
        }
        MetaMethodLinkage theMethod = theSelectedObject.theFirstMethod;
        while (theMethod != null && !theMethod.theMethod.getMethodName().equals(sMethodNameSelected)) {
            theMethod = theMethod.theNextMethod;
        }
        theMethod.theMethod.setCode(theCode);
    }
}

