/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.classEditor.Lizard;
import ch.abacus.designcockpit.ide.ComponentTransferable;
import ch.abacus.designcockpit.ide.IDEComponentPaletteMouseListener;
import ch.abacus.designcockpit.ide.IDEComponentPaletteMouseMotionListener;
import ch.abacus.designcockpit.ide.IDEComponentPaletteSelectionListener;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JATree;
import ch.abacus.lib.ui.customizer.CustomizerDataConnectionInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataElementInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataTableInterface;
import ch.abacus.lib.ui.renderer.common.HammerImageIconFactory;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class IDEComponentPalette
extends JATree
implements Serializable {
    public SuperDesignCockpit theCockpit = null;
    public DefaultTreeModel theModel = null;
    private IDEComponentPaletteNode selectedNode;
    static final int NO_ERROR = 0;
    static final int INVALID_TOP_LEVEL_SELECTION = 1;
    static final int INVALID_ABALET_SELECTION = 2;
    static final int USE_TABBEDPANE_MENU_OPTION = 3;
    static final int OPERATION_FAILED = 4;
    int dragErrorCondition = 0;
    static int INVALID_SELECTION = 5;
    DragSource dragSource;

    public IDEComponentPalette() {
        this.initObject();
    }

    public IDEComponentPalette(DefaultTreeModel objModel, SuperDesignCockpit objCockpit) {
        super((TreeModel)objModel);
        this.theCockpit = objCockpit;
        this.theModel = objModel;
        this.initObject();
    }

    private void initObject() {
        this.addTreeSelectionListener(new IDEComponentPaletteSelectionListener(this));
        if (this.theCockpit.isCustomizing()) {
            this.addTreeWillExpandListener(new IDEComponentPaletteWillExpandListener(this.theCockpit, this));
        }
        final DragSourceListener dsl = new DragSourceListener(){
            IDEComponentPalette theTree;
            {
                this.theTree = IDEComponentPalette.this;
            }

            public void dragEnter(DragSourceDragEvent dsde) {
                Point loc = dsde.getLocation();
                Rectangle targetRect = this.theTree.theCockpit.theViewDisplayer.getBounds();
                SwingUtilities.convertPointFromScreen(loc, (Component)((Object)this.theTree.theCockpit.theViewDisplayer));
                if (targetRect.contains(loc)) {
                    dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
                } else {
                    dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
                }
            }

            public void dragOver(DragSourceDragEvent dsde) {
            }

            public void dropActionChanged(DragSourceDragEvent dsde) {
            }

            public void dragDropEnd(DragSourceDropEvent dsde) {
            }

            public void dragExit(DragSourceEvent dse) {
                Point loc = dse.getLocation();
                Rectangle targetRect = this.theTree.theCockpit.theViewDisplayer.getBounds();
                SwingUtilities.convertPointFromScreen(loc, (Component)((Object)this.theTree.theCockpit.theViewDisplayer));
                if (targetRect.contains(loc)) {
                    dse.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
                } else {
                    dse.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
                }
            }
        };
        final ComponentTransferable stfa = new ComponentTransferable(this);
        DragGestureListener aDragGestureListener = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dge) {
                dge.startDrag(DragSource.DefaultCopyNoDrop, stfa, dsl);
            }
        };
        this.dragSource = new DragSource();
        IDEComponentPalette iDEComponentPalette = this;
        iDEComponentPalette.dragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)this), 1, aDragGestureListener);
        this.dragSource.addDragSourceListener(dsl);
        this.addMouseMotionListener(new IDEComponentPaletteMouseMotionListener(this));
        this.addMouseListener(new IDEComponentPaletteMouseListener(this));
        if (this.theCockpit.isCustomizing()) {
            this.setCellRenderer(new IDEComponentPaletteCellRenderer());
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        } else {
            this.setCellRenderer(new IDEOpenComponentPaletteCellRenderer());
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        }
    }

    public TransferHandler getTransferHandlerOld() {
        if (this.dragErrorCondition == 0) {
            return super.getTransferHandler();
        }
        if (this.dragErrorCondition == 2) {
            JOptionPane pane = new JOptionPane("Only one abalet may be declared for each project and it must be a top level object.", 0);
            JDialog dialog = pane.createDialog(null, "Component Selection Error");
            dialog.show();
            this.setDragErrorCondition(4);
        } else if (this.dragErrorCondition == 1) {
            JOptionPane pane = new JOptionPane("Only an abalet or a frame may be a top level selection.", 0);
            JDialog dialog = pane.createDialog(null, "Component Selection Error");
            dialog.show();
            this.setDragErrorCondition(4);
        } else if (this.dragErrorCondition == 3) {
            JOptionPane pane = new JOptionPane("Right Click on Tabbed Pane to add Tab Page.", 0);
            JDialog dialog = pane.createDialog(null, "Component Selection Error");
            dialog.show();
            this.setDragErrorCondition(4);
        }
        return null;
    }

    public void setSelectionPath(TreePath path) {
        super.setSelectionPath(path);
        IDEComponentPaletteNode theSelectedNode = (IDEComponentPaletteNode)this.getLastSelectedPathComponent();
        this.clearDragErrorCondition();
        if (theSelectedNode != null && theSelectedNode.getMetaClass() != null) {
            this.theCockpit.setMouseSelectState(false);
            if (this.theCockpit.getDesignProject().getFirstObject() == null) {
                if (theSelectedNode.getMetaClass().getMetadata().containerType.getContainerType() != 5 && theSelectedNode.getMetaClass().getMetadata().containerType.getContainerType() != 3) {
                    this.setDragErrorCondition(1);
                    return;
                }
            } else {
                if (theSelectedNode.getMetaClass().getMetadata().containerType.getContainerType() == 5) {
                    this.setDragErrorCondition(2);
                    return;
                }
                if (theSelectedNode.getMetaClass().getMetadata().containerType.getContainerType() == 7) {
                    this.setDragErrorCondition(3);
                    return;
                }
            }
        }
        if (!theSelectedNode.isCustomizerDataElementGroup() && theSelectedNode.getMetaClass() != null) {
            if (theSelectedNode.getChildCount() == 0) {
                this.setSelectedNode(theSelectedNode);
            } else {
                this.setSelectedNode(null);
            }
        }
    }

    public IDEComponentPaletteNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(IDEComponentPaletteNode selectedNode) {
        this.selectedNode = selectedNode;
    }

    public void setDragErrorCondition(int iError) {
        this.dragErrorCondition = iError;
    }

    public int getDragErrorCondition() {
        return this.dragErrorCondition;
    }

    public void clearDragErrorCondition() {
        this.dragErrorCondition = 0;
    }

    public void PopupClassTool() {
        IDEComponentPaletteNode theSelectedNode = (IDEComponentPaletteNode)this.getLastSelectedPathComponent();
        if (theSelectedNode != null && theSelectedNode.getMetaClass() != null) {
            new Lizard(theSelectedNode.getMetaClass(), this.theCockpit.theCurrentDesignProject.theMetaProject.getMetadataDispenser(), this.theCockpit);
        }
    }

    public void setFolderIcons() {
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.getCellRenderer();
        renderer.setOpenIcon(this.theCockpit.folderCubeIcon);
        renderer.setLeafIcon(this.theCockpit.componentIcon);
        renderer.setOpenIcon(this.theCockpit.folderCubeIcon);
    }

    class IDEComponentPaletteWillExpandListener
    implements TreeWillExpandListener {
        private final SuperDesignCockpit theCockpit;
        private final IDEComponentPalette theComponentPalette;

        public IDEComponentPaletteWillExpandListener(SuperDesignCockpit theCockpit, IDEComponentPalette componentPalette) {
            this.theCockpit = theCockpit;
            this.theComponentPalette = componentPalette;
        }

        public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
            boolean bPopulated = false;
            TreePath path = evt.getPath();
            IDEComponentPaletteNode node = (IDEComponentPaletteNode)path.getLastPathComponent();
            if (node.isCustomizerDataTable() && node.deferredNode) {
                bPopulated = this.theCockpit.theCustomizer.populateDeferredDataElements(node.getCustomizerDataTable(), node);
                if (bPopulated) {
                    node.deferredNode = false;
                } else {
                    throw new ExpandVetoException(evt);
                }
            }
        }

        public void treeWillCollapse(TreeExpansionEvent evt) {
        }
    }

    class IDEOpenComponentPaletteCellRenderer
    extends DefaultTreeCellRenderer {
        IDEOpenComponentPaletteCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            IDEComponentPaletteNode node = (IDEComponentPaletteNode)value;
            if (node.getMetaClass() != null) {
                String sDisplayClass;
                HammerImageIconFactory theIconFactory = new HammerImageIconFactory(IDEComponentPalette.this.theCockpit.getClassLoader());
                String metadataIcon = node.getMetaClass().getMetadata().sDisplayClassIcon;
                ImageIcon componentIcon = null;
                componentIcon = theIconFactory.getHammerImageIcon(metadataIcon);
                if (componentIcon != null && metadataIcon.length() > 0) {
                    this.setIcon(componentIcon);
                }
                if ((sDisplayClass = node.getMetaClass().getMetadata().sFullClassName) != null) {
                    this.setToolTipText(sDisplayClass);
                }
            }
            return this;
        }
    }

    class IDEComponentPaletteCellRenderer
    extends DefaultTreeCellRenderer {
        IDEComponentPaletteCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            IDEComponentPaletteNode node = (IDEComponentPaletteNode)value;
            if (node.isCustomizerDataConnection()) {
                CustomizerDataConnectionInterface dataConnection = node.getCustomizerDataConnection();
                this.setIcon(dataConnection.getIcon());
                this.setToolTipText(dataConnection.getToolTip());
            } else if (node.isCustomizerDataTable()) {
                CustomizerDataTableInterface dataTable = node.getCustomizerDataTable();
                this.setIcon(dataTable.getIcon());
                this.setToolTipText(dataTable.getToolTip());
            } else if (node.isCustomizerDataElement()) {
                CustomizerDataElementInterface element = node.getCustomizerDataElement();
                this.setIcon(element.getIcon());
                this.setToolTipText(element.getToolTip());
            } else if (node.getMetaClass() != null) {
                String sDisplayClass;
                HammerImageIconFactory theIconFactory = new HammerImageIconFactory(IDEComponentPalette.this.theCockpit.getClassLoader());
                String metadataIcon = node.getMetaClass().getMetadata().sDisplayClassIcon;
                ImageIcon componentIcon = null;
                componentIcon = theIconFactory.getHammerImageIcon(metadataIcon);
                if (componentIcon != null && metadataIcon.length() > 0) {
                    this.setIcon(componentIcon);
                }
                if ((sDisplayClass = node.getMetaClass().getMetadata().sFullClassName) != null) {
                    this.setToolTipText(sDisplayClass);
                }
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

