/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDEArrayValueDescriptor;
import ch.abacus.designcockpit.ide.IDEArrayValueEditorTable;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

class IDEArrayValueEditorTableModel
extends AbstractTableModel {
    MetaObject theMetaObject;
    ArrayList theArrayValues = new ArrayList(0);
    IDEArrayValueEditorTable theTable;
    String thePropertyName;
    int[] tabPageIndex;

    IDEArrayValueEditorTableModel() {
    }

    public void setArrayIndex(int row, int value) {
        this.tabPageIndex[row] = value;
        TableModelEvent event = new TableModelEvent(this, row, row);
        this.theTable.tableChanged(event);
    }

    public int getRowCount() {
        if (this.theArrayValues == null) {
            return 0;
        }
        return this.theArrayValues.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public void setValueAt(Object theNewValue, int row, int column) {
        IDEArrayValueDescriptor theDescriptor = (IDEArrayValueDescriptor)this.theArrayValues.get(row);
        if (theDescriptor != null && column != 0) {
            theDescriptor.sValue = (String)theNewValue;
        }
    }

    public Object getValueAt(int row, int column) {
        IDEArrayValueDescriptor theDescriptor = (IDEArrayValueDescriptor)this.theArrayValues.get(row);
        if (theDescriptor != null) {
            if (column == 0) {
                return new Integer(row);
            }
            return theDescriptor.sValue;
        }
        return "";
    }

    public Class getColumnClass(int iColumn) {
        String theClassName = "";
        return theClassName.getClass();
    }

    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    public String getColumnName(int iColumn) {
        if (iColumn == 0) {
            return "Array Element";
        }
        return "Array Value";
    }

    protected void Load(IDEArrayValueEditorTable objTable, String thePropertyName) {
        this.thePropertyName = thePropertyName;
        this.theArrayValues = new ArrayList();
        if (this.theMetaObject != null) {
            int iCount = 0;
            MetaProperty theProp = this.theMetaObject.getPropertyMetadata(thePropertyName);
            if (theProp != null) {
                iCount = theProp.getValueCount();
            }
            for (int i = 0; i < iCount; ++i) {
                MetaPropertyValueEx pvValue = this.theMetaObject.getPropertyValue(thePropertyName, i);
                String theValue = "";
                if (pvValue != null) {
                    theValue = new String(pvValue.getStringValue());
                }
                IDEArrayValueDescriptor theDescriptor = new IDEArrayValueDescriptor(theValue);
                this.theArrayValues.add(theDescriptor);
            }
        }
    }

    protected void clear() {
        this.theArrayValues = new ArrayList();
    }
}

