/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;
import org.comedia.text.CNumericDocument;
import org.comedia.ui.CDataTable;
import org.comedia.ui.CEncodedIcon;

public class CTableNavigator
extends JPanel
implements ListSelectionListener,
TableModelListener,
ActionListener,
FocusListener {
    JLabel captionLabel = new JLabel();
    JButton firstButton = new JButton();
    JButton priorButton = new JButton();
    JTextField recordText = new JTextField();
    JButton nextButton = new JButton();
    JButton lastButton = new JButton();
    JButton lastNewButton = new JButton();
    JLabel recordLabel = new JLabel();
    FlowLayout flowLayout1 = new FlowLayout();
    Border border1;
    JPanel splitPanel1 = new JPanel();
    JPanel splitPanel2 = new JPanel();
    JTable table = null;
    private int lastSelection = 0;
    private CNumericDocument document = new CNumericDocument();

    public CTableNavigator() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CTableNavigator(JTable jTable) {
        this();
        this.setTable(jTable);
    }

    private void jbInit() throws Exception {
        this.captionLabel.setText("  Record:  ");
        this.priorButton.setPreferredSize(new Dimension(21, 17));
        this.priorButton.setActionCommand("Prior");
        this.firstButton.setPreferredSize(new Dimension(21, 17));
        this.firstButton.setActionCommand("First");
        this.recordText.setPreferredSize(new Dimension(80, 19));
        this.nextButton.setPreferredSize(new Dimension(21, 17));
        this.nextButton.setActionCommand("Next");
        this.lastButton.setPreferredSize(new Dimension(21, 17));
        this.lastButton.setActionCommand("Last");
        this.lastNewButton.setPreferredSize(new Dimension(21, 17));
        this.lastNewButton.setActionCommand("LastNew");
        this.recordLabel.setText("  of 0");
        this.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(0);
        this.splitPanel1.setPreferredSize(new Dimension(5, 10));
        this.splitPanel2.setPreferredSize(new Dimension(5, 10));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 19));
        this.setMinimumSize(new Dimension(270, 19));
        this.setPreferredSize(new Dimension(270, 19));
        this.add((Component)this.captionLabel, null);
        this.add((Component)this.firstButton, null);
        this.add((Component)this.priorButton, null);
        this.add((Component)this.splitPanel1, null);
        this.add((Component)this.recordText, null);
        this.add((Component)this.splitPanel2, null);
        this.add((Component)this.nextButton, null);
        this.add((Component)this.lastButton, null);
        this.add((Component)this.lastNewButton, null);
        this.add((Component)this.recordLabel, null);
        this.recordText.setEnabled(false);
        this.recordText.setHorizontalAlignment(4);
        this.recordText.addActionListener(this);
        this.recordText.setActionCommand("Goto");
        this.recordText.addFocusListener(this);
        ((JTextComponent)this.recordText).setDocument(this.document);
        this.recordText.setText("0");
        this.initButton(this.firstButton, CEncodedIcon.FIRST_SIGN);
        this.initButton(this.priorButton, CEncodedIcon.PRIOR_SIGN);
        this.initButton(this.nextButton, CEncodedIcon.NEXT_SIGN);
        this.initButton(this.lastButton, CEncodedIcon.LAST_SIGN);
        this.initButton(this.lastNewButton, CEncodedIcon.LAST_NEW_SIGN);
    }

    private void initButton(JButton jButton, CEncodedIcon cEncodedIcon) {
        jButton.setIcon(cEncodedIcon);
        cEncodedIcon = new CEncodedIcon(cEncodedIcon.getImageArray(), cEncodedIcon.getIconWidth(), cEncodedIcon.getIconHeight());
        cEncodedIcon.setEnabled(false);
        jButton.setDisabledIcon(cEncodedIcon);
        jButton.setEnabled(false);
        jButton.addActionListener(this);
        jButton.setFocusPainted(false);
        jButton.setRequestFocusEnabled(false);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateContent();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateContent();
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable jTable) {
        if (this.table != null) {
            this.table.getSelectionModel().removeListSelectionListener(this);
            this.table.getModel().removeTableModelListener(this);
        }
        this.table = jTable;
        int n = this.lastSelection = jTable.getSelectedRow() >= 0 ? jTable.getSelectedRow() : 0;
        if (this.table != null) {
            this.table.getSelectionModel().addListSelectionListener(this);
            this.table.getModel().addTableModelListener(this);
            this.updateContent();
        }
    }

    private void updateContent() {
        int n;
        if (this.table == null) {
            this.firstButton.setEnabled(false);
            this.priorButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
            this.lastNewButton.setEnabled(false);
            this.recordText.setEnabled(false);
            this.recordLabel.setText("  of 0");
            this.validate();
            return;
        }
        int n2 = n = this.table.getSelectedRow() >= 0 ? this.table.getSelectedRow() : 0;
        if (this.table.getSelectedRowCount() > 1) {
            n = this.lastSelection;
        } else {
            this.lastSelection = n;
        }
        int n3 = this.table instanceof CDataTable && ((CDataTable)this.table).isInsert() ? this.table.getRowCount() - 1 : -1;
        int n4 = n3 >= 0 ? this.table.getRowCount() - 1 : this.table.getRowCount();
        this.firstButton.setEnabled(n > 0);
        this.priorButton.setEnabled(this.firstButton.isEnabled());
        this.lastButton.setEnabled(n < n4 - 1);
        this.lastNewButton.setEnabled(n3 >= 0 && n != n3);
        this.nextButton.setEnabled(this.lastButton.isEnabled() || this.lastNewButton.isEnabled());
        this.recordText.setEnabled(n4 > 0);
        this.recordText.setText(new Integer(n + 1).toString());
        this.recordLabel.setText("  of " + new Integer(n4).toString());
        this.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        String string = actionEvent.getActionCommand();
        int n3 = n2 = this.table.getSelectedRow() >= 0 ? this.table.getSelectedRow() : 0;
        if (this.table.getSelectedRowCount() > 1) {
            n2 = this.lastSelection;
        } else {
            this.lastSelection = n2;
        }
        int n4 = this.table instanceof CDataTable && ((CDataTable)this.table).isInsert() ? this.table.getRowCount() - 1 : -1;
        int n5 = n = n4 >= 0 ? this.table.getRowCount() - 1 : this.table.getRowCount();
        if (string.equals("First")) {
            this.gotoRow(0);
        } else if (string.equals("Prior")) {
            this.gotoRow(n2 - 1);
        } else if (string.equals("Next")) {
            this.gotoRow(n2 + 1);
        } else if (string.equals("Last")) {
            this.gotoRow(n - 1);
        } else if (string.equals("LastNew")) {
            this.gotoRow(n4);
        } else if (string.equals("Goto")) {
            int n6 = new Integer(this.recordText.getText());
            this.gotoRow(n6 - 1);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.document.isModified()) {
            this.recordText.postActionEvent();
        }
    }

    private void gotoRow(int n) {
        if (this.table != null && n >= 0 && n < this.table.getRowCount()) {
            Rectangle rectangle;
            this.table.removeEditor();
            this.table.setRowSelectionInterval(n, n);
            if (this.table.getAutoscrolls() && (rectangle = this.table.getCellRect(n, this.table.getSelectedColumn(), false)) != null) {
                this.table.scrollRectToVisible(rectangle);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Comedia Data Grid Test");
        JTable jTable = new JTable(new String[][]{{"1x1", "1x2", "1x3"}, {"2x1", "2x2", "2x3"}, {"3x1", "3x2", "3x3"}, {"4x1", "4x2", "4x3"}}, new String[]{"Column 1", "Column 2", "Column 3"});
        jFrame.getContentPane().add((Component)jTable, "Center");
        CTableNavigator cTableNavigator = new CTableNavigator(jTable);
        jFrame.getContentPane().add((Component)cTableNavigator, "South");
        ((Component)jFrame).setLocation(100, 100);
        ((Component)jFrame).setSize(500, 300);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(cTableNavigator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

