/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CEncodedIcon
implements Icon {
    public static final CEncodedIcon FIRST_SIGN = new CEncodedIcon(new int[]{193, 195, 199, 207, 199, 195, 193}, 8, 7);
    public static final CEncodedIcon PRIOR_SIGN = new CEncodedIcon(new int[]{16, 48, 112, 240, 112, 48, 16}, 4, 7);
    public static final CEncodedIcon LAST_SIGN = new CEncodedIcon(new int[]{131, 195, 227, 243, 227, 195, 131}, 8, 7);
    public static final CEncodedIcon LAST_NEW_SIGN = new CEncodedIcon(new int[]{128, 64, 193, 80, 224, 224, 243, 248, 224, 224, 193, 80, 128, 64}, 13, 7);
    public static final CEncodedIcon NEXT_SIGN = new CEncodedIcon(new int[]{128, 192, 224, 240, 224, 192, 128}, 4, 7);
    public static final CEncodedIcon BIG_RIGHT_ARROW = new CEncodedIcon(new int[]{128, 192, 224, 240, 248, 240, 224, 192, 128}, 5, 9);
    public static final CEncodedIcon SMALL_DOWN_ARROW = new CEncodedIcon(new int[]{124, 56, 16}, 7, 3);
    public static final CEncodedIcon SMALL_UP_ARROW = new CEncodedIcon(new int[]{16, 56, 124}, 7, 3);
    public static final CEncodedIcon STAR_SIGN = new CEncodedIcon(new int[]{16, 84, 56, 254, 56, 84, 16}, 7, 7);
    public static final CEncodedIcon PEN_SIGN = new CEncodedIcon(new int[]{1, 192, 1, 32, 2, 192, 2, 64, 4, 128, 4, 128, 9, 0, 9, 0, 14, 0, 12, 0, 168, 0}, 11, 11);
    public static final CEncodedIcon SMALL_LEFT_ARROW = new CEncodedIcon(new int[]{24, 56, 120, 248, 120, 56, 24}, 5, 7);
    public static final CEncodedIcon SMALL_RIGHT_ARROW = new CEncodedIcon(new int[]{192, 224, 240, 248, 240, 224, 192}, 5, 7);
    public static final CEncodedIcon ONE_SIGN = new CEncodedIcon(new int[]{96, 224, 96, 96, 96, 240}, 4, 6);
    public static final CEncodedIcon MANY_SIGN = new CEncodedIcon(new int[]{121, 224, 198, 48, 198, 48, 198, 48, 121, 224}, 12, 5);
    private int[] image = null;
    private int width = 0;
    private int height = 0;
    private Color color = Color.black;
    private boolean enabled = true;

    public CEncodedIcon(int[] nArray, int n, int n2) {
        this.image = nArray;
        this.width = n;
        this.height = n2;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.image != null) {
            if (this.enabled) {
                graphics.setColor(this.color);
                this.paint(graphics, n, n2);
            } else {
                graphics.setColor(Color.white);
                this.paint(graphics, n + 1, n2 + 1);
                graphics.setColor(Color.gray);
                this.paint(graphics, n, n2);
            }
        }
    }

    private void paint(Graphics graphics, int n, int n2) {
        int n3 = this.width / 8 + (this.width % 8 != 0 ? 1 : 0);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < this.height) {
                int n6 = this.image[n4 + n5 * n3];
                int n7 = 0;
                while (n7 < 8) {
                    if ((n6 << n7 & 0x80) != 0) {
                        graphics.drawLine(n + n4 * 8 + n7, n2 + n5, n + n4 * 8 + n7, n2 + n5);
                    }
                    ++n7;
                }
                ++n5;
            }
            ++n4;
        }
    }

    public int[] getImageArray() {
        return this.image;
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Comedia CEncodedIcon Test");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 4));
        jPanel.add(new JButton(SMALL_UP_ARROW));
        jPanel.add(new JButton(BIG_RIGHT_ARROW));
        jPanel.add(new JButton(SMALL_DOWN_ARROW));
        jPanel.add(new JButton(MANY_SIGN));
        jPanel.add(new JButton(ONE_SIGN));
        jPanel.add(new JButton(PEN_SIGN));
        jPanel.add(new JButton(SMALL_LEFT_ARROW));
        jPanel.add(new JButton(SMALL_RIGHT_ARROW));
        jPanel.add(new JButton(STAR_SIGN));
        jPanel.add(new JButton(FIRST_SIGN));
        jPanel.add(new JButton(PRIOR_SIGN));
        jPanel.add(new JButton(NEXT_SIGN));
        jPanel.add(new JButton(LAST_SIGN));
        jPanel.add(new JButton(LAST_NEW_SIGN));
        jFrame.getContentPane().add((Component)jPanel, "Center");
        ((Component)jFrame).setLocation(100, 100);
        ((Component)jFrame).setSize(300, 300);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
    }
}

