/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.util.Hashtable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class CColorComboBox
extends JComboBox {
    protected final CImageListModel model = new CImageListModel();

    public CColorComboBox() {
        this.setModel(this.model);
        this.setRenderer(new CImageCellRenderer());
        this.setSelectedIndex(0);
    }

    public Color getSelectedColor() {
        return this.model.getColor(this.getSelectedIndex());
    }

    public void setSelectedColor(Color color) {
        this.setSelectedIndex(this.model.getColorIndex(color));
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = new JFrame("Comedia Editor Test");
        CColorComboBox cColorComboBox = new CColorComboBox();
        cColorComboBox.setSelectedColor(new Color(25, 150, 100));
        jFrame.getContentPane().setLayout(new FlowLayout());
        jFrame.getContentPane().add(cColorComboBox);
        ((Component)jFrame).setLocation(100, 100);
        ((Component)jFrame).setSize(300, 300);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
    }

    private static class CSquareIcon
    implements Icon {
        private Color color;

        public CSquareIcon(Color color) {
            this.color = color;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillRect(n + 2, n2, this.getIconWidth() - 2, this.getIconHeight());
            graphics.setColor(Color.black);
            graphics.drawRect(n + 2, n2, this.getIconWidth() - 2, this.getIconHeight());
        }

        public int getIconWidth() {
            return 25;
        }

        public int getIconHeight() {
            return 11;
        }
    }

    private static class CImageCellRenderer
    implements ListCellRenderer {
        private boolean focused = false;
        private JLabel renderer = new JLabel();

        public CImageCellRenderer() {
            this.renderer.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.renderer.setText("");
                this.renderer.setIcon(null);
            } else {
                Hashtable hashtable = (Hashtable)object;
                this.renderer.setText((String)hashtable.get("label"));
                this.renderer.setIcon((Icon)hashtable.get("icon"));
            }
            this.renderer.setBackground(bl ? SystemColor.textHighlight : SystemColor.text);
            this.renderer.setForeground(bl ? SystemColor.textHighlightText : SystemColor.textText);
            return this.renderer;
        }
    }

    private static class CImageListModel
    extends DefaultComboBoxModel {
        private static final Color[] color = new Color[]{Color.black, new Color(132, 0, 0), new Color(0, 130, 0), new Color(132, 130, 0), new Color(0, 0, 132), new Color(132, 0, 132), new Color(0, 130, 132), Color.gray, Color.lightGray, Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white};
        private static final String[] label = new String[]{"Black", "Maroon", "Green", "Olive", "Navy", "Purple", "Teal", "Gray", "Silver", "Red", "Lime", "Yellow", "Blue", "Fuchsia", "Aqua", "White"};

        public CImageListModel() {
            int n = 0;
            int n2 = label.length;
            while (n < n2) {
                CSquareIcon cSquareIcon = new CSquareIcon(color[n]);
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("label", label[n]);
                hashtable.put("icon", cSquareIcon);
                this.addElement(hashtable);
                ++n;
            }
        }

        public Color getColor(int n) {
            return color[n];
        }

        public int getColorIndex(Color color) {
            int n = 0;
            int n2 = 1000;
            int n3 = 0;
            while (n3 < CImageListModel.color.length) {
                Color color2 = CImageListModel.color[n3];
                int n4 = Math.abs(color2.getRed() - color.getRed()) + Math.abs(color2.getGreen() - color.getGreen()) + Math.abs(color2.getBlue() - color.getBlue());
                if (n4 < n2) {
                    n2 = n4;
                    n = n3;
                }
                ++n3;
            }
            return n;
        }
    }
}

