/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.text;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.comedia.util.scanner.CScanner;

public abstract class CAbstractHighlighter {
    protected MutableAttributeSet whiteSpaceAttr = new SimpleAttributeSet();
    protected MutableAttributeSet identAttr = new SimpleAttributeSet();
    protected MutableAttributeSet commentAttr = new SimpleAttributeSet();
    protected MutableAttributeSet delimAttr = new SimpleAttributeSet();
    protected MutableAttributeSet keywordAttr = new SimpleAttributeSet();
    protected MutableAttributeSet stringAttr = new SimpleAttributeSet();
    protected MutableAttributeSet numberAttr = new SimpleAttributeSet();
    protected CScanner scanner = new CScanner();

    public CAbstractHighlighter() {
        this.whiteSpaceAttr.addAttribute(StyleConstants.NameAttribute, "White");
        this.identAttr.addAttribute(StyleConstants.NameAttribute, "Indent");
        this.commentAttr.addAttribute(StyleConstants.NameAttribute, "Comment");
        this.delimAttr.addAttribute(StyleConstants.NameAttribute, "Delim");
        this.keywordAttr.addAttribute(StyleConstants.NameAttribute, "Keyword");
        this.stringAttr.addAttribute(StyleConstants.NameAttribute, "String");
        this.numberAttr.addAttribute(StyleConstants.NameAttribute, "Number");
        StyleConstants.setForeground(this.whiteSpaceAttr, Color.black);
        StyleConstants.setForeground(this.identAttr, Color.black);
        StyleConstants.setForeground(this.commentAttr, new Color(0, 130, 0));
        StyleConstants.setItalic(this.commentAttr, true);
        StyleConstants.setForeground(this.delimAttr, Color.black);
        StyleConstants.setForeground(this.keywordAttr, new Color(0, 0, 132));
        StyleConstants.setBold(this.keywordAttr, true);
        StyleConstants.setForeground(this.stringAttr, Color.blue);
        StyleConstants.setForeground(this.numberAttr, Color.blue);
        this.scanner.setShowComment(true);
        this.scanner.setShowEol(true);
        this.scanner.setShowString(true);
        this.scanner.setShowKeyword(true);
        this.scanner.setShowType(true);
        this.scanner.setShowSpace(true);
    }

    public MutableAttributeSet getWhiteSpaceAttribute() {
        return this.whiteSpaceAttr;
    }

    public void setWhiteSpaceAttribute(MutableAttributeSet mutableAttributeSet) {
        this.whiteSpaceAttr = mutableAttributeSet;
    }

    public MutableAttributeSet getIdentAttribute() {
        return this.identAttr;
    }

    public void setIdentAttribute(MutableAttributeSet mutableAttributeSet) {
        this.identAttr = mutableAttributeSet;
    }

    public MutableAttributeSet getCommentAttribute() {
        return this.commentAttr;
    }

    public void setCommentAttribute(MutableAttributeSet mutableAttributeSet) {
        this.commentAttr = mutableAttributeSet;
    }

    public MutableAttributeSet getDelimAttribute() {
        return this.delimAttr;
    }

    public void setDelimAttribute(MutableAttributeSet mutableAttributeSet) {
        this.delimAttr = mutableAttributeSet;
    }

    public MutableAttributeSet getKeywordAttribute() {
        return this.keywordAttr;
    }

    public void setKeywordAttribute(MutableAttributeSet mutableAttributeSet) {
        this.keywordAttr = mutableAttributeSet;
    }

    public MutableAttributeSet getStringAttribute() {
        return this.stringAttr;
    }

    public void setStringAttribute(MutableAttributeSet mutableAttributeSet) {
        this.stringAttr = mutableAttributeSet;
    }

    public MutableAttributeSet getNumberAttribute() {
        return this.numberAttr;
    }

    public void setNumberAttribute(MutableAttributeSet mutableAttributeSet) {
        this.numberAttr = mutableAttributeSet;
    }

    public void setBuffer(String string) {
        this.scanner.setBuffer(string);
    }

    public String gotoNextToken() {
        this.scanner.gotoNextToken();
        return this.scanner.getToken();
    }

    public String getToken() {
        return this.scanner.getToken();
    }

    public AttributeSet getAttribute() {
        block18: {
            block17: {
                int n;
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                n = this.scanner.getTokenType();
                                if (this.scanner.getTokenType() == 1) {
                                    n = 1;
                                }
                                if (n == 2) break block13;
                                if (n == 4) break block13;
                                if (n != 4096) break block14;
                            }
                            return this.keywordAttr;
                        }
                        if (n == 1) {
                            return this.commentAttr;
                        }
                        if (n == 8) {
                            return this.identAttr;
                        }
                        if (n == 0) break block15;
                        if (n == 256) break block15;
                        if (n == 224) break block15;
                        if (n == 128) break block15;
                        if (n != 32768) break block16;
                    }
                    return this.whiteSpaceAttr;
                }
                if (n == 2048) {
                    return this.stringAttr;
                }
                if (n == 512) break block17;
                if (n != 1024) break block18;
            }
            return this.numberAttr;
        }
        return this.delimAttr;
    }

    protected int locateUnclosedComment(String string, int n, String string2, String string3) {
        int n2;
        int n3 = string.lastIndexOf(string2, n);
        return n3 > (n2 = string.lastIndexOf(string3, n)) ? n3 : -1;
    }

    public abstract int locateUnclosedComment(String var1, int var2);

    public boolean isMultilineComment() {
        return false;
    }
}

