/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.db.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.comedia.db.view.CTableLink;

public class CTableBox
extends JPanel
implements MouseMotionListener,
MouseListener,
FocusListener,
AdjustmentListener {
    private JLabel label = new JLabel();
    private JList listBox = new JList();
    private JScrollPane scroller = new JScrollPane();
    private Point resizePoint;
    private Point reposPoint;
    private int quadrant;
    private Object[] fields;
    private ArrayList links = new ArrayList();
    private static final int CONNER_SIZE = 5;

    public CTableBox() {
        this.setMinimumSize(new Dimension(95, 26));
        this.setSize(new Dimension(112, 112));
        this.setPreferredSize(new Dimension(112, 112));
        this.setRequestFocusEnabled(true);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(3);
        this.setLayout(borderLayout);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(148, 145, 140), new Color(103, 101, 98)), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setBorder(compoundBorder);
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
        this.add((Component)this.label, "North");
        this.label.setFont(new Font("Dialog", 0, 11));
        this.label.setOpaque(true);
        this.label.setCursor(new Cursor(0));
        this.label.addMouseListener(this);
        this.label.addMouseMotionListener(this);
        this.setSelectedColor(false);
        this.listBox.addFocusListener(this);
        this.listBox.setFont(this.label.getFont());
        this.listBox.setCursor(new Cursor(0));
        this.scroller.setViewportView(this.listBox);
        this.scroller.getVerticalScrollBar().addAdjustmentListener(this);
        this.add((Component)this.scroller, "Center");
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setTitle(String string) {
        this.label.setText(string);
    }

    private void setSelectedColor(boolean bl) {
        if (bl) {
            this.label.setBackground(new Color(0, 0, 100));
            this.label.setForeground(Color.white);
        } else {
            this.label.setBackground(Color.gray);
            this.label.setForeground(Color.lightGray);
        }
    }

    public Object[] getFields() {
        return this.fields;
    }

    public void setFields(Object[] objectArray) {
        this.listBox.setListData(objectArray);
        this.fields = objectArray;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.listBox.requestFocus();
        this.setSelectedColor(true);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setSelectedColor(false);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            this.borderMouseDragged(mouseEvent);
        } else if (mouseEvent.getSource() == this.label) {
            this.labelMouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            this.borderMouseMoved(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.listBox.requestFocus();
        if (mouseEvent.getSource() == this) {
            this.quadrant = this.countQuadrant(mouseEvent.getPoint());
            this.resizePoint = mouseEvent.getPoint();
        } else if (mouseEvent.getSource() == this.label) {
            this.label.setCursor(new Cursor(13));
            this.reposPoint = mouseEvent.getPoint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.label) {
            this.label.setCursor(new Cursor(0));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.updateLinks();
    }

    private int countQuadrant(Point point) {
        int n = 2;
        if (point.x <= 5) {
            n = 1;
        } else if (point.x >= this.getWidth() - 5) {
            n = 3;
        }
        if (point.y > 5) {
            n = point.y < this.getHeight() - 5 ? (n += 3) : (n += 6);
        }
        return n;
    }

    public void borderMouseMoved(MouseEvent mouseEvent) {
        switch (this.countQuadrant(mouseEvent.getPoint())) {
            case 1: {
                this.setCursor(new Cursor(6));
                break;
            }
            case 9: {
                this.setCursor(new Cursor(5));
                break;
            }
            case 2: {
                this.setCursor(new Cursor(8));
                break;
            }
            case 8: {
                this.setCursor(new Cursor(9));
                break;
            }
            case 3: {
                this.setCursor(new Cursor(7));
                break;
            }
            case 7: {
                this.setCursor(new Cursor(4));
                break;
            }
            case 4: {
                this.setCursor(new Cursor(10));
                break;
            }
            case 6: {
                this.setCursor(new Cursor(11));
                break;
            }
            default: {
                this.setCursor(new Cursor(0));
            }
        }
    }

    public void borderMouseDragged(MouseEvent mouseEvent) {
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        boolean bl = false;
        int n = mouseEvent.getPoint().x - this.resizePoint.x;
        int n2 = mouseEvent.getPoint().y - this.resizePoint.y;
        switch (this.quadrant) {
            case 1: 
            case 4: 
            case 7: {
                if (dimension.width - n < this.getMinimumSize().width) break;
                point.x += n;
                dimension.width -= n;
                bl = true;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                if (dimension.width + n >= this.getMinimumSize().width) {
                    dimension.width += n;
                }
                bl = true;
            }
        }
        switch (this.quadrant) {
            case 1: 
            case 2: 
            case 3: {
                if (dimension.height - n2 < this.getMinimumSize().height) break;
                point.y += n2;
                dimension.height -= n2;
                bl = true;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                if (dimension.height + n2 >= this.getMinimumSize().height) {
                    dimension.height += n2;
                }
                bl = true;
            }
        }
        if (bl) {
            this.setLocation(point);
            this.setSize(dimension);
            this.updateLinks();
            this.validate();
        }
        if (this.quadrant == 3 || this.quadrant == 6 || this.quadrant == 9) {
            this.resizePoint.x = mouseEvent.getPoint().x;
        }
        if (this.quadrant == 7 || this.quadrant == 8 || this.quadrant == 9) {
            this.resizePoint.y = mouseEvent.getPoint().y;
        }
    }

    public void labelMouseDragged(MouseEvent mouseEvent) {
        Point point = this.getLocation();
        point.x += mouseEvent.getPoint().x - this.reposPoint.x;
        point.y += mouseEvent.getPoint().y - this.reposPoint.y;
        this.setLocation(point);
        this.updateLinks();
    }

    public void addLink(CTableLink cTableLink) {
        this.links.add(cTableLink);
        cTableLink.updateShape();
    }

    public void clearLinks() {
        this.links.clear();
    }

    public void removeLink(CTableLink cTableLink) {
        ((AbstractCollection)this.links).remove(cTableLink);
    }

    public void updateLinks() {
        int n = 0;
        while (n < this.links.size()) {
            try {
                ((CTableLink)this.links.get(n)).updateShape();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public void updateNewLinks() {
        int n = 0;
        while (n < this.links.size()) {
            try {
                CTableLink cTableLink = (CTableLink)this.links.get(n);
                if (!cTableLink.isUpdated()) {
                    cTableLink.updateShape();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.updateNewLinks();
    }

    public int getItemPos(int n) {
        int n2;
        if (n < 0) {
            n2 = this.getHeight() / 2;
        } else if (n < this.listBox.getFirstVisibleIndex() || this.listBox.getVisibleRowCount() <= 0 || this.scroller.getHeight() <= 3) {
            n2 = this.label.getLocation().y + this.label.getHeight() / 2;
        } else if (n > this.listBox.getLastVisibleIndex() && this.listBox.getLastVisibleIndex() >= 0) {
            n2 = this.getHeight() - 4;
        } else {
            Rectangle rectangle = this.listBox.getCellBounds(n, n);
            n2 = this.scroller.getLocation().y + this.listBox.getLocation().y + rectangle.y + rectangle.height / 2;
        }
        return this.getLocationOnScreen().y + n2;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = new JFrame("Test Table View Application");
        jFrame.getContentPane().setLayout(null);
        jFrame.getContentPane().setBackground(Color.white);
        Object[] objectArray = new String[]{"Field1", "Field2", "Field3", "Field4", "Field5", "Field6"};
        CTableBox cTableBox = new CTableBox();
        cTableBox.setLocation(50, 50);
        cTableBox.setTitle("The First Table");
        cTableBox.setFields(objectArray);
        CTableBox cTableBox2 = new CTableBox();
        cTableBox2.setLocation(250, 250);
        cTableBox2.setTitle("The Second Table");
        cTableBox2.setFields(objectArray);
        CTableLink cTableLink = new CTableLink();
        cTableLink.setLeftTable(cTableBox);
        cTableLink.setLeftLinkType(1);
        cTableLink.setLeftRelation(1);
        cTableLink.setLeftFieldIndex(0);
        cTableLink.setRightTable(cTableBox2);
        cTableLink.setRightLinkType(1);
        cTableLink.setRightRelation(2);
        cTableLink.setRightFieldIndex(5);
        cTableLink.setLocation(150, 150);
        cTableLink.setSize(100, 100);
        jFrame.getContentPane().add(cTableBox);
        jFrame.getContentPane().add(cTableBox2);
        jFrame.getContentPane().add(cTableLink);
        JButton jButton = new JButton("OK");
        jButton.setSize(50, 50);
        jButton.setLocation(100, 100);
        jFrame.getContentPane().add(jButton);
        ((Component)jFrame).setSize(500, 500);
        ((Component)jFrame).setLocation(100, 100);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
    }
}

