/*
 * Decompiled with CFR 0.152.
 */
package electric.util.encoding;

import electric.util.ArrayUtil;
import electric.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

public class Encodings {
    private static final String[] DEFAULT_SUGGESTED_ENCODINGS = new String[]{"UTF8", "UTF-16BE", "UTF-16LE", "cp037"};
    private static String[] suggestedEncodings = new String[0];
    private static byte[][] suggestedEncodingBytes = new byte[0][0];
    private static final String ENCODING = "encoding";
    private static final String XML_DECL = "<?xml";
    private static final Hashtable xmlToJavaEncodings = new Hashtable();
    private static final Hashtable javaToXMLEncodings = new Hashtable();
    private static String systemEncoding;

    public static void addSuggestedEncoding(String string) throws UnsupportedEncodingException {
        byte[] byArray = XML_DECL.getBytes(string);
        suggestedEncodingBytes = (byte[][])ArrayUtil.addElement(suggestedEncodingBytes, byArray);
        suggestedEncodings = (String[])ArrayUtil.addElement(suggestedEncodings, string);
    }

    public static String[] getSuggestedEncodings() {
        return suggestedEncodings;
    }

    public static String getJavaEncoding(byte[] byArray) throws UnsupportedEncodingException {
        if (Strings.isUTF16(byArray)) {
            return "UTF-16";
        }
        if (suggestedEncodingBytes.length == 0) {
            Encodings.initSuggestedEncodings(DEFAULT_SUGGESTED_ENCODINGS);
        }
        int n = 0;
        while (n < suggestedEncodingBytes.length) {
            String string;
            if (Encodings.matches(byArray, suggestedEncodingBytes[n]) && (string = Encodings.getJavaEncoding(byArray, suggestedEncodings[n])) != null) {
                return string;
            }
            ++n;
        }
        return "UTF8";
    }

    private static boolean matches(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray2.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static String getJavaEncoding(byte[] byArray, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, string).toLowerCase().trim();
        if (!string2.startsWith(XML_DECL)) {
            return null;
        }
        int n = string2.indexOf(ENCODING);
        int n2 = string2.indexOf("?>");
        if (n == -1 || n2 < n) {
            return string;
        }
        int n3 = string2.indexOf(61, n + ENCODING.length());
        int n4 = string2.indexOf(39, n3);
        int n5 = string2.indexOf(34, n3);
        int n6 = n4 + 1;
        int n7 = 39;
        if (n3 == -1 || n4 == -1 && n5 == -1) {
            return string;
        }
        if (n5 != -1 && (n4 == -1 || n5 < n4)) {
            n6 = n5 + 1;
            n7 = 34;
        }
        int n8 = string2.indexOf(n7, n6);
        return Encodings.getJavaEncoding(string2.substring(n6, n8));
    }

    public static String getJavaEncoding(String string) {
        String string2 = (String)xmlToJavaEncodings.get(string.toUpperCase());
        return string2 == null ? string : string2;
    }

    public static String getXMLEncoding(String string) {
        String string2 = (String)javaToXMLEncodings.get(string.toUpperCase());
        return string2 == null ? string : string2;
    }

    public static void addBidirectionalEncoding(String string, String string2) {
        xmlToJavaEncodings.put(string, string2);
        javaToXMLEncodings.put(string2, string);
    }

    public static void addXMLToJavaEncoding(String string, String string2) {
        xmlToJavaEncodings.put(string, string2);
    }

    public static void addJavaToXMLEncoding(String string, String string2) {
        javaToXMLEncodings.put(string, string2);
    }

    public static String getSystemEncoding() {
        return systemEncoding;
    }

    public static String getXMLSystemEncoding() {
        return Encodings.getXMLEncoding(systemEncoding);
    }

    private static void initSystemEncoding() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
        systemEncoding = inputStreamReader.getEncoding();
        try {
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void clearSuggestedEncodings() {
        suggestedEncodings = new String[0];
        suggestedEncodingBytes = new byte[0][0];
    }

    public static String[] initSuggestedEncodings(String[] stringArray) {
        Encodings.clearSuggestedEncodings();
        if (suggestedEncodingBytes.length > 0) {
            return new String[0];
        }
        if (stringArray != null || stringArray.length == 0) {
            stringArray = DEFAULT_SUGGESTED_ENCODINGS;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            try {
                Encodings.addSuggestedEncoding(stringArray[n]);
            }
            catch (Throwable throwable) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void initXMLToJavaEncodings() {
        String string = System.getProperty("java.version");
        if (string.equals("1.1") || string.startsWith("1.1.")) {
            Encodings.addXMLToJavaEncoding("SJIS", "WINDOWS-31J");
        } else {
            Encodings.addBidirectionalEncoding("MS932", "WINDOWS-31J");
        }
        Encodings.addBidirectionalEncoding("UTF-8", "UTF8");
        Encodings.addBidirectionalEncoding("US-ASCII", "ASCII");
        Encodings.addBidirectionalEncoding("WINDOWS-1250", "Cp1250");
        Encodings.addBidirectionalEncoding("WINDOWS-1251", "Cp1251");
        Encodings.addBidirectionalEncoding("WINDOWS-1252", "Cp1252");
        Encodings.addBidirectionalEncoding("WINDOWS-1253", "Cp1253");
        Encodings.addBidirectionalEncoding("WINDOWS-1254", "Cp1254");
        Encodings.addBidirectionalEncoding("WINDOWS-1255", "Cp1255");
        Encodings.addBidirectionalEncoding("WINDOWS-1256", "Cp1256");
        Encodings.addBidirectionalEncoding("WINDOWS-1257", "Cp1257");
        Encodings.addBidirectionalEncoding("WINDOWS-1258", "Cp1258");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-US", "CP037");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-DK", "CP277");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-FI", "CP278");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-IT", "CP280");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-ES", "CP284");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-GB", "CP285");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-FR", "CP297");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-AR1", "CP420");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-HE", "CP424");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-CH", "CP500");
        Encodings.addBidirectionalEncoding("CP-AR", "CP868");
        Encodings.addBidirectionalEncoding("CP-GR", "CP869");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-ROECE", "CP870");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-IS", "CP871");
        Encodings.addBidirectionalEncoding("EBCDIC-CP-AR2", "CP918");
        Encodings.addBidirectionalEncoding("TIS-620", "TIS620");
        Encodings.addBidirectionalEncoding("ISO-2022-CN", "ISO2022CN");
        Encodings.addBidirectionalEncoding("X0201", "JIS0201");
        Encodings.addBidirectionalEncoding("X0208", "JIS0208");
        Encodings.addBidirectionalEncoding("ISO-IR-159", "JIS0212");
        Encodings.addXMLToJavaEncoding("ISO-IR-100", "ISO8859_1");
        Encodings.addXMLToJavaEncoding("ISO_8859-1", "ISO8859_1");
        Encodings.addXMLToJavaEncoding("LATIN1", "ISO8859_1");
        Encodings.addXMLToJavaEncoding("L1", "ISO8859_1");
        Encodings.addXMLToJavaEncoding("IBM819", "ISO8859_1");
        Encodings.addXMLToJavaEncoding("CP819", "ISO8859_1");
        Encodings.addXMLToJavaEncoding("ISO-IR-101", "ISO8859_2");
        Encodings.addXMLToJavaEncoding("ISO_8859-2", "ISO8859_2");
        Encodings.addXMLToJavaEncoding("LATIN2", "ISO8859_2");
        Encodings.addXMLToJavaEncoding("L2", "ISO8859_2");
        Encodings.addXMLToJavaEncoding("ISO-IR-109", "ISO8859_3");
        Encodings.addXMLToJavaEncoding("ISO_8859-3", "ISO8859_3");
        Encodings.addXMLToJavaEncoding("LATIN3", "ISO8859_3");
        Encodings.addXMLToJavaEncoding("L3", "ISO8859_3");
        Encodings.addXMLToJavaEncoding("ISO-IR-110", "ISO8859_4");
        Encodings.addXMLToJavaEncoding("ISO_8859-4", "ISO8859_4");
        Encodings.addXMLToJavaEncoding("LATIN4", "ISO8859_4");
        Encodings.addXMLToJavaEncoding("L4", "ISO8859_4");
        Encodings.addXMLToJavaEncoding("ISO-IR-144", "ISO8859_5");
        Encodings.addXMLToJavaEncoding("ISO_8859-5", "ISO8859_5");
        Encodings.addXMLToJavaEncoding("CYRILLIC", "ISO8859_5");
        Encodings.addXMLToJavaEncoding("ISO-IR-127", "ISO8859_6");
        Encodings.addXMLToJavaEncoding("ISO_8859-6", "ISO8859_6");
        Encodings.addXMLToJavaEncoding("ECMA-114", "ISO8859_6");
        Encodings.addXMLToJavaEncoding("ASMO-708", "ISO8859_6");
        Encodings.addXMLToJavaEncoding("ARABIC", "ISO8859_6");
        Encodings.addXMLToJavaEncoding("ISO-IR-126", "ISO8859_7");
        Encodings.addXMLToJavaEncoding("ISO_8859-7", "ISO8859_7");
        Encodings.addXMLToJavaEncoding("ELOT_928", "ISO8859_7");
        Encodings.addXMLToJavaEncoding("ECMA-118", "ISO8859_7");
        Encodings.addXMLToJavaEncoding("GREEK", "ISO8859_7");
        Encodings.addXMLToJavaEncoding("GREEK8", "ISO8859_7");
        Encodings.addXMLToJavaEncoding("ISO-IR-138", "ISO8859_8");
        Encodings.addXMLToJavaEncoding("ISO_8859-8", "ISO8859_8");
        Encodings.addXMLToJavaEncoding("HEBREW", "ISO8859_8");
        Encodings.addXMLToJavaEncoding("ISO-IR-148", "ISO8859_9");
        Encodings.addXMLToJavaEncoding("ISO_8859-9", "ISO8859_9");
        Encodings.addXMLToJavaEncoding("LATIN5", "ISO8859_9");
        Encodings.addXMLToJavaEncoding("L5", "ISO8859_9");
        Encodings.addXMLToJavaEncoding("ISO-2022-JP", "ISO2022JP");
        Encodings.addXMLToJavaEncoding("SHIFT_JIS", "SJIS");
        Encodings.addXMLToJavaEncoding("MS_Kanji", "SJIS");
        Encodings.addXMLToJavaEncoding("ISO-2022-KR", "ISO2022KR");
        Encodings.addXMLToJavaEncoding("EBCDIC-CP-CA", "CP037");
        Encodings.addXMLToJavaEncoding("EBCDIC-CP-NL", "CP037");
        Encodings.addXMLToJavaEncoding("EBCDIC-CP-WT", "CP037");
        Encodings.addXMLToJavaEncoding("EBCDIC-CP-NO", "CP277");
        Encodings.addXMLToJavaEncoding("EBCDIC-CP-SE", "CP278");
        Encodings.addXMLToJavaEncoding("EBCDIC-CP-BE", "CP500");
        Encodings.addXMLToJavaEncoding("EBCDIC-CP-YU", "CP870");
        Encodings.addXMLToJavaEncoding("X0212", "JIS0212");
        Encodings.addJavaToXMLEncoding("ISO8859_1", "ISO-8859-1");
        Encodings.addJavaToXMLEncoding("ISO8859_2", "ISO-8859-2");
        Encodings.addJavaToXMLEncoding("ISO8859_3", "ISO-8859-3");
        Encodings.addJavaToXMLEncoding("ISO8859_4", "ISO-8859-4");
        Encodings.addJavaToXMLEncoding("ISO8859_5", "ISO-8859-5");
        Encodings.addJavaToXMLEncoding("ISO8859_6", "ISO-8859-6");
        Encodings.addJavaToXMLEncoding("ISO8859_7", "ISO-8859-7");
        Encodings.addJavaToXMLEncoding("ISO8859_8", "ISO-8859-8");
        Encodings.addJavaToXMLEncoding("ISO8859_9", "ISO-8859-9");
        Encodings.addJavaToXMLEncoding("ISO2022JP", "ISO-2022-JP");
        Encodings.addJavaToXMLEncoding("SJIS", "Shift_JIS");
        Encodings.addJavaToXMLEncoding("MS932", "WINDOWS-31J");
        Encodings.addJavaToXMLEncoding("EUC_JP", "EUC-JP");
        Encodings.addJavaToXMLEncoding("EUC_KR", "EUC-KR");
        Encodings.addJavaToXMLEncoding("ISO2022KR", "ISO-2022-KR");
        Encodings.addJavaToXMLEncoding("KOI8_R", "KOI8-R");
        Encodings.addJavaToXMLEncoding("JIS0212", "ISO-IR-159");
    }

    static {
        Encodings.initSystemEncoding();
        Encodings.initXMLToJavaEncodings();
    }
}

