/*
 * Decompiled with CFR 0.152.
 */
package org.openabacus.jfreechart;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaObjectAccess;
import java.awt.Font;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.openabacus.jfreechart.JAChartPanel;

public class JAPieChart
extends JAChartPanel
implements MetaObjectAccess {
    private DefaultPieDataset dataset = new DefaultPieDataset();
    private String defaultTitle = null;
    private PiePlot plot = null;

    public JAPieChart() {
        this.setDefaultdata();
        this.defaultTitle = new String("No Title");
        this.chart = this.createChart((PieDataset)this.dataset);
        this.setChart(this.chart);
    }

    public void setMetaObject(MetaObject metaObject) {
        this.iDesignMode = metaObject.iMode;
        this.mtObject = metaObject;
        this.setDefaultdata();
    }

    public void setTitle(String title) {
        this.defaultTitle = title;
        this.chart.setTitle(this.defaultTitle);
    }

    public String getTitle() {
        return this.defaultTitle;
    }

    public void setFont(Font chartFont) {
        this.plotFont = chartFont;
        if (this.plot != null) {
            this.plot.setLabelFont(this.plotFont);
        }
    }

    public Font getFont() {
        return this.plotFont;
    }

    public void set3DChart(boolean bFlag) {
        this.b3DChart = bFlag;
        this.chart = this.createChart((PieDataset)this.dataset);
        this.setChart(this.chart);
    }

    public boolean get3DChart(boolean bFlag) {
        return this.b3DChart;
    }

    public DefaultPieDataset getPieDataset() {
        return this.dataset;
    }

    public void refresh(DefaultPieDataset newDataSet) {
        this.dataset = newDataSet;
        this.chart.clearSubtitles();
        this.chart = this.createChart((PieDataset)this.dataset);
        this.setChart(this.chart);
    }

    public PiePlot getPiePlot() {
        return this.plot;
    }

    private void setDefaultdata() {
        if (this.dataset != null && this.iDesignMode == 1) {
            this.dataset.setValue((Comparable)((Object)"One"), (Number)new Double(43.2));
            this.dataset.setValue((Comparable)((Object)"Three"), (Number)new Double(27.5));
            this.dataset.setValue((Comparable)((Object)"Four"), (Number)new Double(17.5));
            this.dataset.setValue((Comparable)((Object)"Five"), (Number)new Double(11.0));
            this.dataset.setValue((Comparable)((Object)"Six"), (Number)new Double(19.4));
            this.dataset.setValue((Comparable)((Object)"Two"), (Number)new Double(10.0));
        }
    }

    private JFreeChart createChart(PieDataset dataset) {
        JFreeChart localChart = null;
        localChart = this.b3DChart ? ChartFactory.createPieChart3D((String)this.defaultTitle, (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false) : ChartFactory.createPieChart((String)this.defaultTitle, (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        this.plot = (PiePlot)localChart.getPlot();
        this.plot.setLabelFont(this.plotFont);
        this.plot.setNoDataMessage("No data available");
        this.plot.setCircular(false);
        this.plot.setLabelGap(0.02);
        return localChart;
    }
}

