/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import net.sourceforge.jtds.jdbc.RequestStream;
import net.sourceforge.jtds.jdbc.ResponseStream;
import net.sourceforge.jtds.util.Logger;

class SharedSocket {
    private Socket socket = null;
    private DataOutputStream out = null;
    private DataInputStream in = null;
    private int maxBufSize = 512;
    private ArrayList socketTable = new ArrayList();
    private int responseOwner = -1;
    private int currentSender = -1;
    private byte[] hdrBuf = new byte[8];
    private static int globalMemUsage = 0;
    private static int peakMemUsage = 0;
    private static int memoryBudget = 100000;
    private static int minMemPkts = 8;
    private static boolean securityViolation = false;
    private int tdsVersion;
    private int serverType;
    private String charsetName;
    private boolean wideChars;
    private int packetCount = 0;
    private static final byte TDS_DONE_TOKEN = -3;

    protected SharedSocket() {
    }

    SharedSocket(String host, int port, int tdsVersion, int serverType) throws IOException, UnknownHostException {
        this.setTdsVersion(tdsVersion);
        this.setServerType(serverType);
        this.socket = new Socket(host, port);
        this.setOut(new DataOutputStream(this.socket.getOutputStream()));
        this.setIn(new DataInputStream(this.socket.getInputStream()));
        this.socket.setTcpNoDelay(true);
    }

    void setCharset(String charsetName) {
        this.charsetName = charsetName;
    }

    String getCharset() {
        return this.charsetName;
    }

    void setWideChars(boolean value) {
        this.wideChars = value;
    }

    boolean isWideChars() {
        return this.wideChars;
    }

    RequestStream getRequestStream() {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            int id = 0;
            while (id < this.socketTable.size()) {
                if (this.socketTable.get(id) == null) break;
                ++id;
            }
            VirtualSocket vsock = new VirtualSocket(id);
            if (id >= this.socketTable.size()) {
                this.socketTable.add(vsock);
            } else {
                this.socketTable.set(id, vsock);
            }
            RequestStream requestStream = new RequestStream(this, id);
            return requestStream;
        }
    }

    ResponseStream getResponseStream(RequestStream requestStream) {
        return new ResponseStream(this, requestStream.getStreamId());
    }

    int getTdsVersion() {
        return this.tdsVersion;
    }

    protected void setTdsVersion(int tdsVersion) {
        this.tdsVersion = tdsVersion;
    }

    int getServerType() {
        return this.serverType;
    }

    protected void setServerType(int serverType) {
        this.serverType = serverType;
    }

    static void setMemoryBudget(int memoryBudget) {
        SharedSocket.memoryBudget = memoryBudget;
    }

    static int getMemoryBudget() {
        return memoryBudget;
    }

    static void setMinMemPkts(int minMemPkts) {
        SharedSocket.minMemPkts = minMemPkts;
    }

    static int getMinMemPkts() {
        return minMemPkts;
    }

    void setSoTimeout(int streamId, int timeOut) {
        VirtualSocket vsock = this.lookup(streamId);
        vsock.timeOut = timeOut;
    }

    int getSoTimeout(int streamId) {
        VirtualSocket vsock = this.lookup(streamId);
        return vsock.timeOut;
    }

    boolean isConnected() {
        return this.socket != null;
    }

    void cancel(int streamId) {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            if (this.responseOwner != -1 && this.responseOwner == streamId && this.currentSender == -1) {
                try {
                    this.sendCancel(streamId);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    void close() throws IOException {
        if (Logger.isActive()) {
            Logger.println("TdsSocket: Max buffer memory used = " + peakMemUsage + "KB");
        }
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.socketTable.size()) {
                VirtualSocket vsock = (VirtualSocket)this.socketTable.get(i);
                if (vsock != null && vsock.diskQueue != null) {
                    try {
                        vsock.diskQueue.close();
                        vsock.queueFile.delete();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
    }

    void forceClose() {
        if (this.socket != null) {
            try {
                try {
                    this.socket.close();
                }
                catch (IOException ioe) {
                    Object var3_2 = null;
                    this.socket = null;
                }
                Object var3_1 = null;
                this.socket = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.socket = null;
                throw throwable;
            }
        }
    }

    void closeStream(int streamId) {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            VirtualSocket vsock = this.lookup(streamId);
            if (vsock.diskQueue != null) {
                try {
                    vsock.diskQueue.close();
                    vsock.queueFile.delete();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.socketTable.set(streamId, null);
        }
    }

    byte[] sendNetPacket(int streamId, byte[] buffer) throws IOException {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            VirtualSocket vsock = this.lookup(streamId);
            while (vsock.inputPkts > 0) {
                if (Logger.isActive()) {
                    Logger.println("TdsSocket: Unread data in input packet queue");
                }
                this.dequeueInput(vsock);
            }
            if (this.responseOwner != -1 && this.responseOwner == streamId) {
                if (Logger.isActive()) {
                    Logger.println("TdsSocket: Unread data on network");
                }
                vsock.flushInput = true;
            }
            if (this.responseOwner != -1 || this.currentSender != -1 && this.currentSender != streamId) {
                this.enqueueOutput(vsock, buffer);
                buffer = new byte[buffer.length];
            } else {
                byte[] tmpBuf = this.dequeueOutput(vsock);
                while (tmpBuf != null) {
                    this.getOut().write(tmpBuf, 0, SharedSocket.getPktLen(tmpBuf, 2));
                    tmpBuf = this.dequeueOutput(vsock);
                }
                this.getOut().write(buffer, 0, SharedSocket.getPktLen(buffer, 2));
                if (buffer[1] != 0) {
                    this.currentSender = -1;
                    this.responseOwner = streamId;
                } else {
                    this.currentSender = streamId;
                }
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    /*
     * Unable to fully structure code
     */
    byte[] getNetPacket(int streamId, byte[] buffer) throws IOException {
        var3_3 = this.socketTable;
        synchronized (var3_3) {
            block7: {
                vsock = this.lookup(streamId);
                if (VirtualSocket.access$300(vsock) > 0) {
                    var5_5 = this.dequeueInput(vsock);
                    return var5_5;
                }
                if (this.responseOwner != -1 && this.responseOwner == streamId && !VirtualSocket.access$400(vsock)) break block7;
                if (this.responseOwner != -1) {
                    other = (VirtualSocket)this.socketTable.get(this.responseOwner);
                    do {
                        tmpBuf = this.readPacket(null, other, 0);
                        if (VirtualSocket.access$400(other)) continue;
                        this.enqueueInput(other, tmpBuf);
                    } while (tmpBuf[1] == 0);
                    VirtualSocket.access$402(other, false);
                }
                if ((tmpBuf = this.dequeueOutput(vsock)) != null) ** GOTO lbl22
                throw new IOException("No client request to send");
lbl-1000:
                // 1 sources

                {
                    this.getOut().write(tmpBuf, 0, SharedSocket.getPktLen(tmpBuf, 2));
                    tmpBuf = this.dequeueOutput(vsock);
lbl22:
                    // 2 sources

                    ** while (tmpBuf != null)
                }
lbl23:
                // 1 sources

                this.responseOwner = streamId;
            }
            var5_6 = buffer = this.readPacket(buffer, vsock, VirtualSocket.access$000(vsock));
            return var5_6;
        }
    }

    private byte[] dequeueInput(VirtualSocket vsock) throws IOException {
        byte[] buf = this.dequeuePacket(vsock);
        if (buf != null) {
            vsock.inputPkts--;
        }
        return buf;
    }

    private void enqueueInput(VirtualSocket vsock, byte[] buffer) throws IOException {
        this.enqueuePacket(vsock, buffer);
        vsock.inputPkts++;
    }

    private byte[] dequeueOutput(VirtualSocket vsock) throws IOException {
        byte[] buf = this.dequeuePacket(vsock);
        if (buf == null) {
            vsock.complete = false;
        } else {
            vsock.outputPkts--;
        }
        return buf;
    }

    private void enqueueOutput(VirtualSocket vsock, byte[] buffer) throws IOException {
        this.enqueuePacket(vsock, buffer);
        vsock.complete = buffer[1] != 0;
        vsock.outputPkts++;
    }

    private void enqueuePacket(VirtualSocket vsock, byte[] buffer) throws IOException {
        if (globalMemUsage + buffer.length > memoryBudget && vsock.pktQueue.size() >= minMemPkts && !securityViolation && vsock.diskQueue == null) {
            try {
                vsock.queueFile = File.createTempFile("jtds", ".tmp");
                vsock.diskQueue = new RandomAccessFile(vsock.queueFile, "rw");
                while (vsock.pktQueue.size() > 0) {
                    byte[] tmpBuf = (byte[])vsock.pktQueue.removeFirst();
                    vsock.diskQueue.write(tmpBuf, 0, SharedSocket.getPktLen(tmpBuf, 2));
                    vsock.pktsOnDisk++;
                }
            }
            catch (SecurityException se) {
                securityViolation = true;
                vsock.queueFile = null;
                vsock.diskQueue = null;
            }
        }
        if (vsock.diskQueue != null) {
            vsock.diskQueue.write(buffer, 0, SharedSocket.getPktLen(buffer, 2));
            vsock.pktsOnDisk++;
        } else {
            vsock.pktQueue.addLast(buffer);
            if ((globalMemUsage += buffer.length) > peakMemUsage) {
                peakMemUsage = globalMemUsage;
            }
        }
    }

    private byte[] dequeuePacket(VirtualSocket vsock) throws IOException {
        byte[] buffer = null;
        if (vsock.pktsOnDisk > 0) {
            if (vsock.diskQueue.getFilePointer() == vsock.diskQueue.length()) {
                vsock.diskQueue.seek(0L);
            }
            vsock.diskQueue.read(this.hdrBuf, 0, 8);
            int len = SharedSocket.getPktLen(this.hdrBuf, 2);
            buffer = new byte[len];
            System.arraycopy(this.hdrBuf, 0, buffer, 0, 8);
            vsock.diskQueue.read(buffer, 8, len - 8);
            vsock.pktsOnDisk--;
            if (vsock.pktsOnDisk < 1) {
                try {
                    vsock.diskQueue.close();
                    vsock.queueFile.delete();
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    vsock.queueFile = null;
                    vsock.diskQueue = null;
                    throw throwable;
                }
                vsock.queueFile = null;
                vsock.diskQueue = null;
                {
                }
            }
        } else if (vsock.pktQueue.size() > 0) {
            buffer = (byte[])vsock.pktQueue.removeFirst();
            globalMemUsage -= buffer.length;
        }
        return buffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readPacket(byte[] buffer, VirtualSocket vsock, int timeOut) throws IOException {
        boolean queryTimedOut = false;
        do {
            if (timeOut > 0) {
                this.setTimeout(timeOut);
            }
            int len = 0;
            while (true) {
                block20: {
                    Object var8_9;
                    if (len != 0) {
                        if (len != -1) break;
                        throw new IOException("DB server closed connection.");
                    }
                    try {
                        try {
                            len = this.getIn().read(this.hdrBuf, 0, 1);
                        }
                        catch (InterruptedIOException e) {
                            queryTimedOut = true;
                            this.sendCancel(vsock.owner);
                            var8_9 = null;
                            if (timeOut > 0) {
                                this.setTimeout(0);
                            }
                            timeOut = 0;
                            continue;
                        }
                        var8_9 = null;
                        if (timeOut <= 0) break block20;
                    }
                    catch (Throwable throwable) {
                        var8_9 = null;
                        if (timeOut > 0) {
                            this.setTimeout(0);
                        }
                        timeOut = 0;
                        throw throwable;
                    }
                    this.setTimeout(0);
                }
                timeOut = 0;
            }
            try {
                this.getIn().readFully(this.hdrBuf, 1, 7);
            }
            catch (EOFException e) {
                throw new IOException("DB server closed connection.");
            }
            byte packetType = this.hdrBuf[0];
            if (packetType != 2 && packetType != 1 && packetType != 4) {
                throw new IOException("Unknown packet type 0x" + Integer.toHexString(packetType));
            }
            len = SharedSocket.getPktLen(this.hdrBuf, 2);
            if (len < 8 || len > 65536) {
                throw new IOException("Invalid network packet length " + len);
            }
            if (buffer == null || len > buffer.length) {
                buffer = new byte[len];
                if (len > this.maxBufSize) {
                    this.maxBufSize = len;
                }
            }
            System.arraycopy(this.hdrBuf, 0, buffer, 0, 8);
            try {
                this.getIn().readFully(buffer, 8, len - 8);
            }
            catch (EOFException e) {
                throw new IOException("DB server closed connection.");
            }
            if (++this.packetCount != 1 || this.serverType != 1 || !"NTLMSSP".equals(new String(buffer, 11, 7))) continue;
            buffer[1] = 1;
        } while (queryTimedOut && buffer[1] == 0 || !queryTimedOut && this.isUnwantedCancelAck(buffer));
        if (buffer[1] != 0) {
            this.responseOwner = -1;
            if (queryTimedOut) {
                throw new InterruptedIOException("Query timed out");
            }
        }
        return buffer;
    }

    private boolean isUnwantedCancelAck(byte[] buffer) {
        if (buffer[1] == 0) {
            return false;
        }
        if (SharedSocket.getPktLen(buffer, 2) != 17) {
            return false;
        }
        if (buffer[8] != -3 || (buffer[9] & 0x20) == 0) {
            return false;
        }
        if (Logger.isActive()) {
            Logger.println("TdsSocket: Cancel packet discarded");
        }
        return true;
    }

    private void sendCancel(int streamId) throws IOException {
        byte[] cancel = new byte[]{6, 1, 0, 8, 0, 0, this.getTdsVersion() >= 3 ? (byte)1 : 0, 0};
        this.getOut().write(cancel, 0, 8);
        if (Logger.isActive()) {
            Logger.logPacket(streamId, false, cancel);
        }
    }

    private VirtualSocket lookup(int streamId) {
        if (streamId < 0 || streamId > this.socketTable.size()) {
            throw new IllegalArgumentException("Invalid parameter stream ID " + streamId);
        }
        VirtualSocket vsock = (VirtualSocket)this.socketTable.get(streamId);
        if (vsock.owner != streamId) {
            throw new IllegalStateException("Internal error: bad stream ID " + streamId);
        }
        return vsock;
    }

    static int getPktLen(byte[] buf, int offset) {
        int lo = buf[offset + 1] & 0xFF;
        int hi = (buf[offset] & 0xFF) << 8;
        return hi | lo;
    }

    protected void setTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    protected DataInputStream getIn() {
        return this.in;
    }

    protected void setIn(DataInputStream in) {
        this.in = in;
    }

    protected DataOutputStream getOut() {
        return this.out;
    }

    protected void setOut(DataOutputStream out) {
        this.out = out;
    }

    private static class VirtualSocket {
        private int owner;
        private int timeOut;
        private LinkedList pktQueue;
        private boolean flushInput;
        private boolean complete;
        private File queueFile;
        private RandomAccessFile diskQueue;
        private int pktsOnDisk;
        private int inputPkts;
        private int outputPkts;

        VirtualSocket(int streamId) {
            this.owner = streamId;
            this.pktQueue = new LinkedList();
            this.flushInput = false;
            this.complete = false;
            this.timeOut = 0;
            this.queueFile = null;
            this.diskQueue = null;
            this.pktsOnDisk = 0;
            this.inputPkts = 0;
            this.outputPkts = 0;
        }

        static /* synthetic */ boolean access$400(VirtualSocket x0) {
            return x0.flushInput;
        }
    }
}

