/*
 * Decompiled with CFR 0.152.
 */
package module.aolim.ui;

import component.IcbmCore;
import component.OscarLabelButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import main.Oscar;
import module.aolim.ui.ImUI;
import module.aolim.ui.UiBean;
import uiutil.ACheckbox;
import uiutil.ChoiceUI;
import uiutil.HorizontalRule;
import uiutil.IUtil;
import uiutil.ImageButton;
import uiutil.ImageLabel;
import uiutil.ImagePanel;
import uiutil.MultiLineLabel;
import uiutil.OFrame;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import uiutil.UIPack;

class ZapUI
extends OFrame
implements ActionListener {
    private static int FORMAT_WIDTH = 38;
    private UiBean uibean;
    private ImUI ui;
    private String nickname;
    private ImageButton evilButton;
    private ImageButton blockButton;
    private ACheckbox anonymousCheck;

    public ZapUI(UiBean uiBean, ImUI imUI, String string) {
        this.uibean = uiBean;
        this.ui = imUI;
        this.nickname = string;
        ((Frame)((Object)this)).setTitle("Zap " + string);
        ((Component)((Object)this)).setBackground(Oscar.backgroundColor);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ImagePanel imagePanel = new ImagePanel();
        ((Container)((Object)this)).add("Center", (Component)imagePanel);
        Image image = Oscar.images.getImage((UIPack)uiBean, Oscar.BG_TILE, (Component)imagePanel, true);
        imagePanel.setTile(image);
        imagePanel.setLayout(new BorderLayout());
        TransparentPanel transparentPanel = new TransparentPanel();
        imagePanel.add("North", (Component)transparentPanel);
        transparentPanel.setLayout(new FlowLayout(0));
        transparentPanel.add((Component)new MultiLineLabel(IUtil.format((String)"Warnings are used to express disapproval of a member who contacted you (by using IM, for example). The more you warn another member, the more the system slows down for that member. Warnings wears off over time. You may choose to use an anonymous (but less powerful) warning.", (int)FORMAT_WIDTH)));
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel.add((Component)transparentPanel2);
        transparentPanel2.setLayout(new BorderLayout());
        TransparentPanel transparentPanel3 = new TransparentPanel();
        transparentPanel2.add("North", (Component)transparentPanel3);
        this.evilButton = OscarLabelButton.makeImageButton((UIPack)uiBean, (Component)imagePanel, (String)"Evil");
        transparentPanel3.add((Component)this.evilButton);
        this.evilButton.addActionListener((ActionListener)this);
        transparentPanel3 = new TransparentPanel();
        transparentPanel2.add("Center", (Component)transparentPanel3);
        this.anonymousCheck = new ACheckbox();
        transparentPanel3.add((Component)this.anonymousCheck);
        String string2 = Oscar.config.getValue(String.valueOf(IcbmCore.IM_KEY) + "." + IcbmCore.ANONYMOUS_KEY);
        if (string2 != null) {
            this.anonymousCheck.setState(string2.equalsIgnoreCase("true"));
        }
        transparentPanel2.add("South", (Component)new ImageLabel("Anonymous", 1));
        imagePanel.add("Center", (Component)new HorizontalRule());
        TransparentPanel transparentPanel4 = new TransparentPanel();
        imagePanel.add("South", (Component)transparentPanel4);
        transparentPanel4.setLayout(new FlowLayout(0));
        transparentPanel4.add((Component)new MultiLineLabel(IUtil.format((String)"When you block a member, that member can no longer contact you or see you online. Likewise, you will not be able to contact or see that member either. If you want to stop blocking a member, you may change your privacy preferences under Setup.", (int)FORMAT_WIDTH)));
        transparentPanel4.add((Component)new Spacer());
        transparentPanel4.add((Component)new Spacer());
        this.blockButton = OscarLabelButton.makeImageButton((UIPack)uiBean, (Component)imagePanel, (String)"Ignore");
        transparentPanel4.add((Component)this.blockButton);
        this.blockButton.addActionListener((ActionListener)this);
        ((Window)((Object)this)).pack();
        ((Component)((Object)this)).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        boolean bl = false;
        if (object == this.evilButton) {
            boolean bl2 = this.anonymousCheck.getState();
            this.uibean.sendEvil(this.nickname, bl2);
            if (bl2) {
                Oscar.config.setValue(String.valueOf(IcbmCore.IM_KEY) + "." + IcbmCore.ANONYMOUS_KEY, "true");
            } else {
                Oscar.config.setValue(String.valueOf(IcbmCore.IM_KEY) + "." + IcbmCore.ANONYMOUS_KEY, "false");
            }
            Oscar.saveConfiguration();
            bl = true;
            IUtil.playSound((UIPack)this.uibean, (String)"Strike");
        } else if (object == this.blockButton) {
            this.uibean.block(this.nickname);
            IUtil.playSound((UIPack)this.uibean, (String)"Ignore");
            ChoiceUI.newChoiceUI((String)("Block " + this.nickname), (String)("You have blocked " + this.nickname + "."));
            bl = true;
        }
        if (bl) {
            this.dispose();
        }
    }

    public void removeNotify() {
        this.ui.zapRemove();
        this.ui = null;
        this.uibean = null;
        super.removeNotify();
    }

    public void setEnabled(boolean bl) {
        this.evilButton.setEnabled(bl);
        this.blockButton.setEnabled(bl);
        this.anonymousCheck.setEnabled(bl);
    }
}

