/*
 * Decompiled with CFR 0.152.
 */
package snac;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import snac.SnacTlv;
import uiutil.ErrorMgr;
import util.OutputBuffer;

public class TLV
extends Vector {
    public TLV() {
        this(5);
    }

    public TLV(int n) {
        super(n);
    }

    public void addTlv(int n) {
        this.addElement(new SnacTlv(n, 0, new byte[0]));
    }

    public void addTlv(int n, byte[] byArray) {
        this.addElement(new SnacTlv(n, byArray.length, byArray));
    }

    public void addTlv(int n, String string) {
        byte[] byArray = string.getBytes();
        this.addTlv(n, byArray);
    }

    public void addTlvS32(int n, int n2) {
        try {
            OutputBuffer outputBuffer = new OutputBuffer(4);
            outputBuffer.d.writeInt(n2);
            this.addTlv(n, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.error("TLV", "error createing new TLV S32 " + iOException.getMessage());
            return;
        }
    }

    public void addTlvU16(int n, int n2) {
        try {
            OutputBuffer outputBuffer = new OutputBuffer(2);
            outputBuffer.d.writeShort(n2);
            this.addTlv(n, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.error("TLV", "error createing new TLV U16 " + iOException.getMessage());
            return;
        }
    }

    public boolean tlvTypePresent(int n) {
        return this.getTlvData(n) != null;
    }

    public String getTlvDataAsString(int n) {
        return this.getTlvDataAsString(n, null);
    }

    public String getTlvDataAsString(int n, String string) {
        byte[] byArray = this.getTlvData(n);
        if (byArray == null) {
            return string;
        }
        return new String(byArray);
    }

    public int getTlvDataAsS32(int n) throws NumberFormatException {
        byte[] byArray = this.getTlvData(n);
        if (byArray == null) {
            throw new NumberFormatException("tlv type " + n + " not found");
        }
        if (byArray.length != 4) {
            throw new NumberFormatException("tlv type " + n + " bad length " + byArray.length);
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return dataInputStream.readInt();
        }
        catch (Exception exception) {
            throw new NumberFormatException("tlv type " + n + " bad data " + exception.getMessage());
        }
    }

    public int getTlvDataAsU16(int n) throws NumberFormatException {
        byte[] byArray = this.getTlvData(n);
        if (byArray == null) {
            throw new NumberFormatException("tlv type " + n + " not found");
        }
        if (byArray.length != 2) {
            throw new NumberFormatException("tlv type " + n + " bad length " + byArray.length);
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return dataInputStream.readUnsignedShort();
        }
        catch (Exception exception) {
            throw new NumberFormatException("tlv type " + n + " bad data " + exception.getMessage());
        }
    }

    public byte[] getTlvData(int n) {
        int n2 = 0;
        while (n2 < this.size()) {
            SnacTlv snacTlv = (SnacTlv)this.elementAt(n2);
            if (snacTlv.type == n) {
                return snacTlv.data;
            }
            ++n2;
        }
        return null;
    }

    public int tlvVectorLength() {
        int n = 4 * this.size();
        int n2 = 0;
        while (n2 < this.size()) {
            SnacTlv snacTlv = (SnacTlv)this.elementAt(n2);
            n += snacTlv.length;
            ++n2;
        }
        return n;
    }

    public void writeTlvVector(DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        while (n < this.size()) {
            SnacTlv snacTlv = (SnacTlv)this.elementAt(n);
            snacTlv.write(dataOutputStream);
            ++n;
        }
    }

    public int readTlvVector(DataInputStream dataInputStream, int n) throws IOException {
        if (this.size() > 0 || n < 0) {
            throw new IOException("readTLVVector bad args");
        }
        int n2 = 0;
        while (n2 < n) {
            SnacTlv snacTlv = new SnacTlv(dataInputStream);
            this.addElement(snacTlv);
            n2 = this.tlvVectorLength();
        }
        if (n2 > n) {
            throw new IOException("readTLVVector, read underflow");
        }
        return n2;
    }

    public static String toString(Vector vector) {
        if (vector == null) {
            return "null TLV";
        }
        String string = "TLV:  size " + vector.size() + "\n";
        int n = 0;
        while (n < vector.size()) {
            SnacTlv snacTlv = (SnacTlv)vector.elementAt(n);
            string = String.valueOf(string) + "   " + TLV.toString(snacTlv) + "\n";
            ++n;
        }
        return string;
    }

    public static String toString(SnacTlv snacTlv) {
        return "SnacTlv: type " + snacTlv.type + " length " + snacTlv.length + " data " + new String(snacTlv.data);
    }
}

