/*
 * Decompiled with CFR 0.152.
 */
package main;

import component.BuddyCore;
import component.IcbmCore;
import component.LocateCore;
import component.MainTool;
import component.OscarSetup;
import component.SetupListener;
import component.Tool;
import component.Tools;
import java.awt.Color;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Date;
import java.util.Properties;
import main.AdCore;
import main.AdminCore;
import main.BOSCore;
import main.ClientDispatcher;
import main.LoginCore;
import main.PermissionAPI;
import proxy.ProxyConnector;
import proxy.SOCKSConnector;
import snac.AdminHandler;
import snac.AdvertHandler;
import snac.BosHandler;
import snac.BuddyHandler;
import snac.IcbmHandler;
import snac.InviteHandler;
import snac.LocateHandler;
import snac.PopupHandler;
import snac.ServiceHandler;
import snac.SnacConstants;
import snac.StatsHandler;
import snac.TranslateHandler;
import snac.UserLookupHandler;
import uiutil.ChoiceUI;
import uiutil.ErrorMgr;
import uiutil.IUtil;
import uiutil.ImageStore;
import uiutil.MediaStore;
import uiutil.ShutdownListener;
import uiutil.UIPackConstants;
import uiutil.UrlViewer;
import util.JUtil;
import util.KeyBindings;
import util.Log;
import util.Timer;

public class Oscar
implements SnacConstants,
UIPackConstants,
ShutdownListener,
SetupListener {
    private static final String MODULE = "Oscar";
    private static boolean running;
    private static ClientDispatcher dispatcher;
    private static String DISC_REASON;
    private static boolean useCLI;
    private static String configFile;
    private static final String CONFIG_DIR_NAME;
    public static String CONFIG_DIR;
    private static final String CONFIG_NAME = "AIM.cfg";
    private static OscarSetup oscarSetup;
    private static final String LOG_NAME = "aim.log";
    public static Oscar app;
    public static BOSCore bosCore;
    public static AdminCore adminCore;
    public static AdCore adCore;
    public static Tools tools;
    public static MainTool mainTool;
    public static PermissionAPI permit;
    public static Color backgroundColor;
    public static int port;
    public static KeyBindings config;
    public static String nickname;
    public static String emailAddress;
    public static int registrationStatus;
    public static ImageStore images;
    public static String ROOT;
    public static String BG_TILE;
    public static String TOOLS_DIR;
    public static String SHARE_DIR;
    public static String SOUND_DIR;
    public static String SOUND_SUFFIX;
    public static String ERROR_SOUND;
    public static String WARNING_SOUND;
    public static String SHORT_NAME;
    public static String FULL_NAME;
    public static int majorVersion;
    public static int minorVersion;
    public static int buildNumber;
    public static String buildTime;
    public static String version;
    public static String build;
    public static String name;
    private static boolean saveConfig;
    public static ProxyConnector connector;

    public static void main(String[] stringArray) {
        System.out.println("Running " + Oscar.clientProfile());
        boolean bl = false;
        boolean bl2 = false;
        try {
            Exception exception;
            String[] stringArray2;
            String string;
            running = true;
            app = new Oscar();
            ErrorMgr.initErrorMgr(null, ERROR_SOUND, WARNING_SOUND, app, Integer.MAX_VALUE);
            new Timer("System", 100);
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                if ((string = stringArray[n++]).equals("-help")) {
                    Oscar.printHelp();
                    System.exit(0);
                    continue;
                }
                if (string.equals("-version")) {
                    System.err.println(name);
                    System.exit(0);
                    continue;
                }
                if (string.equals("-root")) {
                    if (n < stringArray.length) {
                        ROOT = stringArray[n++];
                    }
                    if (ROOT.endsWith(File.separator)) continue;
                    ROOT = String.valueOf(ROOT) + File.separator;
                    continue;
                }
                if (string.equals("-loglevel")) {
                    bl2 = true;
                    if (n < stringArray.length) {
                        if ((stringArray2 = stringArray[n++]).charAt(0) == '-') {
                            Log.setLogLevel(Log.MAXLEVEL);
                            --n;
                            continue;
                        }
                        if (Log.setLogLevel((String)stringArray2) == null) continue;
                        System.err.println("You must specify an integer between 1 and " + Log.MAXLEVEL + '.');
                        System.exit(1);
                        continue;
                    }
                    Log.setLogLevel(Log.MAXLEVEL);
                    continue;
                }
                if (string.equals("-config")) {
                    if (n < stringArray.length) {
                        CONFIG_DIR = stringArray[n++];
                    }
                    if (CONFIG_DIR.endsWith(File.separator)) continue;
                    CONFIG_DIR = String.valueOf(CONFIG_DIR) + File.separator;
                    continue;
                }
                if (string.equals("-autologin")) {
                    bl = true;
                    continue;
                }
                if (string.equals("-cli")) {
                    useCLI = true;
                    continue;
                }
                if (string.equals("-nosound")) {
                    IUtil.playSounds = false;
                    continue;
                }
                if (string.equals("-fonts")) {
                    stringArray2 = Toolkit.getDefaultToolkit().getFontList();
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        System.out.println(stringArray2[n2]);
                        ++n2;
                    }
                    System.exit(0);
                    continue;
                }
                if (string.equals("-system")) {
                    System.exit(0);
                    continue;
                }
                System.err.println("Unknown option `" + string + "`.");
                Oscar.printHelp();
                System.exit(1);
            }
            if (CONFIG_DIR == null && (string = System.getProperty("user.home")) != null && (stringArray2 = new File(string, CONFIG_DIR_NAME)).exists() && !(CONFIG_DIR = stringArray2.getPath()).endsWith(File.separator)) {
                CONFIG_DIR = String.valueOf(CONFIG_DIR) + File.separator;
            }
            if ((string = (config = Oscar.loadConfiguration()).getValueDefault("Browser", "default")) != null && !string.equals("default")) {
                UrlViewer.defaultBrowser = string = string.replace('/', File.separatorChar);
            }
            stringArray2 = config.getValue("debug.loglevel");
            if (!bl2 && stringArray2 != null && (exception = Log.setLogLevel((String)stringArray2)) != null) {
                ErrorMgr.error(FULL_NAME, "bad loglevel specification in preferences " + (String)stringArray2 + " must be a number between 1 and " + Log.MAXLEVEL, exception);
            }
            Oscar.createMediaLocations();
            if (!bl) {
                bl = JUtil.isTrue(config.getValueDefault(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.AUTO_LOGIN_KEY, "false"));
            }
            tools = new Tools();
            dispatcher = new ClientDispatcher();
            Oscar.registerHandlers();
            Oscar.registerTools();
            permit = (PermissionAPI)tools.get("Privacy");
            new LoginCore(dispatcher, tools, bl, useCLI, null, false);
            return;
        }
        catch (Exception exception) {
            ErrorMgr.error("Init", "uncaught exception", exception);
            return;
        }
    }

    public static void printHelp() {
        System.err.println(String.valueOf(FULL_NAME) + " options:");
        System.err.println("\t-help print this message");
        System.err.println("\t-version print the client version");
        System.err.println("\t-root <directory> set the install directory as the ");
        System.err.println("\t     " + FULL_NAME + " root directory");
        System.err.println("\t-config <directory> set the directory as the " + FULL_NAME);
        String string = System.getProperty("user.home");
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        System.err.println("\t     config directory, " + string + CONFIG_DIR_NAME + " by default");
        System.err.println("\t-autologin login automatically if screen name and password are saved");
        System.err.println("\t-loglevel <level> Set the level of logging information between 1 and " + Log.MAXLEVEL);
        System.err.println("\t     (currently set to " + Log.getLogLevel() + ")");
        System.err.println("\t-nosound turn off all sound effects");
        System.err.println("\t-cli use command line interface - for debugging");
        System.err.println("\t-system print system parameters - for debugging");
    }

    private static void registerHandlers() {
        new ServiceHandler(dispatcher);
        new LocateHandler(dispatcher);
        new BuddyHandler(dispatcher);
        new BosHandler(dispatcher);
        new IcbmHandler(dispatcher);
        new AdminHandler(dispatcher);
        new PopupHandler(dispatcher);
        new InviteHandler(dispatcher);
        new UserLookupHandler(dispatcher);
        new StatsHandler(dispatcher);
        new AdvertHandler(dispatcher);
        new TranslateHandler(dispatcher);
    }

    private static void registerTools() {
        bosCore = new BOSCore(dispatcher, tools, useCLI);
        adminCore = new AdminCore(dispatcher, tools, useCLI);
        adCore = new AdCore(dispatcher, tools);
    }

    public static void setDisconnectReason(int n) {
        config.setValue(DISC_REASON, String.valueOf(n), 0);
        Oscar.saveConfiguration();
    }

    public static int getDisconnectReason() {
        String string = config.getFirstValue(DISC_REASON);
        if (string == null) {
            return 29;
        }
        int n = 29;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        config.deleteKey(DISC_REASON);
        Oscar.saveConfiguration();
        return n;
    }

    public static void logout() {
        bosCore.logout();
    }

    public void shutdown(int n) {
        if (!running) {
            return;
        }
        System.out.println(String.valueOf(FULL_NAME) + " exiting...");
        Oscar.printActiveThreads();
        running = false;
        if (dispatcher != null) {
            dispatcher.shutdown();
        }
        if (tools != null) {
            tools.shutdown();
        }
        if (bosCore != null) {
            bosCore.shutdown();
        }
        Timer.shutdown();
        Oscar.printActiveThreads();
        System.exit(n);
    }

    public void shutdown() {
        this.shutdown(0);
    }

    public static void printActiveThreads() {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        int n = threadGroup.activeCount();
        Log.log(MODULE, Log.DB0, "Active thread count = " + n);
        Thread[] threadArray = new Thread[n * 2];
        threadGroup.enumerate(threadArray, true);
        int n2 = 0;
        while (n2 < threadArray.length && threadArray[n2] != null) {
            try {
                Log.log(MODULE, Log.DB0, String.valueOf(n2) + " " + threadArray[n2]);
            }
            catch (NullPointerException nullPointerException) {
                Log.log(MODULE, Log.DB0, String.valueOf(n2) + " had problems printing");
            }
            ++n2;
        }
    }

    public static String clientProfile() {
        String string = String.valueOf(name) + ", " + JUtil.memAvail(true);
        try {
            Properties properties = System.getProperties();
            string = String.valueOf(string) + ", " + properties.getProperty("os.arch", "") + ", " + properties.getProperty("os.name", "") + ", " + properties.getProperty("os.version", "") + ", " + properties.getProperty("java.vendor", "") + ", " + properties.getProperty("java.version", "") + ", " + properties.getProperty("java.class.version", "");
        }
        catch (SecurityException securityException) {}
        string = String.valueOf(string) + ", " + new Date().toString();
        return string;
    }

    public static void displayVersion() {
        String string = String.valueOf(name) + "\n\n" + JUtil.memAvail(true);
        try {
            Properties properties = System.getProperties();
            string = String.valueOf(string) + "\nmachine " + properties.getProperty("os.arch", "") + "\nos " + properties.getProperty("os.name", "") + "\nos version " + properties.getProperty("os.version", "") + "\njava " + properties.getProperty("java.vendor", "") + "\njava version " + properties.getProperty("java.version", "") + "\njava class version " + properties.getProperty("java.class.version", "");
        }
        catch (SecurityException securityException) {}
        ChoiceUI.newChoiceUI("Version", string);
    }

    public static void displayAbout() {
        ChoiceUI.newChoiceUI("About ", String.valueOf(FULL_NAME) + " brought to you by " + "the " + FULL_NAME + " Java team at AOL:  " + "Harry, Will, Andy, Raksas.");
    }

    public static void addMenuItem(String string, MenuItem menuItem) {
        mainTool.addMenuItem(string, menuItem);
    }

    private static KeyBindings loadConfiguration() {
        String string = System.getProperty("user.home");
        if (string == null) {
            return Oscar.loadConfiguration(String.valueOf(ROOT) + CONFIG_NAME);
        }
        File file = new File(CONFIG_DIR, CONFIG_NAME);
        if (file.exists()) {
            return Oscar.loadConfiguration(file.getPath());
        }
        file = new File(string, ".AIM.cfg");
        if (file.exists()) {
            return Oscar.loadConfiguration(file.getPath());
        }
        return Oscar.loadConfiguration(String.valueOf(ROOT) + CONFIG_NAME);
    }

    private static KeyBindings loadConfiguration(String string) {
        KeyBindings keyBindings;
        configFile = string;
        FileReader fileReader = null;
        KeyBindings keyBindings2 = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            ErrorMgr.warn("Config", "Can't open config file" + string);
        }
        try {
            if (fileReader != null) {
                keyBindings2 = new KeyBindings(fileReader);
            }
        }
        catch (Exception exception) {
            ErrorMgr.warn("Config", "Can't load config file " + string, exception);
        }
        if (keyBindings2 == null) {
            keyBindings2 = new KeyBindings();
        }
        saveConfig = false;
        keyBindings2 = Oscar.updateConfiguration(keyBindings2);
        if (saveConfig) {
            Oscar.saveConfiguration(keyBindings2, string);
        }
        if ((keyBindings = keyBindings2.getKeyBindingsOrAdd(LoginCore.LOGIN_KEY)).getValue(LoginCore.AUTH_PORT_KEY) == null) {
            keyBindings.setValue(LoginCore.AUTH_PORT_KEY, LoginCore.DEFAULT_PORT);
        }
        if (keyBindings.getValue(LoginCore.AUTH_HOST_KEY) == null) {
            keyBindings.setValue(LoginCore.AUTH_HOST_KEY, LoginCore.DEFAULT_AUTHORIZER);
        }
        return keyBindings2;
    }

    private static boolean saveConfiguration(KeyBindings keyBindings, String string) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
        }
        catch (Exception exception) {
            ErrorMgr.warn("config", "Can't open config file " + string + " for writing.");
            return false;
        }
        try {
            keyBindings.write(fileWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ErrorMgr.warn("Config", "Can't save configuration.");
            return false;
        }
        try {
            fileWriter.close();
        }
        catch (Exception exception) {
            ErrorMgr.warn("Config", "Can't close configuration file.");
        }
        return true;
    }

    public static boolean saveConfiguration() {
        return Oscar.saveConfiguration(config, configFile);
    }

    private static KeyBindings updateConfiguration(KeyBindings keyBindings) {
        String string;
        String string2;
        KeyBindings keyBindings2;
        if (keyBindings == null) {
            return keyBindings;
        }
        KeyBindings keyBindings3 = keyBindings.getKeyBindings("Tools");
        if (keyBindings3 != null) {
            int n = keyBindings3.size();
            int n2 = 0;
            while (n2 < n) {
                keyBindings.setValues(keyBindings3.getKeyAt(n2), keyBindings3.getValuesAt(n2));
                ++n2;
            }
            keyBindings.deleteKey("Tools");
            saveConfig = true;
        }
        if ((keyBindings2 = keyBindings.getKeyBindings(LoginCore.LOGIN_KEY)) != null) {
            String string3 = keyBindings2.getValue("authorizer");
            if (string3 != null) {
                keyBindings2.deleteKey("authorizer");
                keyBindings2.setValue(LoginCore.AUTH_HOST_KEY, string3);
                saveConfig = true;
            }
            if ((string3 = keyBindings2.getValue("port")) != null) {
                keyBindings2.deleteKey("port");
                keyBindings2.setValue(LoginCore.AUTH_PORT_KEY, string3);
                saveConfig = true;
            }
            if ((string3 = keyBindings2.getValue("default.authorizer")) != null) {
                keyBindings2.deleteKey("default.authorizer");
                keyBindings2.setValue(LoginCore.DEFAULT_AUTH_HOST_KEY, string3);
                saveConfig = true;
            }
            if ((string3 = keyBindings2.getValue("default.port")) != null) {
                keyBindings2.deleteKey("default.port");
                keyBindings2.setValue(LoginCore.DEFAULT_AUTH_PORT_KEY, string3);
                saveConfig = true;
            }
            if ((string3 = keyBindings2.getValue("authorizer.host")) != null) {
                keyBindings2.deleteKey("authorizer.host");
                keyBindings2.setValue(LoginCore.AUTH_HOST_KEY, string3);
                saveConfig = true;
            }
            if ((string3 = keyBindings2.getValue("default.authorizer.host")) != null) {
                keyBindings2.deleteKey("default.authorizer.host");
                keyBindings2.setValue(LoginCore.DEFAULT_AUTH_HOST_KEY, string3);
                saveConfig = true;
            }
            if ((string3 = keyBindings2.getValue("SOCKS.useDNS")) != null) {
                keyBindings2.deleteKey("SOCKS.useDNS");
                keyBindings2.setValue(SOCKSConnector.USEDNS_KEY, string3);
                saveConfig = true;
            }
        }
        if ((keyBindings2 = keyBindings.getKeyBindings(BuddyCore.BUDDY_PREFS_KEY)) != null) {
            String string4 = keyBindings2.getValue("signonSound");
            if (string4 != null) {
                keyBindings2.deleteKey("signonSound");
                keyBindings2.setValue(BuddyCore.SOUND_LOGON, string4);
                saveConfig = true;
            }
            if ((string4 = keyBindings2.getValue("signoffSound")) != null) {
                keyBindings2.deleteKey("signoffSound");
                keyBindings2.setValue(BuddyCore.SOUND_LOGOFF, string4);
                saveConfig = true;
            }
            if ((string4 = keyBindings2.getValue("logonSound")) != null) {
                keyBindings2.deleteKey("logonSound");
                keyBindings2.setValue(BuddyCore.SOUND_LOGOFF, string4);
                saveConfig = true;
            }
            if ((string4 = keyBindings2.getValue("logoffSound")) != null) {
                keyBindings2.deleteKey("logoffSound");
                keyBindings2.setValue(BuddyCore.SOUND_LOGOFF, string4);
                saveConfig = true;
            }
        }
        if ((keyBindings2 = keyBindings.getKeyBindings(LocateCore.LOCATE_KEY)) != null && (string2 = keyBindings2.getValue("missingProfileWarning")) != null) {
            keyBindings2.deleteKey("missingProfileWarning");
            keyBindings2.setValue(LocateCore.WARNING_KEY, string2);
            saveConfig = true;
        }
        if ((keyBindings2 = keyBindings.getKeyBindings("ICBM")) != null) {
            keyBindings.deleteKey("ICBM");
            keyBindings.setValues(IcbmCore.IM_KEY, keyBindings2);
            saveConfig = true;
            String string5 = keyBindings2.getValue("textFgColor");
            if (string5 != null) {
                keyBindings2.deleteKey("textFgColor");
                keyBindings2.setValue(IcbmCore.FONT_FG_COLOR_KEY, string5);
            }
            if ((string5 = keyBindings2.getValue("textBgColor")) != null) {
                keyBindings2.deleteKey("textBgColor");
                keyBindings2.setValue(IcbmCore.FONT_BG_COLOR_KEY, string5);
            }
            if ((string5 = keyBindings2.getValue("font.name")) != null) {
                keyBindings2.deleteKey("font.name");
                keyBindings2.setValue(IcbmCore.FONT_NAME_KEY, string5);
            }
        }
        if ((string = keyBindings.getValue("Main.browser")) != null) {
            keyBindings.deleteKey("Main");
            keyBindings.setValue("Browser", string);
        }
        return keyBindings;
    }

    public static void setup(Tool tool, int n) {
        if (oscarSetup == null) {
            oscarSetup = new OscarSetup(app, tools, tool, n);
            return;
        }
        oscarSetup.show(tool, n);
        oscarSetup.toFront();
    }

    public void setupDisposed() {
        oscarSetup = null;
    }

    public static void createMediaLocations() {
        String string = File.separator;
        long l = System.currentTimeMillis();
        Log.log(MODULE, Log.DB3, "Starting media scan.");
        try {
            Object object;
            File file;
            File file2 = new File(String.valueOf(ROOT) + "tools");
            String[] stringArray = file2.list();
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                String string2;
                file = new File(file2, stringArray[n]);
                MediaStore.addMedia(String.valueOf(file.getPath()) + string + "aol", "tools/" + stringArray[n], 0);
                object = config.getValue(String.valueOf(stringArray[n]) + ".imagePack");
                if (object != null && !((String)object).equals("aol")) {
                    MediaStore.addMedia(String.valueOf(file.getPath()) + string + (String)object, "tools/" + stringArray[n], 2);
                }
                if ((string2 = config.getValue(String.valueOf(stringArray[n]) + ".soundPack")) != null && !string2.equals("aol")) {
                    MediaStore.addMedia(String.valueOf(file.getPath()) + string + string2, "tools/" + stringArray[n], 1);
                }
                ++n;
            }
            file = new File(String.valueOf(CONFIG_DIR) + "tools");
            object = file.list();
            int n2 = 0;
            while (object != null && n2 < ((String[])object).length) {
                String string3;
                String string4;
                File file3 = new File(file, object[n2]);
                if (file3.isDirectory()) {
                    MediaStore.addMedia(String.valueOf(file3.getPath()) + string + "aol", "tools/" + (String)object[n2], 0);
                }
                if ((string4 = config.getValue(String.valueOf(object[n2]) + ".imagePack")) != null && !string4.equals("aol")) {
                    MediaStore.addMedia(String.valueOf(file3.getPath()) + string + string4, "tools/" + (String)object[n2], 2);
                }
                if ((string3 = config.getValue(String.valueOf(object[n2]) + ".soundPack")) != null && !string3.equals("aol")) {
                    MediaStore.addMedia(String.valueOf(file3.getPath()) + string + string3, "tools/" + (String)object[n2], 1);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        long l2 = System.currentTimeMillis();
        Log.log(MODULE, Log.DB2, "Media scan took " + (double)(l2 - l) / 1000.0 + " seconds.");
    }

    public static String validateNickname(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Oscar.makeValidNickname(string);
        if (string2 != null && string.equals(string2)) {
            return string;
        }
        return null;
    }

    public static String makeValidNickname(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == ' ') {
                string2 = String.valueOf(string2) + c;
                if (c != ' ') {
                    ++n;
                }
            }
            ++n2;
        }
        if (n > 2) {
            return string2;
        }
        return null;
    }

    public static boolean validatePassword(String string) {
        return string != null && string.length() >= 4 && string.length() <= 16;
    }

    static {
        dispatcher = null;
        DISC_REASON = "login.disconnectReason";
        CONFIG_DIR_NAME = ".aim" + File.separator;
        oscarSetup = null;
        bosCore = null;
        adminCore = null;
        adCore = null;
        tools = null;
        mainTool = null;
        permit = null;
        backgroundColor = new Color(192, 192, 192);
        port = -1;
        config = null;
        nickname = "";
        emailAddress = "";
        registrationStatus = -1;
        images = new ImageStore();
        ROOT = "";
        BG_TILE = "Bkgdtile";
        TOOLS_DIR = "tools";
        SHARE_DIR = "share";
        SOUND_DIR = "sounds";
        SOUND_SUFFIX = ".au";
        ERROR_SOUND = "error";
        WARNING_SOUND = "warning";
        SHORT_NAME = "Instant Messenger";
        FULL_NAME = "AOL Instant Messenger (TM)";
        majorVersion = 1;
        buildNumber = 13;
        buildTime = "12/01/97";
        version = String.valueOf(majorVersion) + "." + minorVersion;
        build = String.valueOf(buildNumber < 10 ? ".0" : ".") + buildNumber;
        name = String.valueOf(FULL_NAME) + " version " + version + build + " for Java built " + buildTime;
    }
}

