/*
 * Decompiled with CFR 0.152.
 */
package main;

import component.AdminTool;
import component.BuddyCore;
import component.CLIUI;
import component.IcbmCore;
import component.LocateCore;
import component.MainTool;
import component.Permission;
import component.PopupCore;
import component.Tools;
import component.TranslateUrlListener;
import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import main.AdConstants;
import main.AdminAPI;
import main.AdminCLI;
import main.BOSServerAPI;
import main.BuddyAPI;
import main.CallbackData;
import main.ClientDispatcher;
import main.GenericFLAPSockOpener;
import main.IcbmAPI;
import main.InviteAPI;
import main.LocateAPI;
import main.LoginCore;
import main.MainAPI;
import main.MissedIcbm;
import main.Nickname;
import main.Oscar;
import main.PermissionAPI;
import main.Permissions;
import main.PopupAPI;
import main.Rate;
import main.RateMonitor;
import main.Redirect;
import main.SnacConnectionHandler;
import main.StatEvent;
import main.UIAPI;
import snac.BosHandler;
import snac.BosListener;
import snac.BuddyHandler;
import snac.BuddyListener;
import snac.IcbmHandler;
import snac.IcbmListener;
import snac.InviteHandler;
import snac.InviteListener;
import snac.Listener;
import snac.LocateHandler;
import snac.LocateListener;
import snac.PopupListener;
import snac.ReqID;
import snac.ServiceHandler;
import snac.ServiceListener;
import snac.SnacConstants;
import snac.SnacIcbmCookie;
import snac.SnacIcbmMissedCall;
import snac.SnacNickname;
import snac.SnacNicknameWinfo;
import snac.SnacRateClassMembers;
import snac.SnacRateParameters;
import snac.SnacTlv;
import snac.SnacVersion;
import snac.StatsHandler;
import snac.StatsListener;
import snac.TLV;
import snac.TranslateHandler;
import snac.TranslateListener;
import snac.UserLookupHandler;
import snac.UserLookupListener;
import uiutil.ChoiceUI;
import uiutil.ErrorMgr;
import uiutil.IUtil;
import uiutil.UrlViewer;
import util.InputBuffer;
import util.JUtil;
import util.Log;
import util.OutputBuffer;
import util.Timer;
import util.TimerEvent;
import util.TimerListener;

public class BOSCore
extends SnacConnectionHandler
implements BOSServerAPI,
Listener,
ServiceListener,
BuddyListener,
BosListener,
LocateListener,
IcbmListener,
PopupListener,
InviteListener,
UserLookupListener,
AdConstants,
StatsListener,
TimerListener,
TranslateListener {
    private ClientDispatcher dispatcher;
    private Tools tools;
    private boolean useCLI;
    private MainAPI main;
    private BuddyAPI buddy;
    private PermissionAPI perm;
    private LocateAPI locate;
    private IcbmAPI icbm;
    private AdminAPI admin;
    private PopupAPI popup;
    private InviteAPI invite;
    private Vector bosTools;
    private Vector onlineWaitList;
    private int[] families;
    private Vector familyVersions;
    private FLAPSock bos;
    private Permissions lastPermission;
    private boolean bosCloseExpected = false;
    private boolean migrating = false;
    private FLAPSock pendingBos;
    private boolean initingService = false;
    private boolean initingBOS = false;
    private boolean initingBuddy = false;
    private boolean initingLocate = false;
    private boolean initingIcbm = false;
    private boolean initingAdmin = false;
    private boolean firstConnection = true;
    private int maxChannels;
    private int idleTime;
    public static int ModifyPermissions;
    public static int RequestService;
    public static int SetSignature;
    public static int GetUserSignature;
    public static int ModifyBuddyList;
    public static int SendMessage;
    public static int SendEvil;
    private static int GC_TIME;
    private static int IDLE_TIME;
    private static int CLEAR_CHECK_TIME;
    private static int NOOP_TIME;
    private static int GC_EVENT;
    private static int RATE_CLEAR_CHECK_EVENT;
    private static int IDLE_EVENT;
    private static int NOOP_EVENT;
    private static int REPORT_STATS_EVENT;
    private TimerEvent idleTimerEvent;
    private static int MIN_IDLE_TIME;
    private static int MOTD_CHOICE;
    private static int REG_EMAIL_CHOICE;
    private static final String MODULE = "BOS";
    private Vector stats;
    private TimerEvent reportStatsEvent;
    private int statReportInterval = 1200;
    static String[] bosErrors;
    static String[] icbmErrors;
    private static int whisc_item_capabilities;
    private static int capability_version;
    private static int whisc_capability_text;
    private static int whisc_item_im_text;
    private static int im_text_version;
    private static int intl_encode_ascii;
    private static int intl_language_english;

    BOSCore(ClientDispatcher clientDispatcher, Tools tools, boolean bl) {
        this.dispatcher = clientDispatcher;
        this.tools = tools;
        this.useCLI = bl;
        if (bl) {
            this.bosTools = new Vector(1);
            CLIUI cLIUI = new CLIUI(this, tools);
            this.main = cLIUI;
            this.perm = cLIUI;
            this.buddy = cLIUI;
            this.locate = cLIUI;
            this.icbm = cLIUI;
            this.popup = cLIUI;
            this.invite = cLIUI;
            this.bosTools.addElement(cLIUI);
        } else {
            this.bosTools = new Vector(5);
            this.buddy = new BuddyCore(this, tools);
            this.bosTools.addElement(this.buddy);
            this.locate = new LocateCore(this, tools);
            this.bosTools.addElement(this.locate);
            this.icbm = new IcbmCore(this, tools);
            this.bosTools.addElement(this.icbm);
            this.perm = new Permission(this, tools);
            this.bosTools.addElement(this.perm);
            this.admin = new AdminTool(this, tools);
            this.popup = new PopupCore(this, tools);
            this.bosTools.addElement(this.popup);
            this.main = new MainTool(this, tools);
            this.bosTools.addElement(this.main);
            this.invite = (InviteAPI)((Object)this.main);
            if (Oscar.config.getValue("debug.experimentalFoodGroups") != null) {
                Log.log(MODULE, Log.DB0, "Experimental food groups enabled");
            }
        }
        this.bos = null;
        this.lastPermission = null;
        this.stats = new Vector();
        clientDispatcher.registerListener(1, 1, this);
        clientDispatcher.registerListener(3, 1, this);
        clientDispatcher.registerListener(9, 1, this);
        clientDispatcher.registerListener(2, 1, this);
        clientDispatcher.registerListener(4, 1, this);
        clientDispatcher.registerListener(8, 1, this);
        clientDispatcher.registerListener(6, 1, this);
        clientDispatcher.registerListener(10, 1, this);
        if (Oscar.config.getValue("debug.experimentalFoodGroups") != null) {
            clientDispatcher.registerListener(12, 1, this);
        }
        this.onlineWaitList = new Vector();
        if (Oscar.config.getValue("debug.noexplicitgc") == null) {
            Timer.createEvent("System", this, GC_EVENT, null, GC_TIME);
        }
        Timer.createEvent("System", this, NOOP_EVENT, null, NOOP_TIME);
    }

    private int[] getFamilies() {
        if (this.families == null) {
            if (Oscar.config.getValue("debug.experimentalFoodGroups") != null) {
                this.families = new int[10];
                this.families[9] = 12;
            } else {
                this.families = new int[9];
            }
            this.families[0] = 1;
            this.families[1] = 9;
            this.families[2] = 3;
            this.families[3] = 4;
            this.families[4] = 2;
            this.families[5] = 8;
            this.families[6] = 6;
            this.families[7] = 10;
            this.families[8] = 11;
        }
        return this.families;
    }

    private Vector getFamilyVersions() {
        if (this.familyVersions == null) {
            int n = 1;
            this.familyVersions = new Vector();
            this.familyVersions.addElement(new SnacVersion(1, 1, 1, n));
            this.familyVersions.addElement(new SnacVersion(9, 1, this.perm.id(), this.perm.version()));
            this.familyVersions.addElement(new SnacVersion(3, 1, this.buddy.id(), this.buddy.version()));
            this.familyVersions.addElement(new SnacVersion(4, 1, this.icbm.id(), this.icbm.version()));
            this.familyVersions.addElement(new SnacVersion(2, 1, this.locate.id(), this.locate.version()));
            this.familyVersions.addElement(new SnacVersion(8, 1, this.popup.id(), this.popup.version()));
            this.familyVersions.addElement(new SnacVersion(6, 1, this.invite.id(), this.invite.version()));
            this.familyVersions.addElement(new SnacVersion(10, 1, this.invite.id(), this.invite.version()));
            int n2 = 1;
            this.familyVersions.addElement(new SnacVersion(11, 1, 1, n2));
            if (Oscar.config.getValue("debug.experimentalFoodGroups") != null) {
                int n3 = 1;
                this.familyVersions.addElement(new SnacVersion(12, 1, 1, n3));
            }
        }
        return this.familyVersions;
    }

    public void timerEvent(String string, int n, Object object) {
        if (n == GC_EVENT) {
            Runtime runtime = Runtime.getRuntime();
            String string2 = "GC free " + runtime.freeMemory() + " total " + runtime.totalMemory();
            runtime.gc();
            Log.log(MODULE, Log.DB0, String.valueOf(string2) + " after: free " + runtime.freeMemory() + " total " + runtime.totalMemory());
            Timer.createEvent("System", this, GC_EVENT, null, GC_TIME);
            return;
        }
        if (n == RATE_CLEAR_CHECK_EVENT) {
            RateMonitor rateMonitor = (RateMonitor)object;
            if (!rateMonitor.limited) {
                return;
            }
            int n2 = rateMonitor.getRateNow(System.currentTimeMillis());
            if (n2 > rateMonitor.params.clearThreshold) {
                rateMonitor.limited = false;
                this.setEnabled(true);
                return;
            }
            Timer.createEvent("System", this, RATE_CLEAR_CHECK_EVENT, rateMonitor, CLEAR_CHECK_TIME);
            return;
        }
        if (n == IDLE_EVENT) {
            int n3 = IUtil.getIdleTime();
            if (this.idleTime > n3) {
                this.setIdleTime(0);
            } else if (n3 > MIN_IDLE_TIME) {
                this.setIdleTime(n3);
            }
            this.idleTimerEvent = Timer.createEvent("System", this, IDLE_EVENT, null, IDLE_TIME);
            return;
        }
        if (n == NOOP_EVENT) {
            if (this.bos != null) {
                ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
                serviceHandler.noop(this.bos, this, null);
            }
            Timer.createEvent("System", this, NOOP_EVENT, null, NOOP_TIME);
            return;
        }
        if (n == REPORT_STATS_EVENT) {
            this.reportStats(false);
        }
    }

    public void shutdown() {
        this.bosCloseExpected = true;
        if (this.bos != null) {
            this.bos.close();
        }
    }

    private void updateUserInfo(Nickname nickname) {
        if (Nickname.normalize(nickname.nickname).equals(Oscar.nickname)) {
            Oscar.nickname = nickname.nickname;
        }
        this.main.updateUserInfo(nickname);
        this.buddy.updateUserInfo(nickname);
        this.locate.updateUserInfo(nickname);
        this.icbm.updateUserInfo(nickname);
    }

    private void updateUserEvil(String string, int n) {
        this.main.updateUserEvil(string, n);
        this.buddy.updateUserEvil(string, n);
        this.locate.updateUserEvil(string, n);
        this.icbm.updateUserEvil(string, n);
    }

    private void updateRates() {
        this.main.updateRate();
        this.buddy.updateRate();
        this.locate.updateRate();
        this.icbm.updateRate();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void requestTimedOut(Object object) {
        if (object == null) {
            return;
        }
        CallbackData callbackData = (CallbackData)object;
        if (callbackData.responseExpected) {
            this.warn(object, "The server is not responding", null);
        }
    }

    public void logout() {
        this.bosCloseExpected = true;
        if (this.bos != null) {
            if (this.bos.okToSendData()) {
                this.bos.sendSignOff(null);
            }
            this.bos.close();
        }
        Oscar.adCore.flush();
        this.reconnect("Come back soon.");
    }

    private void reconnect(String string) {
        this.bos = null;
        this.pendingBos = null;
        this.setEnabled(false);
        this.disconnect();
        new LoginCore(this.dispatcher, this.tools, false, this.useCLI, string, true);
    }

    public boolean connectionSignOff(FLAPSock fLAPSock, TLV tLV, boolean bl) {
        if (fLAPSock != this.bos) {
            return false;
        }
        fLAPSock.closeExpected(true);
        this.bosCloseExpected = true;
        if (tLV.tlvTypePresent(9)) {
            int n = tLV.getTlvDataAsU16(9);
            tLV.getTlvDataAsString(11);
            if (n == 1) {
                Oscar.setDisconnectReason(21);
                this.reconnect("You have been disconnected because you logged in from another machine.");
            } else if (n == 2) {
                Oscar.setDisconnectReason(21);
                this.reconnect("You have been disconnected because your account has been deleted");
            } else {
                Oscar.setDisconnectReason(29);
                this.reconnect("You have been disconnected by the host for unknown reason " + n);
            }
            return true;
        }
        Oscar.setDisconnectReason(29);
        this.reconnect("You have been disconnected by the host for an unknown reason");
        return true;
    }

    public boolean connectionClosed(FLAPSock fLAPSock, boolean bl, String string, int n, boolean bl2) {
        if (fLAPSock != this.bos && fLAPSock != this.pendingBos) {
            return false;
        }
        Oscar.setDisconnectReason(n);
        if (this.bosCloseExpected && bl) {
            this.bosCloseExpected = false;
            return true;
        }
        this.reconnect("Lost connection to server, caused by " + string + ".");
        return true;
    }

    public void setPendingBos(FLAPSock fLAPSock) {
        this.pendingBos = fLAPSock;
    }

    public int snacError(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        String string = tLV.getTlvDataAsString(4);
        int n3 = -1;
        if (tLV.tlvTypePresent(8)) {
            n3 = tLV.getTlvDataAsU16(8);
        }
        CallbackData callbackData = (CallbackData)object;
        if ((n2 == 4 || n2 == 16) && callbackData != null && (callbackData.snacGroup == 2 && callbackData.subType == 5 || callbackData.snacGroup == 4 && callbackData.subType == 6)) {
            String string2 = callbackData.to;
            ChoiceUI.newChoiceUI(this, SnacConnectionHandler.BORING_CHOICE, null, "Not logged in", String.valueOf(string2) + " is not logged in", "OK", null, null, Oscar.WARNING_SOUND);
        } else if (n2 == 13 && callbackData != null && callbackData.snacGroup == 4 && callbackData.subType == 8) {
            String string3 = callbackData.to;
            String string4 = "Sorry, you can't warn" + string3;
            if (n3 == 1) {
                string4 = String.valueOf(string4) + " because they have not communicated with you recently";
            } else if (n3 == 2) {
                string4 = String.valueOf(string4) + " because you have been warned too many times";
            }
            ChoiceUI.newChoiceUI(this, SnacConnectionHandler.BORING_CHOICE, null, "WARN", string4, "OK", null, null, Oscar.WARNING_SOUND);
        } else if (n2 == 20 && callbackData != null && callbackData.snacGroup == 10 && callbackData.subType == 2 && callbackData.to != null) {
            this.invite.notAMember(callbackData.to, callbackData.data);
        } else if (n2 == 13 && callbackData != null && callbackData.snacGroup == 6 && callbackData.subType == 2 && callbackData.to != null) {
            this.invite.isMemberButDeclinesToRevealNickname(callbackData.to, callbackData.data);
        } else if (n2 == 22 && callbackData != null && callbackData.snacGroup == 6 && callbackData.subType == 2 && callbackData.to != null) {
            this.getNicknameByEmailInternal(callbackData.to, true, callbackData.data);
        } else if (n2 == 15 && callbackData != null && callbackData.snacGroup == 6 && callbackData.subType == 2 && callbackData.to != null) {
            this.warn(object, "Invite is only available to users who have sent back the confirmation email sent when they registered", null);
        } else {
            this.warn(object, this.lookup(SnacConnectionHandler.generalErrors, n2), string);
        }
        if (callbackData != null && callbackData.snacGroup == 4 && callbackData.subType == 6) {
            this.icbm.clearSend((byte[])callbackData.data);
        }
        return 1;
    }

    public void choiceMade(int n, int n2, Object object) {
        if (n == MOTD_CHOICE) {
            if (n2 == 0) {
                String string = (String)object;
                new UrlViewer(string);
                return;
            }
        } else if (n == REG_EMAIL_CHOICE) {
            if (n2 == 0) {
                ((AdminTool)this.tools.get(AdminTool.NAME)).requestAccountConfirmation();
                return;
            }
        } else {
            super.choiceMade(n, n2, object);
        }
    }

    public void requestService(UIAPI uIAPI, String string, Vector vector) {
        int n = -1;
        if (string.equals("admin")) {
            n = 7;
        } else if (string.equals("ad")) {
            n = 5;
        } else {
            return;
        }
        CallbackData callbackData = new CallbackData(string, false, true, 1, 4, "connect to the " + string + " server", uIAPI);
        ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
        TLV tLV = new TLV(0);
        serviceHandler.serviceRequest(this.bos, this, callbackData, n, tLV);
    }

    public int serviceHostOnline(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        if (this.bos == null && this.compareGroups(nArray, this.getFamilies()) > 0) {
            this.bos = fLAPSock;
            this.pendingBos = null;
            this.lastPermission = null;
            this.connect();
            int n2 = 0;
            while (n2 < this.bosTools.size()) {
                this.onlineWaitList.addElement(this.bosTools.elementAt(n2));
                ++n2;
            }
            this.onlineWaitList.addElement("service");
            this.onlineWaitList.addElement("bos");
            this.doneIniting(this.main);
            this.doneIniting(this.perm);
            this.doneIniting(this.popup);
            Log.log(MODULE, Log.DB0, "BOSCore::serviceHostOnline() start :" + this.onlineWaitList);
            this.initingService = true;
            ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
            CallbackData callbackData = new CallbackData(null, true, true, 1, 6, "retrieve the rate parameters", null);
            serviceHandler.rateParamsQuery(this.bos, this, callbackData);
            this.setReportStatsTimer();
            return 1;
        }
        return 0;
    }

    public void setPrivacy() {
        long l = 0L;
        if (this.perm.getPublishIdleTime()) {
            l |= 1L;
        }
        if (this.perm.getPublishMemberSince()) {
            l |= 2L;
        }
        try {
            OutputBuffer outputBuffer = new OutputBuffer(4);
            outputBuffer.writeInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
            CallbackData callbackData = new CallbackData(null, true, false, 1, 20, "set your privacy information", null);
            ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
            serviceHandler.setPrivacyFlags(this.bos, this, callbackData, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn(this.toString(), "trouble setting privacy flags", iOException);
            return;
        }
    }

    public int serviceServiceResponse(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        CallbackData callbackData = (CallbackData)object;
        Redirect redirect = new Redirect(tLV);
        if (redirect.failCode > 0 || redirect.fail != null || redirect.host == null) {
            String string = "";
            if (redirect.fail != null) {
                string = "more info";
            }
        } else {
            String string = callbackData.to;
            if (string != null && string.equalsIgnoreCase("admin")) {
                AdminAPI adminAPI = (AdminAPI)callbackData.data;
                Oscar.adminCore.installUI(adminAPI);
                new GenericFLAPSockOpener(string, adminAPI, redirect.getHost(), redirect.getPort(), redirect.getCookie(), this.dispatcher);
            } else if (string != null && string.equalsIgnoreCase("ad")) {
                new GenericFLAPSockOpener(string, Oscar.adCore, redirect.getHost(), redirect.getPort(), redirect.getCookie(), this.dispatcher);
            }
        }
        return 1;
    }

    public int serviceRateParamsReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector, Vector vector2) {
        Object object2;
        SnacConstants snacConstants;
        if (fLAPSock != this.bos) {
            return 0;
        }
        int[] nArray = new int[vector.size()];
        Vector<RateMonitor> vector3 = new Vector<RateMonitor>(vector.size());
        int n3 = 0;
        while (n3 < vector.size()) {
            snacConstants = (SnacRateParameters)vector.elementAt(n3);
            nArray[n3] = ((SnacRateParameters)snacConstants).id;
            object2 = (SnacRateClassMembers)vector2.elementAt(n3);
            vector3.addElement(new RateMonitor((SnacRateParameters)snacConstants, (SnacRateClassMembers)object2, fLAPSock.connectTime));
            ++n3;
        }
        fLAPSock.userData = vector3;
        this.updateRates();
        snacConstants = (ServiceHandler)this.dispatcher.getHandler(1);
        object2 = new CallbackData(null, true, false, 1, 8, "subscribe to rate changes", null);
        ((ServiceHandler)snacConstants).rateAddParamSub(this.bos, this, object2, nArray);
        if (this.initingService) {
            this.setPrivacy();
            object2 = new CallbackData(null, true, true, 1, 14, "retrieve your account information", null);
            ((ServiceHandler)snacConstants).nickInfoQuery(this.bos, this, object2);
            this.initingService = false;
            this.doneIniting("service");
            if (!this.migrating) {
                this.requestService(Oscar.adCore, "ad", null);
            }
            this.initingBOS = true;
            BosHandler bosHandler = (BosHandler)this.dispatcher.getHandler(9);
            object2 = new CallbackData(null, true, true, 9, 2, "retrieve the system privaledges", null);
            bosHandler.rightsQuery(this.bos, this, object2);
            this.initingBuddy = true;
            BuddyHandler buddyHandler = (BuddyHandler)this.dispatcher.getHandler(3);
            object2 = new CallbackData(null, true, true, 3, 2, "retrieve the buddy list rights", null);
            buddyHandler.rightsQuery(this.bos, this, object2);
            this.initingLocate = true;
            LocateHandler locateHandler = (LocateHandler)this.dispatcher.getHandler(2);
            object2 = new CallbackData(null, true, true, 2, 2, "retrieve the locate rights", null);
            locateHandler.rightsQuery(this.bos, this, object2);
            this.initingIcbm = true;
            IcbmHandler icbmHandler = (IcbmHandler)this.dispatcher.getHandler(4);
            object2 = new CallbackData(null, true, true, 4, 4, "retrieve the icbm parameters", null);
            icbmHandler.parameterQuery(this.bos, this, object2);
        }
        return 1;
    }

    public int serviceRateParamChange(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        if (n2 == 3) {
            this.setEnabled(false);
            if (this.onlineWaitList != null && this.onlineWaitList.size() > 0) {
                fLAPSock.close();
                ErrorMgr.warn("Rate", "You were disconnected while signing on.  This is probably because you have been warned too many times.  Wait a while and try signing on again.");
            } else {
                ErrorMgr.warn("Rate", "You are temporarily disabled because you are sending messages too fast.  You will be turned back on when the rate meter reaches green");
            }
        }
        Vector vector2 = (Vector)fLAPSock.userData;
        int n3 = 0;
        while (vector != null && n3 < vector.size()) {
            SnacRateParameters snacRateParameters = (SnacRateParameters)vector.elementAt(n3);
            RateMonitor rateMonitor = RateMonitor.getByClass(vector2, snacRateParameters.id);
            if (rateMonitor != null) {
                rateMonitor.params = snacRateParameters;
                if (n2 == 3 && !rateMonitor.limited) {
                    rateMonitor.limited = true;
                    Timer.createEvent("System", this, RATE_CLEAR_CHECK_EVENT, rateMonitor, CLEAR_CHECK_TIME);
                }
            }
            ++n3;
        }
        this.updateRates();
        return 1;
    }

    private RateMonitor findWorstRate(RateMonitor[] rateMonitorArray, int[] nArray) {
        int n;
        if (rateMonitorArray == null || rateMonitorArray.length < 1 || nArray == null || rateMonitorArray.length != nArray.length) {
            return null;
        }
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n4 < rateMonitorArray.length) {
            if (nArray[n4] <= rateMonitorArray[n4].params.disconnectThreshold && (n = rateMonitorArray[n4].params.disconnectThreshold - nArray[n4]) < n3) {
                n2 = n4;
                n3 = n;
            }
            ++n4;
        }
        if (n2 != -1) {
            return rateMonitorArray[n2];
        }
        n4 = 0;
        while (n4 < rateMonitorArray.length) {
            if (nArray[n4] <= rateMonitorArray[n4].params.limitThreshold && (n = rateMonitorArray[n4].params.limitThreshold - nArray[n4]) < n3) {
                n2 = n4;
                n3 = n;
            }
            ++n4;
        }
        if (n2 != -1) {
            return rateMonitorArray[n2];
        }
        n4 = 0;
        while (n4 < rateMonitorArray.length) {
            if (nArray[n4] <= rateMonitorArray[n4].params.alertThreshold && (n = rateMonitorArray[n4].params.alertThreshold - nArray[n4]) < n3) {
                n2 = n4;
                n3 = n;
            }
            ++n4;
        }
        if (n2 != -1) {
            return rateMonitorArray[n2];
        }
        n4 = 0;
        while (n4 < rateMonitorArray.length) {
            if (nArray[n4] <= rateMonitorArray[n4].params.clearThreshold && (n = rateMonitorArray[n4].params.clearThreshold - nArray[n4]) < n3) {
                n2 = n4;
                n3 = n;
            }
            ++n4;
        }
        if (n2 != -1) {
            return rateMonitorArray[n2];
        }
        n4 = 0;
        while (n4 < rateMonitorArray.length) {
            if (nArray[n4] < n3) {
                n2 = n4;
                n3 = nArray[n4];
            }
            ++n4;
        }
        return rateMonitorArray[n2];
    }

    public Rate getRate(int n, long l) {
        RateMonitor rateMonitor;
        if (this.bos == null || this.bos.userData == null) {
            return null;
        }
        Rate rate = null;
        if (n == ModifyPermissions) {
            RateMonitor[] rateMonitorArray = new RateMonitor[5];
            int[] nArray = new int[5];
            rateMonitorArray[0] = RateMonitor.getByMsg((Vector)this.bos.userData, 9, 5);
            nArray[0] = rateMonitorArray[0].getRateNow(l);
            rateMonitorArray[1] = RateMonitor.getByMsg((Vector)this.bos.userData, 9, 6);
            nArray[1] = rateMonitorArray[1].getRateNow(l);
            rateMonitorArray[2] = RateMonitor.getByMsg((Vector)this.bos.userData, 9, 7);
            nArray[2] = rateMonitorArray[2].getRateNow(l);
            rateMonitorArray[3] = RateMonitor.getByMsg((Vector)this.bos.userData, 9, 8);
            nArray[3] = rateMonitorArray[3].getRateNow(l);
            rateMonitorArray[4] = RateMonitor.getByMsg((Vector)this.bos.userData, 9, 4);
            nArray[4] = rateMonitorArray[4].getRateNow(l);
            RateMonitor rateMonitor2 = this.findWorstRate(rateMonitorArray, nArray);
            if (rateMonitor2 != null) {
                rate = new Rate(rateMonitor2, rateMonitor2.getRateNow(l));
            }
        } else if (n == RequestService) {
            RateMonitor rateMonitor3 = RateMonitor.getByMsg((Vector)this.bos.userData, 1, 4);
            if (rateMonitor3 != null) {
                rate = new Rate(rateMonitor3, rateMonitor3.getRateNow(l));
            }
        } else if (n == SetSignature) {
            RateMonitor rateMonitor4 = RateMonitor.getByMsg((Vector)this.bos.userData, 2, 4);
            if (rateMonitor4 != null) {
                rate = new Rate(rateMonitor4, rateMonitor4.getRateNow(l));
            }
        } else if (n == GetUserSignature) {
            RateMonitor rateMonitor5 = RateMonitor.getByMsg((Vector)this.bos.userData, 2, 5);
            if (rateMonitor5 != null) {
                rate = new Rate(rateMonitor5, rateMonitor5.getRateNow(l));
            }
        } else if (n == ModifyBuddyList) {
            RateMonitor[] rateMonitorArray = new RateMonitor[2];
            int[] nArray = new int[2];
            rateMonitorArray[0] = RateMonitor.getByMsg((Vector)this.bos.userData, 3, 4);
            nArray[0] = rateMonitorArray[0].getRateNow(l);
            rateMonitorArray[1] = RateMonitor.getByMsg((Vector)this.bos.userData, 3, 5);
            nArray[1] = rateMonitorArray[1].getRateNow(l);
            RateMonitor rateMonitor6 = this.findWorstRate(rateMonitorArray, nArray);
            if (rateMonitor6 != null) {
                rate = new Rate(rateMonitor6, rateMonitor6.getRateNow(l));
            }
        } else if (n == SendMessage) {
            RateMonitor rateMonitor7 = RateMonitor.getByMsg((Vector)this.bos.userData, 4, 6);
            if (rateMonitor7 != null) {
                rate = new Rate(rateMonitor7, rateMonitor7.getRateNow(l));
            }
        } else if (n == SendEvil && (rateMonitor = RateMonitor.getByMsg((Vector)this.bos.userData, 4, 8)) != null) {
            rate = new Rate(rateMonitor, rateMonitor.getRateNow(l));
        }
        return rate;
    }

    private void connect() {
        this.idleTimerEvent = Timer.createEvent("System", this, IDLE_EVENT, null, IDLE_TIME);
        int n = 0;
        while (n < this.bosTools.size()) {
            UIAPI uIAPI = (UIAPI)this.bosTools.elementAt(n);
            uIAPI.connect();
            ++n;
        }
    }

    private void disconnect() {
        if (this.idleTimerEvent != null) {
            Timer.removeEvent(this.idleTimerEvent);
            this.idleTimerEvent = null;
        }
        int n = 0;
        while (n < this.bosTools.size()) {
            UIAPI uIAPI = (UIAPI)this.bosTools.elementAt(n);
            uIAPI.disconnect();
            ++n;
        }
    }

    private void setEnabled(boolean bl) {
        int n = 0;
        while (n < this.bosTools.size()) {
            UIAPI uIAPI = (UIAPI)this.bosTools.elementAt(n);
            uIAPI.setEnabled(bl);
            ++n;
        }
    }

    public int servicePause(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        if (nArray == null || nArray.length == 0 || this.compareGroups(nArray, this.getFamilies()) == 2) {
            this.setEnabled(false);
            fLAPSock.closeExpected(true);
            CallbackData callbackData = new CallbackData(null, true, false, 1, 12, "acknowledge a pause request", null);
            ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
            serviceHandler.pauseAck(this.bos, this, callbackData, this.getFamilies());
        } else {
            this.bifurcationNotSupported("pause", reqID);
        }
        return 1;
    }

    public int serviceResume(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        if (nArray == null || nArray.length == 0 || this.compareGroups(nArray, this.getFamilies()) == 2) {
            fLAPSock.closeExpected(false);
            this.setEnabled(true);
        } else {
            this.bifurcationNotSupported("resume", reqID);
        }
        return 1;
    }

    public int serviceNickInfoReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacNicknameWinfo snacNicknameWinfo) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        Nickname nickname = new Nickname(snacNicknameWinfo);
        Oscar.nickname = nickname.nickname;
        this.updateUserInfo(nickname);
        if (nickname.isDT) {
            this.firstConnection = false;
            Log.log("Login: You are a trial user.  In order to fully enjoy " + Oscar.FULL_NAME + " you must return the email " + "sent to you when you registered.");
            ChoiceUI.newChoiceUI(this, REG_EMAIL_CHOICE, null, "Login", "You are a trial user. To access all the features of " + Oscar.FULL_NAME + ", you must return the e-mail " + "sent to you when you registered. If you would like to " + "receive another copy of the registration e-mail, click " + "on the 'Resend' button below.", "Resend", "Cancel", null, Oscar.WARNING_SOUND);
        }
        return 1;
    }

    public int serviceEvilNotification(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        Nickname nickname = null;
        if (vector != null && vector.size() == 1) {
            SnacNicknameWinfo snacNicknameWinfo = (SnacNicknameWinfo)vector.elementAt(0);
            nickname = new Nickname(snacNicknameWinfo);
            this.updateUserInfo(nickname);
        }
        this.main.setLocalUserEvil(n2, nickname);
        this.updateUserEvil(Oscar.nickname, n2);
        return 1;
    }

    public int serviceMigrateGroups(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, int[] nArray, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        if (nArray == null || nArray.length == 0 || this.compareGroups(nArray, this.getFamilies()) == 2) {
            Redirect redirect = new Redirect(tLV);
            if (redirect.fail != null || redirect.host == null) {
                if (redirect.fail != null) {
                    ErrorMgr.error(this.toString(), redirect.fail);
                } else {
                    ErrorMgr.error(this.toString(), "migrate rejected");
                }
            } else {
                this.bos = null;
                if (redirect.port == Redirect.undefinedPort) {
                    redirect.port = Oscar.port;
                }
                this.bosCloseExpected = true;
                this.migrating = true;
                fLAPSock.migrate(redirect.host, redirect.port, new String(redirect.cookie));
                fLAPSock.closeExpected(false);
                this.bosCloseExpected = false;
            }
        } else {
            this.bifurcationNotSupported("migration", reqID);
        }
        return 1;
    }

    private void bifurcationNotSupported(String string, ReqID reqID) {
        CallbackData callbackData = new CallbackData(null, true, false, 1, 1, "report a " + string + " error", null);
        ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
        serviceHandler.snacError(this.bos, this, callbackData, reqID, 9, null);
    }

    public int serviceMotd(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        String string = tLV.getTlvDataAsString(11);
        if (n2 == 4) {
            this.main.setTopOfTheWorld(string);
        } else {
            String string2 = "";
            if (n2 == 1) {
                string2 = "This client is no longer able to connect to the server, you will need to upgrade the client.";
            } else if (n2 == 2) {
                string2 = "There is a new version of this client available it will be necessary to upgrade shortly.";
            } else if (n2 == 3) {
                string2 = "System Bulletin";
            }
            ChoiceUI.newChoiceUI(this, MOTD_CHOICE, string, "System Alert", string2, "more info", "Cancel", null, Oscar.WARNING_SOUND);
        }
        return 1;
    }

    public int serviceWellKnownUrls(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        System.err.println("BOSCore:serviceWellKnownUrls is not written yet!");
        return 0;
    }

    public int serviceNoop(FLAPSock fLAPSock, Object object, ReqID reqID, int n) {
        return 1;
    }

    synchronized void doneIniting(Object object) {
        Log.log(MODULE, Log.INFO, "BOSCore::doneIniting() :" + this.onlineWaitList);
        if (!this.onlineWaitList.removeElement(object)) {
            Log.log(MODULE, Log.NOTICE, "BOSCore::doneIniting() unhappy.");
            ErrorMgr.warn(this.toString(), String.valueOf(object.toString()) + " sent doneIniting() while not on waitlist");
            return;
        }
        if (this.onlineWaitList.size() == 0) {
            Log.log(MODULE, Log.INFO, "Sending client online.");
            CallbackData callbackData = new CallbackData(null, true, false, 1, 2, "tell the server that the client is ready to go online", null);
            ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
            serviceHandler.clientOnline(this.bos, this, callbackData, this.getFamilyVersions());
            this.migrating = false;
            this.setEnabled(true);
        }
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    private void setIdleTime(int n) {
        if (n == 0 && this.idleTime > 0 || n > 0 && this.idleTime == 0) {
            Log.log(MODULE, Log.DB2, "Sending idle time = " + n);
            CallbackData callbackData = new CallbackData(null, false, false, 1, 17, "set our idle time", null);
            ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
            serviceHandler.idleNotification(this.bos, this, callbackData, n);
        }
        this.idleTime = n;
    }

    public void addBuddies(String[] stringArray) {
        CallbackData callbackData = new CallbackData(null, false, false, 3, 4, "add buddies to the buddy list", stringArray);
        BuddyHandler buddyHandler = (BuddyHandler)this.dispatcher.getHandler(3);
        buddyHandler.addBuddies(this.bos, this, callbackData, this.snacNicknameArray(stringArray));
    }

    public void deleteBuddies(String[] stringArray) {
        CallbackData callbackData = new CallbackData(null, false, false, 3, 5, "remove buddies from the buddy list", null);
        BuddyHandler buddyHandler = (BuddyHandler)this.dispatcher.getHandler(3);
        buddyHandler.delBuddies(this.bos, this, callbackData, this.snacNicknameArray(stringArray));
    }

    public int buddyRightsReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        int n2 = 10;
        if (tLV.tlvTypePresent(1)) {
            n2 = tLV.getTlvDataAsU16(1);
        }
        this.buddy.setMaxBuddies(n2);
        if (this.initingBuddy) {
            String[] stringArray = this.buddy.getBuddyList();
            if (stringArray.length > 0) {
                this.addBuddies(stringArray);
            }
            this.initingBuddy = false;
            this.doneIniting(this.buddy);
        }
        return 1;
    }

    public int buddyWatcherListResponse(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        return 0;
    }

    public int buddyWatcherNotification(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        return 0;
    }

    public int buddyRejectNotification(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        Object object2;
        if (fLAPSock != this.bos) {
            return 0;
        }
        String[] stringArray = new String[vector.size()];
        String string = "";
        int n2 = 0;
        while (n2 < vector.size()) {
            object2 = Nickname.snacNickname((SnacNickname)vector.elementAt(n2));
            string = String.valueOf(string) + " " + (String)object2;
            stringArray[n2] = object2;
            ++n2;
        }
        this.warn(object, "The following people are too popular" + string, null);
        object2 = (CallbackData)object;
        if (object2 != null && ((CallbackData)object2).data != null) {
            String[] stringArray2 = (String[])((CallbackData)object2).data;
            String[] stringArray3 = new String[stringArray2.length - vector.size()];
            n2 = 0;
            int n3 = 0;
            while (n2 < stringArray2.length) {
                boolean bl = false;
                int n4 = 0;
                while (n4 < stringArray.length) {
                    if (stringArray[n4].equals(stringArray2[n2])) {
                        bl = true;
                        break;
                    }
                    ++n4;
                }
                if (!bl) {
                    stringArray3[n3++] = stringArray2[n2];
                }
                ++n2;
            }
            this.addBuddies(stringArray3);
        }
        return 1;
    }

    public int buddyArrived(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        Nickname[] nicknameArray = new Nickname[vector.size()];
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            SnacNicknameWinfo snacNicknameWinfo = (SnacNicknameWinfo)vector.elementAt(n2);
            nicknameArray[n2] = new Nickname(snacNicknameWinfo);
            this.updateUserInfo(nicknameArray[n2]);
            stringArray[n2] = Nickname.snacNickname(snacNicknameWinfo.nickname);
            ++n2;
        }
        this.icbm.clearUserInfo(stringArray);
        this.buddy.buddiesArrived(nicknameArray);
        return 1;
    }

    public int buddyDeparted(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        Nickname[] nicknameArray = new Nickname[vector.size()];
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            SnacNicknameWinfo snacNicknameWinfo = (SnacNicknameWinfo)vector.elementAt(n2);
            nicknameArray[n2] = new Nickname(snacNicknameWinfo);
            this.updateUserInfo(nicknameArray[n2]);
            stringArray[n2] = Nickname.snacNickname(snacNicknameWinfo.nickname);
            ++n2;
        }
        this.icbm.clearUserInfo(stringArray);
        this.buddy.buddiesDeparted(nicknameArray);
        return 1;
    }

    private Vector snacNicknameArray(String[] stringArray) {
        Vector<SnacNickname> vector = new Vector<SnacNickname>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            SnacNickname snacNickname = Nickname.snacNickname(stringArray[n]);
            vector.addElement(snacNickname);
            ++n;
        }
        return vector;
    }

    public int popupDisplayPopup(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        String string = tLV.getTlvDataAsString(1);
        String string2 = tLV.getTlvDataAsString(2);
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        if (tLV.tlvTypePresent(3)) {
            n2 = tLV.getTlvDataAsU16(3);
        }
        if (tLV.tlvTypePresent(4)) {
            n3 = tLV.getTlvDataAsU16(4);
        }
        if (tLV.tlvTypePresent(5)) {
            n4 = tLV.getTlvDataAsU16(5);
        }
        this.popup.displayPopup(string, string2, n2, n3, n4);
        return 1;
    }

    public void invite(String string, String string2, Object object) {
        CallbackData callbackData = new CallbackData(string, false, false, 6, 2, "invite " + string, object);
        TLV tLV = new TLV(2);
        tLV.addTlv(17, string);
        tLV.addTlv(21, string2);
        InviteHandler inviteHandler = (InviteHandler)this.dispatcher.getHandler(6);
        inviteHandler.request(this.bos, this, callbackData, tLV);
    }

    public int inviteRequestAck(FLAPSock fLAPSock, Object object, ReqID reqID, int n) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        CallbackData callbackData = (CallbackData)object;
        this.invite.invitationSent(callbackData.to, callbackData.data);
        return 1;
    }

    public void getNicknameByEmail(String string, Object object) {
        this.getNicknameByEmailInternal(string, false, object);
    }

    private void getNicknameByEmailInternal(String string, boolean bl, Object object) {
        CallbackData callbackData = new CallbackData(string, bl, true, 10, 2, "find a nickname for " + string, object);
        UserLookupHandler userLookupHandler = (UserLookupHandler)this.dispatcher.getHandler(10);
        userLookupHandler.findBYEmail(this.bos, this, callbackData, string.getBytes());
    }

    public int userLookupFindReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        CallbackData callbackData = (CallbackData)object;
        String string = callbackData.to;
        if (tLV == null || tLV.size() < 1) {
            this.invite.isMemberButDeclinesToRevealNickname(string, callbackData.data);
        } else {
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            while (n2 < tLV.size()) {
                String string2;
                SnacTlv snacTlv = (SnacTlv)tLV.elementAt(n2);
                if (snacTlv.type == 1 && (string2 = new String(snacTlv.data)) != null && string2.length() > 0) {
                    vector.addElement(string2);
                }
                ++n2;
            }
            if (vector.size() > 0) {
                this.invite.setNicknamesForEmail(string, vector, callbackData.data);
            } else {
                this.invite.isMemberButDeclinesToRevealNickname(string, callbackData.data);
            }
        }
        return 1;
    }

    private void modPermitDenyList(boolean bl, boolean bl2, Vector vector) {
        Object object;
        Vector<SnacNickname> vector2 = null;
        if (vector == null) {
            vector2 = new Vector<SnacNickname>(0);
        } else {
            vector2 = new Vector(vector.size());
            int n = 0;
            while (n < vector.size()) {
                object = Nickname.normalize((String)vector.elementAt(n));
                vector2.addElement(Nickname.snacNickname((String)object));
                ++n;
            }
        }
        object = (BosHandler)this.dispatcher.getHandler(9);
        if (bl) {
            if (bl2) {
                CallbackData callbackData = new CallbackData(null, false, false, 9, 5, "set your permit list", null);
                ((BosHandler)object).addPermListEntries(this.bos, this, callbackData, vector2);
                return;
            }
            CallbackData callbackData = new CallbackData(null, false, false, 9, 6, "set your permit list", null);
            ((BosHandler)object).delPermListEntries(this.bos, this, callbackData, vector2);
            return;
        }
        if (bl2) {
            CallbackData callbackData = new CallbackData(null, false, false, 9, 7, "set your deny list", null);
            ((BosHandler)object).addDenyListEntries(this.bos, this, callbackData, vector2);
            return;
        }
        CallbackData callbackData = new CallbackData(null, false, false, 9, 8, "set your deny list", null);
        ((BosHandler)object).delDenyListEntries(this.bos, this, callbackData, vector2);
    }

    public void setPermitDeny(Permissions permissions) {
        Object object;
        Vector vector;
        if (permissions == null) {
            return;
        }
        long l = 0L;
        if (permissions.permitDT) {
            l |= 1L;
        }
        if (permissions.permitAdmin) {
            l |= 2L;
        }
        if (permissions.permitAOLUser) {
            l |= 4L;
        }
        if (permissions.permitOscarPayUser) {
            l |= 8L;
        }
        if (permissions.permitOscarFreeUser) {
            l |= 0x10L;
        }
        BosHandler bosHandler = (BosHandler)this.dispatcher.getHandler(9);
        try {
            vector = new OutputBuffer(4);
            ((DataOutputStream)((Object)vector)).writeInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
            object = null;
            object = new CallbackData(null, false, false, 9, 4, "set your permited groups", null);
            bosHandler.setGroupPermitMask(this.bos, this, object, ((OutputBuffer)((Object)vector)).bytes());
        }
        catch (IOException iOException) {
            ErrorMgr.warn(this.toString(), "trouble setting permissions flags", iOException);
        }
        if (this.lastPermission == null) {
            this.modPermitDenyList(permissions.isPermit, true, permissions.names);
        } else if (this.lastPermission.isPermit == permissions.isPermit) {
            vector = permissions.addedNames(this.lastPermission);
            if (vector != null && vector.size() > 0) {
                this.modPermitDenyList(permissions.isPermit, true, vector);
            }
            if ((object = permissions.removedNames(this.lastPermission)) != null && ((Vector)object).size() > 0) {
                this.modPermitDenyList(permissions.isPermit, false, (Vector)object);
            }
        } else {
            this.modPermitDenyList(permissions.isPermit, true, permissions.names);
        }
        vector = permissions.names == null ? new Vector(0) : (Vector)permissions.names.clone();
        this.lastPermission = new Permissions(permissions.isPermit, vector, permissions.permitDT, permissions.permitAdmin, permissions.permitAOLUser, permissions.permitOscarPayUser, permissions.permitOscarFreeUser);
    }

    public int bosRightsReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        int n2 = 10;
        if (tLV.tlvTypePresent(1)) {
            n2 = tLV.getTlvDataAsU16(1);
        }
        int n3 = 10;
        if (tLV.tlvTypePresent(2)) {
            n2 = tLV.getTlvDataAsU16(2);
        }
        this.perm.setMaxPermitDeny(n2, n3);
        if (this.initingBOS) {
            Permissions permissions = this.perm.getPermissions();
            this.setPermitDeny(permissions);
            this.initingBOS = false;
            this.doneIniting("bos");
        }
        return 1;
    }

    public int bosErr(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        String string = tLV.getTlvDataAsString(4);
        int n3 = -1;
        if (tLV.tlvTypePresent(8)) {
            n3 = tLV.getTlvDataAsU16(8);
        }
        this.warn(object, this.lookup(bosErrors, n2), string);
        return 1;
    }

    public int locateRightsReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        if (tLV.tlvTypePresent(1)) {
            int n2 = tLV.getTlvDataAsU16(1);
            this.locate.setMaxSignatureSize(n2);
        }
        if (this.initingLocate) {
            this.setSignature(this.locate.getSignatureMimeType(), this.locate.getSignature());
            this.doneIniting(this.locate);
            this.initingLocate = false;
        }
        return 1;
    }

    public int locateUserInfoReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacNicknameWinfo snacNicknameWinfo, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        Nickname nickname = new Nickname(snacNicknameWinfo);
        this.locate.setUserSignature(nickname, tLV.getTlvDataAsString(1), tLV.getTlvData(2));
        this.updateUserInfo(nickname);
        return 1;
    }

    public int locateWatcherNotification(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        return 1;
    }

    public void setSignature(String string, byte[] byArray) {
        if (string == null || byArray == null) {
            ErrorMgr.warn(this.toString(), "setSignature called with bad mimetype or data");
            return;
        }
        CallbackData callbackData = new CallbackData(null, false, false, 2, 4, "set your signature", null);
        TLV tLV = new TLV(2);
        tLV.addTlv(1, string);
        tLV.addTlv(2, byArray);
        LocateHandler locateHandler = (LocateHandler)this.dispatcher.getHandler(2);
        locateHandler.setInfo(this.bos, this, callbackData, tLV);
    }

    public void getUserSignature(String string) {
        if (string == null) {
            ErrorMgr.warn(this.toString(), "getUserSignature called with bad name");
            return;
        }
        CallbackData callbackData = new CallbackData(string, false, true, 2, 5, "get information on " + string, null);
        LocateHandler locateHandler = (LocateHandler)this.dispatcher.getHandler(2);
        locateHandler.userInfoQuery(this.bos, this, callbackData, 1, Nickname.snacNickname(string));
        if (Oscar.config.getValue("debug.experimentalFoodGroups") != null) {
            if (Oscar.config.getValue("debug.testadminserver") != null) {
                this.requestService(new AdminCLI(), "admin", null);
            }
            if (Oscar.config.getValue("debug.testadserver") != null) {
                this.requestService(Oscar.adCore, "ad", null);
            }
            if (Oscar.config.getValue("debug.testinvite") != null) {
                this.invite("xthulu@aol.com", "hi there", null);
            }
            if (Oscar.config.getValue("debug.testlookup") != null) {
                this.getNicknameByEmail("xthulu@aol.com", null);
            }
        }
    }

    public int icbmParameterReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, byte[] byArray, int n3, int n4, int n5, long l) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        this.maxChannels = n2;
        InputBuffer inputBuffer = new InputBuffer(byArray);
        long l2 = 0L;
        try {
            l2 = JUtil.readU32(inputBuffer.d);
        }
        catch (IOException iOException) {
            ErrorMgr.diag(this.toString(), "icbmParameterReply, couldn't read default flags", iOException);
        }
        boolean bl = (l2 & 1L) != 0L;
        this.icbm.setDefaults(bl, n3, l, n4, n5);
        if (this.initingIcbm) {
            this.updateIcbmParametersInternal(1, true);
            this.initingIcbm = false;
            this.doneIniting(this.icbm);
        }
        return 1;
    }

    public int icbmEvilReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, int n3) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        CallbackData callbackData = (CallbackData)object;
        String string = "unknown";
        if (callbackData != null) {
            string = callbackData.to;
        }
        this.icbm.acknowledgeEvil(n2, n3, string);
        return 1;
    }

    public int icbmMissedCalls(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        Vector<MissedIcbm> vector2 = new Vector<MissedIcbm>(vector.size());
        int n2 = 0;
        while (n2 < vector.size()) {
            SnacIcbmMissedCall snacIcbmMissedCall = (SnacIcbmMissedCall)vector.elementAt(n2);
            Nickname nickname = new Nickname(snacIcbmMissedCall.nickWinfo);
            this.updateUserInfo(nickname);
            MissedIcbm missedIcbm = new MissedIcbm(nickname, snacIcbmMissedCall.numMissed, snacIcbmMissedCall.reason);
            vector2.addElement(missedIcbm);
            ++n2;
        }
        this.icbm.missedIcbms(vector2);
        return 1;
    }

    public int icbmClientErr(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacIcbmCookie snacIcbmCookie, int n2, SnacNickname snacNickname, int n3, byte[] byArray) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        String string = Nickname.snacNickname(snacNickname);
        CallbackData cfr_ignored_0 = (CallbackData)object;
        String string2 = null;
        if (byArray != null) {
            string2 = new String(byArray);
        }
        if (n3 == 2) {
            this.icbm.payloadError(string, n2, snacIcbmCookie.data, string2);
        } else {
            this.icbm.unsupportedChannel(string, n2, snacIcbmCookie.data, string2);
        }
        return 1;
    }

    public int icbmChannelMsgToclient(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacIcbmCookie snacIcbmCookie, int n2, SnacNicknameWinfo snacNicknameWinfo, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        byte[] byArray = tLV.getTlvData(2);
        tLV.getTlvDataAsString(1);
        Nickname nickname = new Nickname(snacNicknameWinfo);
        this.updateUserInfo(nickname);
        String string = Oscar.config.getValue("tools.icbm.disableChannelVersionLogic");
        string = "true";
        if (string != null && string.equals("true")) {
            this.icbm.setChannelVersion(nickname.nickname, n2, snacIcbmCookie.data, this.icbm.getChannelVersion(n2));
        }
        if (n2 == 1) {
            try {
                InputBuffer inputBuffer = new InputBuffer(byArray);
                byArray = this.readAOLChannelHeader(inputBuffer.d);
                if (byArray == null) {
                    ErrorMgr.warn("BOSCore", "error displaying ICBM from " + nickname.nickname + " please send log to bug mailing list " + JUtil.toHexString(byArray));
                    return 1;
                }
            }
            catch (IOException iOException) {
                ErrorMgr.warn(this.toString(), "io exception in read aol channel header", iOException);
            }
        }
        this.icbm.receiveMessage(nickname, n2, snacIcbmCookie.data, new String(byArray), tLV.tlvTypePresent(4));
        return 1;
    }

    public void getChannelVersion(String string, int n, byte[] byArray) {
        String string2 = Oscar.config.getValue("tools.icbm.disableChannelVersionLogic");
        string2 = "true";
        if (string2 != null && string2.equals("true")) {
            this.icbm.setChannelVersion(string, n, byArray, this.icbm.getChannelVersion(n));
        }
    }

    private byte[] readAOLChannelHeader(DataInputStream dataInputStream) throws IOException {
        short s;
        dataInputStream.readByte();
        dataInputStream.readByte();
        int n = dataInputStream.readShort();
        if (n < 1 || n > dataInputStream.available()) {
            return null;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            s = dataInputStream.readByte();
            if (s == whisc_capability_text) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            return null;
        }
        dataInputStream.readByte();
        dataInputStream.readByte();
        s = dataInputStream.readShort();
        if (s != dataInputStream.available()) {
            return null;
        }
        dataInputStream.readShort();
        dataInputStream.readShort();
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.read(byArray);
        return byArray;
    }

    private void writeAOLChannelHeader(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        dataOutputStream.writeByte(whisc_item_capabilities);
        dataOutputStream.writeByte(capability_version);
        dataOutputStream.writeShort(1);
        dataOutputStream.writeByte(whisc_capability_text);
        dataOutputStream.writeByte(whisc_item_im_text);
        dataOutputStream.writeByte(im_text_version);
        dataOutputStream.writeShort(4 + byArray.length);
        dataOutputStream.writeShort(intl_encode_ascii);
        dataOutputStream.writeShort(intl_language_english);
        dataOutputStream.write(byArray, 0, byArray.length);
    }

    public void sendMessage(String string, int n, byte[] byArray, String string2, boolean bl) {
        Object object;
        byte[] byArray2 = string2.getBytes();
        if (n == 1) {
            try {
                object = new OutputBuffer(13 + byArray2.length);
                this.writeAOLChannelHeader((DataOutputStream)object, byArray2);
                byArray2 = ((OutputBuffer)object).bytes();
            }
            catch (IOException iOException) {
                ErrorMgr.warn(this.toString(), "trouble sending icbm message", iOException);
            }
        }
        object = (IcbmHandler)this.dispatcher.getHandler(4);
        CallbackData callbackData = new CallbackData(string, false, false, 4, 6, "send a message to " + string, byArray);
        TLV tLV = new TLV();
        tLV.addTlv(2, byArray2);
        if (bl) {
            tLV.addTlv(4);
        }
        ((IcbmHandler)object).channelMsgTohost(this.bos, this, callbackData, new SnacIcbmCookie(byArray), n, Nickname.snacNickname(string), tLV);
    }

    public void sendEvil(String string, boolean bl) {
        if (string == null) {
            return;
        }
        IcbmHandler icbmHandler = (IcbmHandler)this.dispatcher.getHandler(4);
        CallbackData callbackData = new CallbackData(string, false, true, 4, 8, "warn " + string, null);
        int n = 0;
        if (bl) {
            n |= 1;
        }
        icbmHandler.evilRequest(this.bos, this, callbackData, n, Nickname.snacNickname(string));
    }

    public void sendUnsupportedChannelError(String string, int n, byte[] byArray, String string2) {
        CallbackData callbackData = new CallbackData(string, true, false, 4, 11, "tell " + string + " that we don't support channel " + n, null);
        IcbmHandler icbmHandler = (IcbmHandler)this.dispatcher.getHandler(4);
        icbmHandler.clientErr(this.bos, this, callbackData, new SnacIcbmCookie(byArray), n, Nickname.snacNickname(string), 1, string2.getBytes());
    }

    public void sendIcbmPayloadError(String string, int n, byte[] byArray, String string2) {
        CallbackData callbackData = new CallbackData(string, true, false, 4, 11, "tell " + string + " that we can't understand their data", null);
        IcbmHandler icbmHandler = (IcbmHandler)this.dispatcher.getHandler(4);
        icbmHandler.clientErr(this.bos, this, callbackData, new SnacIcbmCookie(byArray), n, Nickname.snacNickname(string), 2, string2.getBytes());
    }

    public byte[] getCookie() {
        int n = 8;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(Math.random() * 255.0);
            ++n2;
        }
        return byArray;
    }

    public void updateIcbmParameters(int n) {
        this.updateIcbmParametersInternal(n, false);
    }

    private void updateIcbmParametersInternal(int n, boolean bl) {
        long l = 0L;
        if (this.icbm.getMessagesState(n)) {
            l |= 1L;
        }
        l |= 2L;
        int n2 = this.icbm.getMaxIncommingIcbmSize(n);
        int n3 = this.icbm.getMaxSenderEvil(n);
        int n4 = this.icbm.getMaxReceiverEvil(n);
        long l2 = this.icbm.getMinInterIcbmInterval(n);
        IcbmHandler icbmHandler = (IcbmHandler)this.dispatcher.getHandler(4);
        CallbackData callbackData = new CallbackData(null, bl, false, 4, 2, "set ICBM parameters", null);
        try {
            OutputBuffer outputBuffer = new OutputBuffer(4);
            outputBuffer.writeInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
            icbmHandler.addParameters(this.bos, this, callbackData, n, outputBuffer.bytes(), n2, n3, n4, l2);
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.error(this.toString(), "Can't set ICBM parameters, internal error", iOException);
            return;
        }
    }

    public void isAvailable(String string) {
        this.icbm.isAvailable(string, false);
    }

    public int icbmHostAck(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacIcbmCookie snacIcbmCookie, int n2, SnacNickname snacNickname) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        return 1;
    }

    public int translateTranslateReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        int n2 = tLV.size();
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        while (n3 < n2) {
            SnacTlv snacTlv = (SnacTlv)tLV.elementAt(n3);
            if (snacTlv.type == 11) {
                if (snacTlv.data != null) {
                    vector.addElement(new String(snacTlv.data));
                } else {
                    vector.addElement(new String(""));
                }
            } else {
                Log.log(MODULE, Log.WARNING, "Unexpected tlv type " + snacTlv.type + " ignored.");
            }
            ++n3;
        }
        CallbackData callbackData = (CallbackData)object;
        ((TranslateUrlListener)callbackData.data).translateReply(vector);
        return 1;
    }

    public void translateRequest(Vector vector, Object object) {
        CallbackData callbackData = new CallbackData(null, true, true, 12, 2, "translate URLs", object);
        int n = vector.size();
        TLV tLV = new TLV(n);
        int n2 = 0;
        while (n2 < n) {
            tLV.addTlv(11, (String)vector.elementAt(n2));
            ++n2;
        }
        TranslateHandler translateHandler = (TranslateHandler)this.dispatcher.getHandler(12);
        translateHandler.translateRequest(this.bos, this, callbackData, tLV);
    }

    public int statsSetMinReportInterval(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        this.statReportInterval = n2;
        this.setReportStatsTimer();
        return 1;
    }

    private synchronized void setReportStatsTimer() {
        int n = 0;
        long l = System.currentTimeMillis();
        if (this.reportStatsEvent != null && this.reportStatsEvent.getActivationTime() > l) {
            n = (int)(l - this.reportStatsEvent.getCreationTime());
            Timer.removeEvent(this.reportStatsEvent);
        }
        this.reportStatsEvent = Timer.createEvent("System", this, REPORT_STATS_EVENT, null, this.statReportInterval * 1000 - n);
    }

    public synchronized void reportEvent(int n, int n2) {
        StatEvent statEvent = this.findStatEvent(this.stats, n, n2);
        ++statEvent.count;
    }

    private synchronized StatEvent findStatEvent(Vector vector, int n, int n2) {
        StatEvent statEvent = null;
        int n3 = 0;
        while (n3 < vector.size()) {
            statEvent = (StatEvent)vector.elementAt(n3);
            if (statEvent.eventType == n && statEvent.id == n2) {
                return statEvent;
            }
            ++n3;
        }
        statEvent = new StatEvent(n, n2);
        vector.addElement(statEvent);
        return statEvent;
    }

    private synchronized void reportStats(boolean bl) {
        byte[] byArray = this.serializeStats(1);
        byte[] byArray2 = this.serializeStats(2);
        if (byArray == null && byArray2 == null) {
            this.setReportStatsTimer();
            return;
        }
        TLV tLV = new TLV();
        if (byArray != null) {
            tLV.addTlv(2, byArray);
        }
        if (byArray2 != null) {
            tLV.addTlv(1, byArray2);
        }
        if (bl) {
            tLV.addTlv(3);
        }
        CallbackData callbackData = new CallbackData(null, true, bl, 11, 3, "report ad statistics", null);
        StatsHandler statsHandler = (StatsHandler)this.dispatcher.getHandler(11);
        this.stats = new Vector();
        statsHandler.reportEvents(this.bos, this, callbackData, tLV);
        if (!bl) {
            this.setReportStatsTimer();
        }
    }

    private synchronized byte[] serializeStats(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.stats.size()) {
            StatEvent statEvent = (StatEvent)this.stats.elementAt(n3);
            if (statEvent.eventType == n) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        int n4 = 6;
        try {
            OutputBuffer outputBuffer = new OutputBuffer(n4 * n2);
            n3 = 0;
            boolean bl = false;
            while (n3 < this.stats.size()) {
                StatEvent statEvent = (StatEvent)this.stats.elementAt(n3);
                if (statEvent.eventType == n) {
                    outputBuffer.writeInt(statEvent.id);
                    outputBuffer.writeShort(statEvent.count);
                }
                ++n3;
            }
            return outputBuffer.bytes();
        }
        catch (IOException iOException) {
            Log.log("problem serializing stats");
            return null;
        }
    }

    public int statsReportAck(FLAPSock fLAPSock, Object object, ReqID reqID, int n) {
        if (fLAPSock != this.bos) {
            return 0;
        }
        return 1;
    }

    static {
        RequestService = 1;
        SetSignature = 2;
        GetUserSignature = 3;
        ModifyBuddyList = 4;
        SendMessage = 5;
        SendEvil = 6;
        GC_TIME = 5000;
        IDLE_TIME = 15000;
        CLEAR_CHECK_TIME = 1000;
        NOOP_TIME = 300000;
        RATE_CLEAR_CHECK_EVENT = 1;
        IDLE_EVENT = 2;
        NOOP_EVENT = 3;
        REPORT_STATS_EVENT = 4;
        MIN_IDLE_TIME = 900;
        MOTD_CHOICE = SnacConnectionHandler.WARNING_CHOICE + 1;
        REG_EMAIL_CHOICE = MOTD_CHOICE + 1;
        bosErrors = new String[]{null, "wrong mode"};
        icbmErrors = new String[]{null, "unsupported channel", "busted icbm payload"};
        whisc_item_capabilities = 5;
        capability_version = 1;
        whisc_capability_text = 1;
        whisc_item_im_text = 1;
        im_text_version = 1;
    }
}

