/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BuddyCore;
import component.FolderInfo;
import component.PermitProps;
import component.PrivacyProps;
import component.SetupUI;
import component.Tools;
import java.util.Vector;
import main.BOSCore;
import main.Nickname;
import main.Oscar;
import main.PermissionAPI;
import main.Permissions;
import tool.BlockEvent;
import tool.BlockListener;
import uiutil.ChoiceUI;
import uiutil.PropertySheet;
import util.EventBus;
import util.JUtil;
import util.KeyBindings;
import util.Log;

public class Permission
implements PermissionAPI,
BlockListener {
    public static final String NAME = "Privacy";
    private static final String MODULE = "Permission";
    private static int DEFAULT_MAX_PERMITS = 20;
    private static int DEFAULT_MAX_DENIES = 20;
    private int maxPermits;
    private int maxDenies;
    private BOSCore bosCore;
    private Tools tools;
    private boolean enabled = false;
    static /* synthetic */ Class class$tool$BlockEvent;

    public Permission(BOSCore bOSCore, Tools tools) {
        Object object;
        this.bosCore = bOSCore;
        this.tools = tools;
        tools.register(this.getName(), this);
        this.maxPermits = DEFAULT_MAX_PERMITS;
        this.maxDenies = DEFAULT_MAX_DENIES;
        KeyBindings keyBindings = Oscar.config.getKeyBindings(NAME);
        if (keyBindings == null) {
            keyBindings = Oscar.config.addKeyBindings(NAME);
            object = Oscar.config.getKeyBindings("Main");
            if (object != null) {
                String string = ((KeyBindings)object).getValue("permission");
                if (string == null) {
                    string = "deny";
                }
                KeyBindings keyBindings2 = ((KeyBindings)object).getValues("permissionNames");
                Vector vector = ((KeyBindings)object).getValues("permissionClasses");
                if (vector == null) {
                    vector = new Vector(4);
                    vector.addElement("unregistered");
                    vector.addElement("aol");
                    vector.addElement("oscarPay");
                    vector.addElement("oscarFree");
                }
                int n = 0;
                if (keyBindings2 != null) {
                    n = keyBindings2.size();
                }
                if (string.equalsIgnoreCase("deny")) {
                    if (n > 0) {
                        keyBindings.setValue("pref", "blockSome");
                        keyBindings.setValues("blockList", keyBindings2);
                    } else {
                        keyBindings.setValue("pref", "allowAll");
                    }
                } else if (n > 0) {
                    keyBindings.setValue("pref", "allowSome");
                    keyBindings.setValues("allowList", keyBindings2);
                } else {
                    keyBindings.setValue("pref", "blockAll");
                }
                if (vector.removeElement("unregistered")) {
                    vector.addElement("trial");
                }
                keyBindings.setValues("allowClassList", vector);
                ((KeyBindings)object).deleteKey("permission");
                ((KeyBindings)object).deleteKey("permissionNames");
                ((KeyBindings)object).deleteKey("permissionClasses");
                ((KeyBindings)object).deleteKey("stealth");
                if (((Vector)object).size() == 0) {
                    Oscar.config.deleteKey("Main");
                }
                Oscar.saveConfiguration();
            }
        }
        object = EventBus.joinBus(EventBus.SYSTEM_BUS);
        ((EventBus)object).addListenerFor(this, class$tool$BlockEvent != null ? class$tool$BlockEvent : (class$tool$BlockEvent = Permission.class$("tool.BlockEvent")));
    }

    public int getMaxPermits() {
        return this.maxPermits;
    }

    public int getMaxDenies() {
        return this.maxDenies;
    }

    public Permissions getPermissions() {
        KeyBindings keyBindings;
        boolean bl;
        String string;
        KeyBindings keyBindings2 = Oscar.config.getKeyBindings(NAME);
        if (keyBindings2 == null) {
            keyBindings2 = Oscar.config.addKeyBindings(NAME);
        }
        if ((string = keyBindings2.getValue("pref")) != null && string.equalsIgnoreCase("blockAll")) {
            bl = true;
            keyBindings = null;
        } else if (string != null && string.equalsIgnoreCase("allowSome")) {
            bl = true;
            keyBindings = keyBindings2.getValues("allowList");
        } else if (string != null && string.equalsIgnoreCase("blockSome")) {
            bl = false;
            keyBindings = keyBindings2.getValues("blockList");
        } else {
            bl = false;
            keyBindings = null;
        }
        Vector vector = keyBindings2.getValues("allowClassList");
        if (vector == null) {
            vector = new Vector(4);
            vector.addElement("trial");
            vector.addElement("aol");
            vector.addElement("oscarPay");
            vector.addElement("oscarFree");
        }
        Permissions permissions = new Permissions(bl, keyBindings, vector.contains("trial"), true, vector.contains("aol"), vector.contains("oscarPay"), vector.contains("oscarFree"));
        return permissions;
    }

    public boolean getPublishIdleTime() {
        String string = Oscar.config.getValue("Privacy.publishIdleTime");
        return string == null || !string.equalsIgnoreCase("false");
    }

    public boolean getPublishMemberSince() {
        String string = Oscar.config.getValue("Privacy.publishMemberSince");
        return string == null || !string.equalsIgnoreCase("false");
    }

    public void setMaxPermitDeny(int n, int n2) {
        this.maxPermits = n;
        this.maxDenies = n2;
    }

    public void sendPermissions(Permissions permissions) {
        if (this.enabled) {
            this.bosCore.setPermitDeny(permissions);
        }
    }

    public void sendPrivacy() {
        if (this.enabled) {
            this.bosCore.setPrivacy();
        }
    }

    public int setPermissions(Permissions permissions) {
        int n;
        KeyBindings keyBindings = Oscar.config.getKeyBindingsOrAdd(NAME);
        if (permissions.isPermit) {
            if (permissions.names == null || permissions.names.size() == 0) {
                keyBindings.setValue("pref", "blockAll");
            } else {
                n = permissions.names.size() - this.getMaxPermits();
                if (n > 0) {
                    return n;
                }
                keyBindings.setValue("pref", "allowSome");
                keyBindings.setValues("allowList", (Vector)permissions.names.clone());
            }
        } else if (permissions.names == null || permissions.names.size() == 0) {
            keyBindings.setValue("pref", "allowAll");
        } else {
            n = permissions.names.size() - this.getMaxPermits();
            if (n > 0) {
                return n;
            }
            keyBindings.setValue("pref", "blockSome");
            keyBindings.setValues("blockList", (Vector)permissions.names.clone());
        }
        keyBindings.deleteKey("allowClassList");
        if (permissions.permitDT) {
            keyBindings.appendValue("allowClassList", "trial");
        }
        if (permissions.permitAOLUser) {
            keyBindings.appendValue("allowClassList", "aol");
        }
        if (permissions.permitOscarPayUser) {
            keyBindings.appendValue("allowClassList", "oscarPay");
        }
        if (permissions.permitOscarFreeUser) {
            keyBindings.appendValue("allowClassList", "oscarFree");
        }
        Oscar.saveConfiguration();
        this.sendPermissions(permissions);
        BuddyCore buddyCore = (BuddyCore)this.tools.get("Buddy List");
        buddyCore.updateBuddyLists(permissions);
        return 0;
    }

    public String getDisplayName() {
        return NAME;
    }

    public String getName() {
        return NAME;
    }

    public int id() {
        return 1;
    }

    public int version() {
        return 1;
    }

    public String getModuleName() {
        return this.getName();
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        FolderInfo[] folderInfoArray = new FolderInfo[]{new FolderInfo(this, 0, this.getDisplayName(), "Permit"), new FolderInfo(this, 1, this.getDisplayName(), NAME)};
        return folderInfoArray;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        switch (folderInfo.getFolderId()) {
            case 0: {
                return new PermitProps(this.tools, setupUI);
            }
            case 1: {
                return new PrivacyProps(this.tools, setupUI);
            }
        }
        return null;
    }

    public void exportProperties(KeyBindings keyBindings, KeyBindings keyBindings2) {
        KeyBindings keyBindings3;
        KeyBindings keyBindings4 = Oscar.config.getKeyBindings(NAME);
        String string = keyBindings2.getValue(NAME);
        if (string == null || JUtil.isFalse(string)) {
            return;
        }
        if (keyBindings4 == null) {
            keyBindings4 = Oscar.config.addKeyBindings(NAME);
        }
        KeyBindings keyBindings5 = keyBindings.addKeyBindings(NAME);
        string = keyBindings4.getValue("pref");
        if (string != null && string.length() > 0) {
            keyBindings5.setValue("pref", string);
        }
        if ((keyBindings3 = keyBindings4.getValues("allowList")) != null) {
            keyBindings5.setValues("allowList", keyBindings3);
        }
        if ((keyBindings3 = keyBindings4.getValues("blockList")) != null) {
            keyBindings5.setValues("blockList", keyBindings3);
        }
        if ((keyBindings3 = keyBindings4.getValues("allowClassList")) != null) {
            keyBindings5.setValues("allowClassList", keyBindings3);
        }
        if ((string = keyBindings4.getValue("publishIdleTime")) != null && string.length() > 0) {
            keyBindings5.setValue("publishIdleTime", string);
        }
        if ((string = keyBindings4.getValue("publishMemberSince")) != null && string.length() > 0) {
            keyBindings5.setValue("publishMemberSince", string);
        }
        if ((string = keyBindings4.getValue("anonymousEvil")) != null && string.length() > 0) {
            keyBindings5.setValue("anonymousEvil", string);
        }
    }

    public void importProperties(KeyBindings keyBindings, KeyBindings keyBindings2, KeyBindings keyBindings3, boolean bl) {
        KeyBindings keyBindings4 = Oscar.config.getKeyBindings(NAME);
        if (!bl && keyBindings4 != null) {
            keyBindings2.setValues(NAME, keyBindings4);
        }
        KeyBindings keyBindings5 = keyBindings.getKeyBindings(NAME);
        String string = keyBindings3.getValue(NAME);
        if ((string == null || JUtil.isTrue(string)) && keyBindings5 != null) {
            KeyBindings keyBindings6 = keyBindings2.addKeyBindings(NAME);
            string = keyBindings5.getValue("pref");
            if (string != null && string.length() > 0) {
                keyBindings6.setValue("pref", string);
            }
            if ((keyBindings4 = keyBindings5.getValues("allowList")) != null) {
                keyBindings6.setValues("allowList", keyBindings4);
            }
            if ((keyBindings4 = keyBindings5.getValues("blockList")) != null) {
                keyBindings6.setValues("blockList", keyBindings4);
            }
            if ((keyBindings4 = keyBindings5.getValues("allowClassList")) != null) {
                keyBindings6.setValues("allowClassList", keyBindings4);
            }
            if ((string = keyBindings5.getValue("publishIdleTime")) != null && string.length() > 0) {
                keyBindings6.setValue("publishIdleTime", string);
            }
            if ((string = keyBindings5.getValue("publishMemberSince")) != null && string.length() > 0) {
                keyBindings6.setValue("publishMemberSince", string);
            }
            if ((string = keyBindings5.getValue("anonymousEvil")) != null && string.length() > 0) {
                keyBindings6.setValue("anonymousEvil", string);
            }
        }
    }

    public boolean initiate(Vector vector, KeyBindings keyBindings) {
        return true;
    }

    public void shutdown() {
        Log.log(MODULE, Log.INFO, "Permission got shutdown.");
    }

    public void updateUserInfo(Nickname nickname) {
    }

    public void updateUserEvil(String string, int n) {
    }

    public void updateRate() {
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void connect() {
        this.setEnabled(true);
    }

    public void disconnect() {
        this.setEnabled(false);
    }

    public void service() {
    }

    public void setBlock(BlockEvent blockEvent) {
        int n;
        String string = blockEvent.getUser().nickname;
        boolean bl = true;
        Permissions permissions = this.getPermissions();
        if (!permissions.isPermit) {
            if (permissions.names == null) {
                permissions.names = new Vector();
            } else {
                n = permissions.names.size();
                int n2 = 0;
                while (n2 < n) {
                    String string2 = (String)permissions.names.elementAt(n2);
                    if (Nickname.normalize(string2).equals(Nickname.normalize(string))) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (bl) {
                permissions.names.addElement(string);
            }
        } else if (permissions.names != null) {
            n = permissions.names.size();
            int n3 = 0;
            while (n3 < n) {
                String string3 = (String)permissions.names.elementAt(n3);
                if (Nickname.normalize(string3).equals(Nickname.normalize(string))) {
                    permissions.names.removeElementAt(n3);
                    --n;
                }
                ++n3;
            }
        } else {
            bl = false;
        }
        if (bl && (n = this.setPermissions(permissions)) != 0) {
            if (permissions.isPermit) {
                ChoiceUI.newChoiceUI("Block Failed", "Your allow list is too large by " + n + " members even if \"" + string + "\" is removed. You will " + "need to remove members from your " + "allow list before you can block " + "another member.", Oscar.WARNING_SOUND);
                return;
            }
            ChoiceUI.newChoiceUI("Block Failed", "You already reached the limit of " + Oscar.permit.getMaxDenies() + " members on your deny list. " + "You will need to remove one " + "before you can block \"" + string + "\".", Oscar.WARNING_SOUND);
        }
    }

    public void unsetBlock(BlockEvent blockEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

