/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.FolderInfo;
import component.LocateProps;
import component.LocateUI;
import component.SetupUI;
import component.Tool;
import component.Tools;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import main.BOSCore;
import main.LocateAPI;
import main.Nickname;
import main.Oscar;
import main.Rate;
import uiutil.ChoiceListener;
import uiutil.ChoiceUI;
import uiutil.ErrorMgr;
import uiutil.PropertySheet;
import util.JUtil;
import util.KeyBindings;
import util.Log;
import util.Timer;
import util.TimerListener;

public class LocateCore
implements ChoiceListener,
Tool,
TimerListener,
LocateAPI {
    protected static final String NAME = "Locate";
    private static final String DISPLAY_NAME = "Profile";
    private static final String MODULE = "LocateCore";
    private static int UPDATE_RATE_ALARM;
    private static int PROFILE_MISSING_ALARM;
    private static int PROFILE_TOO_BIG_ALARM;
    private static int DEFAULT_MAX_SIG_SIZE;
    private static int RATE_INTERVAL;
    private static int POPUP_DELAY;
    protected static String LOCATE_FILE;
    protected static String LOCATE_INFO;
    protected static String DEFAULT_MIME_TYPE;
    protected static String BLANK_NICKNAME;
    private int EDIT_PROFILE_CHOICE;
    private BOSCore bosCore;
    private Tools tools;
    private boolean disabled = true;
    private Vector locates;
    private int maxSignatureSize;
    private boolean timerStarted = false;
    private String locateFile = String.valueOf(Oscar.ROOT) + LOCATE_FILE;
    private KeyBindings config;
    private int LINE_LENGTH = 76;
    public static String LOCATE_KEY;
    public static String WARNING_KEY;
    public static String EXPORT_LOCATE_KEY;
    public static String MIME_TYPE_KEY;
    public static String DATA_LENGTH_KEY;
    public static String DATA_BLOB_KEY;

    public LocateCore(BOSCore bOSCore, Tools tools) {
        this.bosCore = bOSCore;
        this.tools = tools;
        tools.register(this.getName(), this);
        this.locates = new Vector();
        this.maxSignatureSize = DEFAULT_MAX_SIG_SIZE;
        this.config = Oscar.config.getKeyBindingsOrAdd(LOCATE_KEY);
    }

    public void connect() {
    }

    public void disconnect() {
    }

    public void service() {
    }

    public Rate getRate() {
        return this.bosCore.getRate(BOSCore.GetUserSignature, new Date().getTime());
    }

    public String getSignatureMimeType() {
        return DEFAULT_MIME_TYPE;
    }

    public int getMaxSignatureSize() {
        return this.maxSignatureSize;
    }

    public byte[] getSignature() {
        byte[] byArray = null;
        byArray = this.readSignature();
        if (byArray == null || byArray.length == 0) {
            if (this.getValue(WARNING_KEY, false)) {
                Timer.createEvent("Slow UI Actions", this, PROFILE_MISSING_ALARM, null, POPUP_DELAY);
            }
            ErrorMgr.diag(MODULE, 6, "Missing Profile");
            byArray = LOCATE_INFO.getBytes();
        } else if (byArray != null && byArray.length > this.maxSignatureSize) {
            Integer n = new Integer(byArray.length);
            Timer.createEvent("Slow UI Actions", this, PROFILE_TOO_BIG_ALARM, n, POPUP_DELAY);
            byArray = LOCATE_INFO.getBytes();
        }
        return byArray;
    }

    public String getSignatureAsHTML() {
        byte[] byArray = this.readSignature();
        String string = byArray != null ? new String(byArray) : "";
        if (!string.toUpperCase().startsWith("<HTML>")) {
            string = JUtil.htmlize(string);
        }
        return string;
    }

    public LocateUI getUI(String string) {
        if (string == null) {
            string = "";
        }
        Enumeration enumeration = this.locates.elements();
        while (enumeration.hasMoreElements()) {
            LocateUI locateUI = (LocateUI)enumeration.nextElement();
            if (!locateUI.getNickname().equals(string)) continue;
            return locateUI;
        }
        return null;
    }

    public boolean getValue(String string, boolean bl) {
        String string2 = this.config.getValue(string);
        boolean bl2 = string2 != null ? string2.equalsIgnoreCase("true") : bl;
        return bl2;
    }

    public void locate(String string) {
        this.bosCore.getUserSignature(string);
    }

    public byte[] readSignature() {
        byte[] byArray;
        block4: {
            byArray = null;
            File file = new File(String.valueOf(Oscar.CONFIG_DIR) + LOCATE_FILE);
            if (!file.exists() || !file.canRead()) {
                file = new File(String.valueOf(Oscar.ROOT) + LOCATE_FILE);
            }
            if (!file.exists() || !file.canRead()) break block4;
            this.locateFile = file.getPath();
            int n = (int)file.length();
            if (n > 0) {
                byArray = new byte[(int)file.length()];
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    fileInputStream.read(byArray);
                }
                catch (IOException iOException) {
                    ErrorMgr.diag(MODULE, 3, "IO Error reading profile from \"" + file.getPath() + "\". ", iOException);
                }
            }
        }
        return byArray;
    }

    public void removeUI(LocateUI locateUI) {
        this.locates.removeElement(locateUI);
        System.gc();
    }

    public void setEnabled(boolean bl) {
        this.disabled = !bl;
        Enumeration enumeration = this.locates.elements();
        while (enumeration.hasMoreElements()) {
            LocateUI locateUI = (LocateUI)enumeration.nextElement();
            locateUI.setEnabled(bl);
        }
    }

    public void setMaxSignatureSize(int n) {
        this.maxSignatureSize = n;
    }

    public boolean setSignature(String string) {
        boolean bl = true;
        byte[] byArray = null;
        int n = 0;
        if (string == null) {
            string = "";
        }
        n = string.length();
        byArray = string.getBytes();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.locateFile);
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            bl = false;
            ErrorMgr.warn(MODULE, "An I/O error occured while attempting to save your profile. Please press OK to acknowledge this message.", iOException);
        }
        if (!this.disabled) {
            this.bosCore.setSignature(DEFAULT_MIME_TYPE, byArray);
        }
        return bl;
    }

    public void setUserSignature(Nickname nickname, String string, byte[] byArray) {
        LocateUI locateUI = this.getUI(nickname.nickname);
        if (locateUI == null) {
            locateUI = new LocateUI(this, this.tools, nickname.nickname);
            this.locates.addElement(locateUI);
        }
        locateUI.showData(nickname, string, byArray);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void updateRate() {
        Rate rate = this.getRate();
        if (rate == null) {
            return;
        }
        Enumeration enumeration = this.locates.elements();
        while (enumeration.hasMoreElements()) {
            LocateUI locateUI = (LocateUI)enumeration.nextElement();
            locateUI.updateRate(rate);
        }
    }

    public void updateUserEvil(String string, int n) {
        LocateUI locateUI = this.getUI(string);
        if (locateUI != null) {
            locateUI.updateUserEvil(n);
        }
    }

    public void updateUserInfo(Nickname nickname) {
        LocateUI locateUI = this.getUI(nickname.nickname);
        if (locateUI != null) {
            locateUI.updateUserInfo(nickname);
        }
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getName() {
        return NAME;
    }

    public int id() {
        return 1;
    }

    public int version() {
        return 1;
    }

    public String getModuleName() {
        return this.getName();
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        FolderInfo[] folderInfoArray = new FolderInfo[]{new FolderInfo(this, 0, this.getDisplayName(), "Info")};
        return folderInfoArray;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return new LocateProps(this, setupUI);
    }

    public void exportProperties(KeyBindings keyBindings, KeyBindings keyBindings2) {
        this.config = Oscar.config.getKeyBindings(LOCATE_KEY);
        String string = keyBindings2.getValue(LOCATE_KEY);
        if ((string == null || JUtil.isTrue(string)) && this.config != null) {
            KeyBindings keyBindings3 = keyBindings.addKeyBindings(EXPORT_LOCATE_KEY);
            int n = 0;
            while (n < this.config.size()) {
                String string2 = this.config.getKeyAt(n);
                string = this.config.getValue(string2);
                if (string != null && string.length() > 0) {
                    keyBindings3.setValue(string2, string);
                }
                ++n;
            }
            byte[] byArray = null;
            byArray = this.getSignature();
            if (byArray != null) {
                KeyBindings keyBindings4;
                keyBindings3.setValue(MIME_TYPE_KEY, this.getSignatureMimeType());
                keyBindings3.setValue(DATA_LENGTH_KEY, String.valueOf(byArray.length));
                String string3 = JUtil.toBase64(new String(byArray));
                int n2 = 0;
                int n3 = string3.length();
                while (n2 + this.LINE_LENGTH < n3) {
                    keyBindings4 = new KeyBindings(DATA_BLOB_KEY);
                    keyBindings4.addElement(string3.substring(n2, n2 + this.LINE_LENGTH));
                    keyBindings3.addElement(keyBindings4);
                    n2 += this.LINE_LENGTH;
                }
                keyBindings4 = new KeyBindings(DATA_BLOB_KEY);
                keyBindings4.addElement(string3.substring(n2));
                keyBindings3.addElement(keyBindings4);
            }
        }
    }

    public void importProperties(KeyBindings keyBindings, KeyBindings keyBindings2, KeyBindings keyBindings3, boolean bl) {
        KeyBindings keyBindings4 = Oscar.config.getKeyBindings(LOCATE_KEY);
        if (!bl && keyBindings4 != null) {
            keyBindings2.setValues(LOCATE_KEY, keyBindings4);
        }
        KeyBindings keyBindings5 = keyBindings.getKeyBindings(EXPORT_LOCATE_KEY);
        String string = keyBindings3.getValue(LOCATE_KEY);
        if ((string == null || JUtil.isTrue(string)) && keyBindings5 != null) {
            KeyBindings keyBindings6 = keyBindings2.addKeyBindings(LOCATE_KEY);
            int n = 0;
            while (n < keyBindings5.size()) {
                String string2 = keyBindings5.getKeyAt(n);
                if (!(string2.equalsIgnoreCase(MIME_TYPE_KEY) || string2.equalsIgnoreCase(DATA_LENGTH_KEY) || string2.equalsIgnoreCase(DATA_BLOB_KEY) || (string = keyBindings5.getValue(string2)) == null || string.length() <= 0)) {
                    keyBindings6.setValue(string2, string);
                }
                ++n;
            }
            string = keyBindings5.getValue(DATA_LENGTH_KEY);
            int n2 = 0;
            if (string != null && JUtil.isInteger(string)) {
                n2 = Integer.valueOf(string);
            }
            if (n2 > 0) {
                StringBuffer stringBuffer = new StringBuffer(n2 + 2);
                int n3 = 0;
                while ((string = keyBindings5.getValue(DATA_BLOB_KEY, n3)) != null && string.length() > 0) {
                    stringBuffer.append(string);
                    ++n3;
                }
                this.setSignature(JUtil.fromBase64(stringBuffer.toString()));
            }
        }
    }

    public boolean initiate(Vector vector, KeyBindings keyBindings) {
        LocateUI locateUI;
        String string = null;
        if (vector != null) {
            string = (String)vector.elementAt(0);
        }
        if (!this.timerStarted) {
            Timer.createEvent("System", this, UPDATE_RATE_ALARM, null, RATE_INTERVAL);
            this.timerStarted = true;
        }
        if ((locateUI = this.getUI(string)) != null) {
            ((Component)locateUI).setVisible(true);
        } else if (string != null) {
            this.locate(string);
        } else {
            locateUI = new LocateUI(this, this.tools, null);
            ((Component)locateUI).setVisible(true);
            this.locates.addElement(locateUI);
        }
        return true;
    }

    public void shutdown() {
        Log.log(MODULE, Log.INFO, "LocateCore got shutdown.");
    }

    public void choiceMade(int n, int n2, Object object) {
        if (n == this.EDIT_PROFILE_CHOICE && n2 == 0) {
            Oscar.setup(this, 0);
        }
    }

    public void timerEvent(String string, int n, Object object) {
        if (n == UPDATE_RATE_ALARM) {
            this.updateRate();
            Timer.createEvent("System", this, UPDATE_RATE_ALARM, null, RATE_INTERVAL);
            return;
        }
        if (n == PROFILE_MISSING_ALARM) {
            ChoiceUI.newChoiceUI(this, this.EDIT_PROFILE_CHOICE, null, "Alert: Missing Profile", "You have no personal profile. You may create one now or use \"" + LOCATE_INFO + "\".", "Create Profile", "Use Default", null, Oscar.WARNING_SOUND, true, false);
            return;
        }
        if (n == PROFILE_TOO_BIG_ALARM) {
            Integer n2 = (Integer)object;
            ChoiceUI.newChoiceUI(this, this.EDIT_PROFILE_CHOICE, null, "Alert: Profile Too Big", "Your personal profile is too big. The maximum size allowed is " + this.maxSignatureSize + " bytes. Your " + "profile exceeds this size by " + (n2 - this.maxSignatureSize) + " bytes. You may edit your profile " + "now or use \"" + LOCATE_INFO + "\".", "Edit Profile", "Use Default", null, Oscar.WARNING_SOUND, true, false);
        }
    }

    static {
        PROFILE_MISSING_ALARM = 1;
        PROFILE_TOO_BIG_ALARM = 2;
        DEFAULT_MAX_SIG_SIZE = 1024;
        RATE_INTERVAL = 1000;
        LOCATE_FILE = "Info.sig";
        LOCATE_INFO = "No Information Provided";
        DEFAULT_MIME_TYPE = "text/x-aolrtf";
        BLANK_NICKNAME = "<No Name>";
        LOCATE_KEY = NAME;
        WARNING_KEY = "missingWarning";
        EXPORT_LOCATE_KEY = "User.profile";
        MIME_TYPE_KEY = "mimeType";
        DATA_LENGTH_KEY = "dataLength";
        DATA_BLOB_KEY = "dataBlob";
    }
}

