/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BuddyCore;
import component.BuddyList;
import component.IcbmCore;
import component.ImportExportConstants;
import component.LocateCore;
import component.Tool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import main.LoginCore;
import main.Oscar;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.HorizontalRule;
import uiutil.IUtil;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.JUtil;
import util.KeyBindings;

public class ExportProps
extends PropertySheet
implements ActionListener,
ChangeListener,
ComponentListener,
ImportExportConstants,
ItemListener,
TextListener {
    private String MODULE = "ExportProps";
    private Frame frame;
    private Tools tools;
    private ChangeListener changeListener;
    private boolean changed = false;
    private List buddyListList;
    private Checkbox buddyCheck;
    private Checkbox nicknameCheck;
    private Checkbox connectionCheck;
    private Checkbox profileCheck;
    private Checkbox privacyCheck;
    private Checkbox imCheck;
    private TextField exportTextField;
    private Button exportButton;
    private KeyBindings preferences;

    public ExportProps(Frame frame, Tools tools, ChangeListener changeListener) {
        this.frame = frame;
        this.tools = tools;
        this.changeListener = changeListener;
        this.setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        this.add("North", new Spacer());
        this.add("West", new Spacer());
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout());
        this.add("Center", transparentPanel);
        TransparentPanel transparentPanel2 = new TransparentPanel(new BorderLayout());
        transparentPanel.add("West", transparentPanel2);
        transparentPanel2.add("North", new Label("Buddy Lists"));
        this.buddyListList = new List(2, true);
        transparentPanel2.add("Center", this.buddyListList);
        this.buddyListList.addItemListener(this);
        this.buddyListList.addComponentListener(this);
        TransparentPanel transparentPanel3 = new TransparentPanel(new GridLayout(0, 1, 0, 0));
        transparentPanel2.add("South", transparentPanel3);
        this.buddyCheck = new Checkbox("Buddy Preferences");
        transparentPanel3.add(this.buddyCheck);
        this.buddyCheck.addItemListener(this);
        transparentPanel3.add(new Spacer());
        transparentPanel3.add(new Spacer());
        transparentPanel3.add(new Spacer());
        transparentPanel2 = new TransparentPanel(new GridLayout(0, 1, 0, 0));
        transparentPanel.add("East", transparentPanel2);
        transparentPanel2.add(new Spacer());
        this.connectionCheck = new Checkbox("Connection Settings");
        transparentPanel2.add(this.connectionCheck);
        this.connectionCheck.addItemListener(this);
        this.nicknameCheck = new Checkbox("Saved User Name(s)");
        transparentPanel2.add(this.nicknameCheck);
        this.nicknameCheck.addItemListener(this);
        this.privacyCheck = new Checkbox("Privacy Preferences");
        transparentPanel2.add(this.privacyCheck);
        this.privacyCheck.addItemListener(this);
        this.imCheck = new Checkbox("IM Preferences");
        transparentPanel2.add(this.imCheck);
        this.imCheck.addItemListener(this);
        this.profileCheck = new Checkbox("Personal Profile");
        transparentPanel2.add(this.profileCheck);
        this.profileCheck.addItemListener(this);
        transparentPanel2.add(new Spacer());
        transparentPanel2.add(new Spacer());
        transparentPanel2.add(new Spacer());
        transparentPanel2 = new TransparentPanel(new BorderLayout());
        transparentPanel.add("South", transparentPanel2);
        transparentPanel2.add("North", new HorizontalRule(5, 5));
        transparentPanel3 = new TransparentPanel(new BorderLayout());
        transparentPanel2.add("Center", transparentPanel3);
        transparentPanel3.add("West", new Label("Export To:"));
        this.exportTextField = new TextField();
        transparentPanel3.add("Center", this.exportTextField);
        this.exportTextField.addTextListener(this);
        TransparentPanel transparentPanel4 = new TransparentPanel(new FlowLayout(1, 5, 0));
        transparentPanel3.add("East", transparentPanel4);
        this.exportButton = new Button("Export");
        transparentPanel4.add(this.exportButton);
        this.exportButton.addActionListener(this);
        transparentPanel2.add("South", new Spacer());
        this.preferences = Oscar.config.getKeyBindingsOrAdd("ImportExport.export");
        this.setValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog(this.frame, "Export File", 1);
        this.setFileDialog(fileDialog, this.exportTextField);
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String string = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            if (!string.equalsIgnoreCase(this.exportTextField.getText())) {
                ((TextComponent)this.exportTextField).setText(string);
            }
            this.exportConfiguration();
        }
    }

    public boolean changed() {
        return this.changed;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.buddyListList.makeVisible(0);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private void exportConfiguration() {
        Tool tool;
        FileOutputStream fileOutputStream;
        String string = this.exportTextField.getText();
        if (string == null || string.length() == 0) {
            ChoiceUI.newChoiceUI("Import / Export", "Please specify a filename to export to.");
            return;
        }
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            ChoiceUI.newChoiceUI("Import / Export", "Unable to open file \"" + string + "\". Export failed.");
            return;
        }
        KeyBindings keyBindings = new KeyBindings();
        keyBindings.setValue("Config.version", "1");
        KeyBindings keyBindings2 = new KeyBindings();
        this.saveBuddyListNames(keyBindings2);
        keyBindings2.setValue(BuddyCore.BUDDY_PREFS_KEY, String.valueOf(this.buddyCheck.getState()));
        keyBindings2.setValue(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.NICKNAME_KEY, String.valueOf(this.nicknameCheck.getState()));
        keyBindings2.setValue(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.LOGIN_KEY, String.valueOf(this.connectionCheck.getState()));
        keyBindings2.setValue(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.USE_PROXY_KEY, String.valueOf(this.connectionCheck.getState()));
        keyBindings2.setValue("Privacy", String.valueOf(this.privacyCheck.getState()));
        keyBindings2.setValue(LocateCore.LOCATE_KEY, String.valueOf(this.profileCheck.getState()));
        keyBindings2.setValue(IcbmCore.IM_KEY, String.valueOf(this.imCheck.getState()));
        Enumeration enumeration = this.tools.elements();
        while (enumeration.hasMoreElements()) {
            tool = (Tool)enumeration.nextElement();
            tool.exportProperties(keyBindings, keyBindings2);
        }
        try {
            keyBindings.write(new OutputStreamWriter(fileOutputStream), '{', '}', 0, false);
            tool = this.tools.get("Buddy List");
            IUtil.playSound(tool, "save");
            return;
        }
        catch (IOException iOException) {
            ChoiceUI.newChoiceUI("Export", "Error writing to file \"" + string + "\". Export failed.");
            return;
        }
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Export Help", "Export provides a way to selectively save your preferences to a file. The items selected or checked will be exported. Use the Export button to specify the name of the export file and to export your preferences. You can use the export file to transfer your preferences to " + Oscar.FULL_NAME + " installed on another computer. See help " + "under Import for information on how to import preferences. " + "If you want to save the information about how to export " + "your preferences, press the OK or Apply button in Setup.");
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    public void removeNotify() {
        this.removeAll();
        this.MODULE = null;
        this.tools = null;
        this.changeListener = null;
        this.buddyListList = null;
        this.buddyCheck = null;
        this.nicknameCheck = null;
        this.connectionCheck = null;
        this.profileCheck = null;
        this.privacyCheck = null;
        this.imCheck = null;
        this.exportTextField = null;
        this.exportButton = null;
        this.preferences = null;
        super.removeNotify();
    }

    public boolean save() {
        this.saveBuddyListNames(this.preferences);
        this.preferences.setValue(BuddyCore.BUDDY_PREFS_KEY, String.valueOf(this.buddyCheck.getState()));
        this.preferences.setValue(IcbmCore.IM_KEY, String.valueOf(this.imCheck.getState()));
        this.preferences.setValue(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.NICKNAME_KEY, String.valueOf(this.nicknameCheck.getState()));
        this.preferences.setValue(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.LOGIN_KEY, String.valueOf(this.connectionCheck.getState()));
        this.preferences.setValue(LocateCore.LOCATE_KEY, String.valueOf(this.profileCheck.getState()));
        this.preferences.setValue("Privacy", String.valueOf(this.privacyCheck.getState()));
        String string = this.exportTextField.getText();
        if (string == null || string.length() == 0) {
            this.preferences.deleteKey("file");
        } else {
            this.preferences.setValue("file", string.replace(File.separatorChar, '/'));
        }
        this.setChanged(false);
        return true;
    }

    private void saveBuddyListNames(KeyBindings keyBindings) {
        String[] stringArray = this.buddyListList.getSelectedItems();
        keyBindings.deleteKey(BuddyCore.BUDDY_LIST_KEY);
        keyBindings.addKeyBindings(BuddyCore.BUDDY_LIST_KEY);
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            keyBindings.appendValue(BuddyCore.BUDDY_LIST_KEY, stringArray[n]);
            ++n;
        }
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    private void setFileDialog(FileDialog fileDialog, TextField textField) {
        String string = textField.getText();
        if (string != null) {
            String string2;
            int n = string.lastIndexOf(File.separator);
            if (n != -1) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            } else {
                string2 = string;
                string = null;
            }
            if (string != null) {
                fileDialog.setDirectory(string);
            }
            fileDialog.setFile(string2);
        }
    }

    public void setValues() {
        this.setValuesForBuddyList(Oscar.config.getKeyBindings(BuddyCore.BUDDY_LIST_KEY), this.preferences);
        String string = this.preferences.getValueDefault(BuddyCore.BUDDY_PREFS_KEY, "true");
        this.buddyCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.NICKNAME_KEY, "true");
        this.nicknameCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.LOGIN_KEY, "true");
        this.connectionCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault(LocateCore.LOCATE_KEY, "true");
        this.profileCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault("Privacy", "true");
        this.privacyCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault(IcbmCore.IM_KEY, "true");
        this.imCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault("file", "");
        ((TextComponent)this.exportTextField).setText(string.replace('/', File.separatorChar));
        this.setChanged(false);
    }

    private void setValuesForBuddyList(KeyBindings keyBindings, KeyBindings keyBindings2) {
        KeyBindings keyBindings3 = null;
        BuddyCore buddyCore = (BuddyCore)this.tools.get("Buddy List");
        BuddyList[] buddyListArray = new BuddyList[]{};
        int n = 0;
        if (keyBindings != null) {
            buddyListArray = buddyCore.getBuddyListsFromKeyBindings(keyBindings);
        }
        this.buddyListList.removeAll();
        if (keyBindings2 != null) {
            keyBindings3 = keyBindings2.getValues(BuddyCore.BUDDY_LIST_KEY);
        }
        if (keyBindings3 != null) {
            n = keyBindings3.size();
        }
        int n2 = 0;
        while (n2 < buddyListArray.length) {
            this.buddyListList.addItem(buddyListArray[n2].name());
            if (keyBindings3 == null) {
                this.buddyListList.select(n2);
            }
            int n3 = 0;
            while (n3 < n) {
                String string = (String)keyBindings3.elementAt(n3);
                if (string.equals(buddyListArray[n2].name())) {
                    this.buddyListList.select(n2);
                    break;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.setChanged(true);
    }
}

