/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class DelaySubroutine
extends JFrame {
    Assembler o;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBoxDelayChoice;
    private JComboBox jComboBoxReg1;
    private JComboBox jComboBoxReg2;
    private JComboBox jComboBoxReg3;
    private JComboBox jComboBoxRegPair;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelMaximumDelay;
    private JLabel jLabelMinimumDelay;
    private JTextField jTextFieldDelayLabel;
    private JTextField jTextFieldDelayTime;
    private JTextField jTextFieldTstate;

    public DelaySubroutine() {
        this.initComponents();
        this.choiceHide(3);
    }

    public DelaySubroutine(Assembler o) {
        this.o = o;
        this.initComponents();
        this.choiceHide(3);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldDelayLabel = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldDelayTime = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jComboBoxDelayChoice = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jLabelMaximumDelay = new JLabel();
        this.jLabel7 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel6 = new JLabel();
        this.jTextFieldTstate = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jComboBoxReg1 = new JComboBox();
        this.jComboBoxReg2 = new JComboBox();
        this.jComboBoxReg3 = new JComboBox();
        this.jComboBoxRegPair = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabelMinimumDelay = new JLabel();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Delay Subroutine");
        this.setAlwaysOnTop(true);
        this.setBounds(new Rectangle(300, 150, 0, 0));
        this.setResizable(false);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setForeground(new Color(102, 0, 102));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Delay Subroutine Label : ");
        this.jLabel1.setName("jLabel1");
        this.jTextFieldDelayLabel.setHorizontalAlignment(0);
        this.jTextFieldDelayLabel.setName("jTextFieldDelayLabel");
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setForeground(new Color(0, 102, 102));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Delay for  :");
        this.jLabel2.setName("jLabel2");
        this.jTextFieldDelayTime.setHorizontalAlignment(0);
        this.jTextFieldDelayTime.setName("jTextFieldDelayTime");
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("ms");
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setForeground(new Color(102, 102, 0));
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Format of Subroutine  : ");
        this.jLabel4.setName("jLabel4");
        this.jComboBoxDelayChoice.setFont(new Font("Tahoma", 1, 11));
        this.jComboBoxDelayChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Delay Subroutine using One Register", "Delay Subroutine using Two Registers", "Delay Subroutine using Three Registers", "Delay Subroutine using Register Pair"}));
        this.jComboBoxDelayChoice.setSelectedIndex(3);
        this.jComboBoxDelayChoice.setName("jComboBoxDelayChoice");
        this.jComboBoxDelayChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DelaySubroutine.this.jComboBoxDelayChoiceActionPerformed(evt);
            }
        });
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setForeground(new Color(102, 0, 102));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("For this format maximum delay can be of ");
        this.jLabel5.setName("jLabel5");
        this.jLabelMaximumDelay.setFont(new Font("Tahoma", 1, 11));
        this.jLabelMaximumDelay.setForeground(new Color(0, 0, 102));
        this.jLabelMaximumDelay.setText("100");
        this.jLabelMaximumDelay.setName("jLabelMaximumDelay");
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setForeground(new Color(153, 0, 153));
        this.jLabel7.setText("ms");
        this.jLabel7.setName("jLabel7");
        this.jButton1.setText("OK");
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DelaySubroutine.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setForeground(new Color(51, 153, 0));
        this.jLabel6.setText("Time for 1 T-state : ");
        this.jLabel6.setName("jLabel6");
        this.jTextFieldTstate.setHorizontalAlignment(0);
        this.jTextFieldTstate.setText("320");
        this.jTextFieldTstate.setName("jTextFieldTstate");
        this.jTextFieldTstate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DelaySubroutine.this.jTextFieldTstateActionPerformed(evt);
            }
        });
        this.jTextFieldTstate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DelaySubroutine.this.jTextFieldTstateKeyReleased(evt);
            }
        });
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText("ns");
        this.jLabel8.setName("jLabel8");
        this.jLabel9.setFont(new Font("Tahoma", 1, 11));
        this.jLabel9.setForeground(new Color(102, 0, 0));
        this.jLabel9.setHorizontalAlignment(0);
        this.jLabel9.setText("Registers used : ");
        this.jLabel9.setName("jLabel9");
        this.jComboBoxReg1.setModel(new DefaultComboBoxModel<String>(new String[]{"A", "B", "C", "D", "E", "H", "L"}));
        this.jComboBoxReg1.setName("jComboBoxReg1");
        this.jComboBoxReg2.setModel(new DefaultComboBoxModel<String>(new String[]{"A", "B", "C", "D", "E", "H", "L"}));
        this.jComboBoxReg2.setName("jComboBoxReg2");
        this.jComboBoxReg3.setModel(new DefaultComboBoxModel<String>(new String[]{"A", "B", "C", "D", "E", "H", "L"}));
        this.jComboBoxReg3.setName("jComboBoxReg3");
        this.jComboBoxRegPair.setModel(new DefaultComboBoxModel<String>(new String[]{"B-C", "D-E", "H-L"}));
        this.jComboBoxRegPair.setName("jComboBoxRegPair");
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setForeground(new Color(102, 0, 102));
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setText("& minimum delay of ");
        this.jLabel10.setName("jLabel10");
        this.jLabel11.setFont(new Font("Tahoma", 1, 11));
        this.jLabel11.setForeground(new Color(153, 0, 153));
        this.jLabel11.setText("ms ");
        this.jLabel11.setName("jLabel11");
        this.jLabelMinimumDelay.setFont(new Font("Tahoma", 1, 11));
        this.jLabelMinimumDelay.setForeground(new Color(0, 0, 102));
        this.jLabelMinimumDelay.setText("100");
        this.jLabelMinimumDelay.setName("jLabelMinimumDelay");
        this.jButton2.setText("Cancel");
        this.jButton2.setName("jButton2");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DelaySubroutine.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDelayTime, -1, 76, Short.MAX_VALUE)).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxDelayChoice, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(46, 46, 46).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldTstate, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8)).addComponent(this.jTextFieldDelayLabel, -2, 83, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addGap(5, 5, 5).addComponent(this.jLabelMinimumDelay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11).addGap(46, 46, 46).addComponent(this.jButton1, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton2, -2, 87, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxReg1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jComboBoxReg2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jComboBoxReg3, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jComboBoxRegPair, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelMaximumDelay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldDelayLabel, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldDelayTime, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jTextFieldTstate, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jLabel8)).addGap(31, 31, 31).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jComboBoxDelayChoice, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jComboBoxReg1, -2, -1, -2).addComponent(this.jComboBoxReg2, -2, -1, -2).addComponent(this.jComboBoxReg3, -2, -1, -2).addComponent(this.jComboBoxRegPair, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabelMaximumDelay).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jLabelMinimumDelay).addComponent(this.jLabel11)).addGap(20, 20, 20)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()))));
        this.pack();
    }

    public boolean check() {
        Float f = Float.valueOf(0.0f);
        boolean check = false;
        try {
            f = Float.valueOf(this.jTextFieldDelayTime.getText());
            if (f.floatValue() < Float.valueOf(this.jLabelMinimumDelay.getText()).floatValue()) {
                Popup.show("It cannot be smaller than minimum value");
            } else if (f.floatValue() > Float.valueOf(this.jLabelMaximumDelay.getText()).floatValue()) {
                Popup.show("It cannot be larger than maximum value");
            } else {
                check = true;
            }
        }
        catch (Exception e) {
            Popup.show("Invalid Number");
            this.jTextFieldDelayTime.setText("1");
        }
        return check;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.check()) {
            int choice = this.jComboBoxDelayChoice.getSelectedIndex();
            if (choice == 0) {
                this.delayReg1();
            } else if (choice == 1) {
                this.delayReg2();
            } else if (choice == 2) {
                this.delayReg3();
            } else if (choice == 3) {
                this.delaySubRegPair();
            }
            this.dispose();
        }
    }

    private void jComboBoxDelayChoiceActionPerformed(ActionEvent evt) {
        this.choiceHide(this.jComboBoxDelayChoice.getSelectedIndex());
    }

    private void jTextFieldTstateActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldTstateKeyReleased(KeyEvent evt) {
        this.choiceHide(this.jComboBoxDelayChoice.getSelectedIndex());
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void choiceHide(int choice) {
        int tState = 0;
        try {
            tState = Integer.parseInt(this.jTextFieldTstate.getText());
        }
        catch (Exception e) {
            this.jTextFieldTstate.setText(String.valueOf(tState));
        }
        this.jComboBoxReg1.setVisible(false);
        this.jComboBoxReg2.setVisible(false);
        this.jComboBoxReg3.setVisible(false);
        this.jComboBoxRegPair.setVisible(false);
        switch (choice) {
            case 0: {
                this.jComboBoxReg1.setVisible(true);
                this.jComboBoxReg1.setSelectedIndex(1);
                this.jLabelMinimumDelay.setText(String.valueOf(0.028 * (double)tState / 1000.0));
                this.jLabelMaximumDelay.setText(String.valueOf(3.584 * (double)tState / 1000.0));
                break;
            }
            case 1: {
                this.jComboBoxReg1.setVisible(true);
                this.jComboBoxReg2.setVisible(true);
                this.jComboBoxReg1.setSelectedIndex(1);
                this.jComboBoxReg2.setSelectedIndex(2);
                this.jLabelMinimumDelay.setText(String.valueOf(0.046 * (double)tState / 1000.0));
                this.jLabelMaximumDelay.setText(String.valueOf(914.954 * (double)tState / 1000.0));
                break;
            }
            case 2: {
                this.jComboBoxReg1.setVisible(true);
                this.jComboBoxReg2.setVisible(true);
                this.jComboBoxReg3.setVisible(true);
                this.jComboBoxReg1.setSelectedIndex(1);
                this.jComboBoxReg2.setSelectedIndex(2);
                this.jComboBoxReg3.setSelectedIndex(3);
                this.jLabelMinimumDelay.setText(String.valueOf(0.064 * (double)tState / 1000.0));
                this.jLabelMaximumDelay.setText(String.valueOf(233.314304 * (double)tState));
                break;
            }
            case 3: {
                this.jComboBoxRegPair.setVisible(true);
                this.jLabelMinimumDelay.setText(String.valueOf(0.408 * (double)tState / 1000.0));
                this.jLabelMaximumDelay.setText(String.valueOf(1.572857 * (double)tState));
                break;
            }
        }
    }

    public String delaySubRegPair() {
        String s = "";
        int tState = 0;
        try {
            tState = Integer.parseInt(this.jTextFieldTstate.getText());
        }
        catch (Exception e) {
            this.jTextFieldTstate.setText(String.valueOf(tState));
        }
        int TStates = 0;
        try {
            TStates = (int)(Double.parseDouble(this.jTextFieldDelayTime.getText()) * 1000.0 * 1000.0);
        }
        catch (Exception e) {
            this.jTextFieldTstate.setText(String.valueOf(TStates));
        }
        int count = (TStates / tState - 17) / 24;
        String space = "\t   ";
        String D = this.jComboBoxRegPair.getItemAt(this.jComboBoxRegPair.getSelectedIndex()).toString();
        String E = String.valueOf(D.charAt(2));
        D = String.valueOf(D.charAt(0));
        s = this.jTextFieldDelayLabel.getText() + ":";
        s = s + "\n" + space + "LXI " + D + "," + this.o.engine.Dec2Hex(count);
        s = s + "\n" + this.jTextFieldDelayLabel.getText() + "Loop:\n" + space + "DCX " + D;
        s = s + "\n" + space + "MOV A," + D;
        s = s + "\n" + space + "ORA " + E;
        s = s + "\n" + space + "JNZ " + this.jTextFieldDelayLabel.getText() + "Loop";
        s = s + "\n" + space + "RET";
        this.o.jTextAreaAssemblyLanguageEditor.setText(this.o.jTextAreaAssemblyLanguageEditor.getText() + s);
        this.o.textEditor.colorEditor();
        return s;
    }

    public String delayReg1() {
        String s = "";
        int tState = 0;
        try {
            tState = Integer.parseInt(this.jTextFieldTstate.getText());
        }
        catch (Exception e) {
            this.jTextFieldTstate.setText(String.valueOf(tState));
        }
        int TStates = 0;
        try {
            TStates = (int)(Double.parseDouble(this.jTextFieldDelayTime.getText()) * 1000.0 * 1000.0);
        }
        catch (Exception e) {
            this.jTextFieldTstate.setText(String.valueOf(TStates));
        }
        int noTstate = TStates / tState;
        int count = noTstate / 14 - 1;
        String space = "\t   ";
        String B = this.jComboBoxReg1.getItemAt(this.jComboBoxReg1.getSelectedIndex()).toString();
        s = this.jTextFieldDelayLabel.getText() + ":";
        s = s + "\n" + space + "MVI " + B + "," + this.o.engine.Dec2Hex2digit(count);
        s = s + "\n" + this.jTextFieldDelayLabel.getText() + "Loop:\n" + space + "DCR " + B;
        s = s + "\n" + space + "JNZ " + this.jTextFieldDelayLabel.getText() + "Loop";
        s = s + "\n" + space + "RET";
        this.o.jTextAreaAssemblyLanguageEditor.setText(this.o.jTextAreaAssemblyLanguageEditor.getText() + s);
        this.o.textEditor.colorEditor();
        return s;
    }

    public int[] solveReg2(int tstates) {
        int present = 0;
        int x = 0;
        int y = 0;
        int[] a = new int[]{0, 0};
        int past = 0;
        int px = 0;
        int py = 0;
        for (x = 0; x < 256; ++x) {
            for (y = 0; y < 256; ++y) {
                present = 14 + 18 * x + 14 * x * y;
                if (present / tstates < 1 || !((double)(present / tstates) < 1.00002)) continue;
                if (past == 0) {
                    past = present;
                }
                if (past % tstates < present % tstates) continue;
                past = present;
                px = x;
                py = y;
            }
        }
        a[0] = px;
        a[1] = py;
        return a;
    }

    public String delayReg2() {
        String s = "";
        int tState = 0;
        try {
            tState = Integer.parseInt(this.jTextFieldTstate.getText());
        }
        catch (Exception e) {
            this.jTextFieldTstate.setText(String.valueOf(tState));
        }
        int TStates = 0;
        try {
            TStates = (int)(Double.parseDouble(this.jTextFieldDelayTime.getText()) * 1000.0 * 1000.0);
        }
        catch (Exception e) {
            this.jTextFieldTstate.setText(String.valueOf(TStates));
        }
        int noTstate = TStates / tState;
        int[] count = this.solveReg2(noTstate);
        String space = "\t   ";
        String B = this.jComboBoxReg1.getItemAt(this.jComboBoxReg1.getSelectedIndex()).toString();
        String C = this.jComboBoxReg2.getItemAt(this.jComboBoxReg2.getSelectedIndex()).toString();
        s = this.jTextFieldDelayLabel.getText() + ":";
        s = s + "\n" + space + "MVI " + B + "," + this.o.engine.Dec2Hex2digit(count[0]);
        s = s + "\n" + this.jTextFieldDelayLabel.getText() + "Loop1:\n" + space + "MVI " + C + "," + this.o.engine.Dec2Hex2digit(count[1]);
        s = s + "\n" + this.jTextFieldDelayLabel.getText() + "Loop2:\n" + space + "DCR " + C;
        s = s + "\n" + space + "JNZ " + this.jTextFieldDelayLabel.getText() + "Loop2";
        s = s + "\n" + space + "DCR " + B;
        s = s + "\n" + space + "JNZ " + this.jTextFieldDelayLabel.getText() + "Loop1";
        s = s + "\n" + space + "RET";
        this.o.jTextAreaAssemblyLanguageEditor.setText(this.o.jTextAreaAssemblyLanguageEditor.getText() + s);
        this.o.textEditor.colorEditor();
        return s;
    }

    public int[] solveReg3(long tstates) {
        long present = 0L;
        long past = 0L;
        int x = 0;
        int y = 0;
        int z = 0;
        int[] a = new int[]{0, 0, 0};
        int px = 0;
        int py = 0;
        int pz = 0;
        for (x = 0; x < 256; ++x) {
            for (y = 0; y < 256; ++y) {
                for (z = 0; z < 256; ++z) {
                    present = 14 + 18 * x + 18 * x * y + 14 * x * y * z;
                    if (present / tstates < 1L || !((double)(present / tstates) < 1.00002)) continue;
                    if (past == 0L) {
                        past = present;
                    }
                    if (past % tstates < present % tstates) continue;
                    past = present;
                    px = x;
                    py = y;
                    pz = z;
                }
            }
        }
        a[0] = px;
        a[1] = py;
        a[2] = pz;
        return a;
    }

    public String delayReg3() {
        String s = "";
        long tState = 0L;
        try {
            tState = Integer.parseInt(this.jTextFieldTstate.getText());
        }
        catch (Exception e) {
            this.jTextFieldTstate.setText(String.valueOf(tState));
        }
        long TStates = 0L;
        try {
            TStates = (long)(Double.parseDouble(this.jTextFieldDelayTime.getText()) * 1000.0 * 1000.0);
        }
        catch (Exception e) {
            this.jTextFieldTstate.setText(String.valueOf(TStates));
        }
        long noTstate = TStates / tState;
        int[] count = this.solveReg3(noTstate);
        String space = "\t   ";
        String B = this.jComboBoxReg1.getItemAt(this.jComboBoxReg1.getSelectedIndex()).toString();
        String C = this.jComboBoxReg2.getItemAt(this.jComboBoxReg2.getSelectedIndex()).toString();
        String D = this.jComboBoxReg3.getItemAt(this.jComboBoxReg3.getSelectedIndex()).toString();
        s = this.jTextFieldDelayLabel.getText() + ":";
        s = s + "\n" + space + "MVI " + B + "," + this.o.engine.Dec2Hex2digit(count[0]);
        s = s + "\n" + this.jTextFieldDelayLabel.getText() + "Loop1:\n" + space + "MVI " + C + "," + this.o.engine.Dec2Hex2digit(count[1]);
        s = s + "\n" + this.jTextFieldDelayLabel.getText() + "Loop2:\n" + space + "MVI " + D + "," + this.o.engine.Dec2Hex2digit(count[2]);
        s = s + "\n" + this.jTextFieldDelayLabel.getText() + "Loop3:\n" + space + "DCR " + D;
        s = s + "\n" + space + "JNZ " + this.jTextFieldDelayLabel.getText() + "Loop3";
        s = s + "\n" + space + "DCR " + C;
        s = s + "\n" + space + "JNZ " + this.jTextFieldDelayLabel.getText() + "Loop2";
        s = s + "\n" + space + "DCR " + B;
        s = s + "\n" + space + "JNZ " + this.jTextFieldDelayLabel.getText() + "Loop1";
        s = s + "\n" + space + "RET";
        this.o.jTextAreaAssemblyLanguageEditor.setText(this.o.jTextAreaAssemblyLanguageEditor.getText() + s);
        this.o.textEditor.colorEditor();
        return s;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DelaySubroutine(new Assembler()).setVisible(true);
            }
        });
    }
}

