#include<process.h>
#include<alloc.h>
#include"wir.h"

int loaddir(unsigned cluster)
{
  unsigned*fat;
  unsigned long ul;
  int n,i;

  if(dir){
    farfree(dir);
    dir=NULL;
  }
  for(n=0;cluster<0xFFF8;++n){
    /*
     * Check cluster number validation
     */
    if(cluster>dpb.maxcl||cluster<2){
      fprintf(stderr,"Bad cluster number 0x%04X was found.\n",cluster);
      exit(1);
    }
    /* Load subdirectory into reallocated memory
     */
    ul=((unsigned long)(n+1)<<dpb.sft)*dpb.bps;
    if(!(dir=n?farrealloc(dir,ul):farmalloc(ul)))
      error("Not enough memory to read subdirectory");

    if(farabsread(ul=((unsigned long)(cluster-2)<<dpb.sft)+dpb.data,1<<dpb.sft,
		  MK_FP(FP_SEG(dir)+(n<<(dpb.sft-4))*dpb.bps,FP_OFF(dir)))){
      fprintf(stderr,"Can't read subdirectory cluster %u (sector %lu-%lu)\n",
	      cluster,ul,ul+(1<<dpb.sft)-1);
      exit(1);
    }
    /* Trace FAT chain
     */
    if(!(fat=malloc(dpb.bps)))
      error("Not enough memory to trace FAT");

    i=dpb.nfats;
    for(ul=cluster/(dpb.bps/2)+dpb.rsv;farabsread(ul,1,fat);ul+=dpb.sfats)
      if(--i<=0){
	fprintf(stderr,"Can't read FAT sector %lu.\n",ul);
	exit(1);
      }
    cluster=fat[cluster&(dpb.bps/2-1)];
    free(fat);
  }
  return(short)((unsigned long)n*dpb.bps<<(dpb.sft-5));
}
