/********************************************************copyrite.xic***/
/*                                                                     */
/*   Licensed Materials - Property of IBM                              */
/*                                                                     */
/*   This product contains "Restricted Materials of IBM":              */
/*      Program Number:   5798RXW                                      */
/*      Program Name:     IBM TCP/IP Version 1.2 for OS/2              */
/*   (C) Copyright IBM Corporation. 1990, 1991.                        */
/*                                                                     */
/*   All rights reserved.                                              */
/*                                                                     */
/*   US Government Users Restricted Rights -                           */
/*   Use, duplication or disclosure restricted by GSA ADP Schedule     */
/*   Contract with IBM Corp.                                           */
/*                                                                     */
/*   See IBM Copyright Instructions.                                   */
/*                                                                     */
/*   SELECTS is a TCP server that accepts a file transfered from       */
/*   SENDFILE client.  The file is written to the default directory    */
/*   as tmpfile.                                                       */
/*                                                                     */
/*   SELECTS is a UDP server that receives a message sent by SENDMSG   */
/*   (up to 80 charcters), displays it and its origin.                 */
/*                                                                     */
/*                                                                     */
/********************************************************copyrite.xic***/
/*
 * Simple TCP and UDP server using BSD select() call.
 */
#ifndef BSD_SELECT
#define BSD_SELECT
#endif

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <memory.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>

#include <sys\tcptypes.h>
#include <sys\utils.h>
#include <sys\socket.h>
#include <netinet\in.h>
#include <arpa\inet.h>
#include <sys\ioctl.h>
#include <sys\errno.h>


int main(int argc,char * argv[])
{
    unsigned short port;           /* port server binds to                  */
    char buf[82];                  /* buffer for sending and receiving data */
    struct sockaddr_in tcp_client; /* client address information            */
    struct sockaddr_in tcp_server; /* server address information            */
    struct sockaddr_in udp_client;
    struct sockaddr_in udp_server;
    int tcpsock,udpsock;           /* socket for accepting connections      */
    int ns;                        /* socket connected to client            */
    int namelen;                   /* length of client name                 */
    int client_address_size;
    fd_set rdfds;                  /* read set mask for select() call */
    int width=0;                   /* # bits to be checked for select() call */
    int readysock=0;
    int on = 1;
    int i;
    struct timeval timeout;
    int tfileno;

/*
 * Check arguments. Should be only one: the port number to bind to.
 */

    if (argc != 2)
    {
        fprintf(stderr, "Usage: %s port\n", argv[0]);
        exit(1);
    }

/*
 * Check if INET is running.
 */
    if ( sock_init() )
    {
       printf("TCPIP is not running");
       exit(2);
    }

/*
 * First argument should be the port.
 */
    port = (unsigned short) atoi(argv[1]);

/*
 *
 * TCP SERVER
 *
 * Get a TCP socket for accepting connections.
 */
    if ((tcpsock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
        perror("Socket()");
        exit(3);
    }

/*
 * Bind the TCP socket to the server address.
 */
    tcp_server.sin_family = AF_INET;
    tcp_server.sin_port   = htons(port);
    tcp_server.sin_addr.s_addr = INADDR_ANY;

    if (bind(tcpsock,(struct sockaddr _far *) &tcp_server, sizeof(tcp_server)) < 0)
    {
        perror("Bind()");
        exit(4);
    }

/*
 * Listen for connections. Specify the backlog as 5.
 */
    if (listen(tcpsock, 5) != 0)
    {
        perror("Listen()");
        exit(5);
    }

/*
 *  UDP SERVER
 *
 * Create a UDP socket in the internet domain and use the
 * default protocol (UDP).
 */
   if ((udpsock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
   {
       perror("socket()");
       exit(6);
   }
/*
 *
 * Bind the UDP socket to the server address.
 *
 */
   udp_server.sin_family      = AF_INET;    /* Server is in Internet Domain */
   udp_server.sin_port        = htons(port);
   udp_server.sin_addr.s_addr = INADDR_ANY; /* Server's Internet Address    */

   if (bind(udpsock,(struct sockaddr _far *) &udp_server, sizeof(udp_server)) < 0)
   {
       perror("bind()");
       exit(7);
   }

   for(;;)
   {
        /*
         *  polling every 10 seconds instead of blocking indefinitely.
         */
        timeout.tv_sec = 10l;
        timeout.tv_usec = 0l;

        /*
         * read set mask is zeroed before use
         */
        FD_ZERO( &rdfds );

        /*
         * add socket discriptor in the read set mask.
         */
        FD_SET( tcpsock, &rdfds );
        if ( tcpsock > width ) width = tcpsock;
        FD_SET( udpsock, &rdfds );
        if ( udpsock > width ) width = udpsock;

        /*
         * width can be FD_SETSIZE, i.e. 512.
         */
        width++;

        /*
         * Select() returns the number of socket descriptors selected;
         * if it returns 0 then it timed out.
         * if it returns -1 then there is an error.
         */
        if ((readysock=select(width, &rdfds, (fd_set *)0, (fd_set *)0, &timeout)) == -1)
         {
           perror("Select()");
           exit(8);
         }

        if (readysock > 0)
         {
           /*
            * Check read readiness on the socket.
            */
           if(FD_ISSET(tcpsock,&rdfds))
            {
             /*
              * Accept a connection.
              */
              namelen = sizeof(tcp_client);
              if ((ns = accept(tcpsock,(struct sockaddr _far *) &tcp_client, &namelen)) == -1)
               {
                  perror("Accept()");
                  exit(9);
               }

              tfileno = open("tmpfile", O_CREAT | O_BINARY | O_RDWR);
              (void)ioctl(ns, FIONBIO, (caddr_t) &on);

              printf("\nReceiving tmpfile\n");

              while ((i=recv(ns, buf, sizeof(buf), 0)) != 0) {
                 if(i < 0)  {
                    if (tcperrno == EWOULDBLOCK)
                       continue;
                    break;
                 } /* endif */
                 write(tfileno, (void *)buf, i);
              } /* endwhile */

              close(tfileno);
              soclose(ns);
              printf("TCP Server received successfully\n");
            }


           if(FD_ISSET(udpsock,&rdfds))
            {
             /*
              * Receive a message on socket udpsock in buf  of maximum size 32
              * from a client.
              */
              client_address_size = sizeof(udp_client);

              if(recvfrom(udpsock, buf, sizeof(buf), 0, (struct sockaddr *) &udp_client,
                          &client_address_size) <0)
               {
                 perror("recvfrom()");
                 exit(12);
               }
             /*
              * Print the message and the name of the client.
              */
              printf("Received message %s from domain %s port %d internet address %s\n",
              buf,
              (udp_client.sin_family == AF_INET?"AF_INET":"UNKNOWN"),
              ntohs(udp_client.sin_port),
              inet_ntoa(udp_client.sin_addr));

              if(sendto(udpsock, buf, sizeof(buf), 0, (struct sockaddr *) &udp_client,
                       sizeof(udp_client)) <0)
              {
                  perror("sendto()");
                  exit(4);
              }
           }
         } else {
           if (kbhit()) break;
/*         putch('.'); */
         }
   } /* end of for(;;) loop */
 soclose(tcpsock);
 soclose(udpsock);
 return(0);
}
