;
; ணࠬ ନ஢  IDE ᪮                           
; ᪮ ࠢ (C) 1994 樠   .⥪         
;

       include Support.inc
       include Control.inc
       include Global.inc
       include Constant.inc

       include IdeInfo.inc

.data
;ͻ
; 饭 
;ͼ

msgTitle    DB  "IDE Driver(s) Information. Version 1.00",CR,LF
            DB  "Copyright (C) 1994 Medinform Assotiation and D.Steklenev",CR,LF,CR,LF,0

msgDrive0   DB  "Drive 0 ",0
msgDrive1   DB  "Drive 1 ",0
msgDrive3   DB  "Drive 3 ",0
msgDrive4   DB  "Drive 4 ",0

msgNotIDE   DB  "is not IDE driver or not installed",CR,LF,0
msgInform   DB  "information"                       ,CR,LF,CR,LF,0

msgSerialNo DB  " Serial Number: ",0
msgVersion  DB  " Model Version: ",0
msgModelNo  DB  " Model  Number: ",0

msgGeometry DB  "      Geometry: Cylinders Heads Sectors Byte/Sect Size,Mb ECC 32-bits",CR,LF
            DB  "                ========= ===== ======= ========= ======= === =======",CR,LF,0

msgTotal    DB  "         Total:",0
msgCurrent  DB  "       Current:",0

msgYes      DB  " Yes"       ,0
msgNo       DB  " No "       ,0
msgBeeg     DB  "   Beeg!"   ,0
msgDosByte  DB  "       512" ,0

msgBuffSize DB  "   Buffer Size: ",0
msgSpeed    DB  "         Speed: ",0
msgSpeedDMA DB  "Speed with DMA: ",0

msgKB       DB  " kb",0

msgLow      DB  "Low    ",CR,LF,0
msgMedium   DB  "Medium ",CR,LF,0
msgFast     DB  "Fast   ",CR,LF,0
msgUnknown  DB  "Unknown",CR,LF,0


;ͻ
;   
;ͼ

;-----------------------------------;
info      DB  512 dup (0)           ;  ଠ樨
;-----------------------------------;
strCyls   DB  "0000000000",0        ; ᫮ 樫஢
strHead   DB  "000000"    ,0        ; ᫮ 
strSect   DB  "00000000"  ,0        ; ᫮ ᥪ஢
strWord   DB  "00000"     ,0        ; ப 樨 ᫮.
strECC    DB  "0000"      ,0        ; ᫮  ECC
strSize   DB  "00000000"  ,0        ; 
strByte   DB  "0000000000",0        ;   ᥪ
;-----------------------------------;

.code
.startup
;ͻ
;  楤                                                    
;ͼ
ideStart proc near

  @out  msgTitle              ;뢥 ᪨ ࠢ.

  @out  msgDrive0             ;0- ᪮
  xor   ax,ax                 ; IDE ଠ
  call  ideGetInfo            ; ᪮.
  @if   ax == TRUE            ;᫨ ଠ 祭,
        @out  msgInform       ;⮡ࠧ   ࠭.
        call  ideShowInfo
  @else
        @out  msgNotIDE       ;뢥 ᮮ饭 
  @endif                      ;⢨ IDE ࠩ.

  call  _dosEject

  @out  msgDrive1             ;1- ᪮
  mov   ax,1                  ; IDE ଠ
  call  ideGetInfo            ; ᪮.
  @if   ax == TRUE            ;᫨ ଠ 祭,
        @out  msgInform       ;⮡ࠧ   ࠭.
        call  ideShowInfo
  @else
        @out  msgNotIDE       ;뢥 ᮮ饭 
  @endif                      ;⢨ IDE ࠩ.

  call  _dosEject

  @quit 0
endp

;ͻ
;  ଠ  IDE ࠩ                                   
;͹
; Call  Assembler                                                     
;͹
; In    AX ᮤন  ࠩ (稭  )                
;Ķ
; Out   AX ᮤন FALSE, ᫨ ࠩ  IDE   ⠭      
;       AX ᮤন TRUE,  info  ଠ樥              
;ͼ
ideGetInfo proc near uses bx cx dx di si es ds

  cli

  mov cl,4            ;ନ஢  롮 ᪮ 
  shl al,cl           ;।  ஫ ᪮.
  or  al,0A0h
  mov dx,1F6h
  out dx,al

  inc dx              ; 1F7h.
  in  al,dx           ;  ﭨ.
  @if al #& 40h       ;᫨   ⮢
      mov ax,FALSE    ;᪮ - ᪮
      sti             ; ⠭.
      ret
  @endif

  mov al,0ECh         ; 祭
  out dx,al           ;IDE-ଠ樨

  in  al,dx           ;  ﭨ.
  @if al && 01h       ;᫨ ⠭  訡
      mov ax,FALSE    ;믮  - 
      sti             ; IDE ࠩ.
      ret
  @endif

  @dowhile al && 80h  ; ⮢
    in al,dx          ;᪮.
  @enddo

  mov  ax,cs          ;ଠ 砥  
  mov  es,ax          ;1F0  뢠   info.
  lea  di,info
  mov  dx,1F0h
  @for 256
       in ax,dx
       stosw
  @next
  mov  ax,TRUE
  sti
  ret
endp

;ͻ
; ⮡ࠧ ଠ  IDE ᪥                                   
;ͼ
ideShowInfo proc near

  @if info.ideSerialNo #= 0     ;᫨ ࢮ ᫮ ਩ 
      @out msgSerialNo          ; , 뢥 20  
      lea  si,info.ideSerialNo  ;࠭.
      @for 10
           lodsw                ;.. ப ᠭ ᫮,
           xchg ah,al           ; ᭠砫 뢮 2-
           call _dosChar        ;,  ⥬ 1-.
           mov  al,ah
           call _dosChar
      @next
      call _dosEject
  @endif

  @out msgVersion               ;뢥 8  ᨨ .
  lea  si,info.ideVersion
  @for 4
       lodsw                    ;.. ப ᠭ ᫮,
       xchg ah,al               ; ᭠砫 뢮 2-
       call _dosChar            ;,  ⥬ 1-.
       mov  al,ah
       call _dosChar
  @next
  call _dosEject

  @out msgModelNo               ;뢥 40   .
  lea  si,info.ideModelNo
  @for 20
       lodsw                    ;.. ப ᠭ ᫮,
       xchg ah,al               ; ᭠砫 뢮 2-
       call _dosChar            ;,  ⥬ 1-.
       mov  al,ah
       call _dosChar
  @next
  call _dosEject
  call _dosEject

  @out msgGeometry              ;뢥 :

  @out msgTotal                 ; .

  @dcv info.ideTotalCyls strCyls 10
  @dcv info.ideTotalHead strHead  6
  @dcv info.ideTotalSpT  strSect  8
  @dcv info.ideTotalBpS  strByte 10
  @out strCyls
  @out strHead
  @out strSect
  @out strByte

  mov  ax,info.ideTotalCyls     ; ᫮ 樫஢ 
  mul  info.ideTotalHead        ;᫮ .
  mov  bx,info.ideTotalSpT      ; १  ᫮
  call _intMUL                  ;ᥪ஢  ஦.
  jc   @@overTotalSize
  mov  bx,info.ideTotalBpS      ; १  ᫮ 
  call _intMUL                  ; ᥪ.
  jc   @@overTotalSize

  mov  cx,000FH                 ; १  1 000 000
  mov  bx,4240h                 ;(ॢ  ).
  call _intDiv

  mov  dx,cx                    ;⪮஢  뢥 
  mov  ax,bx                    ;࠭.
  lea  si,strSize
  mov  cx,8
  call _intDCV
  @out strSize

  jmp  short @@addECC

@@overTotalSize:                ;᫨  ६ ᫥ 
                                ;९, 뢥 ᮮ饭  ⮬,
  @out msgBeeg                  ;  १砩 .

@@addECC:

  @dcv info.ideECC strECC 4     ; 饩 ਨ 
  @out strECC                   ;᫮  ECC.

  @if  info.ide32Acces == 0     ;  饩 ਨ
       @out msgNo               ;䫠 প 32-⭮
  @else                         ;/뢮.
       @out msgYes
  @endif

  call _dosEject

  @out msgCurrent
  @dcv info.ideCurrCyls strCyls 10
  @dcv info.ideCurrHead strHead  6
  @dcv info.ideCurrSpT  strSect  8
  @out strCyls
  @out strHead
  @out strSect
  @out msgDosByte

  mov  ax,info.ideCurrCyls      ; ᫮ 樫஢ 
  mul  info.ideCurrHead         ;᫮ .
  mov  bx,info.ideCurrSpT       ; १  ᫮
  call _intMUL                  ;ᥪ஢  ஦.
  jc   @@overCurrSize
  mov  bx,512                   ; १  512 
  call _intMUL
  jc   @@overCurrSize

  mov  cx,000FH                 ; १  1 000 000
  mov  bx,4240h                 ;(ॢ  ).
  call _intDiv

  mov  dx,cx                    ;⪮஢  뢥 
  mov  ax,bx                    ;࠭.
  lea  si,strSize
  mov  cx,8
  call _intDCV
  @out strSize
  jmp  short @@bufferSize

@@overCurrSize:                 ;᫨  ६ ᫥ 
                                ;९, 뢥 ᮮ饭  ⮬,
  @out msgBeeg                  ;  १砩 .

@@bufferSize:

  call _dosEject
  call _dosEject

  @out msgBuffSize              ;뢥 ࠧ 
  mov  ax,info.ideBuffSize      ;।⥫쭮, ࠧ  㪠뢠
  shr  ax,1                     ; ᥪ ( 512 ?)
  @dcv ax strWord 5
  @out si
  @out msgKB
  call _dosEject


  @out msgSpeed                 ;뢥 ᪮ ।
  mov  al,info.ideSpeed         ;.
  @if  al == 0
       lea si,msgLow
  @elseif al == 1
       lea si,msgMedium
  @elseif al == 2
       lea si,msgFast
  @else
       lea si,msgUnknown
  @endif
  @out si


  @out msgSpeedDMA              ;뢥 ᪮ ।
  mov  al,info.ideSpeedDMA      ;  DMA.
  @if  al == 0
       lea si,msgLow
  @elseif al == 1
       lea si,msgMedium
  @elseif al == 2
       lea si,msgFast
  @else
       lea si,msgUnknown
  @endif
  @out si

  ret
endp
end @startup
